/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.xputertechnologies.santa.core.DataAccess;
import com.xputertechnologies.santa.core.ObjectState;
import com.xputertechnologies.santa.list.UnitDataList;
import com.xputertechnologies.santa.ui.MainPage;
import com.xputertechnologies.santa.ui.NotificationType;
import com.xputertechnologies.santa.ui.UIParent;
import com.xputertechnologies.santa.ui.Unit;
import com.xputertechnologies.santa.ui.UnitContainer;
import java.io.IOException;
import java.sql.Connection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.layout.VBox;
import org.dbunit.database.DatabaseConnection;

public class UnitPane
extends UIParent {
    public static DataAccess da;
    private static Connection con;
    private static DatabaseConnection dc;
    @FXML
    private Button addNewUnitbut;
    @FXML
    private Button donebut;
    @FXML
    public VBox unitVbrep;
    public UnitDataList unitDataList;
    MainPage mainPage;
    Unit cu = null;

    public UnitPane(MainPage mainPage) throws Exception {
        FXMLLoader fxmlLoader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("UnitPane.fxml"));
        fxmlLoader.setRoot((Object)this);
        fxmlLoader.setController((Object)this);
        try {
            fxmlLoader.load();
            this.santa = mainPage.santa;
            da = this.santa.da;
            this.mainPage = mainPage;
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        this.title = "Unit Page";
        this.unitDataList = com.xputertechnologies.santa.Unit.SearchUnit("", da);
        for (com.xputertechnologies.santa.Unit unit : this.unitDataList.getOriginalList()) {
            unit.isEdit = true;
            this.unitVbrep.getChildren().add((Object)new UnitContainer(unit, this, this.santa));
        }
        this.addNewUnitbut.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                try {
                    UnitPane.this.createUnit();
                }
                catch (Exception ex) {
                    Logger.getLogger(UnitPane.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        this.donebut.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                UnitPane.this.done();
            }
        });
    }

    public void createUnit() {
        com.xputertechnologies.santa.Unit unit = new com.xputertechnologies.santa.Unit(da);
        this.cu = new Unit(this, unit, false);
        this.mainPage.hbCenter.setContent((Node)this.cu);
        this.mainPage.hbBottom.setVisible(true);
    }

    @Override
    void closeNotification() {
        this.mainPage.closeNotification();
    }

    private void done() {
        try {
            this.unitDataList.update();
            this.mainPage.showNotification(NotificationType.Success, "Operation Successful", this);
        }
        catch (Exception ex) {
            this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), this);
        }
    }

    @Override
    boolean validateControl() {
        this.errorMessage = "";
        this.needToSave = false;
        for (com.xputertechnologies.santa.Unit sa : this.unitDataList.getOriginalList()) {
            if (sa.getState() != ObjectState.Changed && sa.getState() != ObjectState.New) continue;
            this.needToSave = true;
            break;
        }
        return true;
    }

    @Override
    void yes() {
        try {
            this.done();
            this.mainPage.isToMenu = true;
            this.closeNotification();
            this.mainPage.hbCenter.setContent((Node)this.mainPage.menuControl);
            this.mainPage.hbBottom.setVisible(false);
        }
        catch (Exception ex) {
            this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), this);
        }
    }

    @Override
    void no() {
        this.mainPage.isToMenu = true;
        this.closeNotification();
        this.mainPage.hbCenter.setContent((Node)this.mainPage.menuControl);
        this.mainPage.hbBottom.setVisible(false);
    }

    @Override
    void completeControl() {
        this.mainPage.isToMenu = false;
        this.mainPage.showNotification(NotificationType.Warning, "Do you want to save change(s)", this);
    }
}

