/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXComboBox;
import com.jfoenix.controls.JFXDialog;
import com.jfoenix.controls.JFXProgressBar;
import com.xputertechnologies.santa.IDBEntity;
import com.xputertechnologies.santa.NameValueObject;
import com.xputertechnologies.santa.ProductSerial;
import com.xputertechnologies.santa.StockItem;
import com.xputertechnologies.santa.StockItemData;
import com.xputertechnologies.santa.Store;
import com.xputertechnologies.santa.list.StockItemList;
import com.xputertechnologies.santa.list.StoreDataList;
import com.xputertechnologies.santa.list.SyncSettingDataList;
import com.xputertechnologies.santa.report.ReportType;
import com.xputertechnologies.santa.ui.General;
import com.xputertechnologies.santa.ui.NotificationType;
import com.xputertechnologies.santa.ui.ReportPane;
import com.xputertechnologies.santa.ui.SalesPane;
import com.xputertechnologies.santa.ui.Santa;
import com.xputertechnologies.santa.ui.SerialView;
import com.xputertechnologies.santa.ui.SyncData;
import com.xputertechnologies.santa.ui.UIParent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.util.Callback;
import net.sf.jasperreports.engine.JRException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.controlsfx.control.textfield.AutoCompletionBinding;
import org.controlsfx.control.textfield.TextFields;
import org.controlsfx.glyphfont.FontAwesome;
import org.json.JSONArray;
import org.json.JSONObject;

public class StockVisibility
extends UIParent {
    @FXML
    private TableView<StockItem> tbItems;
    @FXML
    private TableView<StockItem> tbItems1;
    @FXML
    private TableColumn colItemCode;
    @FXML
    private TableColumn colName;
    @FXML
    private TableColumn colGroup;
    @FXML
    private TableColumn colStoreName;
    @FXML
    private TableColumn colsn;
    @FXML
    private TableColumn colsn1;
    @FXML
    private TableColumn colPrice;
    @FXML
    private TableColumn colPrice1;
    @FXML
    private TableColumn colPriceB2B;
    @FXML
    private TableColumn colPriceB2B1;
    @FXML
    private TableColumn colQty;
    @FXML
    private TableColumn colQty1;
    @FXML
    private TableColumn colCnsQty;
    @FXML
    private TableColumn colDspQty;
    @FXML
    private TableColumn colWeight1;
    @FXML
    private TableColumn colTotQty;
    @FXML
    private JFXButton btnSearch;
    @FXML
    private JFXButton btnRpt;
    @FXML
    private JFXButton btnSearch1;
    @FXML
    private StackPane stackPane;
    @FXML
    private JFXComboBox<Store> cmbStore;
    @FXML
    private TableColumn colSerial;
    @FXML
    private Label lblitemName;
    @FXML
    private TextField searchBox;
    @FXML
    private TextField searchBox1;
    public StockItemList stockItemList;
    public List<StockItemData> allProducts;
    VBox progressContainer;
    int i = 0;

    public StockVisibility(Santa app) {
        super("StockVisibility.fxml", app);
        this.title = "Stock List Visibility";
        this.stockItemList = new StockItemList(this.da);
        this.prefWidthProperty().bind((ObservableValue)this.santa.mainpage.hbCenter.widthProperty());
        this.tbItems.prefHeightProperty().bind((ObservableValue)this.santa.mainpage.hbCenter.heightProperty());
        StoreDataList storeDataList = new StoreDataList(this.da);
        storeDataList.selectAll("Select *from store", this.da.getEmptyParameterValues());
        ObservableList stores = FXCollections.observableArrayList((Collection)storeDataList.getOriginalList().stream().filter(prdct -> prdct.getName() != null && !prdct.getName().isEmpty()).collect(Collectors.toList()));
        this.cmbStore.setItems(stores);
        this.btnRpt.setOnAction(v -> {
            if (this.tbItems.getItems().size() > 0) {
                ReportPane.FromDt = new Date(new java.util.Date().getTime());
                ReportPane.ToDt = new Date(new java.util.Date().getTime());
                Dialog dialog = new Dialog();
                dialog.initStyle(StageStyle.DECORATED);
                dialog.initOwner((Window)this.santa.stage);
                dialog.setTitle("Stock inventory for " + ((Store)this.cmbStore.getSelectionModel().getSelectedItem()).getName());
                dialog.setResizable(true);
                try {
                    dialog.getDialogPane().setContent((Node)new ReportPane(this.santa, ReportType.StockListAudit, (ObservableList<StockItem>)this.tbItems.getItems(), null, ((Store)this.cmbStore.getSelectionModel().getSelectedItem()).getName()));
                    dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.CANCEL});
                    dialog.show();
                }
                catch (JRException ex) {
                    Logger.getLogger(StockVisibility.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (IOException ex) {
                    Logger.getLogger(StockVisibility.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        this.btnSearch.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                StockVisibility.this.searchItemNew(true);
            }
        });
        this.btnSearch1.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (!StockVisibility.this.searchBox1.getText().isEmpty()) {
                    StockVisibility.this.searchItemNew(false);
                } else {
                    StockVisibility.this.mainPage.showNotification(NotificationType.Error, "Please supply Item Code or Item Name", StockVisibility.this);
                }
            }
        });
        this.colsn.setCellValueFactory((Callback)new PropertyValueFactory("sn"));
        this.colWeight1.setCellValueFactory((Callback)new PropertyValueFactory("netWeight"));
        this.colItemCode.setCellValueFactory((Callback)new PropertyValueFactory("itemCode"));
        this.colName.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        this.colGroup.setCellValueFactory((Callback)new PropertyValueFactory("type"));
        this.colQty.setCellValueFactory((Callback)new PropertyValueFactory("quantity"));
        this.colCnsQty.setCellValueFactory((Callback)new PropertyValueFactory("cnsQty"));
        this.colDspQty.setCellValueFactory((Callback)new PropertyValueFactory("dspQty"));
        this.colTotQty.setCellValueFactory((Callback)new PropertyValueFactory("totalQty"));
        this.colPrice.setCellValueFactory((Callback)new PropertyValueFactory("sellingPrice"));
        this.colPriceB2B.setCellValueFactory((Callback)new PropertyValueFactory("priceB2B"));
        this.colPrice.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<StockItem, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<StockItem, String> param) {
                StockItem value = (StockItem)param.getValue();
                return new SimpleStringProperty(General.formatDecimalToMoneyString(value.getSellingPrice()));
            }
        });
        this.colPriceB2B.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<StockItem, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<StockItem, String> param) {
                StockItem value = (StockItem)param.getValue();
                return new SimpleStringProperty(General.formatDecimalToMoneyString(value.getSellingPrice()));
            }
        });
        this.colQty.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<StockItem, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<StockItem, String> param) {
                StockItem value = (StockItem)param.getValue();
                return new SimpleStringProperty(String.valueOf(Math.round(value.getQuantity())));
            }
        });
        this.colTotQty.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<StockItem, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<StockItem, String> param) {
                StockItem value = (StockItem)param.getValue();
                return new SimpleStringProperty(String.valueOf(Math.round(value.getTotalQty())));
            }
        });
        this.colDspQty.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<StockItem, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<StockItem, String> param) {
                StockItem value = (StockItem)param.getValue();
                return new SimpleStringProperty(String.valueOf(Math.round(value.getDspQty())));
            }
        });
        this.colCnsQty.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<StockItem, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<StockItem, String> param) {
                StockItem value = (StockItem)param.getValue();
                return new SimpleStringProperty(String.valueOf(Math.round(value.getCnsQty())));
            }
        });
        this.colPriceB2B1.setCellValueFactory((Callback)new PropertyValueFactory("priceB2B"));
        this.colPrice1.setCellValueFactory((Callback)new PropertyValueFactory("sellingPrice"));
        this.colsn1.setCellValueFactory((Callback)new PropertyValueFactory("sn"));
        this.colQty1.setCellValueFactory((Callback)new PropertyValueFactory("quantity"));
        this.colStoreName.setCellValueFactory((Callback)new PropertyValueFactory("storeName"));
        this.colPrice1.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<StockItem, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<StockItem, String> param) {
                StockItem value = (StockItem)param.getValue();
                return new SimpleStringProperty(General.formatDecimalToMoneyString(value.getSellingPrice()));
            }
        });
        this.colPriceB2B1.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<StockItem, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<StockItem, String> param) {
                StockItem value = (StockItem)param.getValue();
                return new SimpleStringProperty(General.formatDecimalToMoneyString(value.getSellingPrice()));
            }
        });
        this.colQty1.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<StockItem, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<StockItem, String> param) {
                StockItem value = (StockItem)param.getValue();
                return new SimpleStringProperty(String.valueOf(Math.round(value.getQuantity())));
            }
        });
        Callback<TableColumn<StockItem, String>, TableCell<StockItem, String>> cellFactoryVieSerial = new Callback<TableColumn<StockItem, String>, TableCell<StockItem, String>>(){

            public TableCell call(TableColumn<StockItem, String> param) {
                TableCell<StockItem, String> cell = new TableCell<StockItem, String>(){
                    final JFXButton lbl = new JFXButton();

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                            this.setText(null);
                        } else {
                            StockItem req = (StockItem)this.getTableView().getItems().get(this.getIndex());
                            if (!req.getSerials().getOriginalList().isEmpty()) {
                                this.lbl.setPrefHeight(30.0);
                                this.lbl.setPrefWidth(30.0);
                                this.lbl.setPadding(new Insets(0.0, 5.0, 0.0, 5.0));
                                this.lbl.setGraphic((Node)StockVisibility.this.fontAwesome.create((Enum)FontAwesome.Glyph.EYE).color(Color.GREEN).size(15.0));
                                this.lbl.setOnAction(c -> {
                                    ObservableList observableList = FXCollections.observableArrayList();
                                    StockVisibility.this.i = 0;
                                    req.getSerials().getOriginalList().forEach(x -> {
                                        ++StockVisibility.this.i;
                                        NameValueObject valuePair = new NameValueObject(StockVisibility.this.da);
                                        valuePair.setKey(Integer.toString(StockVisibility.this.i));
                                        valuePair.setData(x.getSerial());
                                        observableList.add((Object)valuePair);
                                    });
                                    JFXDialog dialog = new JFXDialog();
                                    dialog.setDialogContainer(StockVisibility.this.stackPane);
                                    dialog.setTransitionType(JFXDialog.DialogTransition.CENTER);
                                    dialog.setContent((Region)new SerialView(StockVisibility.this.santa, dialog, req.getName(), (ObservableList<NameValueObject>)observableList));
                                    dialog.setOverlayClose(false);
                                    dialog.show();
                                });
                                this.setGraphic((Node)this.lbl);
                            } else {
                                this.setGraphic(null);
                            }
                            this.setAlignment(Pos.CENTER);
                            this.setText(null);
                        }
                    }
                };
                return cell;
            }
        };
        this.colSerial.setCellFactory((Callback)cellFactoryVieSerial);
        AutoCompletionBinding autoCompletionBinding = TextFields.bindAutoCompletion((TextField)this.searchBox, t -> {
            List<StockItemData> result = this.searchDataH(t.getUserText());
            return result.size() > 25 ? result.subList(0, 24) : result;
        });
        autoCompletionBinding.setOnAutoCompleted((EventHandler)new EventHandler<AutoCompletionBinding.AutoCompletionEvent<StockItemData>>(){

            public void handle(AutoCompletionBinding.AutoCompletionEvent<StockItemData> event) {
                StockVisibility.this.searchBox.setText(((StockItemData)event.getCompletion()).getItemCode());
            }
        });
        autoCompletionBinding.setPrefWidth(400.0);
        AutoCompletionBinding autoCompletionBinding1 = TextFields.bindAutoCompletion((TextField)this.searchBox1, t -> {
            List<StockItemData> result = this.searchDataH(t.getUserText());
            return result.size() > 25 ? result.subList(0, 24) : result;
        });
        autoCompletionBinding1.setOnAutoCompleted((EventHandler)new EventHandler<AutoCompletionBinding.AutoCompletionEvent<StockItemData>>(){

            public void handle(AutoCompletionBinding.AutoCompletionEvent<StockItemData> event) {
                StockVisibility.this.searchBox1.setText(((StockItemData)event.getCompletion()).getItemCode());
                StockVisibility.this.lblitemName.setText(((StockItemData)event.getCompletion()).getDescription());
            }
        });
        autoCompletionBinding.setPrefWidth(400.0);
        this.searchBox1.setTooltip(new Tooltip(this.searchBox1.getText()));
        this.allProducts = new ArrayList<StockItemData>();
        StockItemList localProducts = new StockItemList(this.da);
        localProducts.selectAll("Select * from StockItem", this.da.getEmptyParameterValues());
        localProducts.getOriginalList().forEach(pr -> {
            StockItemData stockData = new StockItemData(pr.getItemCode(), pr.getName());
            this.allProducts.add(stockData);
        });
    }

    public void searchItem() {
        if (this.cmbStore.getSelectionModel().getSelectedItem() != null) {
            this.tbItems.getItems().clear();
            JFXProgressBar progressIndicator = new JFXProgressBar();
            progressIndicator.setProgress(-1.0);
            final VBox box = new VBox(new Node[]{progressIndicator});
            box.setAlignment(Pos.CENTER);
            this.progressContainer = box;
            this.stackPane.getChildren().add((Object)box);
            Service service = new Service(){

                protected Task createTask() {
                    return new Task(){

                        protected Object call() throws Exception {
                            Object url = SyncSettingDataList.getSyncSetting(StockVisibility.this.da).getBEURL();
                            String itemCode = StockVisibility.this.searchBox.getText();
                            url = (String)url + "RProduct/GetProductsFromOtherStore";
                            StockVisibility.this.stockItemList = new StockItemList(StockVisibility.this.da);
                            ArrayList<BasicNameValuePair> listParam = new ArrayList<BasicNameValuePair>();
                            BasicNameValuePair param1 = new BasicNameValuePair("storeCode", ((Store)StockVisibility.this.cmbStore.getSelectionModel().getSelectedItem()).getCode());
                            listParam.add(param1);
                            BasicNameValuePair param2 = new BasicNameValuePair("searchString", itemCode);
                            listParam.add(param2);
                            try {
                                HttpGet httpGet = new HttpGet((String)url);
                                RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectTimeout(Santa.connectionTimeOut).setSocketTimeout(Santa.socketTimeOut).setConnectionRequestTimeout(Santa.socketTimeOut).build();
                                httpGet.setHeader("Content-type", "application/json");
                                CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(defaultRequestConfig).build();
                                URI uri = new URIBuilder(httpGet.getURI()).addParameters(listParam).build();
                                httpGet.setURI(uri);
                                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
                                if (response.getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 204) {
                                    String output;
                                    BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                    StringBuilder stringBuilder = new StringBuilder();
                                    System.out.println("Output from Server .... \n");
                                    while ((output = br.readLine()) != null) {
                                        System.out.println(output);
                                        stringBuilder.append(output + "\n");
                                    }
                                    br.close();
                                    httpClient.getConnectionManager().shutdown();
                                    String result = stringBuilder.toString();
                                    JSONArray jar = new JSONArray(result);
                                    if (jar.length() > 0) {
                                        for (int i = 0; i < jar.length(); ++i) {
                                            JSONObject jo = jar.getJSONObject(i);
                                            StockItem si = new StockItem(StockVisibility.this.da);
                                            si.setName(jo.isNull("Name") ? "" : jo.getString("Name"));
                                            si.setItemCode(jo.isNull("ItemCode") ? "" : jo.getString("ItemCode"));
                                            si.setType(jo.isNull("Group") ? "" : jo.getString("Group"));
                                            si.setQuantity((float)(jo.isNull("Quantity") ? 0.0 : jo.getDouble("Quantity")));
                                            si.setSellingPrice((float)(jo.isNull("SellingPrice") ? 0.0 : jo.getDouble("SellingPrice")));
                                            si.setPriceB2B(jo.isNull("B2BPrice") ? 0.0 : jo.getDouble("B2BPrice"));
                                            si.setCnsQty(jo.isNull("ConsignmentQty") ? 0.0f : (float)jo.getInt("ConsignmentQty"));
                                            si.setDspQty(jo.isNull("DisplayQty") ? 0.0f : (float)jo.getInt("DisplayQty"));
                                            si.setParentCompany(StockVisibility.this.currentUser.getParentCompany());
                                            si.setStockUnit("Pieces");
                                            si.setSn(StockVisibility.this.stockItemList.getOriginalList().size() + 1);
                                            JSONArray array = jo.getJSONArray("Serials");
                                            if (array != null && array.length() > 0) {
                                                for (int j = 0; j < array.length(); ++j) {
                                                    JSONObject joS = array.getJSONObject(j);
                                                    ProductSerial serialItemData = new ProductSerial(StockVisibility.this.da);
                                                    serialItemData.setItemCode(joS.isNull("ItemCode") ? "" : joS.getString("ItemCode"));
                                                    serialItemData.setQuantity(joS.isNull("Quantity") ? 0 : joS.getInt("Quantity"));
                                                    serialItemData.setSerial(joS.isNull("Serial") ? "" : joS.getString("Serial"));
                                                    serialItemData.setStatus(joS.isNull("Status") ? "" : joS.getString("Status"));
                                                    serialItemData.setSysSerial(joS.isNull("SysSerial") ? 0 : joS.getInt("SysSerial"));
                                                    serialItemData.setWhscode(joS.isNull("WhsCode") ? "" : joS.getString("WhsCode"));
                                                    si.getSerials().getOriginalList().add((Object)serialItemData);
                                                }
                                            }
                                            StockVisibility.this.stockItemList.getOriginalList().add((Object)si);
                                        }
                                    }
                                    Platform.runLater(() -> {
                                        StockVisibility.this.stackPane.getChildren().remove((Object)box);
                                        StockVisibility.this.tbItems.setItems(StockVisibility.this.stockItemList.getOriginalList());
                                        StockVisibility.this.tbItems.refresh();
                                        if (StockVisibility.this.stockItemList.getOriginalList().isEmpty()) {
                                            StockVisibility.this.mainPage.showNotification(NotificationType.Information, "No result found", StockVisibility.this);
                                        }
                                    });
                                } else {
                                    String output;
                                    BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                    StringBuilder stringBuilder = new StringBuilder();
                                    while ((output = br.readLine()) != null) {
                                        System.out.println(output);
                                        stringBuilder.append(output + "\n");
                                    }
                                    br.close();
                                    String fullError = stringBuilder.toString();
                                    Platform.runLater(() -> {
                                        StockVisibility.this.stackPane.getChildren().remove((Object)box);
                                        StockVisibility.this.mainPage.showNotification(NotificationType.Error, fullError, StockVisibility.this);
                                    });
                                }
                            }
                            catch (Exception e) {
                                Platform.runLater(() -> {
                                    StockVisibility.this.stackPane.getChildren().remove((Object)box);
                                    StockVisibility.this.mainPage.showNotification(NotificationType.Error, e.getMessage(), StockVisibility.this);
                                });
                            }
                            return null;
                        }
                    };
                }
            };
            progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
            service.start();
        } else {
            this.mainPage.showNotification(NotificationType.Error, "Please select store", this);
        }
    }

    public void searchItemNew(final Boolean withLocation) {
        if (this.cmbStore.getSelectionModel().getSelectedItem() != null || !withLocation.booleanValue()) {
            if (withLocation.booleanValue()) {
                this.tbItems.getItems().clear();
            } else {
                this.tbItems1.getItems().clear();
            }
            JFXProgressBar progressIndicator = new JFXProgressBar();
            progressIndicator.setProgress(-1.0);
            final VBox box = new VBox(new Node[]{progressIndicator});
            box.setAlignment(Pos.CENTER);
            this.progressContainer = box;
            this.stackPane.getChildren().add((Object)box);
            Service service = new Service(){

                protected Task createTask() {
                    return new Task(){

                        protected Object call() throws Exception {
                            String itemCode = withLocation != false ? StockVisibility.this.searchBox.getText() : StockVisibility.this.searchBox1.getText();
                            JSONObject param = new JSONObject().put("item_Id", (Object)itemCode).put("locationId", (Object)(withLocation != false ? ((Store)StockVisibility.this.cmbStore.getSelectionModel().getSelectedItem()).getCode() : "")).put("isRetailLocation", !StockVisibility.this.currentUser.getParentCompany().getIsMainHub());
                            new SyncData(StockVisibility.this.santa, StockVisibility.this.da, StockVisibility.this.currentUser.getParentCompany()).getInventory(param, new IDBEntity<StockItem>(){

                                @Override
                                public void onSuccess(ObservableList<StockItem> data) {
                                    StockVisibility.this.stackPane.getChildren().remove((Object)box);
                                    if (withLocation.booleanValue()) {
                                        StockVisibility.this.tbItems.setItems(data);
                                        StockVisibility.this.tbItems.refresh();
                                    } else {
                                        ObservableList res = FXCollections.observableArrayList((Collection)data.stream().filter(prdct -> prdct.getQuantity() > 0.0f).collect(Collectors.toList()));
                                        StockVisibility.this.tbItems1.setItems(res);
                                        StockVisibility.this.tbItems1.refresh();
                                    }
                                    if (data.isEmpty()) {
                                        StockVisibility.this.mainPage.showNotification(NotificationType.Information, "No result found", StockVisibility.this);
                                    }
                                }

                                @Override
                                public void onError(String data) {
                                    StockVisibility.this.stackPane.getChildren().remove((Object)box);
                                    StockVisibility.this.mainPage.showNotification(NotificationType.Error, data, StockVisibility.this);
                                }

                                @Override
                                public void onTimeOut(String data) {
                                    StockVisibility.this.stackPane.getChildren().remove((Object)box);
                                    StockVisibility.this.mainPage.showNotification(NotificationType.Error, data, StockVisibility.this);
                                }
                            });
                            return null;
                        }
                    };
                }
            };
            progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
            service.start();
        } else {
            this.mainPage.showNotification(NotificationType.Error, "Please select store", this);
        }
    }

    public List<StockItemData> searchDataH(String searchString) {
        if (searchString == null || searchString.equals("")) {
            return new ArrayList<StockItemData>();
        }
        try {
            List result = this.allProducts.stream().filter(e -> e.getItemCode().toLowerCase().contains(searchString.toLowerCase()) || e.getDescription().toLowerCase().contains(searchString.toLowerCase())).collect(Collectors.toList());
            LinkedList searchResult = new LinkedList();
            searchResult.addAll(result.isEmpty() && result.size() > 0 ? this.allProducts : result);
            return searchResult.subList(0, searchResult.size());
        }
        catch (Exception ex) {
            Logger.getLogger(SalesPane.class.getName()).log(Level.SEVERE, null, ex);
            return new ArrayList<StockItemData>();
        }
    }
}

