/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.jfoenix.controls.JFXButton;
import com.xputertechnologies.santa.SaleItem;
import com.xputertechnologies.santa.core.DataAccess;
import com.xputertechnologies.santa.list.UnitDataList;
import com.xputertechnologies.santa.ui.DecimalNumberTextBox;
import com.xputertechnologies.santa.ui.General;
import com.xputertechnologies.santa.ui.ISalePane;
import com.xputertechnologies.santa.ui.NotificationType;
import com.xputertechnologies.santa.ui.SalesPane;
import com.xputertechnologies.santa.ui.SalesPaneAdmin;
import com.xputertechnologies.santa.ui.SalesPaneB2B;
import com.xputertechnologies.santa.ui.UIControlBase;
import java.util.function.Predicate;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextFormatter;
import javafx.scene.paint.Color;
import org.controlsfx.glyphfont.FontAwesome;

public class SalesItemAdminCard
extends UIControlBase {
    @FXML
    private Label lblItemCode;
    @FXML
    private Label naira;
    @FXML
    private JFXButton btnRemove;
    @FXML
    private Label lblItemName;
    @FXML
    private DecimalNumberTextBox tbPrice;
    @FXML
    private DecimalNumberTextBox tbQty;
    @FXML
    private Label lblAvailQty;
    @FXML
    private CheckBox chkManual;
    public SaleItem saleItem;
    private DataAccess da;

    public SalesItemAdminCard(final SaleItem saleItem, ISalePane sp) {
        this.da = sp.getSanta().da;
        this.saleItem = saleItem;
        this.btnRemove.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.TRASH).color(Color.RED).size(15.0));
        this.naira.setText("\u20a6");
        this.lblItemCode.setText(saleItem.getItemCode());
        this.lblItemName.setText(saleItem.getItemName());
        UnitDataList unitDataList = new UnitDataList(this.da);
        if (((SalesPaneAdmin)sp).getContainer().getChildren().isEmpty() || (((SalesPaneAdmin)sp).getContainer().getChildren().size() + 1) % 2 > 0) {
            this.setStyle("-fx-background-color:white;");
        } else {
            this.setStyle("-fx-background-color:#F3F3F3;");
        }
        unitDataList.SelectAll();
        this.saleItem.setQuantity(this.saleItem.getQuantity() > 0.0f ? this.saleItem.getQuantity() : 1.0f);
        this.btnRemove.setOnAction(v -> {
            ((SalesPaneAdmin)sp).getContainer().getChildren().removeIf((Predicate)new Predicate<Node>(){

                @Override
                public boolean test(Node t) {
                    return ((SalesItemAdminCard)t).saleItem.getItemCode().equals(saleItem.getItemCode());
                }
            });
            sp.getSale().getSaleItemsList().removeIf(c -> c.getItemCode().equals(saleItem.getItemCode()));
        });
        saleItem.addPropertyChangeListener(evt -> {
            if (evt.getPropertyName().equals("quantity") && ((SaleItem)evt.getSource()).getParentStockItem().getSellingPrice() == 0.0 && Float.valueOf(evt.getOldValue().toString()).floatValue() > 0.0f) {
                this.tbQty.setText("0.0");
                sp.getMainPage().showNotification(NotificationType.Error, "Item without price cannot be sold", sp instanceof SalesPane ? (SalesPane)sp : (SalesPaneB2B)sp);
            }
        });
        this.tbPrice.setMin(-1.0);
        this.tbQty.setMin(-1.0);
        this.chkManual.selectedProperty().bindBidirectional((Property)saleItem.isManualProperty());
        this.chkManual.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (newValue.booleanValue()) {
                    SalesItemAdminCard.this.tbQty.setMax(2.147483647E9);
                    SalesItemAdminCard.this.tbPrice.setMax(1.0E9);
                } else {
                    SalesItemAdminCard.this.tbQty.setMax(saleItem.availableQty.get());
                    SalesItemAdminCard.this.tbPrice.setMax(saleItem.getSellingPrice());
                    saleItem.setVariablePrice(saleItem.getSellingPrice());
                }
            }
        });
        this.lblAvailQty.textProperty().bindBidirectional((Property)saleItem.availableQty, this.intConverter);
        this.tbQty.textProperty().bindBidirectional((Property)saleItem.quantityProperty(), this.fConverter);
        this.tbQty.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if ((float)saleItem.availableQty.get() >= saleItem.getQuantity()) {
                    SalesItemAdminCard.this.lblAvailQty.setStyle("-fx-text-fill:green;");
                } else {
                    SalesItemAdminCard.this.lblAvailQty.setStyle("-fx-text-fill:red;");
                }
            }
        });
        TextFormatter priceFormater = new TextFormatter(this.dConverter, (Object)saleItem.variablePriceProperty().get());
        this.tbPrice.setTextFormatter(priceFormater);
        this.tbPrice.editableProperty().bindBidirectional((Property)saleItem.isManualProperty());
        this.tbPrice.textProperty().bindBidirectional((Property)saleItem.variablePriceProperty(), this.dConverter);
        General.selectAll(this.tbQty);
        this.tbQty.setMin(0.0);
    }

    public void setMaxQty() {
        if (!this.saleItem.getIsManual().booleanValue()) {
            this.tbQty.setMax(this.saleItem.availableQty.get());
            if ((float)this.saleItem.availableQty.get() >= this.saleItem.getQuantity()) {
                this.lblAvailQty.setStyle("-fx-text-fill:green;");
            } else {
                this.lblAvailQty.setStyle("-fx-text-fill:red;");
            }
        }
    }
}

