/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.xputertechnologies.santa.Customer;
import com.xputertechnologies.santa.Sale;
import com.xputertechnologies.santa.ui.ISalePane;
import com.xputertechnologies.santa.ui.SalesPane;
import com.xputertechnologies.santa.ui.UIControlBase;
import com.xputertechnologies.santa.ui.UnitContainer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import javafx.util.StringConverter;
import javafx.util.converter.DoubleStringConverter;
import javafx.util.converter.FloatStringConverter;

public class SaleListItem
extends UIControlBase {
    @FXML
    private Button btnSale;
    @FXML
    private ImageView close;
    private ISalePane salesPane;
    public Sale sale = null;
    StringConverter<? extends Number> fconverter = new FloatStringConverter();
    StringConverter<? extends Number> dconverter = new DoubleStringConverter();
    public Dialog<Customer> dialog;

    public SaleListItem(final Sale sale, final ISalePane salesPane, boolean isActive) {
        this.salesPane = salesPane;
        this.sale = sale;
        HBox parent = (HBox)this.btnSale.getParent();
        parent.styleProperty().bind((ObservableValue)this.btnSale.styleProperty());
        this.btnSale.textProperty().bindBidirectional(sale.descriptionProperty());
        this.btnSale.setGraphic((Node)this.fontAwesome.create('\uf007').color(Color.WHITE).size(15.0));
        this.close.visibleProperty().bind((ObservableValue)sale.AllowCloseProperty());
        this.close.setImage(new Image("/com/xputertechnologies/santa/ui/Images/close_x.png"));
        this.close.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                sale.isSold = true;
                event.consume();
                salesPane.getHbSales().getChildren().remove(salesPane.getHbSales().getChildren().stream().filter(prdct -> prdct instanceof SaleListItem && (sale.getInvoiceNumber() == 0 ? ((SaleListItem)prdct).sale.getCustomerName().equals(sale.getCustomerName()) : ((SaleListItem)prdct).sale.getInvoiceNumber() == sale.getInvoiceNumber())).findAny().orElse(null));
                for (Node object : salesPane.getHbSales().getChildren()) {
                    if (!(object instanceof SaleListItem)) continue;
                    if (!sale.getDescription().equals(((SaleListItem)object).sale.getDescription()) && !((SaleListItem)object).sale.getDescription().equals("New Sale")) {
                        salesPane.setSale(((SaleListItem)object).sale);
                        ((SaleListItem)object).setAsSelected();
                        salesPane.saleSelectionChanged();
                        break;
                    }
                    if (sale.getDescription().equals(((SaleListItem)object).sale.getDescription()) || !((SaleListItem)object).sale.getDescription().equals("New Sale")) continue;
                    salesPane.resetSale();
                    break;
                }
                if (salesPane instanceof SalesPane) {
                    ((SalesPane)salesPane).listManualSales.getSelectionModel().clearSelection();
                }
            }
        });
        if (isActive) {
            this.setAsSelected();
        } else {
            this.btnSale.setStyle("-fx-background-color: #b2b2b2;");
        }
        this.btnSale.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                try {
                    salesPane.setSale(sale);
                    for (Node node : salesPane.getHbSales().getChildren()) {
                        if (node instanceof Label) continue;
                        if (((Object)((Object)((SaleListItem)node))).equals((Object)SaleListItem.this)) {
                            SaleListItem.this.setAsSelected();
                            salesPane.saleSelectionChanged();
                            continue;
                        }
                        ((SaleListItem)node).btnSale.setStyle("-fx-background-color: #4FC4F6;");
                    }
                    if (sale.getDescription().equals("New Sale")) {
                        salesPane.showDialog(null);
                    }
                }
                catch (Exception ex) {
                    Logger.getLogger(UnitContainer.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
    }

    public Sale getSale() {
        return this.sale;
    }

    void setAsSelected() {
        this.btnSale.setStyle("-fx-background-color: #04aadc;");
    }

    private void createEditPane() throws Exception {
    }
}

