/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.jfoenix.controls.JFXButton;
import com.xputertechnologies.santa.SaleItem;
import com.xputertechnologies.santa.core.DataAccess;
import com.xputertechnologies.santa.list.UnitDataList;
import com.xputertechnologies.santa.ui.DecimalNumberTextBox;
import com.xputertechnologies.santa.ui.General;
import com.xputertechnologies.santa.ui.ISalePane;
import com.xputertechnologies.santa.ui.NotificationType;
import com.xputertechnologies.santa.ui.SalesPane;
import com.xputertechnologies.santa.ui.SalesPaneB2B;
import com.xputertechnologies.santa.ui.SerialTablePane;
import com.xputertechnologies.santa.ui.UIControlBase;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import org.controlsfx.glyphfont.FontAwesome;

public class SaleItemCart
extends UIControlBase {
    @FXML
    private DecimalNumberTextBox QtyTF;
    @FXML
    private DecimalNumberTextBox cndQty;
    @FXML
    private DecimalNumberTextBox dspQty;
    @FXML
    private HBox hbRow2;
    @FXML
    private CheckBox chkManual;
    @FXML
    private ImageView btnAdd;
    @FXML
    private ImageView btnRemove;
    @FXML
    private HBox hbRow1;
    @FXML
    private Label lblPriceFromStock;
    @FXML
    private Label lblItemCode;
    @FXML
    private Label lblCns;
    @FXML
    private Label lblDsp;
    @FXML
    private Label PriceTF;
    @FXML
    private Label lblSku;
    private static DataAccess da;
    public SaleItem saleItem;
    @FXML
    private Label lblStockQty;
    @FXML
    private Label lblName;
    @FXML
    private Label naira;
    @FXML
    private ImageView imgReduce;
    @FXML
    private JFXButton btnviewserail;
    @FXML
    private Tooltip toolTipItemName;
    private UnitDataList unitDataList;
    FocusHolder currentFocusHolder;

    public SaleItemCart(SaleItem saleItemF, final ISalePane sp) {
        da = sp.getSanta().da;
        if (sp.getSale().saleCreated) {
            this.setDisable(true);
        }
        this.currentFocusHolder = FocusHolder.Actual;
        try {
            this.saleItem = (SaleItem)saleItemF.fullClone();
        }
        catch (CloneNotSupportedException ex) {
            Logger.getLogger(SaleItemCart.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (sp.getSale().getSaleItemsList().size() % 2 == 0) {
            String css = "-fx-background-color:#F5F5F5";
            this.setStyle(css);
        }
        this.lblItemCode.setText(this.saleItem.getItemCode());
        this.naira.setText("\u20a6");
        this.saleItem.setQuantity(this.saleItem.getQuantity() > 0.0f ? this.saleItem.getQuantity() : 1.0f);
        this.chkManual.setSelected(this.saleItem.getIsManual().booleanValue());
        this.btnAdd.setImage(new Image("/com/xputertechnologies/santa/ui/Images/increase.png"));
        this.btnRemove.setImage(new Image("/com/xputertechnologies/santa/ui/Images/cart-remove.png"));
        this.imgReduce.setImage(new Image("/com/xputertechnologies/santa/ui/Images/decrease.png"));
        this.btnviewserail.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.EYE).color(Color.GREEN).size(15.0));
        this.cndQty.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (newValue.booleanValue()) {
                    SaleItemCart.this.currentFocusHolder = FocusHolder.Consignment;
                }
            }
        });
        this.dspQty.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (newValue.booleanValue()) {
                    SaleItemCart.this.currentFocusHolder = FocusHolder.Display;
                }
            }
        });
        this.QtyTF.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (newValue.booleanValue()) {
                    SaleItemCart.this.currentFocusHolder = FocusHolder.Actual;
                }
            }
        });
        this.lblName.setOnMouseEntered((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                SaleItemCart.this.toolTipItemName.setText(SaleItemCart.this.saleItem.serialToolTipProperty());
            }
        });
        this.btnAdd.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (SaleItemCart.this.currentFocusHolder == FocusHolder.Actual && (SaleItemCart.this.saleItem.getIsManual().booleanValue() || SaleItemCart.this.saleItem.quantityProperty().get() < SaleItemCart.this.saleItem.getParentStockItem().getQuantity())) {
                    SaleItemCart.this.saleItem.quantityProperty().set(SaleItemCart.this.saleItem.getQuantity() + 1.0f);
                } else if (SaleItemCart.this.currentFocusHolder == FocusHolder.Consignment && SaleItemCart.this.saleItem.cnsQtyProperty().get() < (float)SaleItemCart.this.saleItem.getParentStockItem().getCnsQty()) {
                    SaleItemCart.this.saleItem.cnsQtyProperty().set((float)(SaleItemCart.this.saleItem.getCnsQty() + 1));
                } else if (SaleItemCart.this.currentFocusHolder == FocusHolder.Display && SaleItemCart.this.saleItem.dspQtyProperty().get() < (float)SaleItemCart.this.saleItem.getParentStockItem().getDspQty()) {
                    SaleItemCart.this.saleItem.dspQtyProperty().set((float)(SaleItemCart.this.saleItem.getDspQty() + 1));
                }
            }
        });
        this.imgReduce.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                event.consume();
                if (SaleItemCart.this.currentFocusHolder == FocusHolder.Actual) {
                    if (SaleItemCart.this.saleItem.dspQtyProperty().get() == 0.0f && SaleItemCart.this.saleItem.quantityProperty().get() == 1.0f && SaleItemCart.this.saleItem.cnsQtyProperty().get() == 0.0f) {
                        sp.getRepeatingVBAdded().getChildren().removeIf((Predicate)new Predicate<Node>(){

                            @Override
                            public boolean test(Node t) {
                                return ((SaleItemCart)t).saleItem.getParentStockItem().getItemCode().equals(SaleItemCart.this.saleItem.getParentStockItem().getItemCode());
                            }
                        });
                        sp.getSale().getSaleItemsList().removeIf((Predicate)new Predicate<SaleItem>(){

                            @Override
                            public boolean test(SaleItem t) {
                                return t.getParentStockItem().getItemCode().equals(SaleItemCart.this.saleItem.getParentStockItem().getItemCode());
                            }
                        });
                    } else {
                        SaleItemCart.this.saleItem.quantityProperty().set(SaleItemCart.this.saleItem.getQuantity() > 0.0f ? SaleItemCart.this.saleItem.getQuantity() - 1.0f : 0.0f);
                    }
                } else if (SaleItemCart.this.currentFocusHolder == FocusHolder.Display) {
                    if (SaleItemCart.this.saleItem.dspQtyProperty().get() == 1.0f && SaleItemCart.this.saleItem.quantityProperty().get() == 0.0f && SaleItemCart.this.saleItem.cnsQtyProperty().get() == 0.0f) {
                        sp.getRepeatingVBAdded().getChildren().removeIf((Predicate)new Predicate<Node>(){

                            @Override
                            public boolean test(Node t) {
                                return ((SaleItemCart)t).saleItem.getParentStockItem().getItemCode().equals(SaleItemCart.this.saleItem.getParentStockItem().getItemCode());
                            }
                        });
                        sp.getSale().getSaleItemsList().removeIf((Predicate)new Predicate<SaleItem>(){

                            @Override
                            public boolean test(SaleItem t) {
                                return t.getParentStockItem().getItemCode().equals(SaleItemCart.this.saleItem.getParentStockItem().getItemCode());
                            }
                        });
                    } else {
                        SaleItemCart.this.saleItem.dspQtyProperty().set(SaleItemCart.this.saleItem.getDspQty() > 0 ? (float)(SaleItemCart.this.saleItem.getDspQty() - 1) : 0.0f);
                    }
                } else if (SaleItemCart.this.currentFocusHolder == FocusHolder.Consignment) {
                    if (SaleItemCart.this.saleItem.dspQtyProperty().get() == 0.0f && SaleItemCart.this.saleItem.quantityProperty().get() == 0.0f && SaleItemCart.this.saleItem.cnsQtyProperty().get() == 1.0f) {
                        sp.getRepeatingVBAdded().getChildren().removeIf((Predicate)new Predicate<Node>(){

                            @Override
                            public boolean test(Node t) {
                                return ((SaleItemCart)t).saleItem.getParentStockItem().getItemCode().equals(SaleItemCart.this.saleItem.getParentStockItem().getItemCode());
                            }
                        });
                        sp.getSale().getSaleItemsList().removeIf((Predicate)new Predicate<SaleItem>(){

                            @Override
                            public boolean test(SaleItem t) {
                                return t.getParentStockItem().getItemCode().equals(SaleItemCart.this.saleItem.getParentStockItem().getItemCode());
                            }
                        });
                    } else {
                        SaleItemCart.this.saleItem.cnsQtyProperty().set(SaleItemCart.this.saleItem.getCnsQty() > 0 ? (float)(SaleItemCart.this.saleItem.getCnsQty() - 1) : 0.0f);
                    }
                }
            }
        });
        this.btnRemove.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                event.consume();
                sp.getRepeatingVBAdded().getChildren().remove(sp.getRepeatingVBAdded().getChildren().stream().filter(prdct -> ((SaleItemCart)prdct).saleItem.getItemCode().equals(SaleItemCart.this.saleItem.getItemCode())).findAny().orElse(null));
                sp.getSale().getSaleItemsList().remove((Object)SaleItemCart.this.saleItem);
                if (sp.getSale().getSaleItemsList().stream().filter(f -> f.getIsManual()).collect(Collectors.toList()).size() > 0) {
                    sp.getSale().setIsManual(true);
                }
            }
        });
        this.btnviewserail.setOnAction(c -> {
            Dialog dialog = new Dialog();
            dialog.initStyle(StageStyle.DECORATED);
            dialog.initOwner((Window)sp.getSanta().stage);
            dialog.setTitle("Product Serials");
            dialog.setResizable(true);
            dialog.getDialogPane().setContent((Node)new SerialTablePane(sp.getSanta(), false, this.saleItem));
            dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.CANCEL});
            dialog.show();
        });
        this.saleItem.addPropertyChangeListener(evt -> {
            if (evt.getPropertyName().equals("quantity") && ((SaleItem)evt.getSource()).getParentStockItem().getSellingPrice() == 0.0 && Float.valueOf(evt.getOldValue().toString()).floatValue() > 0.0f) {
                this.QtyTF.setText("0.0");
                sp.getMainPage().showNotification(NotificationType.Error, "Item without price cannot be sold", sp instanceof SalesPane ? (SalesPane)sp : (SalesPaneB2B)sp);
            }
        });
        this.lblName.setText(this.saleItem.getParentStockItem().getName());
        this.unitDataList = new UnitDataList(da);
        this.unitDataList.SelectAll();
        this.QtyTF.textProperty().bindBidirectional((Property)this.saleItem.quantityProperty(), this.fConverter);
        this.QtyTF.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (!(newValue.isEmpty() || newValue.equals("0.0") || newValue.equals("0"))) {
                    SaleItemCart.this.lblStockQty.setText("(" + Integer.toString(Math.round(SaleItemCart.this.saleItem.getQuantity())) + ")");
                } else {
                    SaleItemCart.this.lblStockQty.setText("(0)");
                }
            }
        });
        this.cndQty.textProperty().bindBidirectional((Property)this.saleItem.cnsQtyProperty(), this.fConverter);
        this.cndQty.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (!newValue.isEmpty()) {
                    SaleItemCart.this.lblCns.setText("(" + Integer.toString(Math.round(SaleItemCart.this.saleItem.getCnsQty())) + ")");
                } else {
                    SaleItemCart.this.lblCns.setText("(0)");
                }
            }
        });
        this.dspQty.textProperty().bindBidirectional((Property)this.saleItem.dspQtyProperty(), this.fConverter);
        this.dspQty.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (!newValue.isEmpty()) {
                    SaleItemCart.this.lblDsp.setText("(" + Integer.toString(Math.round(SaleItemCart.this.saleItem.getDspQty())) + ")");
                } else {
                    SaleItemCart.this.lblDsp.setText("(0)");
                }
            }
        });
        if (this.saleItem.getParentStockItem().dspQtyProperty().get() == 0.0f) {
            this.dspQty.setEditable(false);
        }
        if (this.saleItem.getParentStockItem().cnsQtyProperty().get() == 0.0f) {
            this.cndQty.setEditable(false);
        }
        this.PriceTF.textProperty().bindBidirectional((Property)this.saleItem.variablePriceProperty(), this.dConverter);
        this.lblStockQty.setText("(" + Integer.toString(Math.round(this.saleItem.getQuantity())) + ")");
        this.lblCns.setText("(" + Integer.toString(this.saleItem.getCnsQty()) + ")");
        this.lblDsp.setText("(" + Integer.toString(this.saleItem.getDspQty()) + ")");
        this.PriceTF.addEventFilter(KeyEvent.KEY_TYPED, General.numeric_Validation(20));
        General.selectAll(this.QtyTF);
        General.selectAll(this.cndQty);
        General.selectAll(this.dspQty);
        if (!this.saleItem.isManualProperty().get()) {
            this.QtyTF.setMax(this.saleItem.getParentStockItem().getQuantity());
        }
        this.cndQty.setMax(this.saleItem.getParentStockItem().getCnsQty());
        this.cndQty.setMin(0.0);
        this.dspQty.setMax(this.saleItem.getParentStockItem().getDspQty());
        this.dspQty.setMin(0.0);
        this.cndQty.setMax(this.saleItem.getParentStockItem().getCnsQty());
        this.cndQty.setMin(0.0);
        if (!this.saleItem.getIsManual().booleanValue()) {
            this.QtyTF.setMax(this.saleItem.getParentStockItem().getQuantity());
        }
        this.QtyTF.setMin(0.0);
        this.setDisable(sp.getSale().saleCreated);
    }

    static enum FocusHolder {
        Actual,
        Display,
        Consignment;

    }
}

