/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.xputertechnologies.santa.Role;
import com.xputertechnologies.santa.User;
import com.xputertechnologies.santa.UserType;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.list.RoleList;
import com.xputertechnologies.santa.list.UserDataList;
import com.xputertechnologies.santa.ui.ConfigurationPageContainerPane;
import com.xputertechnologies.santa.ui.NotificationType;
import com.xputertechnologies.santa.ui.RoleContainer;
import com.xputertechnologies.santa.ui.Santa;
import com.xputertechnologies.santa.ui.UIParent;
import java.sql.JDBCType;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Accordion;
import javafx.scene.control.Button;
import javafx.scene.control.Dialog;
import javafx.scene.control.TextField;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;

public class RolePane
extends UIParent {
    public RoleContainer sourceRole;
    public User movedUser;
    @FXML
    public Accordion Accd;
    @FXML
    private Button searchButton;
    @FXML
    private TextField searchtxtf;
    @FXML
    private Button newuserrolebutton;
    public AnchorPane anchorPane;
    public RoleList roleList;
    public UserDataList userList;
    @FXML
    public VBox vbRoleRepeatingCntrl;
    private ArrayList<ParameterValue> tempParamValue = new ArrayList();
    ConfigurationPageContainerPane parentContainerPane;
    @FXML
    private HBox hbSearch;
    ConfigurationPageContainerPane cpcp;
    public RoleContainer roleContainerSelected;
    public UserDataList Users = new UserDataList(this.da);
    Dialog dialog;

    public RolePane(ConfigurationPageContainerPane cpcp, ObservableList<Role> listRole, Santa app) {
        super("RolePane.fxml", app);
        if (cpcp != null) {
            this.cpcp = cpcp;
            this.santa = cpcp.santa;
            this.parentContainerPane = cpcp;
            this.da = cpcp.santa.da;
            this.hbSearch.setVisible(false);
            this.roleList = cpcp.roleList;
            try {
                this.loadAllRoles();
            }
            catch (Exception ex) {
                Logger.getLogger(RolePane.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            this.reloadData();
        }
        this.newuserrolebutton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
            }
        });
        this.searchButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
            }
        });
    }

    public void reloadData() {
        if (this.currentUser.getRoleDescription().equals(UserType.SalesPerson.name())) {
            this.Users.selectAll("Select * From \"User\" where username=?", new ParameterValue[]{new ParameterValue("username", JDBCType.VARCHAR, this.currentUser.getUserName())});
        } else if (this.currentUser.getRoleDescription().equals(UserType.SalesManager.name())) {
            this.Users.selectAll("Select * From \"User\" where roleDescription=? or roleDescription=? ", new ParameterValue[]{new ParameterValue("roleDescription", JDBCType.VARCHAR, UserType.SalesManager.name()), new ParameterValue("roleDescription", JDBCType.VARCHAR, UserType.SalesPerson.name())});
        } else {
            this.Users.selectAll("Select * From \"User\"", this.da);
        }
        this.hbSearch.setVisible(true);
        this.roleList = new RoleList(this.da);
        this.mainPage.lbllTittle.setText("Role Page");
        this.movedUser = null;
        try {
            this.loadAllRoles();
        }
        catch (Exception ex) {
            Logger.getLogger(RolePane.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void loadAllRoles() throws Exception {
        this.Accd.getPanes().clear();
        if (this.cpcp == null && (this.currentUser.getRoleDescription().equals(UserType.SalesPerson.name()) || this.currentUser.getRoleDescription().equals(UserType.SalesManager.name()))) {
            RoleContainer pi;
            if (this.currentUser.getRoleDescription().equals(UserType.SalesManager.name())) {
                pi = new RoleContainer(this, UserType.SalesManager.name());
                for (User u : this.Users.getOriginalList()) {
                    if (!u.getRoleDescription().equals(pi.titledPane.getText())) continue;
                    pi.show(u);
                }
                this.Accd.getPanes().add((Object)pi);
            }
            pi = new RoleContainer(this, UserType.SalesPerson.name());
            for (User u : this.Users.getOriginalList()) {
                if (!u.getRoleDescription().equals(pi.titledPane.getText())) continue;
                pi.show(u);
            }
            this.Accd.getPanes().add((Object)pi);
        } else {
            for (int i = 0; i < UserType.values().length; ++i) {
                RoleContainer pi = new RoleContainer(this, UserType.values()[i].name());
                for (User u : this.Users.getOriginalList()) {
                    if (!u.getRoleDescription().equals(pi.titledPane.getText())) continue;
                    pi.show(u);
                }
                if (!this.currentUser.getRoleDescription().equals(UserType.Administrator.name()) && !pi.getText().equals(this.currentUser.getRoleDescription()) && (!this.currentUser.getRoleDescription().equals(UserType.SalesManager.name()) || !pi.getText().equals(UserType.SalesPerson.name()) && !pi.getText().equals(UserType.StockManager.name()))) continue;
                this.Accd.getPanes().add((Object)pi);
            }
        }
    }

    public void done() throws Exception {
        try {
            this.userList = new UserDataList(this.da);
            this.roleList.update();
            for (Role role : this.roleList.getOriginalList()) {
                this.userList.getOriginalList().addAll(role.getUserList());
            }
            this.userList.update();
            if (this.mainPage != null) {
                this.mainPage.showNotification(NotificationType.Success, "Operation Successful", this);
            }
        }
        catch (Exception e) {
            if (this.mainPage == null) {
                this.cpcp.Notification(NotificationType.Error, e.getMessage(), this);
            }
            this.mainPage.showNotification(NotificationType.Error, e.getMessage(), this);
        }
    }

    @Override
    boolean validateControl() {
        this.errorMessage = "";
        if (this.mainPage != null) {
            return true;
        }
        if (this.Users.getOriginalList().size() > 0) {
            for (User use : this.Users.getOriginalList()) {
                if (!use.getStatus().equals("Active") || !use.getRoleDescription().equals(UserType.Administrator.name())) continue;
                return true;
            }
        }
        this.errorMessage = "No Active user created\nYou must create at least one active Administrator user ";
        if (this.mainPage == null) {
            this.cpcp.Notification(NotificationType.Error, this.errorMessage, this);
        } else {
            this.mainPage.showNotification(NotificationType.Error, this.errorMessage, this);
        }
        return false;
    }

    @Override
    void closeNotification() {
        if (this.mainPage != null) {
            this.mainPage.closeNotification();
        } else {
            this.cpcp.closeNotification();
        }
    }

    @Override
    void completeControl() {
        try {
            this.closeNotification();
        }
        catch (Exception ex) {
            if (this.mainPage != null) {
                this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), this);
            }
            this.cpcp.Notification(NotificationType.Error, ex.getMessage(), this);
        }
    }
}

