/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.xputertechnologies.santa.Expenses;
import com.xputertechnologies.santa.core.ObjectState;
import com.xputertechnologies.santa.ui.Expense;
import com.xputertechnologies.santa.ui.ExpenseContainer;
import com.xputertechnologies.santa.ui.NotificationType;
import com.xputertechnologies.santa.ui.Santa;
import com.xputertechnologies.santa.ui.UIParent;
import com.xputertechnologies.santa.ui.UnitPane;
import java.sql.Connection;
import java.sql.Date;
import java.time.LocalDate;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.layout.VBox;
import org.dbunit.database.DatabaseConnection;

public class ExpensesPane
extends UIParent {
    private static Connection con;
    private static DatabaseConnection dc;
    @FXML
    private DatePicker dpFrom;
    @FXML
    public Label lblTotal;
    @FXML
    private DatePicker dpTo;
    @FXML
    private Button btnSearch;
    @FXML
    private Button addNewUnitbut;
    @FXML
    private Button donebut;
    @FXML
    public VBox expenseVbrep;
    Expenses expense = new Expenses(this.da);
    Expense cu = null;
    @FXML
    private Button btnDel;

    public ExpensesPane(Santa app) throws Exception {
        super("ExpensesPane.fxml", app);
        this.title = "Expense Page";
        this.dpFrom.setValue((Object)LocalDate.now());
        this.dpTo.setValue((Object)LocalDate.now());
        this.btnSearch.setOnAction(event -> this.search());
        this.addNewUnitbut.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                try {
                    ExpensesPane.this.createExpense();
                }
                catch (Exception ex) {
                    Logger.getLogger(UnitPane.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        this.donebut.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                ExpensesPane.this.done();
            }
        });
        this.lblTotal.textProperty().bind((ObservableValue)this.expense.totalAmountBinding);
    }

    private void delete() {
        try {
            this.expense.getExpenseItemsList().getOriginalList().forEach((Consumer)new Consumer<Expenses>(){

                @Override
                public void accept(Expenses t) {
                    t.setState(ObjectState.Removed);
                }
            });
            this.expense.getExpenseItemsList().update();
        }
        catch (Exception ex) {
            Logger.getLogger(ExpensesPane.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void search() {
        Expenses inc = new Expenses(this.da);
        this.expense.getExpenseItemsList().getOriginalList().clear();
        this.expense.getExpenseItemsList().getOriginalList().addAll(inc.search(Date.valueOf((LocalDate)this.dpFrom.getValue()), Date.valueOf((LocalDate)this.dpTo.getValue()), this.da));
        this.expenseVbrep.getChildren().clear();
        double Total = 0.0;
        for (Expenses unit : this.expense.getExpenseItemsList().getOriginalList()) {
            unit.isEdit = true;
            unit.tracker.set(unit.tracker.get() + 1);
            this.expenseVbrep.getChildren().add((Object)new ExpenseContainer(unit, this, this.santa));
        }
    }

    public void createExpense() throws Exception {
        Expenses expenses = new Expenses(this.da);
        expenses.setParentCompany(this.mainPage.currentUser.getParentCompany());
        expenses.dateProperty().set((Object)Date.valueOf(this.mainPage.currentUser.getParentCompany().getCurrentDay()));
        expenses.setParentUser(this.mainPage.currentUser);
        this.cu = new Expense(this, expenses, false);
        this.mainPage.hbCenter.setContent((Node)this.cu);
        this.mainPage.hbBottom.setVisible(true);
    }

    private void done() {
        if (this.validateControl() && this.needToSave) {
            try {
                this.expense.getExpenseItemsList().update();
                this.mainPage.showNotification(NotificationType.Success, "Operation Successful", this);
            }
            catch (Exception ex) {
                this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), this);
            }
        }
    }

    @Override
    void closeNotification() {
        this.mainPage.closeNotification();
    }

    @Override
    boolean validateControl() {
        this.errorMessage = "";
        this.needToSave = false;
        for (Expenses sa : this.expense.getExpenseItemsList().getOriginalList()) {
            if (sa.getState() != ObjectState.Changed && sa.getState() != ObjectState.New) continue;
            this.needToSave = true;
            break;
        }
        return true;
    }

    @Override
    void yes() {
        try {
            this.done();
            this.mainPage.isToMenu = true;
            this.closeNotification();
            this.mainPage.hbCenter.setContent((Node)this.mainPage.menuControl);
            this.mainPage.hbBottom.setVisible(false);
        }
        catch (Exception ex) {
            this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), this);
        }
    }

    @Override
    void no() {
        this.mainPage.isToMenu = true;
        this.closeNotification();
        this.mainPage.hbCenter.setContent((Node)this.mainPage.menuControl);
        this.mainPage.hbBottom.setVisible(false);
    }

    @Override
    void completeControl() {
        this.mainPage.isToMenu = false;
        this.mainPage.showNotification(NotificationType.Warning, "Do you want to save change(s)", this);
    }
}

