/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.jfoenix.controls.JFXProgressBar;
import com.xputertechnologies.santa.Account;
import com.xputertechnologies.santa.AccountDetail;
import com.xputertechnologies.santa.Employee;
import com.xputertechnologies.santa.IDBEntity;
import com.xputertechnologies.santa.NameValueObject;
import com.xputertechnologies.santa.NameValueObjectType;
import com.xputertechnologies.santa.ObjectDb;
import com.xputertechnologies.santa.StockItemData;
import com.xputertechnologies.santa.Store;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.list.AccountDataList;
import com.xputertechnologies.santa.list.EmployeeDataList;
import com.xputertechnologies.santa.list.StockItemList;
import com.xputertechnologies.santa.list.StoreDataList;
import com.xputertechnologies.santa.ui.NotificationType;
import com.xputertechnologies.santa.ui.Santa;
import com.xputertechnologies.santa.ui.SyncData;
import com.xputertechnologies.santa.ui.UIParent;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.sql.JDBCType;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.json.JSONArray;
import org.json.JSONObject;

public class DataReload
extends UIParent {
    @FXML
    VBox box;
    @FXML
    private Button btnSR;
    @FXML
    private Button btnBank;
    @FXML
    private Button btnPT;
    @FXML
    private Button btnPM;
    @FXML
    private Button btnDim;
    @FXML
    private Button btnStore;
    @FXML
    private Label lblStore;
    @FXML
    private Label lblBank;
    @FXML
    private Label lblSR;
    @FXML
    private Label lblPT;
    @FXML
    private Label lblPM;
    @FXML
    StackPane stackPane;
    VBox progressContainer;
    ObjectDb objectDb;
    @FXML
    StoreDataList storeDataList;

    public DataReload(Santa app) throws Exception {
        super("DataReload.fxml", app);
        this.title = "Data Reload";
        this.storeDataList = new StoreDataList(this.da);
        this.storeDataList.selectAll(this.da);
        this.objectDb = ObjectDb.loadLocalDb() == null ? new ObjectDb() : ObjectDb.loadLocalDb();
        this.updateLastDay();
        this.btnStore.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                DataReload.this.wrapper(Loadable.Store);
            }
        });
        this.btnSR.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                DataReload.this.wrapper(Loadable.SalesResponsible);
            }
        });
        this.btnPM.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                DataReload.this.wrapper(Loadable.PaymentMethod);
            }
        });
        this.btnBank.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                DataReload.this.wrapper(Loadable.Bank);
            }
        });
        this.btnPT.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                DataReload.this.wrapper(Loadable.PaymentTerm);
            }
        });
        this.btnDim.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                DataReload.this.wrapper(Loadable.Dimension);
            }
        });
    }

    void updateLastDay() {
        this.lblBank.setText(this.objectDb.getLastUpdateAccount() == null ? "Unknown" : new SimpleDateFormat("dd/MM/yyyy").format(this.objectDb.getLastUpdateAccount()));
        this.lblStore.setText(this.objectDb.getLastUpdateStores() == null ? "Unknown" : new SimpleDateFormat("dd/MM/yyyy").format(this.objectDb.getLastUpdateStores()));
        this.lblSR.setText(this.objectDb.getLastUpdateB2B() == null ? "Unknown" : new SimpleDateFormat("dd/MM/yyyy").format(this.objectDb.getLastUpdateB2B()));
        this.lblPM.setText(this.objectDb.getLastSalesChannel() == null ? "Unknown" : new SimpleDateFormat("dd/MM/yyyy").format(this.objectDb.getLastSalesChannel()));
        this.lblPT.setText(this.objectDb.getLastUpdateYuProduct() == null ? "Unknown" : new SimpleDateFormat("dd/MM/yyyy").format(this.objectDb.getLastUpdateYuProduct()));
    }

    public void wrapper(final Loadable load) {
        JFXProgressBar progressIndicator = new JFXProgressBar();
        progressIndicator.setMinHeight(10.0);
        progressIndicator.setProgress(-1.0);
        this.box = new VBox(new Node[]{progressIndicator});
        this.box.setAlignment(Pos.CENTER);
        this.progressContainer = this.box;
        this.stackPane.getChildren().add((Object)this.box);
        Service service = new Service(){

            protected Task createTask() {
                return new Task(){

                    protected Object call() throws Exception {
                        switch (load) {
                            case Store: {
                                DataReload.this.loadStore();
                                break;
                            }
                            case SalesResponsible: {
                                DataReload.this.loadSR();
                                break;
                            }
                            case PaymentTerm: {
                                DataReload.this.loadPT();
                                break;
                            }
                            case Bank: {
                                DataReload.this.loadBank();
                                break;
                            }
                            case Dimension: {
                                DataReload.this.loadDimension();
                                break;
                            }
                            case PaymentMethod: {
                                DataReload.this.loadPM();
                                break;
                            }
                        }
                        return null;
                    }
                };
            }
        };
        progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
        service.start();
    }

    private void loadSR() {
        try {
            SyncData syncData = new SyncData(this.santa, this.da, this.santa.currentUser.getParentCompany());
            syncData.getEmployee(this.da, new IDBEntity<Employee>(){

                @Override
                public void onError(String data) {
                    DataReload.this.callBack(data);
                }

                @Override
                public void onTimeOut(String data) {
                    DataReload.this.callBack(data);
                }

                @Override
                public void onSuccess(ObservableList<Employee> data) {
                    DataReload.this.callBack(null);
                }
            });
        }
        catch (Exception ex) {
            Logger.getLogger(DataReload.class.getName()).log(Level.SEVERE, null, ex);
            this.callBack(ex.getMessage());
        }
    }

    private void loadPM() {
        try {
            SyncData syncData = new SyncData(this.santa, this.da, this.santa.currentUser.getParentCompany());
            syncData.getPaymentModes(this.da, new IDBEntity<NameValueObject>(){

                @Override
                public void onError(String data) {
                    DataReload.this.callBack(data);
                }

                @Override
                public void onTimeOut(String data) {
                    DataReload.this.callBack(data);
                }

                @Override
                public void onSuccess(ObservableList<NameValueObject> data) {
                    DataReload.this.callBack(null);
                }
            });
        }
        catch (Exception ex) {
            Logger.getLogger(DataReload.class.getName()).log(Level.SEVERE, null, ex);
            this.callBack(ex.getMessage());
        }
    }

    private void loadDimension() {
        try {
            SyncData syncData = new SyncData(this.santa, this.da, this.santa.currentUser.getParentCompany());
            syncData.getDimenssions(this.da, new IDBEntity<NameValueObject>(){

                @Override
                public void onError(String data) {
                    DataReload.this.callBack(data);
                }

                @Override
                public void onTimeOut(String data) {
                    DataReload.this.callBack(data);
                }

                @Override
                public void onSuccess(ObservableList<NameValueObject> data) {
                    DataReload.this.callBack(null);
                }
            });
        }
        catch (Exception ex) {
            Logger.getLogger(DataReload.class.getName()).log(Level.SEVERE, null, ex);
            this.callBack(ex.getMessage());
        }
    }

    private void loadBank() {
        try {
            SyncData syncData = new SyncData(this.santa, this.da, this.santa.currentUser.getParentCompany());
            syncData.getBank(this.da, this.santa.currentUser.getParentCompany().getStoreCode(), new IDBEntity<AccountDetail>(){

                @Override
                public void onError(String data) {
                    DataReload.this.callBack(data);
                }

                @Override
                public void onTimeOut(String data) {
                    DataReload.this.callBack(data);
                }

                @Override
                public void onSuccess(ObservableList<AccountDetail> data) {
                    DataReload.this.callBack(null);
                }
            });
        }
        catch (Exception ex) {
            Logger.getLogger(DataReload.class.getName()).log(Level.SEVERE, null, ex);
            this.callBack(ex.getMessage());
        }
    }

    private void loadPT() {
        try {
            SyncData syncData = new SyncData(this.santa, this.da, this.santa.currentUser.getParentCompany());
            syncData.getPaymentTerms(this.da, new IDBEntity<NameValueObject>(){

                @Override
                public void onError(String data) {
                    DataReload.this.callBack(data);
                }

                @Override
                public void onTimeOut(String data) {
                    DataReload.this.callBack(data);
                }

                @Override
                public void onSuccess(ObservableList<NameValueObject> data) {
                    DataReload.this.callBack(null);
                }
            });
        }
        catch (Exception ex) {
            Logger.getLogger(DataReload.class.getName()).log(Level.SEVERE, null, ex);
            this.callBack(ex.getMessage());
        }
    }

    public void loadStore() {
        try {
            SyncData syncData = new SyncData(this.santa, this.da, this.santa.currentUser.getParentCompany());
            syncData.getLocations(this.da, new IDBEntity<Store>(){

                @Override
                public void onError(String data) {
                    DataReload.this.callBack(data);
                }

                @Override
                public void onTimeOut(String data) {
                    DataReload.this.callBack(data);
                }

                @Override
                public void onSuccess(ObservableList<Store> data) {
                    DataReload.this.callBack(null);
                }
            });
        }
        catch (Exception ex) {
            Logger.getLogger(DataReload.class.getName()).log(Level.SEVERE, null, ex);
            this.callBack(ex.getMessage());
        }
    }

    public void loadB2B() {
        ArrayList<Employee> list = new ArrayList<Employee>();
        Object url = this.santa.syncSetting.getBEURL();
        url = (String)url + "RMIsc/GetSalesEmployees";
        try {
            HttpGet httpGet = new HttpGet((String)url);
            RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectTimeout(Santa.connectionTimeOut).setSocketTimeout(Santa.socketTimeOut).setConnectionRequestTimeout(Santa.socketTimeOut).build();
            httpGet.setHeader("Content-type", "application/json");
            CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(defaultRequestConfig).build();
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            if (response.getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 204) {
                String output;
                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                StringBuilder stringBuilder = new StringBuilder();
                System.out.println("Output from Server .... \n");
                while ((output = br.readLine()) != null) {
                    System.out.println(output);
                    stringBuilder.append(output + "\n");
                }
                br.close();
                httpClient.getConnectionManager().shutdown();
                String result = stringBuilder.toString();
                JSONArray jar = new JSONArray(result);
                if (jar.length() > 0) {
                    for (int i = 0; i < jar.length(); ++i) {
                        JSONObject jo = jar.getJSONObject(i);
                        Employee stkData = new Employee(this.da);
                        stkData.setEmpId(jo.isNull("EmpID") ? "" : jo.getString("EmpID"));
                        stkData.setEmpName(jo.isNull("EmpName") ? "" : jo.getString("EmpName"));
                        list.add(stkData);
                    }
                    EmployeeDataList employeeDataList = new EmployeeDataList(this.da);
                    employeeDataList.selectAll("Select * from Employee", this.da.getEmptyParameterValues());
                    for (Employee store : list) {
                        Employee found = employeeDataList.getOriginalList().stream().filter(p -> p.equals(store)).findAny().orElse(null);
                        if (found != null) {
                            found.setEmpId(store.getEmpId());
                            found.setEmpName(store.getEmpName());
                            continue;
                        }
                        employeeDataList.getOriginalList().add((Object)store);
                    }
                    employeeDataList.update();
                    this.objectDb.setLastUpdateB2B(new Date());
                    this.callBack(null);
                }
            } else {
                String output;
                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                StringBuilder stringBuilder = new StringBuilder();
                while ((output = br.readLine()) != null) {
                    System.out.println(output);
                    stringBuilder.append(output + "\n");
                }
                br.close();
                String fullError = stringBuilder.toString();
                this.callBack(fullError);
            }
        }
        catch (Exception e) {
            this.callBack(e.getMessage());
        }
    }

    public void loadBaseData() {
        Object url = this.santa.syncSetting.getBEURL();
        ArrayList<NameValueObject> baseDataList = new ArrayList<NameValueObject>();
        url = (String)url + "RMIsc/GetBaseData";
        try {
            HttpGet httpGet = new HttpGet((String)url);
            RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectTimeout(Santa.connectionTimeOut).setSocketTimeout(Santa.socketTimeOut).setConnectionRequestTimeout(Santa.socketTimeOut).build();
            httpGet.setHeader("Content-type", "application/json");
            CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(defaultRequestConfig).build();
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            if (response.getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 204) {
                String output;
                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                StringBuilder stringBuilder = new StringBuilder();
                System.out.println("Output from Server .... \n");
                while ((output = br.readLine()) != null) {
                    System.out.println(output);
                    stringBuilder.append(output + "\n");
                }
                br.close();
                httpClient.getConnectionManager().shutdown();
                String result = stringBuilder.toString();
                JSONObject jar = new JSONObject(result);
                if (jar != null) {
                    NameValueObject obj;
                    JSONObject jo;
                    int i;
                    ArrayList<NameValueObject> nameValueObjects;
                    JSONArray suppliersArray = jar.getJSONArray("Suppliers");
                    JSONArray CostCentresArray = jar.getJSONArray("CostCentres");
                    JSONArray TaxCodesArray = jar.getJSONArray("TaxCodes");
                    JSONArray CurrenciesArray = jar.getJSONArray("Currencies");
                    JSONArray BanksArray = jar.getJSONArray("Banks");
                    JSONArray PaymentTermsArray = jar.getJSONArray("PaymentTerms");
                    JSONArray WarehousesArray = jar.getJSONArray("Warehouses");
                    JSONArray ItemGroupArray = jar.getJSONArray("ItemGroups");
                    JSONArray ManufacturersArray = jar.getJSONArray("Manufacturers");
                    if (suppliersArray.length() > 0) {
                        nameValueObjects = new ArrayList<NameValueObject>();
                        StockItemList.deleteAll("Delete from NameValueObject where \"TYPE\"=? ", new ParameterValue[]{new ParameterValue("\"Type\"", JDBCType.VARCHAR, NameValueObjectType.Supplier.name())}, this.da);
                        for (i = 0; i < suppliersArray.length(); ++i) {
                            jo = suppliersArray.getJSONObject(i);
                            obj = new NameValueObject(this.da);
                            if (jo.isNull("VendorId") || jo.isNull("VendorName") || jo.getString("VendorName").isEmpty()) continue;
                            obj.setKey(jo.isNull("VendorId") ? "" : jo.getString("VendorId"));
                            obj.setData(jo.isNull("VendorName") ? "" : jo.getString("VendorName"));
                            obj.setType(NameValueObjectType.Supplier.name());
                            nameValueObjects.add(obj);
                        }
                        baseDataList.addAll(nameValueObjects);
                    }
                    if (CostCentresArray.length() > 0) {
                        nameValueObjects = new ArrayList();
                        StockItemList.deleteAll("Delete from NameValueObject where \"TYPE\"=? ", new ParameterValue[]{new ParameterValue("\"Type\"", JDBCType.VARCHAR, NameValueObjectType.CostCentre.name())}, this.da);
                        for (i = 0; i < CostCentresArray.length(); ++i) {
                            jo = CostCentresArray.getJSONObject(i);
                            obj = new NameValueObject(this.da);
                            if (jo.isNull("Code")) continue;
                            obj.setKey(jo.isNull("Code") ? "" : jo.getString("Code"));
                            obj.setData(jo.isNull("Name") ? "" : jo.getString("Name"));
                            obj.setType(NameValueObjectType.CostCentre.name());
                            nameValueObjects.add(obj);
                        }
                        baseDataList.addAll(nameValueObjects);
                    }
                    if (TaxCodesArray.length() > 0) {
                        nameValueObjects = new ArrayList();
                        StockItemList.deleteAll("Delete from NameValueObject where \"TYPE\"=? ", new ParameterValue[]{new ParameterValue("\"Type\"", JDBCType.VARCHAR, NameValueObjectType.TaxCodes.name())}, this.da);
                        for (i = 0; i < TaxCodesArray.length(); ++i) {
                            jo = TaxCodesArray.getJSONObject(i);
                            obj = new NameValueObject(this.da);
                            if (jo.isNull("Code")) continue;
                            obj.setKey(jo.isNull("Code") ? "" : jo.getString("Code"));
                            obj.setData(jo.isNull("Name") ? "" : jo.getString("Name"));
                            obj.setType(NameValueObjectType.TaxCodes.name());
                            nameValueObjects.add(obj);
                        }
                        baseDataList.addAll(nameValueObjects);
                    }
                    if (CurrenciesArray.length() > 0) {
                        nameValueObjects = new ArrayList();
                        StockItemList.deleteAll("Delete from NameValueObject where \"TYPE\"=? ", new ParameterValue[]{new ParameterValue("\"Type\"", JDBCType.VARCHAR, NameValueObjectType.Currencies.name())}, this.da);
                        for (i = 0; i < CurrenciesArray.length(); ++i) {
                            jo = CurrenciesArray.getJSONObject(i);
                            obj = new NameValueObject(this.da);
                            if (jo.isNull("Code")) continue;
                            obj.setKey(jo.isNull("Code") ? "" : jo.getString("Code"));
                            obj.setData(jo.isNull("Name") ? "" : jo.getString("Name"));
                            obj.setType(NameValueObjectType.Currencies.name());
                            nameValueObjects.add(obj);
                        }
                        baseDataList.addAll(nameValueObjects);
                    }
                    if (BanksArray.length() > 0) {
                        nameValueObjects = new ArrayList();
                        StockItemList.deleteAll("Delete from NameValueObject where \"TYPE\"=? ", new ParameterValue[]{new ParameterValue("\"Type\"", JDBCType.VARCHAR, NameValueObjectType.Banks.name())}, this.da);
                        for (i = 0; i < BanksArray.length(); ++i) {
                            jo = BanksArray.getJSONObject(i);
                            obj = new NameValueObject(this.da);
                            if (jo.isNull("BankCode")) continue;
                            obj.setKey(jo.isNull("BankCode") ? "" : jo.getString("BankCode").trim());
                            obj.setData(jo.isNull("BankName") ? "" : jo.getString("BankName"));
                            obj.setType(NameValueObjectType.Banks.name());
                            if (obj.getKey().equals("CITI Bank")) {
                                System.out.println("ob");
                            }
                            if (nameValueObjects.stream().filter(c -> c.getKey().equalsIgnoreCase(obj.getKey())).findAny().orElse(null) != null) continue;
                            nameValueObjects.add(obj);
                        }
                        baseDataList.addAll(nameValueObjects);
                    }
                    if (PaymentTermsArray.length() > 0) {
                        nameValueObjects = new ArrayList();
                        StockItemList.deleteAll("Delete from NameValueObject where \"TYPE\"=? ", new ParameterValue[]{new ParameterValue("\"Type\"", JDBCType.VARCHAR, NameValueObjectType.PaymentTerm.name())}, this.da);
                        for (i = 0; i < PaymentTermsArray.length(); ++i) {
                            jo = PaymentTermsArray.getJSONObject(i);
                            obj = new NameValueObject(this.da);
                            if (jo.isNull("Code")) continue;
                            obj.setKey(jo.isNull("Code") ? "" : jo.getString("Code"));
                            obj.setData(jo.isNull("Description") ? "" : jo.getString("Description"));
                            obj.setType(NameValueObjectType.PaymentTerm.name());
                            nameValueObjects.add(obj);
                        }
                        baseDataList.addAll(nameValueObjects);
                    }
                    if (ItemGroupArray.length() > 0) {
                        nameValueObjects = new ArrayList();
                        StockItemList.deleteAll("Delete from NameValueObject where \"TYPE\"=? ", new ParameterValue[]{new ParameterValue("\"Type\"", JDBCType.VARCHAR, NameValueObjectType.ItemGroups.name())}, this.da);
                        for (i = 0; i < ItemGroupArray.length(); ++i) {
                            jo = ItemGroupArray.getJSONObject(i);
                            obj = new NameValueObject(this.da);
                            if (jo.isNull("Code")) continue;
                            obj.setKey(jo.isNull("Code") ? "" : jo.getString("Code"));
                            obj.setData(jo.isNull("Description") ? "" : jo.getString("Description"));
                            obj.setType(NameValueObjectType.ItemGroups.name());
                            nameValueObjects.add(obj);
                        }
                        baseDataList.addAll(nameValueObjects);
                    }
                    if (WarehousesArray.length() > 0) {
                        StoreDataList storeDataList = new StoreDataList(this.da);
                        StockItemList.deleteAll("Store", this.da);
                        for (i = 0; i < WarehousesArray.length(); ++i) {
                            jo = WarehousesArray.getJSONObject(i);
                            Store store = new Store(this.da);
                            if (jo.isNull("Code")) continue;
                            store.setCode(jo.isNull("Code") ? "" : jo.getString("Code"));
                            store.setName(jo.isNull("Name") ? "" : jo.getString("Name"));
                            storeDataList.getOriginalList().add((Object)store);
                        }
                        storeDataList.update();
                    }
                    if (ManufacturersArray.length() > 0) {
                        nameValueObjects = new ArrayList();
                        StockItemList.deleteAll("Delete from NameValueObject where \"TYPE\"=? ", new ParameterValue[]{new ParameterValue("\"Type\"", JDBCType.VARCHAR, NameValueObjectType.Manufacturers.name())}, this.da);
                        for (i = 0; i < ManufacturersArray.length(); ++i) {
                            jo = ManufacturersArray.getJSONObject(i);
                            obj = new NameValueObject(this.da);
                            if (jo.isNull("Code")) continue;
                            obj.setKey(jo.isNull("Code") ? "" : jo.getString("Code"));
                            obj.setData(jo.isNull("Name") ? "" : jo.getString("Name"));
                            obj.setType(NameValueObjectType.Manufacturers.name());
                            nameValueObjects.add(obj);
                        }
                        baseDataList.addAll(nameValueObjects);
                    }
                    NameValueObject.insertBatch(baseDataList, this.da);
                    this.callBack(null);
                } else {
                    this.callBack("No data found");
                }
            } else {
                String output;
                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                StringBuilder stringBuilder = new StringBuilder();
                while ((output = br.readLine()) != null) {
                    System.out.println(output);
                    stringBuilder.append(output + "\n");
                }
                br.close();
                String fullError = stringBuilder.toString();
                this.callBack(fullError);
            }
        }
        catch (Exception e) {
            this.callBack(e.getMessage());
        }
    }

    public void loadAccount() {
        ArrayList<Account> list = new ArrayList<Account>();
        Object url = this.santa.syncSetting.getBEURL();
        url = (String)url + "RMIsc/GetAccounts";
        try {
            HttpGet httpGet = new HttpGet((String)url);
            RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectTimeout(Santa.connectionTimeOut).setSocketTimeout(Santa.socketTimeOut).setConnectionRequestTimeout(Santa.socketTimeOut).build();
            httpGet.setHeader("Content-type", "application/json");
            CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(defaultRequestConfig).build();
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            if (response.getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 204) {
                String output;
                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                StringBuilder stringBuilder = new StringBuilder();
                System.out.println("Output from Server .... \n");
                while ((output = br.readLine()) != null) {
                    System.out.println(output);
                    stringBuilder.append(output + "\n");
                }
                br.close();
                httpClient.getConnectionManager().shutdown();
                String result = stringBuilder.toString();
                JSONArray jar = new JSONArray(result);
                if (jar.length() > 0) {
                    for (int i = 0; i < jar.length(); ++i) {
                        JSONObject jo = jar.getJSONObject(i);
                        Account stkData = new Account(this.da);
                        stkData.setName(jo.isNull("AccountName") ? "" : jo.getString("AccountName"));
                        stkData.setAccNumber(jo.isNull("AccountNumber") ? "" : jo.getString("AccountNumber"));
                        list.add(stkData);
                    }
                    AccountDataList accountDataList = new AccountDataList(this.da);
                    accountDataList.selectAll("Select * from Account", this.da.getEmptyParameterValues());
                    for (Account acc : list) {
                        Account found = accountDataList.getOriginalList().stream().filter(p -> p.equals(acc)).findAny().orElse(null);
                        if (found != null) {
                            found.setAccNumber(acc.getAccNumber());
                            found.setName(acc.getName());
                            continue;
                        }
                        accountDataList.getOriginalList().add((Object)acc);
                    }
                    accountDataList.update();
                    this.objectDb.setLastUpdateAccount(new Date());
                    this.callBack(null);
                }
            } else {
                String output;
                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                StringBuilder stringBuilder = new StringBuilder();
                while ((output = br.readLine()) != null) {
                    System.out.println(output);
                    stringBuilder.append(output + "\n");
                }
                br.close();
                String fullError = stringBuilder.toString();
                this.callBack(fullError);
            }
        }
        catch (Exception e) {
            this.callBack(e.getMessage());
        }
    }

    public void loadSalesChannel() {
        ArrayList<NameValueObject> list = new ArrayList<NameValueObject>();
        Object url = this.santa.syncSetting.getBEURL();
        url = (String)url + "RMIsc/GetChannels";
        try {
            HttpGet httpGet = new HttpGet((String)url);
            RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectTimeout(Santa.connectionTimeOut).setSocketTimeout(Santa.socketTimeOut).setConnectionRequestTimeout(Santa.socketTimeOut).build();
            httpGet.setHeader("Content-type", "application/json");
            CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(defaultRequestConfig).build();
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            if (response.getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 204) {
                String output;
                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                StringBuilder stringBuilder = new StringBuilder();
                System.out.println("Output from Server .... \n");
                while ((output = br.readLine()) != null) {
                    System.out.println(output);
                    stringBuilder.append(output + "\n");
                }
                br.close();
                httpClient.getConnectionManager().shutdown();
                String result = stringBuilder.toString();
                JSONArray jar = new JSONArray(result);
                if (jar.length() > 0) {
                    for (int i = 0; i < jar.length(); ++i) {
                        JSONObject jo = jar.getJSONObject(i);
                        NameValueObject stkData = new NameValueObject(this.da);
                        stkData.setKey(jo.isNull("Name") ? "" : jo.getString("Name"));
                        stkData.setData(jo.isNull("Code") ? "" : jo.getString("Code"));
                        list.add(stkData);
                    }
                    StockItemList.deleteAll("SaleChannel", this.da);
                    StockItemList.insertChannels(list, this.da);
                    this.objectDb.setLastSalesChannel(new Date());
                    this.callBack(null);
                }
            } else {
                String output;
                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                StringBuilder stringBuilder = new StringBuilder();
                while ((output = br.readLine()) != null) {
                    System.out.println(output);
                    stringBuilder.append(output + "\n");
                }
                br.close();
                String fullError = stringBuilder.toString();
                this.callBack(fullError);
            }
        }
        catch (Exception e) {
            this.callBack(e.getMessage());
        }
    }

    public void loadYuProduct() {
        try {
            HttpGet httpGet = new HttpGet(this.santa.syncSetting.getBEURL() + "rProduct/GetSAPItems");
            RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectTimeout(Santa.connectionTimeOut).setSocketTimeout(Santa.socketTimeOut).setConnectionRequestTimeout(Santa.socketTimeOut).build();
            httpGet.setHeader("Content-type", "application/json");
            CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(defaultRequestConfig).build();
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            if (response.getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 204) {
                String output;
                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                StringBuilder stringBuilder = new StringBuilder();
                System.out.println("Output from Server .... \n");
                while ((output = br.readLine()) != null) {
                    System.out.println(output);
                    stringBuilder.append(output + "\n");
                }
                br.close();
                httpClient.getConnectionManager().shutdown();
                String result = stringBuilder.toString();
                JSONArray jar = new JSONArray(result);
                if (jar.length() > 0) {
                    ArrayList<StockItemData> list = new ArrayList<StockItemData>();
                    for (int i = 0; i < jar.length(); ++i) {
                        JSONObject jo = jar.getJSONObject(i);
                        StockItemData stkData = new StockItemData();
                        stkData.setDescription(jo.isNull("ItemName") ? "" : jo.getString("ItemName"));
                        stkData.setItemCode(jo.isNull("ItemCode") ? "" : jo.getString("ItemCode"));
                        list.add(stkData);
                    }
                    StockItemList.insertAllYudalaProduct(list, this.da);
                    if (list.size() > 0) {
                        this.santa.Products.clear();
                        this.santa.Products.addAll(list);
                    }
                    this.objectDb.setLastUpdateYuProduct(new Date());
                    this.callBack(null);
                }
            } else {
                String output;
                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                StringBuilder stringBuilder = new StringBuilder();
                while ((output = br.readLine()) != null) {
                    System.out.println(output);
                    stringBuilder.append(output + "\n");
                }
                br.close();
                String fullError = stringBuilder.toString();
                this.callBack(fullError);
            }
        }
        catch (Exception ex) {
            this.callBack(ex.getMessage());
        }
    }

    public void loadSupplier() {
        try {
            HttpGet httpGet = new HttpGet(this.santa.syncSetting.getBEURL() + "RMIsc/GetSuppliers");
            RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectTimeout(Santa.connectionTimeOut).setSocketTimeout(Santa.socketTimeOut).setConnectionRequestTimeout(Santa.socketTimeOut).build();
            httpGet.setHeader("Content-type", "application/json");
            CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(defaultRequestConfig).build();
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            if (response.getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 204) {
                String output;
                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                StringBuilder stringBuilder = new StringBuilder();
                System.out.println("Output from Server .... \n");
                while ((output = br.readLine()) != null) {
                    System.out.println(output);
                    stringBuilder.append(output + "\n");
                }
                br.close();
                httpClient.getConnectionManager().shutdown();
                String result = stringBuilder.toString();
                JSONArray jar = new JSONArray(result);
                if (jar.length() > 0) {
                    ArrayList<NameValueObject> list = new ArrayList<NameValueObject>();
                    for (int i = 0; i < jar.length(); ++i) {
                        JSONObject jo = jar.getJSONObject(i);
                        if (jo.isNull("VendorId") || jo.isNull("VendorName") || jo.getString("VendorName").isEmpty()) continue;
                        NameValueObject nameValueObject = new NameValueObject(this.da);
                        nameValueObject.setData(jo.isNull("VendorName") ? "" : jo.getString("VendorName"));
                        nameValueObject.setKey(jo.isNull("VendorId") ? "" : jo.getString("VendorId"));
                        nameValueObject.setType(NameValueObjectType.Supplier.name());
                        list.add(nameValueObject);
                    }
                    StockItemList.deleteAll("Delete from NameValueObject where \"TYPE\"=? ", new ParameterValue[]{new ParameterValue("\"Type\"", JDBCType.VARCHAR, NameValueObjectType.Supplier.name())}, this.da);
                    list.forEach(val -> {
                        try {
                            val.insert();
                        }
                        catch (Exception ex) {
                            Logger.getLogger(SyncData.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    });
                    this.objectDb.setLastUpdateSupplier(new Date());
                    this.callBack(null);
                }
            } else {
                String output;
                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                StringBuilder stringBuilder = new StringBuilder();
                while ((output = br.readLine()) != null) {
                    System.out.println(output);
                    stringBuilder.append(output + "\n");
                }
                br.close();
                String fullError = stringBuilder.toString();
                this.callBack(fullError);
            }
        }
        catch (Exception ex) {
            this.callBack(ex.getMessage());
        }
    }

    public void callBack(String error) {
        Platform.runLater(() -> {
            this.stackPane.getChildren().remove((Object)this.box);
            if (error == null) {
                this.mainPage.showNotification(NotificationType.Success, "Operation Successful", this);
                this.objectDb.saveLocalDb();
                this.updateLastDay();
            } else {
                this.mainPage.showNotification(NotificationType.Error, error, this);
            }
        });
    }

    static enum Loadable {
        SalesResponsible,
        PaymentMethod,
        Store,
        Bank,
        PaymentTerm,
        Dimension,
        Supplier,
        NewYuProductDated,
        LoadStoreConfig;

    }
}

