/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.xputertechnologies.santa.SearchClass;
import com.xputertechnologies.santa.core.DataAccess;
import com.xputertechnologies.santa.core.ObjectState;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.list.CustomerDataList;
import com.xputertechnologies.santa.ui.Customer;
import com.xputertechnologies.santa.ui.ICustomerContainer;
import com.xputertechnologies.santa.ui.NotificationType;
import com.xputertechnologies.santa.ui.Santa;
import com.xputertechnologies.santa.ui.StockItemPane;
import com.xputertechnologies.santa.ui.UIParent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.paint.Color;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.util.Callback;
import org.controlsfx.control.textfield.AutoCompletionBinding;
import org.controlsfx.control.textfield.TextFields;
import org.controlsfx.glyphfont.FontAwesome;

public class CustomerPane
extends UIParent
implements ICustomerContainer {
    @FXML
    private Button SearchButnCustomer;
    @FXML
    public TextField SearchFieldCustomer;
    @FXML
    private Button btnNewCustomer;
    @FXML
    private Label lblCount;
    @FXML
    private TableView<com.xputertechnologies.santa.Customer> table;
    @FXML
    private TableColumn<String, com.xputertechnologies.santa.Customer> colName;
    @FXML
    private TableColumn<String, com.xputertechnologies.santa.Customer> colEmail;
    @FXML
    private TableColumn<String, com.xputertechnologies.santa.Customer> colSapCode;
    @FXML
    private TableColumn<String, com.xputertechnologies.santa.Customer> colPnum;
    @FXML
    private TableColumn<String, com.xputertechnologies.santa.Customer> colAddress;
    @FXML
    private TableColumn<Integer, com.xputertechnologies.santa.Customer> colSn;
    @FXML
    private TableColumn colEdit;
    private ArrayList<ParameterValue> tempParamValue = new ArrayList();
    public CustomerDataList customerList;
    Customer customerInput;
    boolean isSearching = false;
    private Set<String> possibleSuggestions = null;
    Dialog dialog;

    public CustomerPane(Santa app) throws Exception {
        super("CustomerPane.fxml", app);
        this.santa = app;
        this.title = "Customer Page";
        this.customerList = new CustomerDataList(this.da);
        this.possibleSuggestions = new HashSet<String>();
        this.populateSearch("");
        this.lblCount.setText(String.valueOf(this.customerList.getTotalRecord("Customer")) + " Items available");
        this.btnNewCustomer.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.PLUS_CIRCLE).color(Color.WHITE).size(20.0));
        AutoCompletionBinding autoCompletionBinding = TextFields.bindAutoCompletion((TextField)this.SearchFieldCustomer, t -> {
            List<SearchClass> result = this.searchData(t.getUserText());
            return result.size() > 25 ? result.subList(0, 24) : result;
        });
        autoCompletionBinding.setOnAutoCompleted((EventHandler)new EventHandler<AutoCompletionBinding.AutoCompletionEvent<SearchClass>>(){

            public void handle(AutoCompletionBinding.AutoCompletionEvent<SearchClass> event) {
                CustomerPane.this.populateSearch(((SearchClass)event.getCompletion()).getUniqueString());
            }
        });
        autoCompletionBinding.setPrefWidth(400.0);
        this.colSn.setCellValueFactory((Callback)new PropertyValueFactory("sn"));
        this.colName.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        this.colSapCode.setCellValueFactory((Callback)new PropertyValueFactory("d365Code"));
        this.colPnum.setCellValueFactory((Callback)new PropertyValueFactory("phoneNumber"));
        this.colEmail.setCellValueFactory((Callback)new PropertyValueFactory("email"));
        this.colAddress.setCellValueFactory((Callback)new PropertyValueFactory("address"));
        Callback<TableColumn<com.xputertechnologies.santa.Customer, String>, TableCell<com.xputertechnologies.santa.Customer, String>> cellFactoryView = new Callback<TableColumn<com.xputertechnologies.santa.Customer, String>, TableCell<com.xputertechnologies.santa.Customer, String>>(){

            public TableCell call(TableColumn<com.xputertechnologies.santa.Customer, String> param) {
                TableCell<com.xputertechnologies.santa.Customer, String> cell = new TableCell<com.xputertechnologies.santa.Customer, String>(){
                    final Button btn = new Button("Edit");

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                            this.setText(null);
                        } else {
                            com.xputertechnologies.santa.Customer customer = (com.xputertechnologies.santa.Customer)this.getTableView().getItems().get(this.getIndex());
                            this.btn.setStyle("-fx-background-color: #4FC4F6;");
                            this.btn.setOnAction(event -> {
                                try {
                                    CustomerPane.this.dialog = new Dialog();
                                    CustomerPane.this.dialog.initStyle(StageStyle.UTILITY);
                                    CustomerPane.this.dialog.initOwner((Window)CustomerPane.this.santa.stage);
                                    CustomerPane.this.dialog.setTitle("Edit Customer");
                                    CustomerPane.this.dialog.setResizable(true);
                                    CustomerPane.this.dialog.getDialogPane().setContent((Node)new Customer(CustomerPane.this, null, customer));
                                    CustomerPane.this.dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.CANCEL});
                                    CustomerPane.this.dialog.show();
                                }
                                catch (Exception ex) {
                                    Logger.getLogger(CustomerPane.class.getName()).log(Level.SEVERE, null, ex);
                                }
                            });
                            this.btn.setGraphic((Node)CustomerPane.this.fontAwesome.create((Enum)FontAwesome.Glyph.EDIT).color(Color.WHITE).size(20.0));
                            this.setGraphic((Node)this.btn);
                            this.setAlignment(Pos.CENTER);
                            this.setText(null);
                        }
                    }
                };
                return cell;
            }
        };
        this.colEdit.setCellFactory((Callback)cellFactoryView);
        this.prefWidthProperty().bind((ObservableValue)this.santa.mainpage.hbCenter.widthProperty());
        this.table.prefHeightProperty().bind((ObservableValue)this.santa.mainpage.hbCenter.heightProperty());
        this.SearchButnCustomer.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                try {
                    CustomerPane.this.populateSearch(CustomerPane.this.SearchFieldCustomer.getText());
                }
                catch (Exception ex) {
                    Logger.getLogger(StockItemPane.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        this.btnNewCustomer.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                try {
                    CustomerPane.this.dialog = new Dialog();
                    CustomerPane.this.dialog.initStyle(StageStyle.UTILITY);
                    CustomerPane.this.dialog.initOwner((Window)CustomerPane.this.santa.stage);
                    CustomerPane.this.dialog.setTitle("New Customer");
                    CustomerPane.this.dialog.setResizable(true);
                    CustomerPane.this.dialog.getDialogPane().setContent((Node)new Customer(CustomerPane.this, null, new com.xputertechnologies.santa.Customer(CustomerPane.this.da)));
                    CustomerPane.this.dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.CANCEL});
                    CustomerPane.this.dialog.show();
                }
                catch (Exception ex) {
                    Logger.getLogger(CustomerPane.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
    }

    public void autoCompletionLearnWord(String newWord) {
        this.possibleSuggestions.add(newWord);
    }

    @Override
    public List<SearchClass> searchData(String searchString) {
        if (searchString == null || searchString.equals("")) {
            return new ArrayList<SearchClass>();
        }
        try {
            return CustomerDataList.selectAutoComplete(searchString, this.da);
        }
        catch (SQLException sQLException) {
            return new ArrayList<SearchClass>();
        }
    }

    @Override
    public void populateSearch(String SearchValue) {
        this.customerList.currentPage = 0;
        this.customerList = com.xputertechnologies.santa.Customer.SearchCustomers(SearchValue, this.da);
        this.table.setItems(this.customerList.getOriginalList());
        this.table.refresh();
    }

    @Override
    public void done() {
        if (this.validateControl() && this.needToSave) {
            try {
                this.customerList.update();
                this.table.refresh();
                this.mainPage.showNotification(NotificationType.Success, "Operation Successful", this);
            }
            catch (Exception ex) {
                this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), this);
            }
        }
    }

    @Override
    void closeNotification() {
        this.mainPage.closeNotification();
    }

    @Override
    boolean validateControl() {
        this.errorMessage = "";
        this.needToSave = false;
        for (com.xputertechnologies.santa.Customer sa : this.customerList.getOriginalList()) {
            if (sa.getState() != ObjectState.Changed && sa.getState() != ObjectState.New) continue;
            this.needToSave = true;
            break;
        }
        return true;
    }

    @Override
    void yes() {
        try {
            this.done();
            this.mainPage.isToMenu = true;
            this.closeNotification();
            this.mainPage.hbCenter.setContent((Node)this.mainPage.menuControl);
            this.mainPage.hbBottom.setVisible(false);
        }
        catch (Exception ex) {
            this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), this);
        }
    }

    @Override
    void no() {
        this.mainPage.isToMenu = true;
        this.closeNotification();
        this.mainPage.hbCenter.setContent((Node)this.mainPage.menuControl);
        this.mainPage.hbBottom.setVisible(false);
    }

    @Override
    void completeControl() {
        this.mainPage.isToMenu = false;
        this.mainPage.showNotification(NotificationType.Warning, "Do you want to save change(s)", this);
    }

    @Override
    public Dialog getDialog() {
        return this.dialog;
    }

    @Override
    public CustomerDataList getCustomerDataList() {
        return this.customerList;
    }

    @Override
    public DataAccess getDataAccess() {
        return this.da;
    }

    @Override
    public Santa getSanta() {
        return this.santa;
    }

    @Override
    public void updateOtherParam() {
        this.table.setItems(this.customerList.getOriginalList());
        this.table.refresh();
        this.lblCount.setText(String.valueOf(this.customerList.getTotalRecord("Customer")) + " Items available");
        this.mainPage.showNotification(NotificationType.Success, "Operation Successful", this);
    }
}

