/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.xputertechnologies.santa.DbEntity;
import com.xputertechnologies.santa.ui.DecimalNumberTextBox;
import com.xputertechnologies.santa.ui.UIParent;
import javafx.scene.Node;
import javafx.scene.control.TableCell;

public class CustomEditableTableColumnNumberFloat<T extends DbEntity>
extends TableCell<T, Float> {
    private DecimalNumberTextBox txtBox;
    UIParent notifyChange;

    CustomEditableTableColumnNumberFloat(UIParent notifyChange) {
        this.notifyChange = notifyChange;
    }

    CustomEditableTableColumnNumberFloat(boolean isNumber) {
    }

    public void startEdit() {
        if (!this.isEmpty()) {
            super.startEdit();
            this.createTextField();
            this.setText(null);
            this.setGraphic((Node)this.txtBox);
            this.txtBox.selectAll();
        }
    }

    public void cancelEdit() {
        super.cancelEdit();
        this.setText(Float.toString(((Float)this.getItem()).floatValue()));
        this.setGraphic(null);
    }

    public void updateItem(Float item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (empty) {
            this.setText(null);
            this.setGraphic(null);
        } else if (this.isEditing()) {
            if (this.txtBox != null) {
                this.txtBox.setText(Float.toString(this.getValue().floatValue()));
            }
            this.setText(null);
            this.setGraphic((Node)this.txtBox);
        } else {
            this.setText(Float.toString(this.getValue().floatValue()));
            this.setGraphic(null);
        }
    }

    private void createTextField() {
        this.txtBox = new DecimalNumberTextBox(Float.valueOf(this.getValue().floatValue()).floatValue());
        this.txtBox.setMin(0.0);
        this.txtBox.setMinWidth(this.getWidth() - this.getGraphicTextGap() * 2.0);
        this.txtBox.setOnAction(e -> this.commitEdit(Float.valueOf(Float.parseFloat(this.txtBox.getText()))));
        this.txtBox.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                System.out.println("Commiting Float" + this.txtBox.getText());
                this.commitEdit(Float.valueOf(this.txtBox.getText()));
                this.notifyChange.propertyChange();
            }
        });
    }

    private Float getValue() {
        return Float.valueOf(this.getItem() == null ? 0.0f : ((Float)this.getItem()).floatValue());
    }
}

