/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.xputertechnologies.santa.DbEntity;
import com.xputertechnologies.santa.ui.DecimalNumberTextBox;
import com.xputertechnologies.santa.ui.UIParent;
import javafx.scene.Node;
import javafx.scene.control.TableCell;

public class CustomEditableTableColumnNumberDouble<T extends DbEntity>
extends TableCell<T, Double> {
    UIParent notifyChange;
    private DecimalNumberTextBox txtBox;

    CustomEditableTableColumnNumberDouble() {
    }

    CustomEditableTableColumnNumberDouble(UIParent notifyChange) {
        this.notifyChange = notifyChange;
    }

    public void startEdit() {
        if (!this.isEmpty()) {
            super.startEdit();
            this.createTextField();
            this.setText(null);
            this.setGraphic((Node)this.txtBox);
            this.txtBox.selectAll();
        }
    }

    public void cancelEdit() {
        super.cancelEdit();
        this.setText(Double.toString((Double)this.getItem()));
        this.setGraphic(null);
    }

    public void updateItem(Double item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (empty) {
            this.setText(null);
            this.setGraphic(null);
        } else if (this.isEditing()) {
            if (this.txtBox != null) {
                this.txtBox.setText(Double.toString(this.getValue()));
            }
            this.setText(null);
            this.setGraphic((Node)this.txtBox);
        } else {
            this.setText(Double.toString(this.getValue()));
            this.setGraphic(null);
        }
    }

    private void createTextField() {
        this.txtBox = new DecimalNumberTextBox(this.getValue());
        this.txtBox.setMin(0.0);
        this.txtBox.setMinWidth(this.getWidth() - this.getGraphicTextGap() * 2.0);
        this.txtBox.setOnAction(e -> this.commitEdit(Double.parseDouble(this.txtBox.getText())));
        this.txtBox.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                System.out.println("Commiting Double " + this.txtBox.getText());
                this.commitEdit(Double.valueOf(this.txtBox.getText()));
                this.notifyChange.propertyChange();
            }
        });
    }

    private Double getValue() {
        return this.getItem() == null ? 0.0 : (Double)this.getItem();
    }
}

