/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.xputertechnologies.santa.ObjectDb;
import com.xputertechnologies.santa.WebRequest;
import com.xputertechnologies.santa.ui.Santa;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AppLoader {
    static final Integer AppVersion = 1;
    static final String AppDirName = "Santa";
    static final String JarName = "Santa.jar";
    static final String JarURL = Santa.decodeString(ObjectDb.downloadPath) + "/Santa.jar";
    static final String MainClass = "com.xputertechnologies.santa.ui.Santa";
    static boolean isWindows = System.getProperty("os.name").indexOf("Windows") >= 0;
    static boolean isMac = System.getProperty("os.name").indexOf("Mac OS X") >= 0;

    public static boolean needUpdateApp() {
        return WebRequest.isInternetAvailable() != false && AppLoader.isUpdateAvailable();
    }

    public static boolean isUpdateAvailable() {
        try {
            File jarFile = AppLoader.getAppFile(JarName);
            URL url = new URL(JarURL);
            URLConnection connection = url.openConnection();
            long mod0 = jarFile.lastModified();
            long mod1 = connection.getLastModified();
            if (mod0 >= mod1) {
                System.out.println("No update available at " + JarURL + "(" + mod0 + ">" + mod1 + ")");
                return false;
            }
            return true;
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(AppLoader.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(AppLoader.class.getName()).log(Level.SEVERE, null, ex);
        }
        return false;
    }

    public static File getAppDataDir(String aName, boolean doCreate) {
        Object dir = "C:";
        if (isMac) {
            dir = System.getProperty("user.home");
        }
        if (aName != null) {
            dir = (String)dir + File.separator + "Yuvend" + File.separator + aName;
        }
        File dfile = new File((String)dir);
        if (doCreate && aName != null) {
            dfile.mkdirs();
        }
        return dfile;
    }

    public static File getAppFile(String aName) {
        return AppLoader.getAppDataDir(aName, true);
    }

    public static File copyFile(File aSource, File aDest) throws IOException {
        FileInputStream fis = new FileInputStream(aSource);
        File out = aDest.isDirectory() ? new File(aDest, aSource.getName()) : aDest;
        FileOutputStream fos = new FileOutputStream(out);
        byte[] buf = new byte[8192];
        int i = fis.read(buf);
        while (i != -1) {
            fos.write(buf, 0, i);
            i = fis.read(buf);
        }
        fis.close();
        fos.close();
        return out;
    }
}

