/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.jfoenix.controls.JFXTextField;
import com.xputertechnologies.santa.ReportSync;
import com.xputertechnologies.santa.ReportUser;
import com.xputertechnologies.santa.RequestApprovalUser;
import com.xputertechnologies.santa.core.ObjectState;
import com.xputertechnologies.santa.list.ReportSyncDataList;
import com.xputertechnologies.santa.list.ReportUserDataList;
import com.xputertechnologies.santa.ui.NotificationType;
import com.xputertechnologies.santa.ui.Santa;
import com.xputertechnologies.santa.ui.TransferPane;
import com.xputertechnologies.santa.ui.UIParent;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.util.Callback;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.controlsfx.glyphfont.FontAwesome;
import org.json.JSONArray;
import org.json.JSONObject;

public class AdminReportTablePane
extends UIParent {
    @FXML
    private TableView<ReportUser> table;
    @FXML
    private TableView<RequestApprovalUser> tableAdm;
    @FXML
    private TableView<ReportSync> tableLog;
    @FXML
    private Button btnNew;
    @FXML
    private Button btnSave;
    @FXML
    private Button btnNewReq;
    @FXML
    private TableColumn colName;
    @FXML
    private TableColumn colEmail;
    @FXML
    private TableColumn colDelete;
    @FXML
    private TableColumn colNameAdm;
    @FXML
    private TableColumn colEmailAdm;
    @FXML
    private TableColumn colDisableAdm;
    @FXML
    private TableColumn colDate;
    @FXML
    private TableColumn colEditAdm;
    @FXML
    private TableColumn colEdit;
    @FXML
    TableColumn<ReportSync, Boolean> colStatus;
    @FXML
    StackPane stackPane;
    VBox progressContainer;
    boolean isNew = true;
    private Dialog dialog = null;

    public AdminReportTablePane(Santa app) {
        super("AdminReportTablePane.fxml", app);
        this.title = "Admin. Users";
        this.colName.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        this.colEmail.setCellValueFactory((Callback)new PropertyValueFactory("email"));
        this.colNameAdm.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        this.colEmailAdm.setCellValueFactory((Callback)new PropertyValueFactory("email"));
        this.prefWidthProperty().bind((ObservableValue)this.santa.mainpage.hbCenter.widthProperty());
        this.prefHeightProperty().bind((ObservableValue)this.santa.mainpage.hbCenter.heightProperty());
        ReportUserDataList rptDataList = new ReportUserDataList(app.da);
        rptDataList.selectAll("Select * From ReportUser", app.da.getEmptyParameterValues());
        this.btnSave.setOnAction(v -> {
            final String url = this.santa.syncSetting.getBEURL() + "RRequest/CreateApprovingUsers";
            ProgressBar progressIndicator = new ProgressBar();
            progressIndicator.setProgress(-1.0);
            final VBox box = new VBox(new Node[]{progressIndicator});
            box.setAlignment(Pos.CENTER);
            this.progressContainer = box;
            this.stackPane.getChildren().add((Object)box);
            Service service = new Service(){

                protected Task createTask() {
                    return new Task(){

                        protected Object call() throws Exception {
                            try {
                                JSONArray jSONArray = new JSONArray();
                                HttpPost httpPost = new HttpPost(url);
                                for (RequestApprovalUser cs : AdminReportTablePane.this.tableAdm.getItems()) {
                                    JSONObject job = new JSONObject();
                                    job.put("Name", (Object)cs.getName());
                                    job.put("Email", (Object)cs.getEmail());
                                    job.put("Enabled", cs.getIsEnable());
                                    jSONArray.put((Object)job);
                                }
                                RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectTimeout(Santa.connectionTimeOut).setSocketTimeout(Santa.socketTimeOut).setConnectionRequestTimeout(Santa.socketTimeOut).build();
                                CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(defaultRequestConfig).build();
                                StringEntity stringEntity = new StringEntity(jSONArray.toString());
                                httpPost.setEntity((HttpEntity)stringEntity);
                                httpPost.setHeader("Content-type", "application/json");
                                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
                                if (response.getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 204) {
                                    httpClient.getConnectionManager().shutdown();
                                    Platform.runLater(() -> {
                                        AdminReportTablePane.this.stackPane.getChildren().remove((Object)box);
                                        AdminReportTablePane.this.mainPage.showNotification(NotificationType.Success, "Operation Successful", AdminReportTablePane.this);
                                    });
                                } else {
                                    String fullError = response.getStatusLine().getReasonPhrase();
                                    Platform.runLater(() -> {
                                        AdminReportTablePane.this.stackPane.getChildren().remove((Object)box);
                                        AdminReportTablePane.this.mainPage.showNotification(NotificationType.Error, fullError, AdminReportTablePane.this);
                                    });
                                }
                            }
                            catch (Exception e) {
                                Platform.runLater(() -> {
                                    AdminReportTablePane.this.stackPane.getChildren().remove((Object)box);
                                    AdminReportTablePane.this.mainPage.showNotification(NotificationType.Error, e.getMessage(), AdminReportTablePane.this);
                                });
                            }
                            return null;
                        }
                    };
                }
            };
            progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
            service.start();
        });
        this.btnNew.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.PLUS).color(Color.WHITE).size(20.0));
        this.btnNewReq.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.PLUS).color(Color.WHITE).size(20.0));
        this.btnSave.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.CHECK).color(Color.WHITE).size(20.0));
        this.btnNew.setOnAction(v -> this.showDialog(null));
        this.btnNewReq.setOnAction(v -> this.showDialogAdmReq(null));
        this.colEditAdm.setCellValueFactory((Callback)new PropertyValueFactory(""));
        Callback<TableColumn<RequestApprovalUser, String>, TableCell<RequestApprovalUser, String>> cellFactoryViewEditAdm = new Callback<TableColumn<RequestApprovalUser, String>, TableCell<RequestApprovalUser, String>>(){

            public TableCell call(TableColumn<RequestApprovalUser, String> param) {
                TableCell<RequestApprovalUser, String> cell = new TableCell<RequestApprovalUser, String>(){
                    final Button btn = new Button("Edit");

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                            this.setText(null);
                        } else {
                            this.btn.setStyle("-fx-background-color: #4FC4F6;");
                            RequestApprovalUser req = (RequestApprovalUser)this.getTableView().getItems().get(this.getIndex());
                            this.btn.setOnAction(event -> AdminReportTablePane.this.showDialogAdmReq(req));
                            this.btn.setGraphic((Node)AdminReportTablePane.this.fontAwesome.create((Enum)FontAwesome.Glyph.EDIT).color(Color.WHITE).size(20.0));
                            this.setGraphic((Node)this.btn);
                            this.setAlignment(Pos.CENTER);
                            this.setText(null);
                        }
                    }
                };
                return cell;
            }
        };
        this.colEditAdm.setCellFactory((Callback)cellFactoryViewEditAdm);
        this.colEdit.setCellValueFactory((Callback)new PropertyValueFactory(""));
        Callback<TableColumn<ReportUser, String>, TableCell<ReportUser, String>> cellFactoryViewEdit = new Callback<TableColumn<ReportUser, String>, TableCell<ReportUser, String>>(){

            public TableCell call(TableColumn<ReportUser, String> param) {
                TableCell<ReportUser, String> cell = new TableCell<ReportUser, String>(){
                    final Button btn = new Button("Edit");

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                            this.setText(null);
                        } else {
                            this.btn.setStyle("-fx-background-color: #4FC4F6;");
                            ReportUser req = (ReportUser)this.getTableView().getItems().get(this.getIndex());
                            this.btn.setOnAction(event -> {
                                try {
                                    AdminReportTablePane.this.showDialog(req);
                                }
                                catch (Exception ex) {
                                    Logger.getLogger(TransferPane.class.getName()).log(Level.SEVERE, null, ex);
                                }
                            });
                            this.btn.setGraphic((Node)AdminReportTablePane.this.fontAwesome.create((Enum)FontAwesome.Glyph.EDIT).color(Color.WHITE).size(20.0));
                            this.setGraphic((Node)this.btn);
                            this.setAlignment(Pos.CENTER);
                            this.setText(null);
                        }
                    }
                };
                return cell;
            }
        };
        this.colEdit.setCellFactory((Callback)cellFactoryViewEdit);
        this.colDelete.setCellValueFactory((Callback)new PropertyValueFactory(""));
        Callback<TableColumn<ReportUser, String>, TableCell<ReportUser, String>> cellFactoryViewDel = new Callback<TableColumn<ReportUser, String>, TableCell<ReportUser, String>>(){

            public TableCell call(TableColumn<ReportUser, String> param) {
                TableCell<ReportUser, String> cell = new TableCell<ReportUser, String>(){
                    final Button btn = new Button("Delete");

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                            this.setText(null);
                        } else {
                            this.btn.setStyle("-fx-background-color: #FF4444;");
                            ReportUser req = (ReportUser)this.getTableView().getItems().get(this.getIndex());
                            this.btn.setOnAction(event -> {
                                try {
                                    AdminReportTablePane.this.table.getItems().removeIf(v -> {
                                        if (v == req) {
                                            try {
                                                ReportUserDataList reportUserDataList = new ReportUserDataList(AdminReportTablePane.this.da);
                                                req.setState(ObjectState.Removed);
                                                reportUserDataList.getOriginalList().add((Object)req);
                                                reportUserDataList.update();
                                            }
                                            catch (Exception ex) {
                                                Logger.getLogger(AdminReportTablePane.class.getName()).log(Level.SEVERE, null, ex);
                                            }
                                        }
                                        return v == req;
                                    });
                                }
                                catch (Exception ex) {
                                    Logger.getLogger(TransferPane.class.getName()).log(Level.SEVERE, null, ex);
                                }
                            });
                            AdminReportTablePane.this.table.refresh();
                            this.setGraphic((Node)this.btn);
                            this.setAlignment(Pos.CENTER);
                            this.setText(null);
                        }
                    }
                };
                return cell;
            }
        };
        this.colDelete.setCellFactory((Callback)cellFactoryViewDel);
        this.colDisableAdm.setCellValueFactory((Callback)new PropertyValueFactory(""));
        Callback<TableColumn<RequestApprovalUser, String>, TableCell<RequestApprovalUser, String>> cellFactoryViewDelAdm = new Callback<TableColumn<RequestApprovalUser, String>, TableCell<RequestApprovalUser, String>>(){

            public TableCell call(TableColumn<RequestApprovalUser, String> param) {
                TableCell<RequestApprovalUser, String> cell = new TableCell<RequestApprovalUser, String>(){
                    final CheckBox cb = new CheckBox("Enabled");

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                            this.setText(null);
                        } else {
                            RequestApprovalUser req = (RequestApprovalUser)this.getTableView().getItems().get(this.getIndex());
                            this.cb.selectedProperty().bindBidirectional((Property)req.isEnableProperty());
                            AdminReportTablePane.this.tableAdm.refresh();
                            this.setGraphic((Node)this.cb);
                            this.setAlignment(Pos.CENTER);
                            this.setText(null);
                        }
                    }
                };
                return cell;
            }
        };
        this.colDisableAdm.setCellFactory((Callback)cellFactoryViewDelAdm);
        ReportSyncDataList reportSyncDataList = new ReportSyncDataList(this.da);
        reportSyncDataList.selectAll("Select * From ReportSync ", this.da.getEmptyParameterValues());
        this.colDate.setCellValueFactory((Callback)new PropertyValueFactory("currentDay"));
        this.colStatus.setCellValueFactory((Callback)new PropertyValueFactory("isSent"));
        this.colStatus.setCellFactory((Callback)new Callback<TableColumn<ReportSync, Boolean>, TableCell<ReportSync, Boolean>>(){

            public TableCell<ReportSync, Boolean> call(TableColumn<ReportSync, Boolean> param) {
                TableCell<ReportSync, Boolean> cell = new TableCell<ReportSync, Boolean>(){

                    public void updateItem(Boolean status, boolean empty) {
                        if (status != null) {
                            ReportSync req = (ReportSync)this.getTableView().getItems().get(this.getIndex());
                            HBox hb = new HBox();
                            hb.setAlignment(Pos.CENTER);
                            ImageView imageView = new ImageView();
                            if (!req.getIsSent()) {
                                imageView.setImage(new Image("/com/xputertechnologies/santa/ui/Images/pending.png"));
                            } else {
                                imageView.setImage(new Image("/com/xputertechnologies/santa/ui/Images/tick_32.png"));
                            }
                            imageView.setFitHeight(25.0);
                            imageView.setFitWidth(25.0);
                            hb.getChildren().add((Object)imageView);
                            this.setGraphic((Node)hb);
                        }
                    }
                };
                return cell;
            }
        });
        this.tableLog.setItems(reportSyncDataList.getOriginalList());
        this.loadRequestUsers();
    }

    public void showDialog(ReportUser reportUser) {
        VBox vBox = new VBox();
        vBox.setSpacing(5.0);
        JFXTextField name = new JFXTextField();
        name.setLabelFloat(true);
        name.setPrefWidth(300.0);
        name.setPromptText("User fullname");
        JFXTextField email = new JFXTextField();
        email.setLabelFloat(true);
        email.setPrefWidth(200.0);
        email.setPromptText("User valid email address");
        if (reportUser != null) {
            name.textProperty().bindBidirectional((Property)reportUser.nameProperty());
            email.textProperty().bindBidirectional((Property)reportUser.emailProperty());
        }
        Button save = new Button("Save");
        save.setOnAction(v -> {
            try {
                ReportUserDataList reportUserDataList = new ReportUserDataList(this.da);
                if (reportUser == null) {
                    ReportUser ru = new ReportUser(this.da);
                    ru.setEmail(email.getText());
                    ru.setName(name.getText());
                    reportUserDataList.getOriginalList().add((Object)ru);
                    reportUserDataList.update();
                    this.table.getItems().add((Object)ru);
                } else {
                    reportUserDataList.getOriginalList().add((Object)reportUser);
                    reportUserDataList.update();
                }
                this.santa.mainpage.showNotification(NotificationType.Success, "User created successfully", this);
                this.table.refresh();
                this.dialog.close();
            }
            catch (Exception ex) {
                this.santa.mainpage.showNotification(NotificationType.Error, ex.getMessage(), this);
                Logger.getLogger(AdminReportTablePane.class.getName()).log(Level.SEVERE, null, ex);
            }
        });
        vBox.getChildren().addAll((Object[])new Node[]{name, email, save});
        String style = "   -fx-background-repeat: repeat;    -fx-background-color: #394264;    -fx-padding: 8px 8px 16px 8px;";
        vBox.setStyle(style);
        this.dialog = new Dialog();
        this.dialog.initStyle(StageStyle.UTILITY);
        this.dialog.initOwner((Window)this.santa.stage);
        this.dialog.setResizable(true);
        this.dialog.setTitle(reportUser == null ? "New User" : "Edit User");
        this.dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.CANCEL});
        this.dialog.getDialogPane().setContent((Node)vBox);
        this.dialog.show();
    }

    public void showDialogAdmReq(RequestApprovalUser reqUser) {
        VBox vBox = new VBox();
        vBox.setSpacing(5.0);
        JFXTextField name = new JFXTextField();
        name.setPrefWidth(300.0);
        name.setLabelFloat(true);
        name.setPromptText("User fullname");
        JFXTextField email = new JFXTextField();
        email.setPrefWidth(200.0);
        email.setLabelFloat(true);
        email.setPromptText("User valid email address");
        CheckBox checkBox = new CheckBox("Enabled");
        if (reqUser != null) {
            name.textProperty().bindBidirectional((Property)reqUser.nameProperty());
            email.textProperty().bindBidirectional((Property)reqUser.emailProperty());
            checkBox.selectedProperty().bindBidirectional((Property)reqUser.isEnableProperty());
        } else {
            checkBox.setVisible(false);
        }
        Button save = new Button("Done");
        save.setOnAction(v -> {
            try {
                if (reqUser == null) {
                    RequestApprovalUser ru = new RequestApprovalUser(this.da);
                    ru.setEmail(email.getText());
                    ru.setName(name.getText());
                    ru.setIsEnable(true);
                    this.tableAdm.getItems().add((Object)ru);
                }
                this.tableAdm.refresh();
                this.dialog.close();
            }
            catch (Exception ex) {
                this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), this);
                Logger.getLogger(AdminReportTablePane.class.getName()).log(Level.SEVERE, null, ex);
            }
        });
        vBox.getChildren().addAll((Object[])new Node[]{name, email, checkBox, save});
        this.dialog = new Dialog();
        this.dialog.initStyle(StageStyle.UTILITY);
        this.dialog.initOwner((Window)this.santa.stage);
        this.dialog.setResizable(true);
        this.dialog.setTitle(reqUser == null ? "New User" : "Edit User");
        this.dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.CANCEL});
        this.dialog.getDialogPane().setContent((Node)vBox);
        this.dialog.show();
    }

    void loadRequestUsers() {
        this.tableAdm.getItems().clear();
        final String url = this.santa.syncSetting.getBEURL() + "RRequest/GetApprovingUsers";
        ProgressBar progressIndicator = new ProgressBar();
        progressIndicator.setProgress(-1.0);
        final VBox box = new VBox(new Node[]{progressIndicator});
        box.setAlignment(Pos.CENTER);
        this.progressContainer = box;
        this.stackPane.getChildren().add((Object)box);
        Service service = new Service(){

            protected Task createTask() {
                return new Task(){

                    protected Object call() throws Exception {
                        try {
                            HttpGet httpGet = new HttpGet(url);
                            RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectTimeout(Santa.connectionTimeOut).setSocketTimeout(Santa.socketTimeOut).setConnectionRequestTimeout(Santa.socketTimeOut).build();
                            httpGet.setHeader("Content-type", "application/json");
                            CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(defaultRequestConfig).build();
                            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
                            if (response.getStatusLine().getStatusCode() == 200) {
                                String output;
                                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                StringBuilder stringBuilder = new StringBuilder();
                                System.out.println("Output from Server .... \n");
                                while ((output = br.readLine()) != null) {
                                    System.out.println(output);
                                    stringBuilder.append(output + "\n");
                                }
                                br.close();
                                httpClient.getConnectionManager().shutdown();
                                String result = stringBuilder.toString();
                                JSONArray ra = new JSONArray(result);
                                ObservableList requestApprovalUsers = FXCollections.observableArrayList();
                                for (int i = 0; i < ra.length(); ++i) {
                                    JSONObject jaJSONObject = ra.getJSONObject(i);
                                    RequestApprovalUser rau = new RequestApprovalUser(AdminReportTablePane.this.da);
                                    rau.setSn(i + 1);
                                    rau.setEmail(jaJSONObject.getString("Email"));
                                    rau.setName(jaJSONObject.getString("Name"));
                                    rau.setIsEnable(jaJSONObject.getBoolean("Enabled"));
                                    requestApprovalUsers.add((Object)rau);
                                }
                                Platform.runLater(() -> {
                                    AdminReportTablePane.this.stackPane.getChildren().remove((Object)box);
                                    AdminReportTablePane.this.tableAdm.setItems(requestApprovalUsers);
                                });
                            } else {
                                String fullError = response.getStatusLine().getReasonPhrase();
                                AdminReportTablePane.this.mainPage.showNotification(NotificationType.Error, fullError, AdminReportTablePane.this);
                                Platform.runLater(() -> AdminReportTablePane.this.stackPane.getChildren().remove((Object)box));
                            }
                        }
                        catch (Exception e) {
                            Platform.runLater(() -> AdminReportTablePane.this.stackPane.getChildren().remove((Object)box));
                            AdminReportTablePane.this.mainPage.showNotification(NotificationType.Error, e.getMessage(), AdminReportTablePane.this);
                        }
                        return null;
                    }
                };
            }
        };
        progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
        service.start();
    }
}

