/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.jfoenix.controls.JFXCheckBox;
import com.xputertechnologies.santa.AccountDetail;
import com.xputertechnologies.santa.AccountPaymentType;
import com.xputertechnologies.santa.NameValueObject;
import com.xputertechnologies.santa.core.ObjectState;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.list.AccountDetailDataList;
import com.xputertechnologies.santa.list.SaleAccountDetailResolverDataList;
import com.xputertechnologies.santa.ui.NotificationType;
import com.xputertechnologies.santa.ui.SyncSettingPane;
import com.xputertechnologies.santa.ui.UIControlBase;
import java.sql.JDBCType;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;

public class AccountDetailItem
extends UIControlBase {
    @FXML
    private TextField tbAccName;
    @FXML
    private TextField tbAccNo;
    @FXML
    private ComboBox cmbType;
    @FXML
    private JFXCheckBox chkDefault;
    @FXML
    private JFXCheckBox chkDisable;
    @FXML
    private JFXCheckBox chkDelete;
    @FXML
    private ImageView btnRemove;
    public AccountDetail accountDetail;
    SyncSettingPane pane;

    public Integer getAccountDetailPos() {
        return this.accountDetail.getPosition();
    }

    public AccountDetailItem(final AccountDetail accountDetail, final SyncSettingPane pane, Integer totalCount) {
        try {
            this.pane = pane;
            this.accountDetail = accountDetail;
            this.chkDefault.selectedProperty().bindBidirectional((Property)accountDetail.isDefaultProperty());
            this.chkDisable.selectedProperty().bindBidirectional((Property)accountDetail.isDisableProperty());
            this.chkDelete.selectedProperty().bindBidirectional((Property)accountDetail.isDeletedProperty());
            this.chkDefault.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                    AccountDetailItem exist = pane.RepeatingVB.getChildren().stream().filter(p -> ((AccountDetailItem)p).accountDetail.getIsDefault()).findAny().orElse(null);
                    if (exist != null) {
                        exist.accountDetail.isDefaultProperty().set(false);
                    }
                    accountDetail.setIsDefault(newValue);
                }
            });
            ObservableList optionsAcctType = FXCollections.observableArrayList();
            int index = -1;
            for (int i = 0; i < AccountPaymentType.values().length; ++i) {
                optionsAcctType.add((Object)AccountPaymentType.values()[i].name());
                if (!AccountPaymentType.values()[i].name().equals(this.accountDetail.getAccType())) continue;
                index = i;
            }
            this.cmbType.setItems(optionsAcctType);
            if (accountDetail.getState() != ObjectState.New) {
                this.cmbType.getSelectionModel().select(index);
            }
            this.cmbType.getSelectionModel().selectedItemProperty().addListener(new ChangeListener(){

                public void changed(ObservableValue observable, Object oldValue, Object newValue) {
                    accountDetail.setAccType(((NameValueObject)newValue).getKey());
                }
            });
            this.tbAccName.textProperty().bindBidirectional((Property)this.accountDetail.accNameProperty());
            this.tbAccNo.textProperty().bindBidirectional((Property)this.accountDetail.accNumberProperty());
            this.btnRemove.setImage(new Image("/com/xputertechnologies/santa/ui/Images/decrease.png"));
            this.btnRemove.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent event) {
                    event.consume();
                    if (!AccountDetailItem.this.checkIfPartTransaction()) {
                        if (accountDetail.getState() == ObjectState.New) {
                            pane.RepeatingVB.getChildren().removeIf((Predicate)new Predicate<Node>(){

                                @Override
                                public boolean test(Node t) {
                                    return ((AccountDetailItem)t).accountDetail.equals(accountDetail);
                                }
                            });
                        } else {
                            AccountDetailDataList accountDetailDataList = new AccountDetailDataList(pane.da);
                            accountDetail.setState(ObjectState.Removed);
                            accountDetailDataList.getOriginalList().add((Object)accountDetail);
                            try {
                                accountDetailDataList.update();
                                pane.RepeatingVB.getChildren().removeIf((Predicate)new Predicate<Node>(){

                                    @Override
                                    public boolean test(Node t) {
                                        return ((AccountDetailItem)t).accountDetail.equals(accountDetail);
                                    }
                                });
                                pane.mainPage.showNotification(NotificationType.Success, "Operation Successful", pane);
                            }
                            catch (Exception ex) {
                                accountDetail.setState(ObjectState.Unchanged);
                                Logger.getLogger(SyncSettingPane.class.getName()).log(Level.SEVERE, null, ex);
                            }
                        }
                    } else {
                        pane.mainPage.showNotification(NotificationType.Error, "Account with transaction cannot be remove", pane);
                    }
                }
            });
        }
        catch (Exception ex) {
            Logger.getLogger(AccountDetailItem.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public boolean checkIfPartTransaction() {
        SaleAccountDetailResolverDataList sadrdl = new SaleAccountDetailResolverDataList(this.pane.da);
        sadrdl.selectAll("Select * From SaleAccountDetailResolver where accNumber=?", new ParameterValue[]{new ParameterValue("accNumber", JDBCType.VARCHAR, this.accountDetail.getAccNumber())});
        return sadrdl.getOriginalList().size() > 0;
    }
}

