/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa;

import com.xputertechnologies.santa.DbEntity;
import com.xputertechnologies.santa.StockItem;
import com.xputertechnologies.santa.core.BaseConcurrencyException;
import com.xputertechnologies.santa.core.DataAccess;
import com.xputertechnologies.santa.core.ObjectState;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.core.SearchCondition;
import com.xputertechnologies.santa.core.Searchable;
import com.xputertechnologies.santa.list.UnitDataList;
import java.sql.JDBCType;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.FloatProperty;
import javafx.beans.property.SimpleFloatProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;

public class Unit
extends DbEntity {
    public boolean isEdit = false;
    boolean isclone;
    public Unit vclone;
    private StringProperty name = new SimpleStringProperty();
    private String unitName;
    private FloatProperty quantity = new SimpleFloatProperty();
    private static int returnIndex = -1;

    public Unit() {
    }

    public Unit(String name, Float quantity, DataAccess dbAccess) {
        super(dbAccess);
        this.isConstructor = true;
        this.nameProperty().set((Object)name);
        this.quantityProperty().set(quantity.floatValue());
        this.setState(ObjectState.Unchanged);
        this.setMustClone(true);
        this.isConstructor = false;
        this.initializeListener();
    }

    public Unit(DataAccess dbAccess) {
        super(dbAccess);
        this.initializeListener();
    }

    public String getName() {
        return (String)this.name.get();
    }

    public void setName(String name) {
        if (!this.isclone && this.isMustClone()) {
            this.vclone = this.clone();
        }
        this.name.set((Object)name);
        this.unitName = name;
        this.changeObjectState();
    }

    public StringProperty nameProperty() {
        return this.name;
    }

    public float getQuantity() {
        return this.quantity.get();
    }

    public void setQuantity(float quantity) {
        if (!this.isclone && this.isMustClone()) {
            this.vclone = this.clone();
        }
        this.quantity.set(quantity);
        this.changeObjectState();
    }

    public FloatProperty quantityProperty() {
        return this.quantity;
    }

    public Unit clone() {
        Unit cloneTemp = new Unit(this.getDbAccess());
        cloneTemp.setMustClone(false);
        cloneTemp.name.set((Object)((String)this.name.get()));
        cloneTemp.quantity.set(this.quantity.get());
        cloneTemp.setMustClone(true);
        this.isclone = true;
        return cloneTemp;
    }

    public Unit outerClone() {
        Unit cloneTemp = new Unit(this.getDbAccess());
        cloneTemp.setMustClone(false);
        cloneTemp.name.set((Object)((String)this.name.get()));
        cloneTemp.quantity.set(this.quantity.get());
        cloneTemp.setMustClone(true);
        return cloneTemp;
    }

    private void rollBack() {
        this.name.set((Object)((String)this.vclone.name.get()));
        this.quantity.set(this.vclone.quantity.get());
        this.setMustClone(true);
    }

    @Override
    public void insert() throws Exception {
        try {
            ParameterValue[] paramValue = new ParameterValue[]{new ParameterValue("name", JDBCType.VARCHAR, this.name.get()), new ParameterValue("quantity", JDBCType.FLOAT, Float.valueOf(this.quantity.get()))};
            String query = "insert into Unit (name,quantity) values(?,?)";
            this.getDbAccess().performDbOperation(query, paramValue);
            this.vclone = this.clone();
        }
        catch (Exception ex) {
            this.rollBack();
            this.isclone = false;
            throw ex;
        }
    }

    @Override
    public void update() throws BaseConcurrencyException, Exception {
        String query = "update Unit set name=?,quantity=? where name=? and quantity=?";
        try {
            ParameterValue[] paramValue = new ParameterValue[]{new ParameterValue("name", JDBCType.VARCHAR, this.name.get()), new ParameterValue("quantity", JDBCType.FLOAT, Float.valueOf(this.quantity.get())), new ParameterValue("cloneName", JDBCType.VARCHAR, this.vclone.name.get()), new ParameterValue("cloneQuantity", JDBCType.FLOAT, Float.valueOf(this.vclone.quantity.get()))};
            this.getDbAccess().performDbOperation(query, paramValue, true);
            this.vclone = this.clone();
        }
        catch (Exception ex) {
            this.rollBack();
            this.isclone = false;
            if (ex instanceof BaseConcurrencyException) {
                throw new BaseConcurrencyException("This object has been modified by another user, please reload your data", null);
            }
            throw ex;
        }
    }

    @Override
    public void delete() {
        String query = "Delete from Unit  where name=? ";
        try {
            this.getDbAccess().performDbOperation(query, new ParameterValue[]{new ParameterValue("name", JDBCType.VARCHAR, this.name.get())});
        }
        catch (Exception ex) {
            Logger.getLogger(Unit.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public Searchable getSearchable() {
        Searchable sb = new Searchable();
        String[] parameters = new String[]{"name", "quantity"};
        sb.setTableName("Unit");
        sb.setParameters(parameters);
        return sb;
    }

    public static UnitDataList SearchUnit(String searchString, DataAccess da) {
        ArrayList<ParameterValue> tempParamValue = new ArrayList<ParameterValue>();
        tempParamValue.add(new ParameterValue("name", JDBCType.VARCHAR, "%" + searchString + "%"));
        UnitDataList customerList = new UnitDataList(da);
        SearchCondition searchCondition = new SearchCondition();
        searchCondition.setParametersvalues(tempParamValue);
        customerList.select(searchCondition, true, false);
        return customerList;
    }

    @Override
    public void beforeInsert() {
    }

    @Override
    public void afterInsert() {
        this.setState(ObjectState.Unchanged);
    }

    @Override
    public void beforeUpdate() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void afterUpdate() {
    }

    public String toString() {
        return (String)this.name.get();
    }

    public float convertUnit(Unit fromUnit) {
        return this.quantity.get() / fromUnit.getQuantity();
    }

    public float convertUnit(float frmQty) {
        return this.quantity.get() / frmQty;
    }

    public static Double convertUnitFromOneToAnother(StockItem baseUnit, Unit toUnit) {
        return baseUnit.getSellingPrice() / (double)baseUnit.getParentUnit().getQuantity() * (double)toUnit.getQuantity();
    }

    public static Double convertUnitFromOneToAnotherCp(StockItem baseUnit, Unit toUnit) {
        return baseUnit.getCostPrice() / (double)baseUnit.getParentUnit().getQuantity() * (double)toUnit.getQuantity();
    }

    public static int getPiecesIndex(UnitDataList unitDataList) {
        for (int i = 0; i < unitDataList.getOriginalList().size(); ++i) {
            if (!((Unit)unitDataList.getOriginalList().get(i)).getName().equals("Pieces")) continue;
            returnIndex = i;
            break;
        }
        return returnIndex;
    }

    @Override
    public void initializeListener() {
        this.name.addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                Unit.this.setName(newValue);
            }
        });
        this.quantity.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                Unit.this.setQuantity(((Float)newValue).floatValue());
            }
        });
    }
}

