/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa;

import com.xputertechnologies.santa.Company;
import com.xputertechnologies.santa.DbEntity;
import com.xputertechnologies.santa.Unit;
import com.xputertechnologies.santa.core.BaseConcurrencyException;
import com.xputertechnologies.santa.core.DataAccess;
import com.xputertechnologies.santa.core.ObjectState;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.core.SearchCondition;
import com.xputertechnologies.santa.core.Searchable;
import com.xputertechnologies.santa.list.CompanyDataList;
import com.xputertechnologies.santa.list.ProductSerialDataList;
import com.xputertechnologies.santa.list.StockItemList;
import com.xputertechnologies.santa.list.UnitDataList;
import java.sql.Date;
import java.sql.JDBCType;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.FloatProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleFloatProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;

public class StockItem
extends DbEntity {
    private StringProperty storeName = new SimpleStringProperty("");
    public static String insertQuery = "insert into StockItem  (itemCode,companyName,costPrice,image,maker,name,preload,quantity,cnsQty,dspQty,sellingPrice,size,stockUnit,type,directPurchaseQty,dateLastSold,priceB2B,isActive,syncFlag,manufacture,itemUnit,netWeight) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    public static String updateQuery = "update StockItem set itemCode=?,companyName=?,costPrice=?,image=?,maker=?,name=?,preload=?,quantity=?,cnsQty=?,dspQty=?,sellingPrice=?,size=?,stockUnit=?,type=?,directPurchaseQty=?,dateLastSold=?, priceB2B=?,isActive=?,syncFlag=?,manufacture=?,itemUnit=?,netWeight=? where ItemCode=?";
    private ProductSerialDataList serials = new ProductSerialDataList(this.getDbAccess());
    public int totalQty;
    private StringProperty syncError = new SimpleStringProperty("");
    private StringProperty manufacture = new SimpleStringProperty("");
    private StringProperty itemUnit = new SimpleStringProperty("");
    public boolean isEdit = false;
    private Company parentCompany;
    private Unit parentUnit;
    private FloatProperty dspQty = new SimpleFloatProperty();
    private FloatProperty netWeight = new SimpleFloatProperty();
    private FloatProperty cnsQty = new SimpleFloatProperty();
    public String serial;
    public String status;
    public String whsCode;
    public int sysSerial;
    private BooleanProperty syncFlag = new SimpleBooleanProperty(true);
    private float prevBalanceBfQty;
    private StringProperty maker = new SimpleStringProperty();
    private int sn;
    private StringProperty subGroup_name = new SimpleStringProperty();
    private DoubleProperty priceB2B = new SimpleDoubleProperty();
    private BooleanProperty isActive = new SimpleBooleanProperty();
    private BooleanProperty isReplaced = new SimpleBooleanProperty();
    private StringProperty name = new SimpleStringProperty();
    private StringProperty itemCode = new SimpleStringProperty();
    boolean isclone;
    public StockItem vclone;
    private StringProperty tempCode = new SimpleStringProperty(UUID.randomUUID().toString());
    private StringProperty size = new SimpleStringProperty();
    private StringProperty type = new SimpleStringProperty();
    private ObjectProperty dateLastSold = new SimpleObjectProperty((Object)Date.valueOf(LocalDate.now()));
    private ObjectProperty<byte[]> image = new SimpleObjectProperty();
    private DoubleProperty sellingPrice = new SimpleDoubleProperty();
    private DoubleProperty costPrice = new SimpleDoubleProperty();
    private FloatProperty quantity = new SimpleFloatProperty();
    private FloatProperty quantityWithdraw = new SimpleFloatProperty();
    private FloatProperty replacementValue = new SimpleFloatProperty();
    private StringProperty comment = new SimpleStringProperty();
    private StringProperty displayQuantity = new SimpleStringProperty();
    private String stockUnit;
    private BooleanProperty preload = new SimpleBooleanProperty();
    private String companyName;
    private DoubleProperty directPurchaseQty = new SimpleDoubleProperty();

    public StringProperty storeNameProperty() {
        return this.storeName;
    }

    public String getStoreName() {
        return (String)this.manufacture.get();
    }

    public void setStoreName(String storeName) {
        this.storeName.set((Object)storeName);
    }

    public ProductSerialDataList getSerials() {
        return this.serials;
    }

    public void setTotalQty() {
        this.totalQty = (int)((float)((int)this.quantityProperty().get()) + this.cnsQtyProperty().get() + this.dspQtyProperty().get());
    }

    public int getTotalQty() {
        this.totalQty = (int)((float)((int)this.quantityProperty().get()) + this.cnsQtyProperty().get() + this.dspQtyProperty().get());
        return this.totalQty;
    }

    public StringProperty syncErrorProperty() {
        return this.syncError;
    }

    public String getSyncError() {
        return (String)this.syncError.get();
    }

    public void setSyncError(String syncError) {
        if (!this.isclone && this.isMustClone()) {
            this.vclone = this.clone();
        }
        this.syncError.set((Object)syncError);
        this.changeObjectState();
    }

    public StringProperty manufactureProperty() {
        return this.manufacture;
    }

    public String getManufacture() {
        return (String)this.manufacture.get();
    }

    public void setManufacture(String manufacture) {
        if (!this.isclone && this.isMustClone()) {
            this.vclone = this.clone();
        }
        this.manufacture.set((Object)manufacture);
        this.changeObjectState();
    }

    public StringProperty itemUnitProperty() {
        return this.itemUnit;
    }

    public String getItemUnit() {
        return (String)this.itemUnit.get();
    }

    public void setItemUnit(String itemUnit) {
        if (!this.isclone && this.isMustClone()) {
            this.vclone = this.clone();
        }
        this.itemUnit.set((Object)itemUnit);
        this.changeObjectState();
    }

    public int getSn() {
        return this.sn;
    }

    public void setSn(int sn) {
        this.sn = sn;
    }

    public StockItem() {
    }

    public StockItem(DataAccess dbAccess) {
        super(dbAccess);
    }

    public int getDspQty() {
        return (int)this.dspQty.get();
    }

    public void setDspQty(float dspQty) {
        if (!this.isclone && this.isMustClone()) {
            this.vclone = this.clone();
        }
        this.dspQty.set(dspQty);
        this.changeObjectState();
    }

    public FloatProperty dspQtyProperty() {
        return this.dspQty;
    }

    public float getNetWeight() {
        return this.netWeight.get();
    }

    public void setNetWeight(float netWeight) {
        if (!this.isclone && this.isMustClone()) {
            this.vclone = this.clone();
        }
        this.netWeight.set(netWeight);
        this.changeObjectState();
    }

    public FloatProperty netWeightProperty() {
        return this.netWeight;
    }

    public int getCnsQty() {
        return (int)this.cnsQty.get();
    }

    public void setCnsQty(float cnsQty) {
        if (!this.isclone && this.isMustClone()) {
            this.vclone = this.clone();
        }
        this.cnsQty.set(cnsQty);
        this.changeObjectState();
    }

    public FloatProperty cnsQtyProperty() {
        return this.cnsQty;
    }

    public Boolean getSyncFlag() {
        return this.syncFlag.get();
    }

    public void setSyncFlag(Boolean syncFlag) {
        if (!this.isclone && this.isMustClone()) {
            this.vclone = this.clone();
        }
        this.syncFlag.set(syncFlag.booleanValue());
        this.changeObjectState();
    }

    public BooleanProperty syncFlagProperty() {
        return this.syncFlag;
    }

    public StockItem(String itemCode, String companyName, Double costPrice, byte[] image, String maker, String name, Boolean preload, Float quantity, Float cnsQty, Float dspQty, Double sellingPrice, String size, String stockUnit, String type, double directPurchaseQty, Date dateLastSold, Double priceB2B, String serial, String status, Integer sysSerial, String whsCode, String manufacture, String itemUnit, Float netWeight, DataAccess dt) {
        super(dt);
        this.manufacture.set((Object)manufacture);
        this.netWeight.set(netWeight.floatValue());
        this.itemUnit.set((Object)itemUnit);
        this.whsCode = whsCode;
        this.status = status;
        this.sysSerial = sysSerial;
        this.serial = serial;
        this.itemCode.set((Object)itemCode);
        this.name.set((Object)name);
        this.dspQty.set(dspQty.floatValue());
        this.cnsQty.set(cnsQty.floatValue());
        this.maker.set((Object)maker);
        this.size.set((Object)size);
        this.type.set((Object)type);
        this.image.set((Object)image);
        this.sellingPrice.set(sellingPrice.doubleValue());
        this.costPrice.set(costPrice.doubleValue());
        this.quantity.set(quantity.floatValue());
        this.directPurchaseQty.set(directPurchaseQty);
        this.dateLastSold.set((Object)dateLastSold);
        this.stockUnit = stockUnit;
        this.preload.set(preload.booleanValue());
        this.companyName = companyName;
        this.priceB2B.set(priceB2B.doubleValue());
        this.setState(ObjectState.Unchanged);
        this.setMustClone(true);
        this.initializeListener();
        this.vclone = this.clone();
    }

    public StockItem(String itemCode, String companyName, Double costPrice, byte[] image, String maker, String name, Boolean preload, Float quantity, Float cnsQty, Float dspQty, Double sellingPrice, String size, String stockUnit, String type, double directPurchaseQty, Date dateLastSold, Double priceB2B, Boolean isActive, Boolean syncFlag, String manufacture, String itemUnit, float netWeight, DataAccess dt) {
        super(dt);
        this.manufacture.set((Object)manufacture);
        this.netWeight.set(netWeight);
        this.itemUnit.set((Object)itemUnit);
        this.syncFlag.set(syncFlag.booleanValue());
        this.isActive.set(isActive.booleanValue());
        this.itemCode.set((Object)itemCode);
        this.name.set((Object)name);
        this.dspQty.set(dspQty.floatValue());
        this.cnsQty.set(cnsQty.floatValue());
        this.maker.set((Object)maker);
        this.size.set((Object)size);
        this.type.set((Object)type);
        this.image.set((Object)image);
        this.sellingPrice.set(sellingPrice.doubleValue());
        this.costPrice.set(costPrice.doubleValue());
        this.quantity.set(quantity.floatValue());
        this.directPurchaseQty.set(directPurchaseQty);
        this.dateLastSold.set((Object)dateLastSold);
        this.stockUnit = stockUnit;
        this.preload.set(preload.booleanValue());
        this.companyName = companyName;
        this.priceB2B.set(priceB2B.doubleValue());
        this.setState(ObjectState.Unchanged);
        this.setMustClone(true);
        this.initializeListener();
        this.vclone = this.clone();
    }

    public StockItem(String name, String maker, String type, String size, boolean isSelected, Company company) {
        this.name.set((Object)name);
        this.maker.set((Object)maker);
        this.size.set((Object)size);
        this.type.set((Object)type);
        this.setIsActive(isSelected);
        this.setParentCompany(company);
        this.initializeListener();
    }

    public boolean existInStockItem() {
        StockItemList stockItemList = new StockItemList(this.getParentCompany().getDbAccess());
        stockItemList.selectAll("Select * From StockItem where name=? and maker=? and type=? and size=?", new ParameterValue[]{new ParameterValue("name", JDBCType.VARCHAR, this.name.get()), new ParameterValue("maker", JDBCType.VARCHAR, this.maker.get()), new ParameterValue("type", JDBCType.VARCHAR, this.type.get()), new ParameterValue("size", JDBCType.VARCHAR, this.size.get())});
        return stockItemList.getOriginalList().size() == 1;
    }

    public float getPrevBalaceBfQty() {
        return this.prevBalanceBfQty;
    }

    public void setPrevBalaceBfQty(float prevBalanceBfQty) {
        this.prevBalanceBfQty = prevBalanceBfQty;
    }

    public StringProperty makerProperty() {
        return this.maker;
    }

    public String getGroups() {
        return (String)this.maker.get();
    }

    public void setGroups(String maker) {
        if (!this.isclone && this.isMustClone()) {
            this.vclone = this.clone();
        }
        this.maker.set((Object)maker);
        this.changeObjectState();
    }

    public StringProperty subGroup_nameProperty() {
        return this.subGroup_name;
    }

    public String getSubGroup_name() {
        return (String)this.subGroup_name.get();
    }

    public void setSubGroup_name(String subGroup_name) {
        if (!this.isclone && this.isMustClone()) {
            this.vclone = this.clone();
        }
        this.subGroup_name.set((Object)subGroup_name);
        this.changeObjectState();
    }

    public double getPriceB2B() {
        return this.priceB2B.get();
    }

    public void setPriceB2B(double priceB2B) {
        if (!this.isclone && this.isMustClone()) {
            this.vclone = this.clone();
        }
        this.priceB2B.set(priceB2B);
        this.changeObjectState();
    }

    public DoubleProperty priceB2BProperty() {
        return this.priceB2B;
    }

    public BooleanProperty isActiveProperty() {
        return this.isActive;
    }

    public boolean getIsActive() {
        return this.isActive.get();
    }

    public void setIsActive(boolean isActive) {
        if (!this.isclone && this.isMustClone()) {
            this.vclone = this.clone();
        }
        this.isActive.set(isActive);
        this.changeObjectState();
    }

    public BooleanProperty isReplacedProperty() {
        return this.isReplaced;
    }

    public boolean getIsReplaced() {
        return this.isReplaced.get();
    }

    public void setIsReplaced(boolean isReplaced) {
        this.isReplaced.set(isReplaced);
    }

    public StringProperty nameProperty() {
        return this.name;
    }

    public String getName() {
        return (String)this.name.get();
    }

    public void setName(String name) {
        if (!this.isclone && this.isMustClone()) {
            this.vclone = this.clone();
        }
        this.name.set((Object)name);
        this.changeObjectState();
    }

    public StringProperty itemCodeProperty() {
        return this.itemCode;
    }

    public String getItemCode() {
        return (String)this.itemCode.get();
    }

    public void setItemCode(String itemCode) {
        if (!this.isclone && this.isMustClone()) {
            this.vclone = this.clone();
        }
        this.itemCode.set((Object)itemCode);
        this.changeObjectState();
    }

    public StringProperty tempCodeProperty() {
        return this.tempCode;
    }

    public String getMaker() {
        return (String)this.maker.get();
    }

    public void setMaker(String maker) {
        if (!this.isclone && this.isMustClone()) {
            this.vclone = this.clone();
        }
        this.maker.set((Object)maker);
        this.changeObjectState();
    }

    public String getSize() {
        return (String)this.size.get();
    }

    public void setSize(String size) {
        if (!this.isclone && this.isMustClone()) {
            this.vclone = this.clone();
        }
        this.size.set((Object)size);
        this.changeObjectState();
    }

    public StringProperty sizeProperty() {
        return this.size;
    }

    public String getType() {
        return (String)this.type.get();
    }

    public void setType(String type) {
        if (!this.isclone && this.isMustClone()) {
            this.vclone = this.clone();
        }
        this.type.set((Object)type);
        this.changeObjectState();
    }

    public StringProperty typeProperty() {
        return this.type;
    }

    public Date getDateLastSold() {
        return (Date)this.dateLastSold.get();
    }

    public void setDateLastSold(Date dateLastSold) {
        if (!this.isclone && this.isMustClone()) {
            this.vclone = this.clone();
        }
        this.dateLastSold.set((Object)dateLastSold);
        this.changeObjectState();
    }

    public ObjectProperty dateLastDateProperty() {
        return this.dateLastSold;
    }

    public byte[] getImage() {
        return (byte[])this.image.get();
    }

    public void setImage(byte[] image) {
        if (!this.isclone && this.isMustClone()) {
            this.vclone = this.clone();
        }
        this.image.set((Object)image);
        this.changeObjectState();
    }

    public ObjectProperty<byte[]> imageProperty() {
        return this.image;
    }

    public double getSellingPrice() {
        return this.sellingPrice.get();
    }

    public void setSellingPrice(double sellingPrice) {
        if (!this.isclone && this.isMustClone()) {
            this.vclone = this.clone();
        }
        this.sellingPrice.set(sellingPrice);
        this.changeObjectState();
    }

    public DoubleProperty sellingPriceProperty() {
        return this.sellingPrice;
    }

    public double getCostPrice() {
        return this.costPrice.get();
    }

    public void setCostPrice(double costPrice) {
        if (!this.isclone && this.isMustClone()) {
            this.vclone = this.clone();
        }
        this.costPrice.set(costPrice);
        this.changeObjectState();
    }

    public DoubleProperty costPriceProperty() {
        return this.costPrice;
    }

    public float getQuantity() {
        return this.quantity.get();
    }

    public void setQuantity(float quantity) {
        if (!this.isclone && this.isMustClone() && this.vclone == null) {
            this.vclone = this.clone();
        }
        this.quantity.set(quantity);
        this.setDisplayQuantity();
        this.changeObjectState();
    }

    public FloatProperty quantityProperty() {
        return this.quantity;
    }

    public float getQuantityWithDraw() {
        return this.quantityWithdraw.get();
    }

    public void setQuantityWithDraw(float quantityWithDraw) {
        if (!this.isclone && this.isMustClone()) {
            this.vclone = this.clone();
        }
        this.quantityWithdraw.set(quantityWithDraw);
        this.changeObjectState();
    }

    public FloatProperty quantityWithdrawProperty() {
        return this.quantityWithdraw;
    }

    public float getReplacementValue() {
        return this.replacementValue.get();
    }

    public void setReplacementValue(float replacementValue) {
        if (!this.isclone && this.isMustClone()) {
            this.vclone = this.clone();
        }
        this.replacementValue.set(replacementValue);
        this.changeObjectState();
    }

    public FloatProperty replacementValueProperty() {
        return this.replacementValue;
    }

    public String getComment() {
        return (String)this.comment.get();
    }

    public StringProperty commentProperty() {
        return this.comment;
    }

    public void setComment(String comment) {
        if (!this.isclone && this.isMustClone()) {
            this.vclone = this.clone();
        }
        this.comment.set((Object)comment);
        this.changeObjectState();
    }

    public String getDisplayQuantity() {
        this.setDisplayQuantity();
        return (String)this.displayQuantity.get();
    }

    public void setDisplayQuantity() {
        if (this.getQuantity() == 0.0f) {
            this.displayQuantity.set((Object)"0 pieces");
        } else if (this.getParentUnit() != null) {
            String whole = String.valueOf(this.getQuantity() / this.getParentUnit().getQuantity());
            String[] temparr = whole.split("\\.");
            float mod = this.getQuantity() % this.getParentUnit().getQuantity();
            this.displayQuantity.set((Object)(temparr[0] + " " + this.getParentUnit().getName() + " " + (String)(mod > 0.0f ? String.valueOf(mod) + " pieces" : "")));
        }
    }

    public String getDisplayQuantityCOnverted() {
        if (this.directPurchaseQty.get() == 0.0) {
            return "0 " + this.getParentUnit().getName();
        }
        String whole = String.valueOf(this.directPurchaseQty.get() / (double)this.getParentUnit().getQuantity());
        String[] temparr = whole.split("\\.");
        float mod = (float)(this.directPurchaseQty.get() % (double)this.getParentUnit().getQuantity());
        return temparr[0] + " " + this.getParentUnit().getName() + " " + (String)(mod > 0.0f ? String.valueOf(mod) + " pieces" : "");
    }

    public StringProperty displayQuantityProperty() {
        this.setDisplayQuantity();
        return this.displayQuantity;
    }

    public String getStockUnit() {
        return this.stockUnit;
    }

    public void setStockUnit(String stockUnit) {
        this.stockUnit = stockUnit;
    }

    public boolean isPreload() {
        return this.preload.get();
    }

    public void setPreload(boolean preload) {
        if (!this.isclone && this.isMustClone()) {
            this.vclone = this.clone();
        }
        this.preload.set(preload);
        this.changeObjectState();
    }

    public BooleanProperty prealoadProperty() {
        return this.preload;
    }

    public double getDirectPurchaseQty() {
        return this.directPurchaseQty.get();
    }

    public void setDirectPurchaseQty(double directPurchaseQty) {
        if (!this.isclone && this.isMustClone()) {
            this.vclone = this.clone();
        }
        this.directPurchaseQty.set(directPurchaseQty);
        this.changeObjectState();
    }

    public DoubleProperty directPurchaseQtyProperty() {
        return this.directPurchaseQty;
    }

    public static ArrayList<String> searchStockItem(String searchString, DataAccess dt) {
        ArrayList<ParameterValue> tempParamValue = new ArrayList<ParameterValue>();
        ArrayList<String> result = new ArrayList<String>();
        StockItemList stockItemList = new StockItemList(dt);
        tempParamValue.add(new ParameterValue("barCode", JDBCType.VARCHAR, "%" + searchString + "%"));
        tempParamValue.add(new ParameterValue("companyName", JDBCType.VARCHAR, "%" + searchString + "%"));
        tempParamValue.add(new ParameterValue("maker", JDBCType.VARCHAR, "%" + searchString + "%"));
        tempParamValue.add(new ParameterValue("name", JDBCType.VARCHAR, "%" + searchString + "%"));
        tempParamValue.add(new ParameterValue("size", JDBCType.VARCHAR, "%" + searchString + "%"));
        tempParamValue.add(new ParameterValue("type", JDBCType.VARCHAR, "%" + searchString + "%"));
        SearchCondition searchCondition = new SearchCondition();
        searchCondition.setParametersvalues(tempParamValue);
        if (!searchString.equals("") && searchString != null) {
            stockItemList.select(searchCondition, true, false);
        }
        return result;
    }

    public static StockItemList searchStock(String searchString, DataAccess dt) {
        ArrayList<ParameterValue> tempParamValue = new ArrayList<ParameterValue>();
        StockItemList stockItemList = new StockItemList(dt);
        tempParamValue.add(new ParameterValue("companyName", JDBCType.VARCHAR, "%" + searchString + "%"));
        tempParamValue.add(new ParameterValue("name", JDBCType.VARCHAR, "%" + searchString + "%"));
        tempParamValue.add(new ParameterValue("itemCode", JDBCType.VARCHAR, "%" + searchString + "%"));
        tempParamValue.add(new ParameterValue("type", JDBCType.VARCHAR, "%" + searchString + "%"));
        SearchCondition searchCondition = new SearchCondition();
        searchCondition.setParametersvalues(tempParamValue);
        if (!searchString.equals("") && searchString != null) {
            stockItemList.select(searchCondition, true, false);
        } else {
            stockItemList.selectAll("Select * From StockItem", dt.getEmptyParameterValues());
        }
        return stockItemList;
    }

    @Override
    public void insert() throws Exception {
        try {
            ParameterValue[] paramValue = new ParameterValue[]{new ParameterValue("itemCode", JDBCType.VARCHAR, this.itemCode.get()), new ParameterValue("companyName", JDBCType.VARCHAR, this.companyName), new ParameterValue("costPrice", JDBCType.DOUBLE, this.costPrice.get()), new ParameterValue("image", JDBCType.BINARY, this.image.get()), new ParameterValue("maker", JDBCType.VARCHAR, this.maker.get()), new ParameterValue("name", JDBCType.VARCHAR, this.name.get()), new ParameterValue("preload", JDBCType.CHAR, this.preload.get()), new ParameterValue("quantity", JDBCType.FLOAT, Float.valueOf(this.quantity.get())), new ParameterValue("cnsQty", JDBCType.FLOAT, Float.valueOf(this.cnsQty.get())), new ParameterValue("dspQty", JDBCType.FLOAT, Float.valueOf(this.dspQty.get())), new ParameterValue("sellingPrice", JDBCType.DOUBLE, this.sellingPrice.get()), new ParameterValue("size", JDBCType.VARCHAR, this.size.get()), new ParameterValue("stockUnit", JDBCType.VARCHAR, this.stockUnit), new ParameterValue("type", JDBCType.VARCHAR, this.type.get()), new ParameterValue("directPurchaseQty", JDBCType.DOUBLE, this.directPurchaseQty.get()), new ParameterValue("dateLastSold", JDBCType.DATE, this.dateLastSold.get()), new ParameterValue("priceB2B", JDBCType.DOUBLE, this.priceB2B.get()), new ParameterValue("isActive", JDBCType.CHAR, this.isActive.get()), new ParameterValue("syncFlag", JDBCType.CHAR, this.syncFlag.get()), new ParameterValue("manufacture", JDBCType.VARCHAR, this.manufacture.get()), new ParameterValue("itemUnit", JDBCType.VARCHAR, this.itemUnit.get()), new ParameterValue("netWeight", JDBCType.FLOAT, Float.valueOf(this.netWeight.get()))};
            this.getDbAccess().performDbOperation(insertQuery, paramValue);
            this.vclone = this.clone();
        }
        catch (Exception ex) {
            this.rollBack();
            this.isclone = false;
            throw ex;
        }
    }

    public static void deleteAll(DataAccess dt) {
        String query = "Delete from StockItem";
        try {
            dt.performDbOperation(query, dt.getEmptyParameterValues());
        }
        catch (Exception ex) {
            Logger.getLogger(StockItem.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void update() throws BaseConcurrencyException, Exception {
        try {
            ParameterValue[] paramValue = new ParameterValue[]{new ParameterValue("itemCode", JDBCType.VARCHAR, this.itemCode.get()), new ParameterValue("companyName", JDBCType.VARCHAR, this.companyName), new ParameterValue("costPrice", JDBCType.DOUBLE, this.costPrice.get()), new ParameterValue("image", JDBCType.BINARY, this.image.get()), new ParameterValue("maker", JDBCType.VARCHAR, this.maker.get()), new ParameterValue("name", JDBCType.VARCHAR, this.name.get()), new ParameterValue("preload", JDBCType.CHAR, this.preload.get()), new ParameterValue("quantity", JDBCType.FLOAT, Float.valueOf(this.quantity.get())), new ParameterValue("cnsQty", JDBCType.FLOAT, Float.valueOf(this.cnsQty.get())), new ParameterValue("dspQty", JDBCType.FLOAT, Float.valueOf(this.dspQty.get())), new ParameterValue("sellingPrice", JDBCType.DOUBLE, this.sellingPrice.get()), new ParameterValue("size", JDBCType.VARCHAR, this.size.get()), new ParameterValue("stockUnit", JDBCType.VARCHAR, this.stockUnit), new ParameterValue("type", JDBCType.VARCHAR, this.type.get()), new ParameterValue("directPurchaseQty", JDBCType.DOUBLE, this.directPurchaseQty.get()), new ParameterValue("dateLastSold", JDBCType.DATE, this.dateLastSold.get()), new ParameterValue("priceB2B", JDBCType.DOUBLE, this.priceB2B.get()), new ParameterValue("isActive", JDBCType.CHAR, this.isActive.get()), new ParameterValue("syncFlag", JDBCType.CHAR, this.syncFlag.get()), new ParameterValue("manufacture", JDBCType.VARCHAR, this.manufacture.get()), new ParameterValue("itemUnit", JDBCType.VARCHAR, this.itemUnit.get()), new ParameterValue("netWeight", JDBCType.FLOAT, Float.valueOf(this.netWeight.get())), new ParameterValue("cloneItemCode", JDBCType.VARCHAR, this.vclone.itemCode.get())};
            this.getDbAccess().performDbOperation(updateQuery, paramValue, true);
            this.vclone = this.clone();
        }
        catch (Exception ex) {
            this.rollBack();
            this.isclone = false;
            if (ex instanceof BaseConcurrencyException) {
                throw new BaseConcurrencyException("This object has been modified by another user, please reload your data", null);
            }
            throw ex;
        }
    }

    @Override
    public void delete() {
        String query = "Delete from \"StockItem\" where itemCode=? ";
        try {
            this.getDbAccess().performDbOperation(query, new ParameterValue[]{new ParameterValue("itemCode", JDBCType.VARCHAR, this.itemCode.get())});
        }
        catch (Exception ex) {
            Logger.getLogger(StockItem.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public Searchable getSearchable() {
        Searchable sb = new Searchable();
        sb.setTableName("StockItem");
        String[] parameters = new String[]{"itemCode", "companyName", "maker", "name", "size", "stockUnit", "type"};
        sb.setParameters(parameters);
        return sb;
    }

    public StockItem clone() {
        StockItem cloneTemp = new StockItem(this.getDbAccess());
        cloneTemp.setMustClone(false);
        cloneTemp.itemCode.set((Object)((String)this.itemCode.get()));
        cloneTemp.netWeight.set(this.netWeight.get());
        cloneTemp.name.set((Object)((String)this.name.get()));
        cloneTemp.cnsQty.set(this.cnsQty.get());
        cloneTemp.dspQty.set(this.dspQty.get());
        cloneTemp.maker.set((Object)((String)this.maker.get()));
        cloneTemp.size.set((Object)((String)this.size.get()));
        cloneTemp.type.set((Object)((String)this.type.get()));
        cloneTemp.image.set((Object)((byte[])this.image.get()));
        cloneTemp.sellingPrice.set(this.sellingPrice.get());
        cloneTemp.costPrice.set(this.costPrice.get());
        cloneTemp.quantity.set(this.quantity.get());
        cloneTemp.dateLastSold.set(this.dateLastSold.get());
        cloneTemp.manufacture.set((Object)((String)this.manufacture.get()));
        cloneTemp.itemUnit.set((Object)((String)this.itemUnit.get()));
        cloneTemp.stockUnit = this.stockUnit;
        cloneTemp.directPurchaseQty.set(this.directPurchaseQty.get());
        cloneTemp.preload.set(this.preload.get());
        cloneTemp.priceB2B.set(this.priceB2B.get());
        cloneTemp.syncFlag.set(this.syncFlag.get());
        cloneTemp.isActive.set(this.isActive.get());
        cloneTemp.companyName = this.companyName;
        cloneTemp.setMustClone(true);
        this.isclone = true;
        return cloneTemp;
    }

    private void rollBack() {
        this.itemCode = this.vclone.itemCode;
        this.name = this.vclone.name;
        this.cnsQty = this.vclone.cnsQty;
        this.netWeight = this.vclone.netWeight;
        this.dspQty = this.vclone.dspQty;
        this.maker = this.vclone.maker;
        this.size = this.vclone.size;
        this.type = this.vclone.type;
        this.image = this.vclone.image;
        this.sellingPrice = this.vclone.sellingPrice;
        this.costPrice = this.vclone.costPrice;
        this.quantity = this.vclone.quantity;
        this.directPurchaseQty = this.vclone.directPurchaseQty;
        this.dateLastSold = this.vclone.dateLastSold;
        this.manufacture = this.vclone.manufacture;
        this.itemUnit = this.vclone.itemUnit;
        this.stockUnit = this.vclone.stockUnit;
        this.preload = this.vclone.preload;
        this.priceB2B = this.vclone.priceB2B;
        this.syncFlag = this.vclone.syncFlag;
        this.isActive = this.vclone.isActive;
        this.companyName = this.vclone.companyName;
        this.setMustClone(true);
    }

    public void setParentCompany(Company cp) {
        this.parentCompany = cp;
        this.companyName = cp == null ? "" : cp.getName();
        this.changeObjectState();
    }

    public void loadParentCompany() {
        CompanyDataList compList = new CompanyDataList(this.getDbAccess());
        ParameterValue[] paramValue = new ParameterValue[]{new ParameterValue("name", JDBCType.VARCHAR, this.companyName)};
        String query = "Select * From Company where name=?";
        compList.selectAll(query, paramValue);
        if (compList.getOriginalList().size() > 0) {
            this.parentCompany = (Company)compList.getOriginalList().get(0);
        }
    }

    public Company getParentCompany() {
        if (this.parentCompany == null) {
            this.loadParentCompany();
        }
        return this.parentCompany;
    }

    public void setParentUnit(Unit un) {
        if (!this.isclone) {
            this.vclone = this.clone();
        }
        this.parentUnit = un;
        this.stockUnit = un == null ? "" : un.getName();
        this.changeObjectState();
    }

    public void loadParentUnit() {
        UnitDataList unitList = new UnitDataList(this.getDbAccess());
        String query = "Select * From Unit where name=?";
        unitList.selectAll(query, new ParameterValue[]{new ParameterValue("name", JDBCType.VARCHAR, this.stockUnit)});
        if (unitList.getOriginalList().size() > 0) {
            this.parentUnit = (Unit)unitList.getOriginalList().get(0);
        }
    }

    public void loadSerials() {
        ProductSerialDataList unitList = new ProductSerialDataList(this.getDbAccess());
        String query = "Select * From ProductSerial where itemCode=?";
        unitList.selectAll(query, new ParameterValue[]{new ParameterValue("itemCode", JDBCType.VARCHAR, this.itemCode.get())});
        this.serials.getOriginalList().addAll(unitList.getOriginalList());
    }

    public Unit getParentUnit() {
        if (this.parentUnit == null) {
            this.loadParentUnit();
        }
        return this.parentUnit;
    }

    @Override
    public void beforeInsert() {
    }

    @Override
    public void afterInsert() {
        this.setState(ObjectState.Unchanged);
    }

    @Override
    public void beforeUpdate() {
    }

    @Override
    public void afterUpdate() {
        this.setState(ObjectState.Unchanged);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        StockItem stockItem = (StockItem)object;
        if (stockItem.itemCode.get() == null || this.itemCode.get() == null) {
            return false;
        }
        return ((String)this.itemCode.get()).equals(stockItem.itemCode.get());
    }

    @Override
    public void initializeListener() {
        this.maker.addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                StockItem.this.setMaker(newValue);
            }
        });
        this.subGroup_name.addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                StockItem.this.setSubGroup_name(newValue);
            }
        });
        this.name.addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                StockItem.this.setName(newValue);
            }
        });
        this.size.addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                StockItem.this.setSize(newValue);
            }
        });
        this.type.addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                StockItem.this.setType(newValue);
            }
        });
        this.image.addListener((ChangeListener)new ChangeListener<byte[]>(){

            public void changed(ObservableValue<? extends byte[]> observable, byte[] oldValue, byte[] newValue) {
                StockItem.this.setImage(newValue);
            }
        });
        this.sellingPrice.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                StockItem.this.setSellingPrice((Double)newValue);
            }
        });
        this.costPrice.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                StockItem.this.setCostPrice((Double)newValue);
            }
        });
        this.quantity.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                StockItem.this.setQuantity(((Float)newValue).floatValue());
            }
        });
        this.quantityWithdraw.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                StockItem.this.setQuantityWithDraw(((Float)newValue).floatValue());
            }
        });
        this.replacementValue.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                StockItem.this.setReplacementValue(((Float)newValue).floatValue());
            }
        });
        this.directPurchaseQty.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                StockItem.this.setDirectPurchaseQty((Double)newValue);
            }
        });
        this.storeName.addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                StockItem.this.setStoreName(newValue);
            }
        });
    }
}

