/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa;

import com.xputertechnologies.santa.DbEntity;
import com.xputertechnologies.santa.Replenishment;
import com.xputertechnologies.santa.Sale;
import com.xputertechnologies.santa.SaleItemSerial;
import com.xputertechnologies.santa.StockItem;
import com.xputertechnologies.santa.Store;
import com.xputertechnologies.santa.Unit;
import com.xputertechnologies.santa.core.BaseConcurrencyException;
import com.xputertechnologies.santa.core.DataAccess;
import com.xputertechnologies.santa.core.ObjectState;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.core.Searchable;
import com.xputertechnologies.santa.list.SaleItemSerialDataList;
import com.xputertechnologies.santa.list.SaleList;
import com.xputertechnologies.santa.list.StockItemList;
import com.xputertechnologies.santa.list.StoreDataList;
import com.xputertechnologies.santa.list.UnitDataList;
import java.beans.PropertyChangeListener;
import java.sql.Date;
import java.sql.JDBCType;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.FloatProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleFloatProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;

public class SaleItem
extends DbEntity {
    public SaleItem vclone;
    private boolean iscloned;
    public StockItem parentStockItem;
    private boolean isConstructor;
    DataAccess dt = this.getDbAccess();
    private SaleItemSerialDataList serials = new SaleItemSerialDataList(this.dt);
    private StringProperty storeName = new SimpleStringProperty();
    public String channel;
    public String costCentre;
    public IntegerProperty availableQty = new SimpleIntegerProperty();
    public int totalQty;
    private DoubleProperty costPrice = new SimpleDoubleProperty();
    private StringProperty lineStatus = new SimpleStringProperty("");
    private StringProperty code = new SimpleStringProperty(UUID.randomUUID().toString());
    public double duplicateSellinPrice;
    private BooleanProperty isManual = new SimpleBooleanProperty();
    private BooleanProperty hasQty = new SimpleBooleanProperty();
    private DoubleProperty sellingPrice = new SimpleDoubleProperty();
    private StringProperty storeCode = new SimpleStringProperty();
    private DoubleProperty variablePrice = new SimpleDoubleProperty();
    private DoubleProperty priceB2B = new SimpleDoubleProperty();
    private FloatProperty quantity = new SimpleFloatProperty();
    private FloatProperty dspQty = new SimpleFloatProperty(0.0f);
    private FloatProperty cnsQty = new SimpleFloatProperty(0.0f);
    private StringProperty quantityBought = new SimpleStringProperty();
    private StringProperty totalQuantityBought = new SimpleStringProperty();
    private StringProperty displayQuantity = new SimpleStringProperty();
    public Unit loadedUnit = new Unit();
    private BooleanProperty isProrate = new SimpleBooleanProperty((Object)this, "isProrate", false);
    private FloatProperty returnQty = new SimpleFloatProperty();
    private FloatProperty qtyToreturnQty = new SimpleFloatProperty(this, "qtyToreturnQty", 0.0f){

        public void set(float value) {
            if (SaleItem.this.quantity.get() >= value) {
                super.set(value);
            } else {
                super.set(0.0f);
            }
        }
    };
    private float AccumulateReturnQty;
    private StringProperty returnDisplayQuantity = new SimpleStringProperty();
    private StringProperty itemName = new SimpleStringProperty();
    private StringProperty itemCode = new SimpleStringProperty();
    private Sale parentSale;
    private Integer saleInvoiceNumber;
    private String saleUnit = "Pieces";
    private Unit parentUnit;

    public String serialToolTipProperty() {
        Object result = "";
        if (this.serials.getOriginalList().size() > 0) {
            for (SaleItemSerial saleItemSerial : this.serials.getOriginalList()) {
                result = (String)result + saleItemSerial.getSerial() + "\n";
            }
        }
        return result;
    }

    public String getSerialString() {
        Object rslt = this.serials.getOriginalList().size() > 0 ? "(" : "";
        for (SaleItemSerial saleItemSerial : this.serials.getOriginalList()) {
            rslt = (String)rslt + saleItemSerial.getSerial() + ", ";
        }
        return ((String)rslt).length() > 0 ? ((String)rslt).substring(0, ((String)rslt).length() - 2) + ")" : rslt;
    }

    public SaleItemSerialDataList getSerials() {
        return this.serials;
    }

    public StringProperty storeNameProperty() {
        return this.storeName;
    }

    public String getStoreName() {
        return (String)this.storeName.get();
    }

    public void setStoreName(String storeName) {
        this.storeName.set((Object)storeName);
    }

    public void setTotalQty() {
        this.totalQty = (int)((float)((int)this.quantityProperty().get()) + this.cnsQtyProperty().get() + this.dspQtyProperty().get());
    }

    public int getTotalQty() {
        this.totalQty = (int)((float)((int)this.quantityProperty().get()) + this.cnsQtyProperty().get() + this.dspQtyProperty().get() - this.returnQty.get());
        return this.totalQty;
    }

    public double getCostPrice() {
        return this.costPrice.get();
    }

    public void setCostPrice(double costPrice) {
        if (!this.iscloned && this.isMustClone()) {
            this.vclone = this.clone();
        }
        this.costPrice.set(costPrice);
        this.changeObjectState();
    }

    public DoubleProperty costPriceProperty() {
        return this.costPrice;
    }

    public StringProperty lineStatusProperty() {
        return this.lineStatus;
    }

    public String getLineStatus() {
        return (String)this.lineStatus.get();
    }

    public void setLineStatus(String lineStatus) {
        if (!this.iscloned && this.isMustClone()) {
            this.vclone = this.clone();
        }
        this.changeObjectState();
        this.lineStatus.set((Object)lineStatus);
    }

    public StringProperty codeProperty() {
        return this.code;
    }

    public String getCode() {
        return (String)this.code.get();
    }

    public void setCode(String code) {
        if (!this.iscloned && this.isMustClone()) {
            this.vclone = this.clone();
        }
        this.changeObjectState();
        this.code.set((Object)code);
    }

    public StockItem getParentStockItem() {
        if (this.parentStockItem == null) {
            this.loadParentStockItem();
        }
        return this.parentStockItem;
    }

    public void setParentStockItem(StockItem parentStockItem) {
        if (!this.iscloned && this.isMustClone()) {
            this.vclone = this.clone();
        }
        this.parentStockItem = parentStockItem;
        this.setItemCode(parentStockItem == null ? "" : parentStockItem.getItemCode());
        this.setItemName(parentStockItem == null ? "" : parentStockItem.getName());
        this.changeObjectState();
    }

    private void loadParentStockItem() {
        StockItemList compList = new StockItemList(this.dt);
        String query = "Select * From StockItem Where ItemCode=?";
        compList.selectAll(query, new ParameterValue[]{new ParameterValue("ItemCode", JDBCType.VARCHAR, this.itemCode.get())});
        if (compList.getOriginalList().size() > 0) {
            this.parentStockItem = (StockItem)compList.getOriginalList().get(0);
            this.setItemName(((StockItem)compList.getOriginalList().get(0)).getName());
        }
    }

    public double getduplicateSellinPrice() {
        return this.duplicateSellinPrice;
    }

    public Boolean getIsManual() {
        return this.isManual.get();
    }

    public void setIsManual(Boolean isManual) {
        if (!this.iscloned && this.isMustClone()) {
            this.vclone = this.clone();
        }
        this.isManual.set(isManual.booleanValue());
        if (!(this.getParentStockItem() == null || isManual.booleanValue() || this.getParentStockItem().getSellingPrice() == this.getSellingPrice() && this.getParentStockItem().getQuantity() == this.getQuantity())) {
            this.sellingPrice.set(this.getParentStockItem().getSellingPrice());
            this.quantity.set(this.getParentStockItem().getQuantity());
        }
        if (this.parentSale.getSaleItemsList().stream().filter(f -> f.getIsManual()).count() > 0L) {
            this.parentSale.setIsManual(true);
        }
    }

    public BooleanProperty isManualProperty() {
        return this.isManual;
    }

    public void setduplicateSellinPrice(double sellingPrice) {
        this.duplicateSellinPrice = sellingPrice;
    }

    public boolean getHasQty() {
        return this.hasQty.get();
    }

    public void setHasQty(boolean hasQty) {
        this.hasQty.set(hasQty);
    }

    public BooleanProperty hasQtyProperty() {
        return this.hasQty;
    }

    public String getStoreCode() {
        return (String)this.storeCode.get();
    }

    public StringProperty storeCodeProperty() {
        return this.storeCode;
    }

    public void setStoreCode(String storeCode) {
        if (!this.iscloned && this.isMustClone()) {
            this.vclone = this.clone();
        }
        this.storeCode.set((Object)storeCode);
        this.changeObjectState();
    }

    public double getSellingPrice() {
        return this.sellingPrice.get();
    }

    public void setSellingPrice(double sellingPrice) {
        if (!this.iscloned && this.isMustClone()) {
            this.vclone = this.clone();
        }
        this.sellingPrice.set(sellingPrice);
        this.changeObjectState();
    }

    public DoubleProperty sellingPriceProperty() {
        return this.sellingPrice;
    }

    public double getVariablePrice() {
        return this.variablePrice.get();
    }

    public void setVariablePrice(double variablePrice) {
        this.variablePrice.set(variablePrice);
    }

    public DoubleProperty variablePriceProperty() {
        return this.variablePrice;
    }

    public double getPriceB2B() {
        return this.priceB2B.get();
    }

    public void setPriceB2B(double priceB2B) {
        if (!this.iscloned && this.isMustClone()) {
            this.vclone = this.clone();
        }
        this.priceB2B.set(priceB2B);
        this.changeObjectState();
    }

    public DoubleProperty priceB2BProperty() {
        return this.priceB2B;
    }

    public float getQuantity() {
        return this.quantity.get();
    }

    public void setQuantity(float quantity) {
        if (!this.iscloned && this.isMustClone()) {
            this.vclone = this.clone();
        }
        this.quantity.set(quantity);
        if (quantity == 0.0f) {
            this.hasQty.set(false);
        }
        this.changeObjectState();
    }

    public FloatProperty quantityProperty() {
        return this.quantity;
    }

    public int getDspQty() {
        return (int)this.dspQty.get();
    }

    public void setDspQty(float dspQty) {
        if (!this.iscloned && this.isMustClone()) {
            this.vclone = this.clone();
        }
        this.dspQty.set(dspQty);
        this.changeObjectState();
    }

    public FloatProperty dspQtyProperty() {
        return this.dspQty;
    }

    public int getCnsQty() {
        return (int)this.cnsQty.get();
    }

    public void setCnsQty(float cnsQty) {
        if (!this.iscloned && this.isMustClone()) {
            this.vclone = this.clone();
        }
        this.cnsQty.set(cnsQty);
        this.changeObjectState();
    }

    public FloatProperty cnsQtyProperty() {
        return this.cnsQty;
    }

    public String getQuantityBought() {
        return (String)this.quantityBought.get();
    }

    public StringProperty quantityBoughtProperty() {
        this.setQuantityBought();
        return this.quantityBought;
    }

    public void setQuantityBought() {
        String whole = String.valueOf(this.getQuantity() / this.getParentUnit().getQuantity());
        String[] temparr = whole.split("\\.");
        float mod = this.getQuantity() % this.getParentUnit().getQuantity();
        this.quantityBought.set((Object)(temparr[0] + " " + this.getParentUnit().getName() + " " + (String)(mod > 0.0f ? String.valueOf(mod) + " and pieces" : "")));
    }

    public String getTotalQuantityBought() {
        return (String)this.totalQuantityBought.get();
    }

    public StringProperty totalQuantityBoughtProperty() {
        this.setTotalQuantityBought();
        return this.totalQuantityBought;
    }

    public void setTotalQuantityBought() {
        String whole = String.valueOf((this.getQuantity() + this.getReturnQty()) / this.getParentUnit().getQuantity());
        String[] temparr = whole.split("\\.");
        float mod = (this.getQuantity() + this.getReturnQty()) % this.getParentUnit().getQuantity();
        this.totalQuantityBought.set((Object)(temparr[0] + " " + this.getParentUnit().getName() + " " + (String)(mod > 0.0f ? String.valueOf(mod) + " and pieces" : "")));
    }

    public String getDisplayQuantity() {
        return (String)this.displayQuantity.get();
    }

    public void setDisplayQuantity() {
        String whole = String.valueOf(this.parentStockItem.getQuantity() / this.parentStockItem.getParentUnit().getQuantity());
        String[] temparr = whole.split("\\.");
        float mod = this.parentStockItem.getQuantity() % this.parentStockItem.getParentUnit().getQuantity();
        this.displayQuantity.set((Object)(temparr[0] + " " + this.parentStockItem.getParentUnit().getName() + (String)(mod > 0.0f ? String.valueOf(mod) + " and pieces" : "")));
    }

    public void setDisplayQuantityInternal() {
        String whole = String.valueOf(this.getParentStockItem().getQuantity() / this.getParentStockItem().getParentUnit().getQuantity());
        String[] temparr = whole.split("\\.");
        float mod = this.getParentStockItem().getQuantity() % this.getParentStockItem().getParentUnit().getQuantity();
        this.displayQuantity.set((Object)(temparr[0] + " " + this.getParentStockItem().getParentUnit().getName() + " " + (String)(mod > 0.0f ? String.valueOf(mod) + " and pieces" : "")));
    }

    public StringProperty displayQuantityProperty() {
        this.setDisplayQuantityInternal();
        return this.displayQuantity;
    }

    public boolean getIsProrate() {
        return this.isProrate.get();
    }

    public void setIsProrate(boolean isProrate) {
        if (!this.iscloned && this.isMustClone()) {
            this.vclone = this.clone();
        }
        this.isProrate.set(isProrate);
        this.changeObjectState();
    }

    public BooleanProperty isProrateProperty() {
        return this.isProrate;
    }

    public float getReturnQty() {
        return this.returnQty.get();
    }

    public void setReturnQty(float returnQty) {
        if (!this.iscloned && this.isMustClone()) {
            this.vclone = this.clone();
        }
        this.returnQty.set(returnQty);
        this.changeObjectState();
    }

    public FloatProperty returnQtyProperty() {
        return this.returnQty;
    }

    public float getQtyToreturnQty() {
        return this.qtyToreturnQty.get();
    }

    public void setQtyToreturnQty(float qtyToreturnQty) {
        if (!this.iscloned && this.isMustClone()) {
            this.vclone = this.clone();
        }
        this.qtyToreturnQty.set(qtyToreturnQty);
        this.changeObjectState();
    }

    public FloatProperty qtyToreturnQtyProperty() {
        return this.qtyToreturnQty;
    }

    public float getAccumulateReturnQty() {
        return this.AccumulateReturnQty;
    }

    public void setAccumulateReturnQty(float AccumulateReturnQty) {
        this.AccumulateReturnQty = AccumulateReturnQty;
    }

    public String getReturnDisplayQuantity() {
        return (String)this.returnDisplayQuantity.get();
    }

    public void setReturnDisplayQuantity() {
        String whole = String.valueOf(this.returnQty.get() / this.getParentUnit().getQuantity());
        this.AccumulateReturnQty = this.returnQty.get();
        String[] temparr = whole.split("\\.");
        float mod = this.returnQty.get() % this.parentUnit.getQuantity();
        this.returnDisplayQuantity.set((Object)(temparr[0] + " " + this.parentUnit.getName() + (String)(mod > 0.0f ? String.valueOf(mod) + " and pieces" : "")));
    }

    public StringProperty returnDisplayQuantityProperty() {
        this.setReturnDisplayQuantity();
        return this.returnDisplayQuantity;
    }

    public StringProperty itemNameProperty() {
        return this.itemName;
    }

    public String getItemName() {
        return (String)this.itemName.get();
    }

    public void setItemName(String name) {
        if (!this.iscloned && this.isMustClone()) {
            this.vclone = this.clone();
        }
        this.itemName.set((Object)name);
        this.changeObjectState();
    }

    public StringProperty itemCodeProperty() {
        return this.itemCode;
    }

    public String getItemCode() {
        return (String)this.itemCode.get();
    }

    public void setItemCode(String itemCode) {
        if (!this.iscloned && this.isMustClone()) {
            this.vclone = this.clone();
        }
        this.itemCode.set((Object)itemCode);
        this.changeObjectState();
    }

    public Sale getParentSale() {
        if (this.parentSale == null) {
            this.loadParentSale();
        }
        return this.parentSale;
    }

    public void setParentSale(Sale parentSale1) {
        if (!this.iscloned && this.isMustClone()) {
            this.vclone = this.clone();
        }
        this.parentSale = parentSale1;
        this.saleInvoiceNumber = parentSale1 == null ? null : Integer.valueOf(this.parentSale.getInvoiceNumber());
        this.changeObjectState();
    }

    private void loadParentSale() {
        SaleList compList = new SaleList(this.dt);
        String query = "Select * From Sale Where invoiceNumber=?";
        compList.selectAll(query, new ParameterValue[]{new ParameterValue("saleInvoiceNumber", JDBCType.INTEGER, this.saleInvoiceNumber)});
        if (compList.getOriginalList().size() > 0) {
            this.parentSale = (Sale)compList.getOriginalList().get(0);
        }
    }

    public void loadSerials() {
        if (this.serials.getOriginalList().size() == 0) {
            SaleItemSerialDataList compList = new SaleItemSerialDataList(this.dt);
            String query = "Select * From SALEITEMSERIAL Where SALEITEMCODE=? and ITEMCODE=?";
            compList.selectAll(query, new ParameterValue[]{new ParameterValue("SALEITEMCODE", JDBCType.VARCHAR, this.code.get()), new ParameterValue("ITEMCODE", JDBCType.VARCHAR, this.itemCode.get())});
            this.serials.getOriginalList().addAll(compList.getOriginalList());
        }
    }

    public void setParentUnit(Unit un) {
        if (!this.iscloned && this.isMustClone()) {
            this.vclone = this.clone();
        }
        this.parentUnit = un;
        this.saleUnit = un == null ? "" : un.getName();
        this.parentSale.manualEnt = false;
        this.parentSale.tracker.set(this.parentSale.tracker.get() + 1);
        this.changeObjectState();
    }

    public void loadParentUnit() {
        UnitDataList saleUnitList = new UnitDataList(this.getDbAccess() == null ? this.dt : this.getDbAccess());
        String query = "Select * From Unit Where name=?";
        saleUnitList.selectAll(query, new ParameterValue[]{new ParameterValue("name", JDBCType.VARCHAR, this.saleUnit)});
        if (saleUnitList.getOriginalList().size() > 0) {
            this.parentUnit = (Unit)saleUnitList.getOriginalList().get(0);
        }
    }

    public Unit getParentUnit() {
        if (this.parentUnit == null) {
            this.loadParentUnit();
        }
        return this.parentUnit;
    }

    public SaleItem duplicate() {
        SaleItem chase = new SaleItem(this.dt);
        chase.quantity.set(this.quantity.get() > 0.0f ? 1.0f : 0.0f);
        chase.cnsQty.set(chase.quantity.get() > 0.0f ? 0.0f : (this.cnsQty.get() > 0.0f ? 1.0f : this.cnsQty.get()));
        chase.dspQty.set(chase.quantity.get() > 0.0f ? 0.0f : (this.cnsQty.get() > 0.0f ? 0.0f : (this.dspQty.get() > 0.0f ? 1.0f : 0.0f)));
        chase.code.set((Object)UUID.randomUUID().toString());
        chase.itemName.set((Object)((String)this.itemName.get()));
        chase.lineStatus.set((Object)((String)this.lineStatus.get()));
        chase.returnQty.set(this.returnQty.get());
        chase.sellingPrice.set(this.sellingPrice.get());
        chase.isProrate.set(this.isProrate.get());
        chase.itemCode = this.itemCode;
        chase.saleUnit = this.saleUnit;
        chase.saleInvoiceNumber = this.saleInvoiceNumber;
        chase.variablePrice.set(this.sellingPrice.get());
        chase.priceB2B.set(this.priceB2B.get());
        chase.isManual = this.isManual;
        chase.setState(ObjectState.New);
        chase.setParentStockItem(this.getParentStockItem());
        chase.setParentSale(this.getParentSale());
        chase.setParentUnit(this.getParentUnit());
        chase.initializeListener();
        return chase;
    }

    public SaleItem clone() {
        SaleItem chase = new SaleItem();
        this.setMustClone(false);
        chase.lineStatus.set((Object)((String)this.lineStatus.get()));
        chase.quantity.set(this.quantity.get());
        chase.cnsQty.set(this.cnsQty.get());
        chase.dspQty.set(this.dspQty.get());
        chase.code.set((Object)((String)this.code.get()));
        chase.costPrice.set(this.costPrice.get());
        chase.isManual.set(this.isManual.get());
        chase.itemName.set((Object)((String)this.itemName.get()));
        chase.storeCode.set((Object)((String)this.storeCode.get()));
        chase.returnQty.set(this.returnQty.get());
        chase.sellingPrice.set(this.sellingPrice.get());
        chase.isProrate.set(this.isProrate.get());
        chase.itemCode.set((Object)((String)this.itemCode.get()));
        chase.saleUnit = this.saleUnit;
        chase.variablePrice = this.variablePrice;
        chase.saleInvoiceNumber = this.saleInvoiceNumber;
        chase.priceB2B = this.priceB2B;
        this.setMustClone(true);
        this.iscloned = true;
        return chase;
    }

    public void rollBack() {
        this.setQuantity(this.vclone.getQuantity());
        this.cnsQty = this.vclone.cnsQty;
        this.lineStatus = this.vclone.lineStatus;
        this.dspQty = this.vclone.dspQty;
        this.quantity = this.vclone.quantity;
        this.setReturnQty(this.vclone.getReturnQty());
        this.setSellingPrice(this.vclone.getSellingPrice());
        this.setIsProrate(this.vclone.getIsProrate());
        this.itemCode = this.vclone.itemCode;
        this.itemName = this.vclone.itemName;
        this.code = this.vclone.code;
        this.storeCode = this.vclone.storeCode;
        this.saleUnit = this.vclone.saleUnit;
        this.variablePrice = this.vclone.variablePrice;
        this.saleInvoiceNumber = this.vclone.saleInvoiceNumber;
        this.priceB2B = this.vclone.priceB2B;
        this.setIscloned(false);
        this.setMustClone(true);
    }

    public SaleItem() {
    }

    public SaleItem(Float quantity, Float returnQty, Double sellingPrice, Boolean isProrate, String ItemCode, String saleUnit, Integer saleInvoiceNumber, Double priceB2B, String lineStatus, DataAccess de) {
        super(de);
        this.saleInvoiceNumber = saleInvoiceNumber;
        this.quantity.set(quantity.floatValue());
        this.returnQty.set(returnQty.floatValue());
        this.sellingPrice.set(sellingPrice.doubleValue());
        this.isProrate.set(isProrate.booleanValue());
        this.itemCode.set((Object)ItemCode);
        this.saleUnit = saleUnit;
        this.setState(ObjectState.Unchanged);
        this.priceB2B.set(priceB2B.doubleValue());
        this.bps.addPropertyChangeSupportFor((Property)this.quantity);
        this.bps.addPropertyChangeSupportFor((Property)this.sellingPrice);
        this.setMustClone(true);
        this.initializeListener();
        this.vclone = this.clone();
    }

    public SaleItem(Float quantity, Float cnsQty, Float dspQty, Float returnQty, Double sellingPrice, Boolean isProrate, String ItemCode, String saleUnit, Integer saleInvoiceNumber, Double priceB2B, String code, String storeCode, String itemName, Double costPrice, Double variablePrice, String lineStatus, DataAccess de) {
        super(de);
        this.variablePrice.set(variablePrice.doubleValue());
        this.saleInvoiceNumber = saleInvoiceNumber;
        this.lineStatus.set((Object)lineStatus);
        this.costPrice.set(costPrice.doubleValue());
        this.quantity.set(quantity.floatValue());
        this.storeCode.set((Object)storeCode);
        this.dspQty.set(dspQty.floatValue());
        this.cnsQty.set(cnsQty.floatValue());
        this.code.set((Object)code);
        this.itemName.set((Object)itemName);
        this.returnQty.set(returnQty.floatValue());
        this.sellingPrice.set(sellingPrice.doubleValue());
        this.isProrate.set(isProrate.booleanValue());
        this.itemCode.set((Object)ItemCode);
        this.saleUnit = saleUnit;
        this.setState(ObjectState.Unchanged);
        this.priceB2B.set(priceB2B.doubleValue());
        this.bps.addPropertyChangeSupportFor((Property)this.quantity);
        this.bps.addPropertyChangeSupportFor((Property)this.sellingPrice);
        this.setMustClone(true);
        this.initializeListener();
        this.vclone = this.clone();
    }

    public SaleItem(DataAccess dbAccess) {
        super(dbAccess);
    }

    public SaleItem(StockItem si, DataAccess dbAccess, Sale parentSale) {
        super(dbAccess);
        this.setParentSale(parentSale);
        this.sellingPrice.set(si.getSellingPrice());
        this.setQuantity(si.getQuantity());
        this.setPriceB2B(si.getPriceB2B());
        this.setCnsQty(si.getCnsQty());
        this.setDspQty(si.getDspQty());
        this.costPrice.set(si.getCostPrice());
        this.itemName.set((Object)(si != null ? si.getName() : ""));
        this.setParentStockItem(si);
        this.setMustClone(true);
        this.bps.addPropertyChangeSupportFor((Property)this.quantity);
        this.bps.addPropertyChangeSupportFor((Property)this.sellingPrice);
        this.initializeListener();
        this.vclone = this.clone();
    }

    @Override
    public void insert() throws Exception {
        try {
            String query = "INSERT INTO SaleItem (ItemCode,saleUnit,saleInvoiceNumber,sellingPrice,Prorate,returnQty,quantity,cnsQty,dspQty,priceB2B,code,storeCode,itemName,costPrice,variablePrice,lineStatus) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            this.dt.performDbOperation(query, new ParameterValue[]{new ParameterValue("ItemCode", JDBCType.VARCHAR, this.itemCode.get()), new ParameterValue("saleUnit", JDBCType.VARCHAR, this.saleUnit == null ? "Pieces" : this.saleUnit), new ParameterValue("saleInvoiceNumber", JDBCType.INTEGER, this.saleInvoiceNumber), new ParameterValue("sellingPrice", JDBCType.DOUBLE, this.sellingPrice.get()), new ParameterValue("Prorate", JDBCType.CHAR, this.isProrate.get()), new ParameterValue("returnQty", JDBCType.FLOAT, Float.valueOf(this.returnQty.get())), new ParameterValue("quantity", JDBCType.FLOAT, Float.valueOf(this.quantity.get())), new ParameterValue("cnsQty", JDBCType.FLOAT, Float.valueOf(this.cnsQty.get())), new ParameterValue("dspQty", JDBCType.FLOAT, Float.valueOf(this.dspQty.get())), new ParameterValue("priceB2B", JDBCType.DOUBLE, this.priceB2B.get()), new ParameterValue("code", JDBCType.VARCHAR, this.code.get()), new ParameterValue("storeCode", JDBCType.VARCHAR, this.storeCode.get()), new ParameterValue("itemName", JDBCType.VARCHAR, this.itemName.get()), new ParameterValue("costPrice", JDBCType.DOUBLE, this.costPrice.get()), new ParameterValue("variablePrice", JDBCType.DOUBLE, this.variablePrice.get()), new ParameterValue("lineStatus", JDBCType.VARCHAR, this.lineStatus.get())});
            this.vclone = this.clone();
        }
        catch (Exception ex) {
            this.rollBack();
            this.iscloned = false;
            throw ex;
        }
    }

    @Override
    public void update() throws Exception {
        try {
            String query = "UPDATE SaleItem set ItemCode=?,saleUnit=?,saleInvoiceNumber=?,sellingPrice=?,Prorate=?,returnQty=?,quantity=?,cnsQty=?,dspQty=?,priceB2B=?,code=?,storeCode=?, itemName=?,costPrice=?,variablePrice=?, lineStatus=? where saleInvoiceNumber=? and ItemCode=?";
            this.dt.performDbOperation(query, new ParameterValue[]{new ParameterValue("ItemCode", JDBCType.VARCHAR, this.itemCode.get()), new ParameterValue("saleUnit", JDBCType.VARCHAR, this.saleUnit == null ? "Pieces" : this.saleUnit), new ParameterValue("saleInvoiceNumber", JDBCType.INTEGER, this.saleInvoiceNumber), new ParameterValue("sellingPrice", JDBCType.DOUBLE, this.sellingPrice.get()), new ParameterValue("Prorate", JDBCType.CHAR, this.isProrate.get()), new ParameterValue("returnQty", JDBCType.FLOAT, Float.valueOf(this.returnQty.get())), new ParameterValue("quantity", JDBCType.FLOAT, Float.valueOf(this.quantity.get())), new ParameterValue("cnsQty", JDBCType.FLOAT, Float.valueOf(this.cnsQty.get())), new ParameterValue("dspQty", JDBCType.FLOAT, Float.valueOf(this.dspQty.get())), new ParameterValue("priceB2B", JDBCType.DOUBLE, this.priceB2B.get()), new ParameterValue("code", JDBCType.VARCHAR, this.code.get()), new ParameterValue("storeCode", JDBCType.VARCHAR, this.storeCode.get()), new ParameterValue("itemName", JDBCType.VARCHAR, this.itemName.get()), new ParameterValue("costPrice", JDBCType.DOUBLE, this.costPrice.get()), new ParameterValue("variablePrice", JDBCType.DOUBLE, this.variablePrice.get()), new ParameterValue("lineStatus", JDBCType.VARCHAR, this.lineStatus.get()), new ParameterValue("cloneSaleInvoiceNumber", JDBCType.INTEGER, this.vclone.saleInvoiceNumber), new ParameterValue("cloneSaleItemCode", JDBCType.VARCHAR, this.vclone.getItemCode())});
            this.vclone = this.clone();
        }
        catch (Exception ex) {
            this.rollBack();
            this.iscloned = false;
            if (ex instanceof BaseConcurrencyException) {
                throw new BaseConcurrencyException("This object has been modified by another user, please reload your data", null);
            }
            throw ex;
        }
    }

    @Override
    public void delete() throws Exception {
        String query = "Delete FROM SaleItem where saleInvoiceNumber=? and ItemCode=?";
        this.dt.performDbOperation(query, new ParameterValue[]{new ParameterValue("saleInvoiceNumber", JDBCType.INTEGER, this.saleInvoiceNumber), new ParameterValue("ItemCode", JDBCType.VARCHAR, this.itemCode.get())});
    }

    @Override
    public void beforeInsert() {
        if (this.saleInvoiceNumber == 0) {
            this.saleInvoiceNumber = this.getParentSale().getInvoiceNumber();
        }
        if (this.cnsQty.get() > 0.0f) {
            try {
                StoreDataList storeDataList = new StoreDataList(this.dt);
                storeDataList.selectAll("Select * FROM Store where Name=?", new ParameterValue[]{new ParameterValue("Name", JDBCType.VARCHAR, "Consignment Warehouse")});
                if (storeDataList.getOriginalList().size() == 1) {
                    this.storeCode.set((Object)((Store)storeDataList.getOriginalList().get(0)).getCode());
                }
            }
            catch (Exception ex) {
                Logger.getLogger(SaleItem.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else if (this.dspQty.get() > 0.0f) {
            try {
                StoreDataList storeDataList = new StoreDataList(this.dt);
                storeDataList.selectAll("Select * FROM Store where Name=?", new ParameterValue[]{new ParameterValue("Name", JDBCType.VARCHAR, "Display Items Warehouse")});
                if (storeDataList.getOriginalList().size() == 1) {
                    this.storeCode.set((Object)((Store)storeDataList.getOriginalList().get(0)).getCode());
                }
            }
            catch (Exception ex) {
                Logger.getLogger(SaleItem.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    @Override
    public void afterInsert() {
        this.setState(ObjectState.Unchanged);
    }

    @Override
    public void beforeUpdate() {
    }

    @Override
    public void afterUpdate() {
        this.setState(ObjectState.Unchanged);
    }

    public Replenishment generateReplenishment(String Comment, float qty) {
        Replenishment replenishment = new Replenishment(this.dt);
        if (qty == 0.0f) {
            replenishment.quantityProperty().set(this.getQuantity());
        } else {
            replenishment.quantityProperty().set(qty);
        }
        replenishment.setParentStockItem(this.getParentStockItem());
        replenishment.commentProperty().set((Object)Comment);
        replenishment.balanceBfProperty().set(this.getParentStockItem().getPrevBalaceBfQty());
        replenishment.dateProperty().set((Object)Date.valueOf(this.getParentSale().getParentCompany().getCurrentDay()));
        return replenishment;
    }

    @Override
    public Searchable getSearchable() {
        Searchable sb = new Searchable();
        sb.setTableName("SaleItem");
        String[] parameter = new String[]{"stockItemBarcode", "ItemCode", "saleUnit", "saleInvoiceNumber", "sellingPrice", "isProrate", "returnQty"};
        parameter[7] = "quantity";
        sb.setParameters(parameter);
        return sb;
    }

    public void setIscloned(boolean iscloned) {
        this.iscloned = iscloned;
    }

    @Override
    public void initializeListener() {
        this.sellingPrice.addListener(new InvalidationListener(){

            public void invalidated(Observable observable) {
                SaleItem.this.getParentSale().manualEnt = false;
                SaleItem.this.getParentSale().tracker.set(SaleItem.this.getParentSale().tracker.get() + 1);
            }
        });
        this.sellingPrice.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                SaleItem.this.setSellingPrice((Double)newValue);
            }
        });
        this.variablePrice.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                SaleItem.this.setVariablePrice((Double)newValue);
            }
        });
        this.variablePrice.addListener(new InvalidationListener(){

            public void invalidated(Observable observable) {
                SaleItem.this.getParentSale().tracker.set(SaleItem.this.getParentSale().tracker.get() + 1);
            }
        });
        this.quantity.addListener(new InvalidationListener(){

            public void invalidated(Observable observable) {
                SaleItem.this.getParentSale().amountPaidProperty().set(0.0);
                SaleItem.this.getParentSale().manualEnt = false;
                SaleItem.this.getParentSale().alreadyProrate = false;
                SaleItem.this.getParentSale().setDiscount(0.0);
                SaleItem.this.getParentSale().tracker.set(SaleItem.this.getParentSale().tracker.get() + 1);
            }
        });
        this.quantity.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                try {
                    if (!newValue.equals("")) {
                        SaleItem.this.setQuantity(((Float)newValue).floatValue());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.cnsQty.addListener(new InvalidationListener(){

            public void invalidated(Observable observable) {
                SaleItem.this.getParentSale().amountPaidProperty().set(0.0);
                SaleItem.this.getParentSale().manualEnt = false;
                SaleItem.this.getParentSale().alreadyProrate = false;
                SaleItem.this.getParentSale().setDiscount(0.0);
                SaleItem.this.getParentSale().tracker.set(SaleItem.this.getParentSale().tracker.get() + 1);
            }
        });
        this.cnsQty.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                try {
                    if (!newValue.equals("")) {
                        SaleItem.this.setCnsQty(((Float)newValue).floatValue());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.dspQty.addListener(new InvalidationListener(){

            public void invalidated(Observable observable) {
                SaleItem.this.getParentSale().amountPaidProperty().set(0.0);
                SaleItem.this.getParentSale().manualEnt = false;
                SaleItem.this.getParentSale().alreadyProrate = false;
                SaleItem.this.getParentSale().setDiscount(0.0);
                SaleItem.this.getParentSale().tracker.set(SaleItem.this.getParentSale().tracker.get() + 1);
            }
        });
        this.dspQty.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                try {
                    if (!newValue.equals("")) {
                        SaleItem.this.setDspQty(((Float)newValue).floatValue());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.isProrate.addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                SaleItem.this.setIsProrate(newValue);
            }
        });
        this.isProrate.addListener(new InvalidationListener(){

            public void invalidated(Observable observable) {
                if (SaleItem.this.getParentSale() != null) {
                    SaleItem.this.getParentSale().setDiscount(0.0);
                    SaleItem.this.getParentSale().alreadyProrate = false;
                    SaleItem.this.getParentSale().manualEnt = false;
                    SaleItem.this.getParentSale().tracker.set(SaleItem.this.getParentSale().tracker.get() + 1);
                }
            }
        });
        this.isManual.addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                SaleItem.this.setIsManual(newValue);
            }
        });
    }

    public final void addPropertyChangeListener(PropertyChangeListener listener) {
        this.bps.addChangeListener(listener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener listener) {
        this.bps.removeChangeListener(listener);
    }

    @Override
    public void setDbAccess(DataAccess db) {
        this.dt = db;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof SaleItem) {
            SaleItem saleItem = (SaleItem)object;
            return this.getItemCode().equals(saleItem.getItemCode());
        }
        return false;
    }
}

