/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa;

import com.xputertechnologies.santa.Company;
import com.xputertechnologies.santa.DbEntity;
import com.xputertechnologies.santa.Operation;
import com.xputertechnologies.santa.User;
import com.xputertechnologies.santa.core.BaseConcurrencyException;
import com.xputertechnologies.santa.core.DataAccess;
import com.xputertechnologies.santa.core.ObjectState;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.core.Searchable;
import com.xputertechnologies.santa.list.CompanyDataList;
import com.xputertechnologies.santa.list.RoleList;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.JDBCType;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.ListProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class Role
extends DbEntity {
    private ObservableList<User> userList = FXCollections.observableArrayList();
    private Company parentCompany;
    boolean isclone;
    public Role vclone;
    private List<Operation> operationsList;
    private String companyName;
    private StringProperty description;
    private byte[] operationsSelected;
    public boolean isDbLoad = false;
    public List<Operation> selectedOperationsList;
    private boolean needAdd;
    private byte[] operations;

    public Role(String companyName, String description, byte[] operation, DataAccess dbAccess) {
        super(dbAccess);
        this.companyName = companyName;
        this.setMustClone(false);
        this.descriptionProperty().set((Object)description);
        try {
            this.setOperationsSelected(operation);
        }
        catch (IOException ex) {
            Logger.getLogger(Role.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.isDbLoad = true;
        this.setState(ObjectState.Unchanged);
        this.setMustClone(true);
        this.initializeListener();
    }

    public Role(DataAccess dt) {
        super(dt);
        this.selectedOperationsList = new ArrayList<Operation>();
        try {
            this.operationsSelected = this.serializeOperation(this.selectedOperationsList);
        }
        catch (IOException ex) {
            Logger.getLogger(Role.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public Role() {
    }

    public boolean isNeedAdd() {
        return this.needAdd;
    }

    public void setNeedAdd(boolean needAdd) {
        this.needAdd = needAdd;
    }

    public String getDescription() {
        return (String)this.descriptionProperty().get();
    }

    public void setDescription(String description) {
        if (!this.isclone && this.isMustClone()) {
            this.vclone = this.clone();
        }
        this.descriptionProperty().set((Object)description);
        this.changeObjectState();
    }

    public StringProperty descriptionProperty() {
        if (this.description == null) {
            this.description = new SimpleStringProperty();
        }
        return this.description;
    }

    public byte[] getOperations() {
        return this.operationsSelected;
    }

    public List<Operation> getSelectedOperationsList() {
        return this.selectedOperationsList;
    }

    public void setOperationsSelected(List<Operation> operation) throws IOException {
        if (!this.isclone && this.isMustClone()) {
            this.vclone = this.clone();
        }
        this.selectedOperationsList = operation;
        this.changeObjectState();
    }

    public void setOperationsSelected() throws IOException {
        if (this.selectedOperationsList.size() > 0) {
            this.operationsSelected = this.serializeOperation(this.selectedOperationsList);
        }
    }

    public void setOperations(List<Operation> operation) throws IOException {
        this.operations = this.serializeOperation(operation);
        this.changeObjectState();
    }

    public void setOperationsSelected(byte[] operation) throws IOException {
        if (!this.isclone && this.isMustClone()) {
            this.vclone = this.clone();
        }
        this.operationsSelected = operation;
        this.selectedOperationsList = this.deserializeOperation(this.operationsSelected);
        this.changeObjectState();
    }

    public void setOperationLists(byte[] operation) throws IOException {
        this.operationsSelected = operation;
        this.selectedOperationsList = this.deserializeOperation(this.operationsSelected);
    }

    public ListProperty<Operation> operationsListProperty() {
        if (this.operationsList == null) {
            this.operationsList = new SimpleListProperty();
        }
        return (ListProperty)this.operationsList;
    }

    public Role clone() {
        String compName = this.companyName;
        String desc = (String)this.description.get();
        byte[] operations = this.getOperations();
        Role cloneTemp = new Role(compName, desc, operations, this.getDbAccess());
        cloneTemp.setMustClone(false);
        this.setMustClone(true);
        this.isclone = true;
        return cloneTemp;
    }

    private void rollBack() {
        this.companyName = this.vclone.companyName;
        this.description.set((Object)((String)this.vclone.description.get()));
        try {
            this.setOperationLists(this.vclone.operationsSelected);
        }
        catch (IOException ex) {
            Logger.getLogger(Role.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.setMustClone(true);
    }

    private List<Operation> deserializeOperation(byte[] operation) throws IOException {
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(operation);
        DataInputStream datainputStream = new DataInputStream(byteArrayInputStream);
        while (datainputStream.available() > 0) {
            operationList.add(new Operation(datainputStream.readUTF()));
        }
        return operationList;
    }

    private byte[] serializeOperation(List<Operation> operationList) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        for (Operation operation : operationList) {
            dataOutputStream.writeUTF(operation.getDescription());
        }
        byte[] returnByte = byteArrayOutputStream.toByteArray();
        return returnByte;
    }

    public static RoleList search(String qry, ParameterValue[] param, DataAccess dt) {
        RoleList roleList = new RoleList(dt);
        roleList.selectAll(qry, param);
        return roleList;
    }

    @Override
    public void insert() throws Exception {
        try {
            this.setOperationsSelected();
            ParameterValue[] paramValue = new ParameterValue[]{new ParameterValue("companyName", JDBCType.VARCHAR, this.companyName), new ParameterValue("description", JDBCType.VARCHAR, this.description.get()), new ParameterValue("operations", JDBCType.BINARY, this.getOperations())};
            String query = "insert into Role (companyName,description,operations) values(?,?,?)";
            this.getDbAccess().performDbOperation(query, paramValue);
            this.vclone = this.clone();
        }
        catch (Exception ex) {
            this.rollBack();
            this.isclone = false;
            throw ex;
        }
    }

    @Override
    public void update() throws Exception {
        String query = "update Role set companyName=?,description=?,operations=? where description=?";
        try {
            this.setOperationsSelected();
            ParameterValue[] paramValue = new ParameterValue[]{new ParameterValue("companyName", JDBCType.VARCHAR, this.companyName), new ParameterValue("description", JDBCType.VARCHAR, this.description.get()), new ParameterValue("operations", JDBCType.BINARY, this.getOperations()), new ParameterValue("cloneDecription", JDBCType.VARCHAR, this.vclone.description.get())};
            this.getDbAccess().performDbOperation(query, paramValue, true);
            this.vclone = this.clone();
        }
        catch (Exception ex) {
            this.rollBack();
            this.isclone = false;
            if (ex instanceof BaseConcurrencyException) {
                throw new BaseConcurrencyException("This object has been modified by another user, please reload your data", null);
            }
            throw ex;
        }
    }

    @Override
    public void delete() throws Exception {
        String query = "Delete from Role  where description=? ";
        this.getDbAccess().performDbOperation(query, new ParameterValue[]{new ParameterValue("description", JDBCType.VARCHAR, this.description.get())});
    }

    public void setParentCompany(Company cp) {
        if (!this.isclone) {
            this.vclone = this.clone();
        }
        this.parentCompany = cp;
        this.companyName = cp == null ? "" : cp.getName();
        this.changeObjectState();
    }

    public void loadParentCompany() {
        CompanyDataList compList = new CompanyDataList(this.getDbAccess());
        String query = "Select * From Company Where name=?";
        compList.selectAll(query, new ParameterValue[]{new ParameterValue("name", JDBCType.VARCHAR, this.companyName)});
        if (compList.getOriginalList().size() > 0) {
            this.parentCompany = (Company)compList.getOriginalList().get(0);
        }
    }

    @Override
    public void beforeInsert() {
    }

    @Override
    public void afterInsert() {
        this.setState(ObjectState.Unchanged);
    }

    @Override
    public void beforeUpdate() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void afterUpdate() {
        this.setState(ObjectState.Unchanged);
    }

    @Override
    public Searchable getSearchable() {
        Searchable searchable = new Searchable();
        searchable.setTableName("Role");
        String[] parameters = new String[]{"companyName", "description", "operations"};
        searchable.setParameters(parameters);
        return searchable;
    }

    public Company getParentCompany() {
        if (this.parentCompany == null) {
            this.loadParentCompany();
        }
        return this.parentCompany;
    }

    public ObservableList<User> getUserList() {
        return this.userList;
    }

    public void setUserList(ObservableList<User> userList) {
        this.userList = userList;
    }

    @Override
    public void initializeListener() {
    }
}

