/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa;

import com.xputertechnologies.santa.Customer;
import com.xputertechnologies.santa.DbEntity;
import com.xputertechnologies.santa.core.BaseConcurrencyException;
import com.xputertechnologies.santa.core.ConsequentialConcurrencyException;
import com.xputertechnologies.santa.core.DataAccess;
import com.xputertechnologies.santa.core.ObjectState;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.core.Searchable;
import java.sql.JDBCType;
import java.sql.Timestamp;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class Log
extends DbEntity {
    public Log vClone;
    private boolean isCloned;
    DataAccess dt = this.getDbAccess();
    private Timestamp sTimestamp;
    private StringProperty status = new SimpleStringProperty("Failure");
    private ObjectProperty<Date> dateLog = new SimpleObjectProperty((Object)new Timestamp(new Date().getTime()));
    private StringProperty msg = new SimpleStringProperty();
    private StringProperty payload = new SimpleStringProperty();

    public Log(String msg, Date dateLog, String status, ObjectState objectState, String payload, DataAccess dbAccess) {
        super(dbAccess);
        this.msg.set((Object)msg);
        this.payload.set((Object)payload);
        this.dateLog.set((Object)dateLog);
        this.status.set((Object)status);
        this.setState(objectState);
        this.setMustClone(true);
        this.initializeListener();
    }

    public Log(String msg, Date dateLog, String status, String payload, DataAccess dbAccess) {
        super(dbAccess);
        this.msg.set((Object)msg);
        this.dateLog.set((Object)dateLog);
        this.status.set((Object)status);
        this.payload.set((Object)payload);
        this.setState(ObjectState.Unchanged);
        this.setMustClone(true);
        this.initializeListener();
    }

    public Log(DataAccess dt) {
        super(dt);
    }

    public StringProperty statusProperty() {
        return this.status;
    }

    public String getStatus() {
        return (String)this.msg.get();
    }

    public void setStatus(String status) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.status.set((Object)status);
    }

    public Date getDateLog() {
        return (Date)this.dateLog.get();
    }

    public void setDateLog(Date dateLog) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.dateLog.set((Object)dateLog);
    }

    public ObjectProperty<Date> dateLogProperty() {
        return this.dateLog;
    }

    public StringProperty msgProperty() {
        return this.msg;
    }

    public String getmsg() {
        return (String)this.msg.get();
    }

    public void setMsg(String msg) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.msg.set((Object)msg);
    }

    public StringProperty payLoadProperty() {
        return this.payload;
    }

    public String getPayload() {
        return (String)this.payload.get();
    }

    public void setPayload(String payload) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.payload.set((Object)payload);
    }

    public Log clone() {
        Log log = new Log(this.dt);
        log.setMustClone(false);
        log.status.set((Object)((String)this.status.get()));
        log.msg.set((Object)((String)this.msg.get()));
        log.dateLog.set((Object)((Date)this.dateLog.get()));
        log.payload.set((Object)((String)this.payload.get()));
        this.setMustClone(true);
        this.isCloned = true;
        return log;
    }

    protected void rollBack() {
        this.status.set((Object)((String)this.vClone.status.get()));
        this.msg.set((Object)((String)this.vClone.msg.get()));
        this.dateLog.set((Object)((Date)this.vClone.dateLog.get()));
        this.payload.set((Object)((String)this.vClone.payload.get()));
        this.setMustClone(true);
    }

    @Override
    public void insert() throws Exception {
        try {
            String query = "INSERT INTO Log(msg,dateLog,status,payload) Values(?,?,?,?)";
            if (this.msg != null && this.msg.get() != null) {
                if (!((String)this.msg.get()).isEmpty() && ((String)this.msg.get()).length() > 4999) {
                    this.msg.set((Object)((String)this.msg.get()).substring(0, 4998));
                }
                ParameterValue[] parameterValues = new ParameterValue[]{new ParameterValue("msg", JDBCType.VARCHAR, this.msg.get()), new ParameterValue("dateLog", JDBCType.TIMESTAMP, new Timestamp(((Date)this.dateLog.get()).getTime())), new ParameterValue("status", JDBCType.VARCHAR, this.status.get()), new ParameterValue("payload", JDBCType.VARCHAR, "")};
                this.getDbAccess().performDbOperation(query, parameterValues);
                this.vClone = this.clone();
            } else {
                System.out.println("Error again");
            }
        }
        catch (Exception e) {
            this.isCloned = false;
            throw e;
        }
    }

    @Override
    public void update() throws Exception {
        try {
            String query = "UPDATE Log SET msg=?,status=?,payload=? WHERE dateLog=?";
            ParameterValue[] parameterValues = new ParameterValue[]{new ParameterValue("msg", JDBCType.VARCHAR, this.msg.get()), new ParameterValue("status", JDBCType.VARCHAR, this.status.get()), new ParameterValue("payload", JDBCType.VARCHAR, this.payload.get()), new ParameterValue("dateLog", JDBCType.TIMESTAMP, new Timestamp(((Date)this.vClone.dateLog.get()).getTime()))};
            this.getDbAccess().performDbOperation(query, parameterValues, true);
            this.vClone = this.clone();
        }
        catch (Exception e) {
            if (e instanceof BaseConcurrencyException) {
                String message = e.getMessage();
                throw new ConsequentialConcurrencyException(message, (Object)null);
            }
            throw e;
        }
    }

    @Override
    public void delete() {
        String query = "DELETE FROM Log";
        try {
            this.getDbAccess().performDbOperation(query, this.getDbAccess().getEmptyParameterValues());
        }
        catch (Exception ex) {
            Logger.getLogger(Customer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void deleteMain() {
        String query = "DELETE FROM Log WHERE dateLog=?";
        ParameterValue[] parameterValues = new ParameterValue[]{new ParameterValue("dateLog", JDBCType.DATE, new Timestamp(((Date)this.dateLog.get()).getTime()))};
        try {
            this.getDbAccess().performDbOperation(query, parameterValues);
        }
        catch (Exception ex) {
            Logger.getLogger(Customer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void beforeInsert() {
    }

    @Override
    public void afterInsert() {
    }

    @Override
    public void beforeUpdate() {
    }

    @Override
    public void afterUpdate() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Searchable getSearchable() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void initializeListener() {
    }

    public Timestamp getsTimestamp() {
        return this.sTimestamp;
    }

    public void setsTimestamp(Timestamp sTimestamp) {
        this.sTimestamp = sTimestamp;
    }
}

