/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa;

import com.xputertechnologies.santa.BoundPropertySupport;
import com.xputertechnologies.santa.core.DataAccess;
import com.xputertechnologies.santa.core.ObjectState;
import com.xputertechnologies.santa.core.Searchable;
import java.util.Date;

public abstract class DbEntity
implements Cloneable {
    private DataAccess dbAccess;
    private ObjectState state;
    private boolean mustClone = true;
    public Date lastSyncDate = new java.sql.Date(new Date().getTime());
    final BoundPropertySupport bps = new BoundPropertySupport(this);
    boolean isConstructor = false;

    public Object fullClone() throws CloneNotSupportedException {
        return super.clone();
    }

    public DbEntity(DataAccess dbAccess) {
        this();
        this.dbAccess = dbAccess;
        this.mustClone = true;
    }

    public abstract void insert() throws Exception;

    public abstract void update() throws Exception;

    public abstract void delete() throws Exception;

    public abstract void beforeInsert();

    public abstract void afterInsert();

    public abstract void beforeUpdate();

    public abstract void afterUpdate();

    public abstract Searchable getSearchable();

    public void changeObjectState() {
        if (this.getState().compareTo(ObjectState.New) != 0 && this.getState().compareTo(ObjectState.Removed) != 0) {
            this.state = ObjectState.Changed;
        }
    }

    public abstract void initializeListener();

    public DataAccess getDbAccess() {
        return this.dbAccess;
    }

    public void setDbAccess(DataAccess dbAccess) {
        this.dbAccess = dbAccess;
    }

    public ObjectState getState() {
        return this.state;
    }

    public void setState(ObjectState state) {
        this.state = state;
    }

    public DbEntity() {
        this.state = ObjectState.New;
    }

    public boolean isMustClone() {
        return this.mustClone;
    }

    public void setMustClone(boolean mustClone) {
        this.mustClone = mustClone;
    }
}

