/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.xputertechnologies.santa.core.DataAccess;
import com.xputertechnologies.santa.ui.NotificationType;
import com.xputertechnologies.santa.ui.UIParent;
import com.xputertechnologies.santa.ui.UnitContainer;
import com.xputertechnologies.santa.ui.UnitPane;
import java.io.IOException;
import java.sql.Connection;
import javafx.beans.property.Property;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.util.StringConverter;
import javafx.util.converter.FloatStringConverter;
import org.dbunit.database.DatabaseConnection;

public class Unit
extends UIParent {
    public static DataAccess da;
    private static Connection con;
    private static DatabaseConnection dc;
    @FXML
    private Button btnAddNew;
    @FXML
    private Button cancelbutton;
    @FXML
    private TextField nametxt;
    @FXML
    private TextField qtytxt;
    private UnitPane unitPane;
    com.xputertechnologies.santa.Unit unit = null;
    StringConverter<? extends Number> fconverter = new FloatStringConverter();
    String errorMsg;

    public Unit(UnitPane unitPane, com.xputertechnologies.santa.Unit unit, boolean lanch) {
        FXMLLoader fxmlLoader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("Unit.fxml"));
        fxmlLoader.setRoot((Object)this);
        fxmlLoader.setController((Object)this);
        try {
            fxmlLoader.load();
            this.santa = unitPane.santa;
            this.unitPane = unitPane;
            da = this.unitPane.santa.da;
            this.mainParent = this.unitPane;
            this.unit = unit;
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        this.hasParent = true;
        this.nametxt.textProperty().bindBidirectional((Property)unit.nameProperty());
        this.qtytxt.textProperty().bindBidirectional((Property)unit.quantityProperty(), this.fconverter);
        this.cancelbutton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                Unit.this.cancel();
            }
        });
        this.btnAddNew.setOnAction(event -> this.addNewUnit());
        if (lanch) {
            unitPane.mainPage.hbCenter.setContent((Node)this);
            unitPane.mainPage.hbBottom.setVisible(true);
        }
    }

    private void cancel() {
        this.unitPane.mainPage.hbCenter.setContent((Node)this.mainParent);
        this.unitPane.mainPage.closeNotification();
    }

    private void addNewUnit() {
        if ((double)this.unit.quantityProperty().get() != 0.0 && this.unit.nameProperty().get() != null && !((String)this.unit.nameProperty().get()).equals("") && !this.unit.isEdit) {
            this.unit.isEdit = true;
            this.unitPane.unitDataList.getOriginalList().add((Object)this.unit);
            this.unitPane.unitVbrep.getChildren().add((Object)new UnitContainer(this.unit, this.unitPane, this.santa));
            try {
                this.unitPane.createUnit();
            }
            catch (Exception ex) {
                this.unitPane.mainPage.showNotification(NotificationType.Error, ex.getMessage(), this);
            }
        } else if (this.validateControl()) {
            this.unitPane.mainPage.showNotification(NotificationType.Error, this.errorMsg, this);
        }
    }

    private void done() {
        if ((double)this.unit.quantityProperty().get() != 0.0 && this.unit.nameProperty().get() != null && !((String)this.unit.nameProperty().get()).equals("") && !this.unit.isEdit) {
            this.unit.isEdit = true;
            this.unitPane.unitDataList.getOriginalList().add((Object)this.unit);
            this.unitPane.unitVbrep.getChildren().add((Object)new UnitContainer(this.unit, this.unitPane, this.santa));
        } else if (!this.validateControl()) {
            this.unitPane.mainPage.showNotification(NotificationType.Error, this.errorMsg, this);
        }
    }

    @Override
    boolean validateControl() {
        this.errorMsg = "";
        if (this.nametxt.getText() == null || this.nametxt.getText().trim().isEmpty()) {
            this.errorMsg = this.errorMsg + "Quantity description must not be empty\n";
        }
        if (this.qtytxt.getText() == null || this.qtytxt.getText().trim().isEmpty() || this.qtytxt.getText().equals("0.0")) {
            this.errorMsg = this.errorMsg + "Quantity must not be empty";
        }
        return this.errorMsg.equals("");
    }

    @Override
    void completeControl() {
        this.done();
    }
}

