/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.jfoenix.controls.JFXButton;
import com.xputertechnologies.santa.Request;
import com.xputertechnologies.santa.RequestStatus;
import com.xputertechnologies.santa.RequestType;
import com.xputertechnologies.santa.Store;
import com.xputertechnologies.santa.UserType;
import com.xputertechnologies.santa.list.RequestDataList;
import com.xputertechnologies.santa.report.ReportType;
import com.xputertechnologies.santa.ui.DlgInterface;
import com.xputertechnologies.santa.ui.NotificationType;
import com.xputertechnologies.santa.ui.PromptDialog;
import com.xputertechnologies.santa.ui.ReportPane;
import com.xputertechnologies.santa.ui.SalesReturnPaneAudit;
import com.xputertechnologies.santa.ui.TransferPane;
import com.xputertechnologies.santa.ui.TransferPaneB2B;
import com.xputertechnologies.santa.ui.TransferSaleItemScanDialogB2B;
import com.xputertechnologies.santa.ui.UIParent;
import java.text.SimpleDateFormat;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.paint.Color;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import org.controlsfx.glyphfont.FontAwesome;

public class TransferCardB2B
extends UIParent {
    @FXML
    private TextField lblReqCode;
    @FXML
    private Label lblToStore;
    @FXML
    private Label lblFromStore;
    @FXML
    private Label lblDate;
    @FXML
    private Label lblStatus;
    @FXML
    private Label lblOrigUser;
    @FXML
    private Label lblReqType;
    @FXML
    private JFXButton btnDelete;
    @FXML
    private JFXButton btnAction;
    @FXML
    private JFXButton btnReload;
    @FXML
    private JFXButton btnCount;
    public Request request = null;

    public TransferCardB2B(final Request request, final TransferPaneB2B transferPane) {
        super("TransferCardB2B.fxml", null);
        this.request = request;
        if (request.getItems().isEmpty()) {
            request.loadRequestItems();
        }
        this.btnDelete.setVisible(false);
        this.btnAction.setVisible(false);
        this.btnDelete.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.TRASH).color(Color.RED));
        this.btnReload.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.REFRESH).color(Color.GREEN));
        this.lblReqCode.setText(request.getCode());
        this.lblToStore.setText(request.getToStoreName());
        this.lblFromStore.setText(request.getFromStoreName());
        this.lblOrigUser.setText(request.getStaffName());
        this.lblReqType.setText(request.getRequestType());
        this.btnCount.setText(Integer.toString(request.getItems().size()));
        this.btnCount.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.EYE).color(Color.GREEN));
        this.lblStatus.textProperty().bind((ObservableValue)request.statusProperty());
        this.lblDate.setText(new SimpleDateFormat("dd-MM-yyyy hh:mm").format(request.getRequestDate()));
        if (transferPane.currentUser.getRoleDescription().equals(UserType.Administrator.name()) || (request.getStatus().equals(RequestStatus.APPROVED.name()) || request.getStatus().equals(RequestStatus.PENDING.name())) && request.getFromStoreCode().equals(transferPane.currentUser.getParentCompany().getB2bLocationCode())) {
            this.btnDelete.setVisible(true);
        }
        if (request.getStatus().equals(RequestStatus.RELEASED.name()) && (request.getToStoreCode().equals(transferPane.currentUser.getParentCompany().getB2bLocationCode()) && request.getRequestType().equals(RequestType.Inbound.name()) || request.getFromStoreCode().equals(transferPane.currentUser.getParentCompany().getB2bLocationCode()) && request.getRequestType().equals(RequestType.Outbound.name()))) {
            this.btnAction.setText("Print");
            this.btnAction.setVisible(true);
            this.btnAction.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.PRINT));
            this.btnAction.setOnAction(eh -> {
                Store found = transferPane.storeDataList.getOriginalList().stream().filter(prdct -> prdct.getCode().equals(request.getFromStoreCode())).findAny().orElse(null);
                if (found != null) {
                    request.storeToAddress = found.getAddress();
                }
                if ((found = (Store)transferPane.storeDataList.getOriginalList().stream().filter(prdct -> prdct.getCode().equals(request.getToStoreCode())).findAny().orElse(null)) != null) {
                    request.storeFromAddress = found.getAddress();
                }
                transferPane.dialog = new Dialog();
                transferPane.dialog.initStyle(StageStyle.DECORATED);
                transferPane.dialog.initOwner((Window)transferPane.santa.stage);
                transferPane.dialog.setTitle("Release Items(s) Stock Report");
                transferPane.dialog.setResizable(true);
                transferPane.dialog.getDialogPane().setPrefWidth(1100.0);
                transferPane.dialog.getDialogPane().setPrefHeight(700.0);
                try {
                    transferPane.dialog.getDialogPane().setContent((Node)new ReportPane(transferPane.santa, ReportType.ReleaseReport, request));
                }
                catch (Exception ex) {
                    Logger.getLogger(SalesReturnPaneAudit.class.getName()).log(Level.SEVERE, null, ex);
                }
                transferPane.dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.CANCEL});
                Optional result = transferPane.dialog.showAndWait();
                if (!request.getIsPrinted().booleanValue() && result.isPresent()) {
                    try {
                        request.setIsPrinted(true);
                        RequestDataList requestDataList = new RequestDataList(this.da);
                        requestDataList.getOriginalList().add((Object)request);
                        request.update();
                    }
                    catch (Exception ex) {
                        Logger.getLogger(TransferPane.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            });
        }
        if (request.getStatus().equals(RequestStatus.CANCELLED.name())) {
            this.lblStatus.setStyle("-fx-background-color:lightcoral;-fx-font-size: 12.0px;-fx-text-fill:white;-fx-label-padding:5 5 5 5");
        } else if (request.getStatus().equals(RequestStatus.PENDING.name())) {
            this.lblStatus.setStyle("-fx-background-color:#f6c4ef;-fx-font-size: 12.0px;-fx-text-fill:black;-fx-label-padding:5 5 5 5");
        } else if (request.getStatus().equals(RequestStatus.DECLINED.name())) {
            this.lblStatus.setStyle("-fx-background-color:#FF0000;-fx-font-size: 12.0px;-fx-text-fill:white;-fx-label-padding:5 5 5 5");
        } else if (request.getStatus().equals(RequestStatus.APPROVED.name())) {
            this.lblStatus.setStyle("-fx-background-color:#34b962;-fx-font-size: 12.0px;-fx-text-fill:white;-fx-label-padding:5 5 5 5");
            Tooltip tooltip = new Tooltip(request.getApprovingUser());
            this.lblStatus.setTooltip(tooltip);
        } else if (request.getStatus().equals(RequestStatus.COMPLETED.name())) {
            this.lblStatus.setStyle("-fx-background-color:#c5f6f4;-fx-font-size: 12.0px;-fx-text-fill:black;-fx-label-padding:5 5 5 5");
        } else if (request.getStatus().equals(RequestStatus.RELEASED.name())) {
            this.lblStatus.setStyle("-fx-background-color:#0afff5;-fx-font-size: 12.0px;-fx-text-fill:black;-fx-label-padding:5 5 5 5");
        } else if (request.getStatus().equals(RequestStatus.ACCEPTED.name())) {
            this.lblStatus.setStyle("-fx-background-color:#B5C460;-fx-font-size: 12.0px;-fx-label-padding:5 5 5 5");
        } else if (request.getStatus().equals(RequestStatus.RETURNED.name())) {
            this.lblStatus.setStyle("-fx-background-color:#59c5c5;-fx-font-size: 12.0px;-fx-label-padding:5 5 5 5");
        }
        if (request.getStatus().equals(RequestStatus.APPROVED.name()) && request.getRequestType().equals(RequestType.Inbound.name()) && request.getToStoreCode().equals(transferPane.currentUser.getParentCompany().getB2bLocationCode()) || request.getStatus().equals(RequestStatus.APPROVED.name()) && request.getRequestType().equals(RequestType.Outbound.name()) && request.getFromStoreCode().equals(transferPane.currentUser.getParentCompany().getB2bLocationCode()) || request.getStatus().equals(RequestStatus.RELEASED.name()) && request.getFromStoreCode().equals(transferPane.currentUser.getParentCompany().getB2bLocationCode()) && request.getRequestType().equals(RequestType.Inbound.name()) || request.getStatus().equals(RequestStatus.RELEASED.name()) && request.getToStoreCode().equals(transferPane.currentUser.getParentCompany().getB2bLocationCode()) && request.getRequestType().equals(RequestType.Outbound.name()) || request.getStatus().equals(RequestStatus.ACCEPTED.name()) && request.getRequestType().equals(RequestType.Outbound.name()) && request.getToStoreCode().equals(transferPane.currentUser.getParentCompany().getB2bLocationCode()) || request.getStatus().equals(RequestStatus.ACCEPTED.name()) && request.getRequestType().equals(RequestType.Inbound.name()) && request.getFromStoreCode().equals(transferPane.currentUser.getParentCompany().getB2bLocationCode())) {
            this.btnAction.setVisible(true);
            if (request.getStatus().equals(RequestStatus.APPROVED.name())) {
                this.btnAction.setText("Release");
                this.btnAction.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.ARROW_UP).color(Color.GOLD));
            } else if (request.getStatus().equals(RequestStatus.RELEASED.name()) || request.getStatus().equals(RequestStatus.ACCEPTED.name())) {
                this.btnAction.setText("Accept");
                this.btnAction.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.ARROW_DOWN).color(Color.GREEN));
            }
            this.btnAction.setOnAction(eh -> {
                try {
                    transferPane.accptRelease = this.btnAction;
                    transferPane.dialog = new Dialog();
                    transferPane.dialog.initStyle(StageStyle.DECORATED);
                    transferPane.dialog.initOwner((Window)transferPane.santa.stage);
                    transferPane.dialog.setTitle("Transfer(Release/Accept)");
                    transferPane.dialog.setResizable(true);
                    transferPane.dialog.getDialogPane().setContent((Node)new TransferSaleItemScanDialogB2B(transferPane.santa, request));
                    ButtonType buttonType = new ButtonType(request.getStatus().equals(RequestStatus.APPROVED.name()) ? "Release" : "Accept", ButtonBar.ButtonData.OK_DONE);
                    transferPane.dialog.getDialogPane().getButtonTypes().add((Object)buttonType);
                    Optional result = transferPane.dialog.showAndWait();
                    if (result.isPresent() && result.get() == buttonType) {
                        if (request.getStatus().equals(RequestStatus.APPROVED.name())) {
                            if (request.getItems().stream().filter(v -> v.getReleasedQuantity() > v.getApprovedQty()).findAny().orElse(null) == null) {
                                if (request.getItems().stream().filter(v -> v.getReleasedQuantity() != v.getApprovedQty().intValue()).findAny().orElse(null) == null || request.getItems().stream().filter(v -> v.getReleasedQuantity() != v.getApprovedQty().intValue()).findAny().orElse(null) != null && !request.getReleaseComment().isEmpty()) {
                                    new PromptDialog(transferPane.santa, "Release", "Are you sure you want to release this transfer request?", transferPane.stackPane, new DlgInterface(){

                                        @Override
                                        public void ok() {
                                            transferPane.Release(request);
                                        }

                                        @Override
                                        public void cancel() {
                                        }
                                    });
                                } else {
                                    transferPane.mainPage.showNotification(NotificationType.Error, "One or more items(s) has quantity not equals to requested quantity, Please specify comment and try again", transferPane);
                                }
                            } else {
                                transferPane.mainPage.showNotification(NotificationType.Error, "One or more items(s) has quantity greater than approved quantity", transferPane);
                            }
                        } else if (request.getStatus().equals(RequestStatus.RELEASED.name()) || request.getStatus().equals(RequestStatus.ACCEPTED.name())) {
                            if (request.getItems().stream().filter(v -> v.getAcceptedQty() > v.getReleasedQuantity()).findAny().orElse(null) == null && !transferPane.isAcceptedQtyGreaterThanReleaseQty(request)) {
                                if (request.getItems().stream().filter(v -> v.getTempQty().intValue() != v.getReleasedQuantity()).findAny().orElse(null) == null || request.getItems().stream().filter(v -> v.getTempQty().intValue() != v.getReleasedQuantity()).findAny().orElse(null) != null && !request.getAcceptedComment().isEmpty()) {
                                    new PromptDialog(transferPane.santa, "Accept", "Are you sure you want to accept this transfer request?", transferPane.stackPane, new DlgInterface(){

                                        @Override
                                        public void ok() {
                                            transferPane.Accept(request);
                                        }

                                        @Override
                                        public void cancel() {
                                        }
                                    });
                                } else {
                                    transferPane.mainPage.showNotification(NotificationType.Error, "One or more items(s) has quantity not equals to requested quantity, Please specify comment and try again", transferPane);
                                }
                            } else {
                                transferPane.mainPage.showNotification(NotificationType.Error, "One or more items(s) has quantity greater than released quantity", transferPane);
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    request.setStatus(RequestStatus.APPROVED.name());
                    Logger.getLogger(TransferPane.class.getName()).log(Level.SEVERE, null, ex);
                }
            });
        }
        this.btnReload.setOnAction(val -> transferPane.reloadRequest(request));
        this.btnCount.setOnAction(eh -> transferPane.loadItems(request));
        this.btnDelete.setOnAction(eh -> new PromptDialog(transferPane.santa, "Remove Transfer Request", "Are you sure you want to remove this transfer request?", transferPane.stackPane, new DlgInterface(){

            @Override
            public void ok() {
                transferPane.deleteRequest(request);
            }

            @Override
            public void cancel() {
            }
        }));
    }
}

