/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.xputertechnologies.santa.SaleItem;
import com.xputertechnologies.santa.ui.DecimalNumberTextBox;
import com.xputertechnologies.santa.ui.General;
import com.xputertechnologies.santa.ui.UIControlBase;
import javafx.beans.property.Property;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.input.KeyEvent;
import javafx.util.StringConverter;
import javafx.util.converter.FloatStringConverter;

public class SalesReturnLine
extends UIControlBase {
    @FXML
    private Label lblItemId;
    @FXML
    private Label lblSn;
    @FXML
    private Label lblName;
    @FXML
    private Label lblQtyBought;
    @FXML
    private Label lblPrice;
    @FXML
    public DecimalNumberTextBox tbReturn;
    StringConverter<? extends Number> fConverter = new FloatStringConverter();
    private SaleItem saleItem;

    public SalesReturnLine(SaleItem saleItem, int no) {
        this.saleItem = saleItem;
        this.lblItemId.setText(saleItem.getItemCode());
        this.lblSn.setText(Integer.toString(no + 1));
        this.lblPrice.setText(General.formatDecimalToMoneyString(saleItem.getVariablePrice()));
        this.lblName.setText(saleItem.getItemName());
        this.lblQtyBought.setText(Float.toString(saleItem.getQuantity()));
        this.tbReturn.textProperty().bindBidirectional((Property)saleItem.qtyToreturnQtyProperty(), this.fConverter);
        this.tbReturn.addEventFilter(KeyEvent.KEY_TYPED, General.vaalidateTextBoxInput(saleItem.getQuantity()));
    }
}

