/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.jfoenix.controls.JFXDialog;
import com.xputertechnologies.santa.AccountDetail;
import com.xputertechnologies.santa.DbEntity;
import com.xputertechnologies.santa.NameValueObject;
import com.xputertechnologies.santa.PurchaseDeliveryNote;
import com.xputertechnologies.santa.PurchaseOrder;
import com.xputertechnologies.santa.Request;
import com.xputertechnologies.santa.RequestItem;
import com.xputertechnologies.santa.RequestType;
import com.xputertechnologies.santa.Sale;
import com.xputertechnologies.santa.SaleAccountDetailResolver;
import com.xputertechnologies.santa.SaleItem;
import com.xputertechnologies.santa.StockItem;
import com.xputertechnologies.santa.StockItemDataPrint;
import com.xputertechnologies.santa.UserType;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.list.SaleAccountDetailResolverDataList;
import com.xputertechnologies.santa.list.SaleList;
import com.xputertechnologies.santa.list.StockItemList;
import com.xputertechnologies.santa.list.StoreDataList;
import com.xputertechnologies.santa.report.JRCreditDataSource;
import com.xputertechnologies.santa.report.JRDailySaleBYAccountDataSource;
import com.xputertechnologies.santa.report.JRDailySaleDataSource;
import com.xputertechnologies.santa.report.JRDailySalesSummaryDataSource;
import com.xputertechnologies.santa.report.JRInvoiceDataSource;
import com.xputertechnologies.santa.report.JRReleasePODataSource;
import com.xputertechnologies.santa.report.JRReleaseTransferDataSource;
import com.xputertechnologies.santa.report.JRStockItemBarCodeDataSource;
import com.xputertechnologies.santa.report.JRStockListDataSource;
import com.xputertechnologies.santa.report.JRViewerFxController;
import com.xputertechnologies.santa.report.ReportType;
import com.xputertechnologies.santa.ui.General;
import com.xputertechnologies.santa.ui.Santa;
import com.xputertechnologies.santa.ui.UIParent;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;

public class ReportPane
extends UIParent {
    JFXDialog dialogFromParent;
    public Santa app;
    Sale sale;
    final String rptPath = ((Object)((Object)this)).getClass().getResource("DailySales.jrxml").toString();
    ObservableList<StockItem> stockItemList = FXCollections.observableArrayList();
    public ObservableList<Sale> saleList = FXCollections.observableArrayList();
    Double tot = 0.0;
    public static Date ToDt;
    public static Date FromDt;
    int qty = 0;
    Double amountPaid = 0.0;
    int totQty = 0;
    double totTax = 0.0;
    double totalAmt = 0.0;
    double txPercentage = 0.0;

    public ReportPane(Santa app, ReportType reportType, Sale sale, ObservableList<StockItem> stockItemList, ObservableList<Sale> saleList, String StoreName) throws JRException, IOException {
        super("DailySaleReportPane.fxml", app);
        this.app = app;
        if (sale != null) {
            this.sale = sale;
        }
        JRViewerFxController controller = null;
        JasperPrint rpt = null;
        General general = new General();
        switch (reportType) {
            case DailySales: {
                this.title = "Daily Sales Report";
                rpt = JasperFillManager.fillReport((JasperReport)general.getJsrpt(reportType.name()), general.reportParams(), (JRDataSource)this.createDailySaleDataSource());
                controller = new JRViewerFxController(this, rpt, ReportType.DailySales);
                break;
            }
            case DailySalesByAccount: {
                this.title = "Daily Sales By Account Report";
                rpt = JasperFillManager.fillReport((JasperReport)general.getJsrpt(reportType.name()), general.reportParams(), (JRDataSource)this.createDailySaleByAccountDataSource());
                controller = new JRViewerFxController(this, rpt, ReportType.DailySalesByAccount);
                break;
            }
            case StockList: {
                this.title = "Stock List Report";
                rpt = JasperFillManager.fillReport((JasperReport)general.getJsrpt(reportType.name()), general.reportParams(), (JRDataSource)this.createStockListDataSource());
                controller = new JRViewerFxController(this, rpt, ReportType.StockList);
                break;
            }
            case StockListAudit: {
                this.title = "Stock List Report";
                rpt = JasperFillManager.fillReport((JasperReport)app.getCompiledJasperReportStockList(), general.reportParams(), (JRDataSource)this.createStockListDataSource(stockItemList, StoreName));
                controller = new JRViewerFxController(this, rpt, ReportType.StockList);
                break;
            }
            case Invoice: {
                this.title = "Invoice";
                rpt = JasperFillManager.fillReport((JasperReport)general.getJsrpt(reportType.name()), general.reportParams(), (JRDataSource)this.createInvoiceDataSource());
                controller = new JRViewerFxController(this, rpt, ReportType.Invoice);
                break;
            }
            case DailySalesSummary: {
                this.title = "Daily Summary Report";
                rpt = JasperFillManager.fillReport((JasperReport)general.getJsrpt(reportType.name()), general.reportParams(), (JRDataSource)this.createDailySalesSummaryDataSource());
                controller = new JRViewerFxController(this, rpt, ReportType.DailySalesSummary);
                break;
            }
            case AuditDailySalesByAccount: {
                this.title = "Daily Sales By Account Report";
                rpt = JasperFillManager.fillReport((JasperReport)general.getJsrpt(reportType.name()), general.reportParams(), (JRDataSource)ReportPane.createDailySaleByAccountDataSourceAudit(saleList, StoreName));
                controller = new JRViewerFxController(this, rpt, ReportType.DailySalesByAccount);
                break;
            }
            case CreditSale: {
                this.title = "Credit Sales Report";
                rpt = JasperFillManager.fillReport((JasperReport)general.getJsrpt(reportType.name()), general.reportParams(), (JRDataSource)this.createCreditSalesDataSource(saleList));
                controller = new JRViewerFxController(this, rpt, ReportType.CreditSale);
                break;
            }
        }
        this.getChildren().add(controller);
    }

    public ReportPane(Santa app, ReportType reportType, ObservableList<StockItem> stockItemList, ObservableList<Sale> saleList, String StoreName) throws JRException, IOException {
        super("DailySaleReportPane.fxml", app);
        this.app = app;
        JRViewerFxController controller = null;
        JasperPrint rpt = null;
        General general = new General();
        switch (reportType) {
            case DailySales: {
                this.title = "Daily Sales Report";
                rpt = JasperFillManager.fillReport((JasperReport)general.getJsrpt(reportType.name()), general.reportParams(), (JRDataSource)this.createDailySaleDataSource());
                controller = new JRViewerFxController(this, rpt, ReportType.DailySales);
                break;
            }
            case DailySalesByAccount: {
                this.title = "Daily Sales By Account Report";
                rpt = JasperFillManager.fillReport((JasperReport)general.getJsrpt(reportType.name()), general.reportParams(), (JRDataSource)this.createDailySaleByAccountDataSource());
                controller = new JRViewerFxController(this, rpt, ReportType.DailySalesByAccount);
                break;
            }
            case StockList: {
                this.title = "Stock List Report";
                rpt = JasperFillManager.fillReport((JasperReport)general.getJsrpt(reportType.name()), general.reportParams(), (JRDataSource)this.createStockListDataSource());
                controller = new JRViewerFxController(this, rpt, ReportType.StockList);
                break;
            }
            case StockListAudit: {
                this.title = "Stock List Report";
                rpt = JasperFillManager.fillReport((JasperReport)app.getCompiledJasperReportStockList(), general.reportParams(), (JRDataSource)this.createStockListDataSource(stockItemList, StoreName));
                controller = new JRViewerFxController(this, rpt, ReportType.StockList, null, stockItemList);
                break;
            }
            case Invoice: {
                this.title = "Invoice";
                rpt = JasperFillManager.fillReport((JasperReport)general.getJsrpt(reportType.name()), general.reportParams(), (JRDataSource)this.createInvoiceDataSource());
                controller = new JRViewerFxController(this, rpt, ReportType.Invoice);
                break;
            }
            case DailySalesSummary: {
                this.title = "Daily Summary Report";
                rpt = JasperFillManager.fillReport((JasperReport)general.getJsrpt(reportType.name()), general.reportParams(), (JRDataSource)this.createDailySalesSummaryDataSource(saleList, StoreName));
                controller = new JRViewerFxController(this, rpt, ReportType.DailySalesSummaryAudit, saleList, null);
                break;
            }
            case AuditDailySalesByAccount: {
                this.title = "Daily Sales By Account Report";
                rpt = JasperFillManager.fillReport((JasperReport)general.getJsrpt(reportType.name()), general.reportParams(), (JRDataSource)ReportPane.createDailySaleByAccountDataSourceAudit(saleList, StoreName));
                controller = new JRViewerFxController(this, rpt, ReportType.AuditDailySalesByAccount, saleList, null);
                break;
            }
        }
        this.getChildren().add(controller);
    }

    public ReportPane(Santa app, ReportType reportType) throws JRException, IOException {
        super("DailySaleReportPane.fxml", app);
        this.app = app;
        JRViewerFxController controller = null;
        JasperPrint rpt = null;
        General general = new General();
        switch (reportType) {
            case DailySales: {
                this.title = "Daily Sales Report";
                rpt = JasperFillManager.fillReport((JasperReport)general.getJsrpt(reportType.name()), general.reportParams(), (JRDataSource)this.createDailySaleDataSource());
                controller = new JRViewerFxController(this, rpt, ReportType.DailySales, this.saleList, null);
                break;
            }
            case DailySalesByAccount: {
                this.title = "Daily Sales By Account Report";
                rpt = JasperFillManager.fillReport((JasperReport)general.getJsrpt(reportType.name()), general.reportParams(), (JRDataSource)this.createDailySaleByAccountDataSource());
                controller = new JRViewerFxController(this, rpt, ReportType.DailySalesByAccount);
                break;
            }
            case StockList: {
                this.title = "Stock List Report";
                rpt = JasperFillManager.fillReport((JasperReport)app.getCompiledJasperReportStockList(), general.reportParams(), (JRDataSource)this.createStockListDataSource());
                controller = new JRViewerFxController(this, rpt, ReportType.StockList, null, this.stockItemList);
                break;
            }
            case Invoice: {
                this.title = "Invoice";
                rpt = JasperFillManager.fillReport((JasperReport)general.getJsrpt(reportType.name()), general.reportParams(), (JRDataSource)this.createInvoiceDataSource());
                controller = new JRViewerFxController(this, rpt, ReportType.Invoice);
                break;
            }
            case DailySalesSummary: {
                this.title = "Daily Summary Report";
                rpt = JasperFillManager.fillReport((JasperReport)general.getJsrpt(reportType.name()), general.reportParams(), (JRDataSource)this.createDailySalesSummaryDataSource());
                if (this.saleList.isEmpty()) {
                    controller = new JRViewerFxController(this, rpt, ReportType.DailySalesSummary);
                    break;
                }
                controller = new JRViewerFxController(this, rpt, ReportType.DailySalesSummary, this.saleList, null);
                break;
            }
        }
        this.getChildren().add(controller);
    }

    public ReportPane(Santa app, ReportType reportType, Sale sale) throws JRException, IOException {
        super("DailySaleReportPane.fxml", app);
        this.app = app;
        if (sale != null) {
            this.sale = sale;
        }
        JRViewerFxController controller = null;
        JasperPrint rpt = null;
        General general = new General();
        this.title = "Invoice";
        rpt = JasperFillManager.fillReport((JasperReport)app.getCompiledJasperReportInvoice(), general.reportParams(), (JRDataSource)this.createInvoiceDataSource());
        controller = new JRViewerFxController(this, rpt, ReportType.Invoice);
        this.getChildren().add((Object)controller);
    }

    public ReportPane(Santa app, ReportType reportType, Request request) throws JRException, IOException {
        super("DailySaleReportPane.fxml", app);
        this.app = app;
        JRViewerFxController controller = null;
        JasperPrint rpt = null;
        General general = new General();
        this.title = "Release Transfer";
        rpt = reportType == ReportType.ReleaseReport ? JasperFillManager.fillReport((JasperReport)app.getCompiledJasperReportReleaseTransfer(), general.reportParams(), (JRDataSource)this.createReleaseTransferDataSource(request)) : JasperFillManager.fillReport((JasperReport)app.getCompiledJasperReportReleaseTransferBin(), general.reportParams(), (JRDataSource)this.createReleaseTransferDataSource(request));
        controller = new JRViewerFxController(this, rpt, reportType);
        this.getChildren().add((Object)controller);
    }

    public ReportPane(Santa app, ReportType reportType, JFXDialog dialogFromParent, ObservableList<Request> requests) throws JRException, IOException {
        super("DailySaleReportPane.fxml", app);
        this.app = app;
        JRViewerFxController controller = null;
        JasperPrint rpt = null;
        General general = new General();
        this.title = "GIT Pending Transfer";
        rpt = JasperFillManager.fillReport((JasperReport)app.getCompiledJasperReportGITTransfer(), general.reportParams(), (JRDataSource)this.createReleaseTransferDataSource(requests));
        controller = new JRViewerFxController(this, rpt, ReportType.GIT, dialogFromParent, requests);
        this.getChildren().add((Object)controller);
    }

    public ReportPane(Santa app, JFXDialog dialogFromParent, PurchaseOrder purchaseOrder) throws JRException, IOException {
        super("DailySaleReportPane.fxml", app);
        this.app = app;
        JRViewerFxController controller = null;
        JasperPrint rpt = null;
        General general = new General();
        this.title = "GIT Pending Transfer";
        rpt = JasperFillManager.fillReport((JasperReport)app.getCompiledJasperReportPO(), general.reportParams(), (JRDataSource)this.createReleasePODataSource(purchaseOrder));
        controller = new JRViewerFxController(this, rpt, dialogFromParent, purchaseOrder);
        this.getChildren().add((Object)controller);
    }

    public ReportPane(Santa app, JFXDialog dialogFromParent, PurchaseDeliveryNote purchaseDeliveryNote) throws JRException, IOException {
        super("DailySaleReportPane.fxml", app);
        this.app = app;
        JRViewerFxController controller = null;
        JasperPrint rpt = null;
        General general = new General();
        this.title = "GIT Pending Transfer";
        rpt = JasperFillManager.fillReport((JasperReport)app.getCompiledJasperReportGRPO(), general.reportParams(), (JRDataSource)this.createReleasePODataSource(purchaseDeliveryNote));
        controller = new JRViewerFxController(this, rpt, dialogFromParent, purchaseDeliveryNote);
        this.getChildren().add((Object)controller);
    }

    public ReportPane(Santa app, JFXDialog dialogFromParent, ObservableList<PurchaseOrder> purchaseOrder) throws JRException, IOException {
        super("DailySaleReportPane.fxml", app);
        this.app = app;
        JRViewerFxController controller = null;
        JasperPrint rpt = null;
        General general = new General();
        this.title = "GIT Pending Transfer";
        rpt = JasperFillManager.fillReport((JasperReport)app.getCompiledJasperReportPOs(), general.reportParams(), (JRDataSource)this.createReleasePODataSource(purchaseOrder));
        controller = new JRViewerFxController(this, rpt, dialogFromParent, purchaseOrder);
        this.getChildren().add((Object)controller);
    }

    public void GenerateBarCode(JFXDialog dialogFromParent, ObservableList<StockItemDataPrint> stockItemDataPrints, boolean isBarCode) throws JRException, IOException {
        Object controller = null;
        JasperPrint rpt = null;
        General general = new General();
        HashMap params = new HashMap();
        rpt = JasperFillManager.fillReport((JasperReport)(isBarCode ? this.app.getCompiledJasperReportStockItemBarCode() : this.app.getCompiledJasperReportStockItemBarCodeItem()), params, (JRDataSource)this.createStockBarCodePrint(stockItemDataPrints));
        this.getChildren().add(controller);
    }

    public ReportPane(Santa s) {
        this.app = s;
    }

    private JRDataSource createDailySaleDataSource() {
        JRDailySaleDataSource dataSource = new JRDailySaleDataSource();
        SaleList saleList = Sale.SearchSaleItemForSaleReturn("", Date.valueOf(LocalDate.now()), Date.valueOf(LocalDate.now()), this.app.da, this.app.currentUser);
        int i = 0;
        this.saleList.clear();
        for (Sale sale : saleList.getOriginalList()) {
            sale.getSaleItemsList().forEach(si -> {
                this.tot = this.tot + si.getVariablePrice() * (double)si.getQuantity();
                if (si.getReturnQty() > 0.0f) {
                    this.tot = this.tot + (double)(si.getQuantity() - si.getReturnQty()) * si.getVariablePrice();
                }
            });
            dataSource.add(null, "", sale.getHdInvoiceNo(), sale.getd365CustomerNo(), sale.getCustomerName(), this.app.mainpage.currentUser.getParentCompany().getStoreName(), sale.getStaff().getFullName(), new BigDecimal(sale.getAmountPaid()), JRViewerFxController.dateAlone(sale.getNewDate()), Integer.toString(++i));
            this.saleList.add((Object)sale);
        }
        return dataSource;
    }

    public JRDataSource createDailySaleByAccountDataSource() {
        JRDailySaleBYAccountDataSource dataSource = new JRDailySaleBYAccountDataSource();
        ObservableList list = FXCollections.observableArrayList();
        Object subQry = "";
        if (this.currentUser.getRoleDescription().equals(UserType.SalesPerson.name())) {
            subQry = " SALE.SellingStaff='" + this.currentUser.getUserName() + "' and ";
        }
        SimpleDateFormat sfd = new SimpleDateFormat("yyyy-MM-dd");
        String date = sfd.format(new java.util.Date());
        String completeQry = " order by  SALEACCOUNTDETAILRESOLVER.TRANSACTIONDATE,SALEACCOUNTDETAILRESOLVER.ACCNUMBER";
        String query = "select  ACCOUNTDETAIL.ACCNAME,  SALEACCOUNTDETAILRESOLVER.INVOICENUMBER,SALE.COMPANYNAME,SALE.SELLINGSTAFF,COMPANY.STORENAME, CUSTOMER.\"NAME\" ,SALEACCOUNTDETAILRESOLVER.AMOUNTPAID,SALEACCOUNTDETAILRESOLVER.TRANSACTIONDATE, SALEACCOUNTDETAILRESOLVER.ACCNUMBER,SALEACCOUNTDETAILRESOLVER.ACCTYPE,SALEACCOUNTDETAILRESOLVER.PAYMENTCODE from  SALEACCOUNTDETAILRESOLVER join SALE on SALEACCOUNTDETAILRESOLVER.INVOICENUMBER=SALE.INVOICENUMBER join CUSTOMER on SALE.CUSTOMERNAME= CUSTOMER.Phonenumber join COMPANY on (SALE.COMPANYNAME = COMPANY.NAME)\n join ACCOUNTDETAIL on SALEACCOUNTDETAILRESOLVER.ACCNUMBER= ACCOUNTDETAIL.ACCNUMBER WHERE SaleStatus <> \"CANCELLED\" and " + (String)subQry + "SALEACCOUNTDETAILRESOLVER.TRANSACTIONDATE between '" + date + " 0:0' And '" + date + " 23:59'";
        list.addAll(SaleAccountDetailResolverDataList.selectDailySaleByAcct(query + completeQry, this.da.getEmptyParameterValues(), this.da));
        int i = 0;
        for (SaleAccountDetailResolver sale : list) {
            dataSource.add(null, "", String.valueOf(sale.getInvoiceNumber()), sale.CustomerCode, sale.CustomerName, sale.StoreName, sale.FullAccountDetail, new BigDecimal(sale.getAmountPaid()), JRViewerFxController.dateAlone(sale.getTransactionDate()), Integer.toString(++i), sale.getTransactionDate(), sale.getTransactionDate(), "", sale.sellingStaff, sale.getAccType(), sale.getAccNumber(), "");
        }
        return dataSource;
    }

    public JRDataSource createDailySaleByAccountDataSource(Santa app, String searcString, Date FromDate, Date ToDate) {
        JRDailySaleBYAccountDataSource dataSource = new JRDailySaleBYAccountDataSource();
        ObservableList list = FXCollections.observableArrayList();
        Object subQry = "";
        if (app.currentUser.getRoleDescription().equals(UserType.SalesPerson.name())) {
            subQry = " SALE.SellingStaff='" + app.currentUser.getUserName() + "' and ";
        }
        String completeQry = " order by  SALEACCOUNTDETAILRESOLVER.TRANSACTIONDATE,SALEACCOUNTDETAILRESOLVER.ACCNUMBER";
        String query = "select  ACCOUNTDETAIL.ACCNAME,SALEACCOUNTDETAILRESOLVER.ACCTYPE, SALEACCOUNTDETAILRESOLVER.INVOICENUMBER,SALE.COMPANYNAME,SALE.sellingStaff,COMPANY.STORENAME, CUSTOMER.\"NAME\" , SALE.SALESCHANNEL, SALEACCOUNTDETAILRESOLVER.AMOUNTPAID,SALEACCOUNTDETAILRESOLVER.TRANSACTIONDATE, SALEACCOUNTDETAILRESOLVER.ACCNUMBER,SALEACCOUNTDETAILRESOLVER.ACCTYPE,SALEACCOUNTDETAILRESOLVER.PAYMENTCODE from  SALEACCOUNTDETAILRESOLVER join SALE on SALEACCOUNTDETAILRESOLVER.INVOICENUMBER=SALE.INVOICENUMBER join CUSTOMER on SALE.CustomerPhoneNumber = CUSTOMER.PHONENUMBER join COMPANY on (SALE.COMPANYNAME = COMPANY.NAME)  join ACCOUNTDETAIL on SALEACCOUNTDETAILRESOLVER.ACCNUMBER= ACCOUNTDETAIL.ACCNUMBER WHERE SaleStatus <> \"CANCELLED\" and " + (String)subQry;
        Calendar clFromDt = Calendar.getInstance();
        clFromDt.setTime(FromDate);
        clFromDt.add(10, 0);
        clFromDt.add(13, 0);
        clFromDt.add(12, 0);
        Calendar clToDt = Calendar.getInstance();
        clToDt.setTime(ToDate);
        clToDt.add(10, 23);
        clToDt.add(13, 59);
        clToDt.add(12, 0);
        if (searcString != null && !searcString.isEmpty() && FromDate != null && ToDate != null) {
            query = query + "(SALE.customerName like ? or SALEACCOUNTDETAILRESOLVER.invoiceNumber like ? or SALE.SellingStaff like ? ) and SALEACCOUNTDETAILRESOLVER.TRANSACTIONDATE between ? And ? ";
            list.addAll(SaleAccountDetailResolverDataList.selectDailySaleByAcct(query + completeQry, new ParameterValue[]{new ParameterValue("customerName", JDBCType.VARCHAR, searcString), new ParameterValue("invoiceNumber", JDBCType.VARCHAR, searcString), new ParameterValue("SellingStaff", JDBCType.VARCHAR, searcString), new ParameterValue("ParamFromDate", JDBCType.TIMESTAMP, new Timestamp(clFromDt.getTime().getTime())), new ParameterValue("ParamToDate", JDBCType.TIMESTAMP, new Timestamp(clToDt.getTime().getTime()))}, app.da));
        } else if ((searcString == null || searcString.isEmpty()) && FromDate != null && ToDate != null) {
            query = query + " SALEACCOUNTDETAILRESOLVER.TRANSACTIONDATE between  " + clFromDt.getTime().getTime() + " And " + clToDt.getTime().getTime();
            list.addAll(SaleAccountDetailResolverDataList.selectDailySaleByAcct(query + completeQry, app.da.getEmptyParameterValues(), app.da));
        } else if (!(searcString == null || searcString.isEmpty() || FromDate != null && ToDate != null)) {
            query = query + "(SALE.customerName like ? or SALEACCOUNTDETAILRESOLVER.invoiceNumber like ? or SALE.SellingStaff like ? ) ";
            list.addAll(SaleAccountDetailResolverDataList.selectDailySaleByAcct(query + completeQry, new ParameterValue[]{new ParameterValue("customerName", JDBCType.VARCHAR, searcString), new ParameterValue("invoiceNumber", JDBCType.VARCHAR, searcString), new ParameterValue("SellingStaff", JDBCType.VARCHAR, searcString)}, app.da));
        }
        int i = 0;
        this.saleList.clear();
        for (SaleAccountDetailResolver sale : list) {
            dataSource.add(null, "", String.valueOf(sale.getInvoiceNumber()), sale.CustomerCode, sale.CustomerName, sale.StoreName, sale.FullAccountDetail, new BigDecimal(sale.getAmountPaid()), JRViewerFxController.dateAlone(sale.getTransactionDate()), Integer.toString(++i), clFromDt.getTime(), clToDt.getTime(), "", sale.sellingStaff, sale.getAccType(), sale.getAccNumber(), "");
        }
        return dataSource;
    }

    public JRDataSource createDailySaleByBusinessStreamDataSource(Santa app, String searcString, Date FromDate, Date ToDate) {
        JRDailySaleBYAccountDataSource dataSource = new JRDailySaleBYAccountDataSource();
        ObservableList list = FXCollections.observableArrayList();
        Object subQry = "";
        if (app.currentUser.getRoleDescription().equals(UserType.SalesPerson.name())) {
            subQry = " SALE.SellingStaff='" + app.currentUser.getUserName() + "' and ";
        }
        String completeQry = " order by  SALEACCOUNTDETAILRESOLVER.TRANSACTIONDATE,SALEACCOUNTDETAILRESOLVER.ACCNUMBER";
        String query = "select  ACCOUNTDETAIL.ACCNAME,SALEACCOUNTDETAILRESOLVER.ACCTYPE, SALEACCOUNTDETAILRESOLVER.INVOICENUMBER,SALE.COMPANYNAME,SALE.sellingStaff,COMPANY.STORENAME, CUSTOMER.\"NAME\" , SALE.SALESCHANNEL, SALEACCOUNTDETAILRESOLVER.AMOUNTPAID,SALEACCOUNTDETAILRESOLVER.TRANSACTIONDATE, SALEACCOUNTDETAILRESOLVER.ACCNUMBER,SALEACCOUNTDETAILRESOLVER.ACCTYPE,SALEACCOUNTDETAILRESOLVER.PAYMENTCODE from  SALEACCOUNTDETAILRESOLVER join SALE on SALEACCOUNTDETAILRESOLVER.INVOICENUMBER=SALE.INVOICENUMBER join CUSTOMER on SALE.CustomerPhoneNumber = CUSTOMER.PHONENUMBER join COMPANY on (SALE.COMPANYNAME = COMPANY.NAME)  join ACCOUNTDETAIL on SALEACCOUNTDETAILRESOLVER.ACCNUMBER= ACCOUNTDETAIL.ACCNUMBER WHERE SaleStatus <> \"CANCELLED\" and " + (String)subQry;
        Calendar clFromDt = Calendar.getInstance();
        clFromDt.setTime(FromDate);
        clFromDt.add(10, 0);
        clFromDt.add(13, 0);
        clFromDt.add(12, 0);
        Calendar clToDt = Calendar.getInstance();
        clToDt.setTime(ToDate);
        clToDt.add(10, 23);
        clToDt.add(13, 59);
        clToDt.add(12, 0);
        if (searcString != null && !searcString.isEmpty() && FromDate != null && ToDate != null) {
            query = query + "(SALE.customerName like ? or SALEACCOUNTDETAILRESOLVER.invoiceNumber like ? or SALE.SellingStaff like ? ) and SALEACCOUNTDETAILRESOLVER.TRANSACTIONDATE between ? And ? ";
            list.addAll(SaleAccountDetailResolverDataList.selectDailySaleByAcct(query + completeQry, new ParameterValue[]{new ParameterValue("customerName", JDBCType.VARCHAR, searcString), new ParameterValue("invoiceNumber", JDBCType.VARCHAR, searcString), new ParameterValue("SellingStaff", JDBCType.VARCHAR, searcString), new ParameterValue("ParamFromDate", JDBCType.TIMESTAMP, new Timestamp(clFromDt.getTime().getTime())), new ParameterValue("ParamToDate", JDBCType.TIMESTAMP, new Timestamp(clToDt.getTime().getTime()))}, app.da));
        } else if ((searcString == null || searcString.isEmpty()) && FromDate != null && ToDate != null) {
            query = query + " SALEACCOUNTDETAILRESOLVER.TRANSACTIONDATE between   " + clFromDt.getTime().getTime() + " And " + clToDt.getTime().getTime();
            list.addAll(SaleAccountDetailResolverDataList.selectDailySaleByAcct(query + completeQry, app.da.getEmptyParameterValues(), app.da));
        } else if (!(searcString == null || searcString.isEmpty() || FromDate != null && ToDate != null)) {
            query = query + "(SALE.customerName like ? or SALEACCOUNTDETAILRESOLVER.invoiceNumber like ? or SALE.SellingStaff like ? ) ";
            list.addAll(SaleAccountDetailResolverDataList.selectDailySaleByAcct(query + completeQry, new ParameterValue[]{new ParameterValue("customerName", JDBCType.VARCHAR, searcString), new ParameterValue("invoiceNumber", JDBCType.VARCHAR, searcString), new ParameterValue("SellingStaff", JDBCType.VARCHAR, searcString)}, app.da));
        }
        int i = 0;
        this.saleList.clear();
        for (SaleAccountDetailResolver sale : list) {
            dataSource.add(null, "", String.valueOf(sale.getInvoiceNumber()), sale.CustomerCode, sale.CustomerName, sale.StoreName, sale.FullAccountDetail, new BigDecimal(sale.getAmountPaid()), JRViewerFxController.dateAlone(sale.getTransactionDate()), Integer.toString(++i), clFromDt.getTime(), clToDt.getTime(), "", sale.sellingStaff, sale.getAccType(), sale.getAccNumber(), sale.saleChannel);
        }
        return dataSource;
    }

    public static JRDataSource createDailySaleByAccountDataSourceAudit(ObservableList<Sale> sales, String StoreName) {
        JRDailySaleBYAccountDataSource dataSource = new JRDailySaleBYAccountDataSource();
        int i = 0;
        for (Sale sale : sales) {
            sale.setTotalAmount(0.0);
            sale.getSaleItemsList().forEach(si -> sale.setTotalAmount(sale.getTotalAmount() + (double)si.getTotalQty() * si.getVariablePrice()));
            for (SaleAccountDetailResolver resolver : sale.getSaleAccountDetailResolvers()) {
                resolver.FullAccountDetail = resolver.getAccType() + " - " + resolver.getAccNumber();
                dataSource.add(null, "", String.valueOf(sale.getInvoiceNumber()), sale.getCustomerName(), sale.getd365CustomerNo(), StoreName, resolver.FullAccountDetail, new BigDecimal(sale.getTotalAmount()), sale.getTransactionDate(), Integer.toString(++i), FromDt, ToDt, sale.getSaleStatus(), sale.getSaleStaffResponsible(), sale.getSalesChannel(), resolver.getAccNumber(), sale.getSaleId());
            }
        }
        return dataSource;
    }

    private JRDataSource createDailySalesSummaryDataSource(ObservableList<Sale> saleList, String storeName) {
        JRDailySalesSummaryDataSource dataSource = new JRDailySalesSummaryDataSource();
        int i = 0;
        this.saleList.clear();
        List<Object> channels = new ArrayList();
        try {
            channels = StockItemList.selectAllChannels(this.app.da);
        }
        catch (SQLException ex) {
            Logger.getLogger(ReportPane.class.getName()).log(Level.SEVERE, null, ex);
        }
        for (Sale sale : saleList) {
            for (SaleItem saleItem : sale.getSaleItemsList()) {
                double d = saleItem.getVariablePrice() * (double)Math.round(saleItem.getTotalQty());
                BigDecimal bigie = new BigDecimal(d);
                NameValueObject channel = channels.stream().filter(c -> c.getKey().equals(saleItem.channel)).findAny().orElse(null);
                sale.salesType = channel == null ? saleItem.channel : channel.getData();
                dataSource.add(null, "", sale.getHdInvoiceNo(), sale.getCustomerName(), storeName, sale.getSaleStaffResponsible(), saleItem.getItemCode(), saleItem.getItemName(), Math.round(saleItem.getTotalQty()), new BigDecimal(saleItem.getVariablePrice()), Integer.toString(++i), sale.salesType, "", bigie, sale.getTransactionDate(), saleItem.getSerialString(), sale.getSaleId());
            }
            this.saleList.add((Object)sale);
        }
        return dataSource;
    }

    private JRDataSource createDailySalesSummaryDataSource() {
        JRDailySalesSummaryDataSource dataSource = new JRDailySalesSummaryDataSource();
        StoreDataList storeDataList = new StoreDataList(this.app.da);
        storeDataList.selectAll(this.app.da);
        SaleList saleList = Sale.SearchSaleItemForSaleReturn("", Date.valueOf(LocalDate.now()), Date.valueOf(LocalDate.now()), this.app.da, this.app.currentUser);
        int i = 0;
        this.saleList.clear();
        for (Sale sale : saleList.getOriginalList()) {
            for (SaleItem saleItem : sale.getSaleItemsList()) {
                ++i;
                double d = saleItem.getVariablePrice() * (double)Math.round(saleItem.getQuantity() - saleItem.getReturnQty());
                BigDecimal bigie = new BigDecimal(d);
                java.util.Date newDate = new java.util.Date();
                saleItem.loadSerials();
                String storeCode = sale.getStoreCode().isEmpty() ? this.app.currentUser.getParentCompany().getStoreCode() : sale.getStoreCode();
                sale.storeName = storeDataList.getOriginalList().stream().filter(x -> x.getCode().trim().equals(storeCode.trim())).findAny().get().getName();
                dataSource.add(null, "", sale.getHdInvoiceNo(), sale.getCustomerName(), sale.storeName, sale.getStaff().getFullName(), saleItem.getItemCode(), saleItem.getItemName(), Math.round(saleItem.getQuantity() - saleItem.getReturnQty()), new BigDecimal(saleItem.getVariablePrice()), Integer.toString(i), sale.getB2B() == true ? "B2B" : "Retail", "", bigie, sale.getTransactionDate(), saleItem.getSerialString(), sale.getSaleId());
            }
            this.saleList.add((Object)sale);
        }
        return dataSource;
    }

    public JRDataSource createDailySalesSummaryDataSource(Santa app, String s, Date from, Date to) {
        JRDailySalesSummaryDataSource dataSource = new JRDailySalesSummaryDataSource();
        SaleList saleList = Sale.SearchSaleItemForSaleReturn(s, from, to, app.da, app.currentUser);
        int i = 0;
        this.saleList.clear();
        for (Sale sale : saleList.getOriginalList()) {
            sale.getSaleItemsList().forEach(si -> {
                this.tot = this.tot + si.getVariablePrice() * (double)si.getQuantity();
                if (si.getReturnQty() > 0.0f) {
                    this.tot = this.tot + (double)(si.getQuantity() - si.getReturnQty()) * si.getVariablePrice();
                }
            });
            for (SaleItem saleItem : sale.getSaleItemsList()) {
                double d = saleItem.getVariablePrice() * (double)Math.round(saleItem.getTotalQty());
                BigDecimal bigie = new BigDecimal(d);
                java.util.Date newDate = new java.util.Date();
                saleItem.loadSerials();
                dataSource.add(null, "", String.valueOf(sale.getInvoiceNumber()), sale.getCustomerName(), app.currentUser.getParentCompany().getStoreName(), sale.getStaff().getFullName(), saleItem.getItemCode(), saleItem.getItemName(), Math.round(saleItem.getTotalQty()), new BigDecimal(saleItem.getVariablePrice()), Integer.toString(++i), sale.getB2B() == true ? "B2B" : "Retail", "", bigie, newDate.compareTo(new java.util.Date(sale.getNewDate().getTime())) == 0 ? new java.util.Date() : new java.util.Date(sale.getNewDate().getTime()), saleItem.getSerialString(), sale.getSaleId());
            }
            this.saleList.add((Object)sale);
        }
        return dataSource;
    }

    public JRDataSource createDailySaleDataSource(Santa app, String s, Date from, Date to) {
        JRDailySaleDataSource dataSource = new JRDailySaleDataSource();
        SaleList saleList = Sale.SearchSaleItemForSaleReturn(s, from, to, app.da, app.currentUser);
        int i = 0;
        this.saleList.clear();
        for (Sale sale : saleList.getOriginalList()) {
            ++i;
            this.tot = 0.0;
            sale.getSaleItemsList().forEach(si -> {
                this.tot = this.tot + si.getVariablePrice() * (double)si.getQuantity();
                if (si.getReturnQty() > 0.0f) {
                    this.tot = this.tot + (double)(si.getQuantity() - si.getReturnQty()) * si.getVariablePrice();
                }
            });
            if (sale.getCreditDescription().equals("Easy Buy")) {
                this.tot = 0.0;
                sale.getPayments().getOriginalList().forEach(pay -> {
                    this.tot = this.tot + pay.getAmountPaid();
                });
            }
            dataSource.add(null, "", "00" + String.valueOf(sale.getInvoiceNumber()), sale.getd365CustomerNo(), sale.getCustomerName(), app.mainpage.currentUser.getParentCompany().getStoreName(), sale.getStaff().getFullName(), new BigDecimal(this.tot), JRViewerFxController.dateAlone(sale.getNewDate()), Integer.toString(i));
            this.saleList.add((Object)sale);
        }
        return dataSource;
    }

    private JRDataSource createStockListDataSource() {
        JRStockListDataSource dataSource = new JRStockListDataSource();
        StockItemList stockList = new StockItemList(this.app.da);
        stockList.selectAll("Select * From StockItem order by name", this.da.getEmptyParameterValues());
        Comparator<StockItem> comparatorMyObject_Name = new Comparator<StockItem>(){

            @Override
            public int compare(StockItem o1, StockItem o2) {
                return o1.getType().compareToIgnoreCase(o2.getType());
            }
        };
        Collections.sort(stockList.getOriginalList(), comparatorMyObject_Name);
        int i = 0;
        for (StockItem stck : stockList.getOriginalList()) {
            stck.setSn(++i);
            this.stockItemList.add((Object)stck);
            dataSource.add(null, "", stck.getItemCode(), stck.getMaker(), this.currentUser.getParentCompany().getStoreName(), stck.getName(), Math.round(stck.getQuantity()), Math.round(stck.getCnsQty()), Math.round(stck.getDspQty()), new BigDecimal(stck.getSellingPrice()), new BigDecimal(stck.getPriceB2B()), Integer.toString(i));
        }
        return dataSource;
    }

    private JRDataSource createStockListDataSource(ObservableList<StockItem> stockList, String storeName) {
        JRStockListDataSource dataSource = new JRStockListDataSource();
        Comparator<StockItem> comparatorMyObject_Name = new Comparator<StockItem>(){

            @Override
            public int compare(StockItem o1, StockItem o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        };
        Collections.sort(stockList, comparatorMyObject_Name);
        int i = 0;
        for (StockItem stck : stockList) {
            dataSource.add(null, "", stck.getItemCode(), stck.getMaker(), storeName, stck.getName(), Math.round(stck.getQuantity()), Math.round(stck.getCnsQty()), Math.round(stck.getDspQty()), new BigDecimal(stck.getSellingPrice()), new BigDecimal(stck.getPriceB2B()), Integer.toString(++i));
        }
        return dataSource;
    }

    private JRDataSource createInvoiceDataSource() {
        JRInvoiceDataSource dataSource = new JRInvoiceDataSource();
        for (SaleItem si : this.sale.getSaleItemsList()) {
            this.qty = 0;
            if (dataSource.getInvoiceItems().stream().filter(val -> val.itemCode.equals(si.getItemCode())).count() != 0L) continue;
            this.sale.getSaleItemsList().forEach(val -> {
                if (val.getItemCode().equals(si.getItemCode())) {
                    this.qty += val.getTotalQty();
                }
            });
            double d = si.getSellingPrice() * (double)Math.round(this.qty);
            BigDecimal bigie = new BigDecimal(d);
            String itemCode = si.getItemCode();
            Object paymentHtml = "<div><b>Payment Information</b></div><hr/>";
            if (this.sale.getCreditToken().isEmpty()) {
                if (this.sale.getAccountDetailList().size() > 0) {
                    for (DbEntity accountDetail : this.sale.getAccountDetailList()) {
                        paymentHtml = (String)paymentHtml + "<div><b><span>" + ((AccountDetail)accountDetail).getAccType() + ":</b></span> <span>" + General.toNaira() + General.formatDecimalToMoneyString(((AccountDetail)accountDetail).getAmount()) + "</span></div>";
                    }
                } else if (this.sale.getPayments().getOriginalList().size() > 0) {
                    for (DbEntity accountDetail : this.sale.getPayments().getOriginalList()) {
                        paymentHtml = (String)paymentHtml + "<div><span><b>" + ((SaleAccountDetailResolver)accountDetail).getAccType() + ":</b></span> <span>" + General.toNaira() + General.formatDecimalToMoneyString(((SaleAccountDetailResolver)accountDetail).getAmountPaid()) + "</span></div>";
                    }
                }
                if (this.sale.getPromoVoucherAmt() > 0.0) {
                    paymentHtml = (String)paymentHtml + "<div><b><span>Discount:</b></span> <span>" + General.toNaira() + General.formatDecimalToMoneyString(this.sale.getPromoVoucherAmt()) + "</span></div>";
                }
            } else {
                paymentHtml = (String)paymentHtml + "<div><b><span>" + this.sale.getCreditDescription() + ":Credit Sale</b></span></div>";
                if (this.sale.getCreditDescription().equals("Easy Buy")) {
                    this.amountPaid = 0.0;
                    this.sale.getPayments().getOriginalList().forEach(res -> {
                        this.amountPaid = this.amountPaid + res.getAmountPaid();
                    });
                    paymentHtml = (String)paymentHtml + "<div><b><span> Cash paid:" + General.toNaira() + General.formatDecimalToMoneyString(this.amountPaid) + "</b></span></div>";
                }
            }
            dataSource.add(null, "", this.sale.getHdInvoiceNo(), this.sale.getd365CustomerNo(), this.sale.getCustomerName(), this.sale.storeName, this.currentUser.getFullName(), itemCode, si.getItemName(), this.qty, bigie, new BigDecimal(si.getSellingPrice()), this.sale.Reprint, this.sale.getTransactionDate(), (String)paymentHtml, si.getSerialString(), this.currentUser.getParentCompany().getAddress(), this.currentUser.getParentCompany().getCostCenter(), this.currentUser.getParentCompany().getLocationCode());
        }
        return dataSource;
    }

    private JRDataSource createReleaseTransferDataSource(Request request) {
        String toStore;
        String fromStore;
        JRReleaseTransferDataSource dataSource = new JRReleaseTransferDataSource();
        if (request.getRequestType().equals(RequestType.Inbound.name())) {
            fromStore = request.getToStoreName();
            toStore = request.getFromStoreName();
        } else {
            fromStore = request.getFromStoreName();
            toStore = request.getToStoreName();
        }
        request.getItems().forEach(it -> {
            this.totQty = it.getReleasedQuantity();
        });
        for (RequestItem si : request.getItems()) {
            this.qty = 0;
            java.util.Date newDate = new java.util.Date();
            if (si.getRequestItemBins().isEmpty()) {
                if (si.getReleasedQuantity() <= 0) continue;
                dataSource.add(null, request.getTransferId(), "", request.getCode(), this.currentUser.getFullName(), si.getItemCode(), si.getItemCode(), fromStore, toStore, si.getItemName(), si.getReleasedQuantity(), request.getStatus(), newDate, si.getSerialString(), request.getIsPrinted() != false ? "Duplicate" : "Original", "", Float.valueOf(si.getNetWeight()), request.storeToAddress, request.storeFromAddress, this.totQty);
                continue;
            }
            si.getRequestItemBins().forEach(va -> {
                if (va.getQuantity() > 0) {
                    dataSource.add(null, request.getTransferId(), "", request.getCode(), this.currentUser.getFullName(), si.getItemCode(), si.getItemCode(), fromStore, toStore, si.getItemName(), va.getQuantity(), request.getStatus(), newDate, si.getSerialString(), request.getIsPrinted() != false ? "Duplicate" : "Original", va.getCode(), Float.valueOf(si.getNetWeight()), request.storeToAddress, request.storeFromAddress, this.totQty);
                }
            });
        }
        return dataSource;
    }

    private JRDataSource createReleaseTransferDataSource(ObservableList<Request> requests) {
        JRReleaseTransferDataSource dataSource = new JRReleaseTransferDataSource();
        requests.forEach(v -> {
            this.totQty = 0;
            v.getItems().forEach(it -> {
                this.totQty = it.getReleasedQuantity();
            });
            v.getItems().forEach(si -> {
                this.qty = 0;
                java.util.Date newDate = new java.util.Date();
                dataSource.add(null, "", v.getCode(), this.currentUser.getFullName(), si.getItemCode(), si.getItemCode(), v.getToStoreName(), v.getFromStoreName(), si.getItemName(), si.getQuantity(), v.getStatus(), newDate, v.getReturningUser(), v.getRequestType(), si.getSerialString(), v.getIsPrinted() != false ? "Duplicate" : "Original", "", Float.valueOf(si.getNetWeight()), v.storeToAddress, v.storeFromAddress, this.totQty);
            });
        });
        return dataSource;
    }

    private JRDataSource createReleasePODataSource(PurchaseOrder v) {
        JRReleasePODataSource dataSource = new JRReleasePODataSource();
        this.totalAmt = 0.0;
        this.totTax = 0.0;
        this.txPercentage = 0.0;
        v.getItems().forEach(si -> {
            this.totTax += si.getTax();
            this.totalAmt += si.getLineTotal();
        });
        this.txPercentage = this.totTax > 0.0 ? this.totTax * 100.0 / this.totalAmt : 0.0;
        v.getItems().forEach(si -> {
            this.qty = 0;
            java.util.Date newDate = new java.util.Date();
            dataSource.add(null, v.getCode(), si.getPartNumber(), si.getItemCode(), si.getItemName(), v.getSapCode(), v.getSupplierName(), v.getSupplierCode(), new BigDecimal(si.getPrice()), new BigDecimal(si.getLineTotal()), new BigDecimal(si.getTax()), new BigDecimal(this.txPercentage), si.getQuantity() == 0 ? 1 : si.getQuantity(), v.getStatus(), newDate, v.dateApproved, v.getDueDate(), v.remark, v.getPaymentTerm(), v.approvingUser, v.getPurchaseType(), (String)v.OrderNoProperty().get(), v.getSapCode(), "", v.getCurrency());
        });
        return dataSource;
    }

    private JRDataSource createCreditSalesDataSource(ObservableList<Sale> v) {
        JRCreditDataSource dataSource = new JRCreditDataSource();
        for (int i = 0; i < v.size(); ++i) {
            Sale si = (Sale)v.get(i);
            dataSource.add(null, "", si.getHdInvoiceNo(), si.getd365CustomerNo(), si.getCustomerName(), si.getStoreCode(), "", new BigDecimal(si.getAmountPaid()), si.getNewDate(), Integer.toString(i), si.getPaymentTerm(), si.getSaleId());
        }
        return dataSource;
    }

    private JRDataSource createReleasePODataSource(PurchaseDeliveryNote v) {
        JRReleasePODataSource dataSource = new JRReleasePODataSource();
        this.totalAmt = 0.0;
        this.totTax = 0.0;
        this.txPercentage = 0.0;
        v.getItems().forEach(si -> {
            this.totTax += si.getTax();
            this.totalAmt += si.getLineTotal();
        });
        this.txPercentage = this.totTax > 0.0 ? this.totTax * 100.0 / this.totalAmt : 0.0;
        v.getItems().forEach(si -> {
            this.qty = 0;
            java.util.Date newDate = new java.util.Date();
            dataSource.add(null, v.parentPO.getCode(), si.getPartNumber(), si.getItemCode(), si.getItemName(), v.getSapCode(), v.getSupplierName(), v.getSupplierCode(), new BigDecimal(si.getPrice()), new BigDecimal(si.getLineTotal()), new BigDecimal(si.getTax()), new BigDecimal(this.txPercentage), si.getQuantity() == 0 ? 1 : si.getQuantity(), v.getStatus(), newDate, v.getDateCreated(), v.getDueDate(), v.parentPO.remark, v.parentPO.getPaymentTerm(), (String)v.createdByProperty().get(), v.parentPO.getPurchaseType(), (String)v.parentPO.OrderNoProperty().get(), v.parentPO.getSapCode(), "", v.currency);
        });
        return dataSource;
    }

    private JRDataSource createReleasePODataSource(ObservableList<PurchaseOrder> pos) {
        JRReleasePODataSource dataSource = new JRReleasePODataSource();
        pos.forEach(v -> v.getItems().forEach(si -> {
            this.qty = 0;
            java.util.Date newDate = new java.util.Date();
            dataSource.add(null, v.getCode(), si.getPartNumber(), si.getItemCode(), si.getItemName(), v.getSapCode(), v.getSupplierName(), v.getSupplierCode(), new BigDecimal(si.getPrice()), new BigDecimal(si.getLineTotal()), new BigDecimal(si.getTax()), new BigDecimal(this.txPercentage), si.getQuantity() == 0 ? 1 : si.getQuantity(), v.getStatus(), newDate, v.dateApproved, v.getDueDate(), v.remark, v.getPaymentTerm(), v.approvingUser, v.getPurchaseType(), (String)v.OrderNoProperty().get(), v.getSapCode(), "", v.getCurrency());
        }));
        return dataSource;
    }

    private JRDataSource createStockBarCodePrint(ObservableList<StockItemDataPrint> pos) {
        JRStockItemBarCodeDataSource dataSource = new JRStockItemBarCodeDataSource();
        pos.forEach(v -> dataSource.add(v.getItemCode(), v.getBarCode(), v.getItemName(), v.getImei().isEmpty() ? v.getInternalNo() : v.getImei()));
        return dataSource;
    }
}

