/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXDatePicker;
import com.jfoenix.controls.JFXDialog;
import com.jfoenix.controls.JFXProgressBar;
import com.jfoenix.controls.JFXTextField;
import com.xputertechnologies.santa.NameValueObject;
import com.xputertechnologies.santa.NameValueObjectType;
import com.xputertechnologies.santa.POApprovalHistory;
import com.xputertechnologies.santa.PurchaseDeliveryNote;
import com.xputertechnologies.santa.PurchaseLineItem;
import com.xputertechnologies.santa.PurchaseOrder;
import com.xputertechnologies.santa.list.PurchaseOrderDataList;
import com.xputertechnologies.santa.list.StockItemList;
import com.xputertechnologies.santa.list.StoreDataList;
import com.xputertechnologies.santa.ui.General;
import com.xputertechnologies.santa.ui.IPurchasePane;
import com.xputertechnologies.santa.ui.NotificationType;
import com.xputertechnologies.santa.ui.PurchaseItemView;
import com.xputertechnologies.santa.ui.PurchaseOrderPane;
import com.xputertechnologies.santa.ui.PurchaseOrderPaneViewerPane;
import com.xputertechnologies.santa.ui.ReportPane;
import com.xputertechnologies.santa.ui.Santa;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URI;
import java.sql.Date;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.util.Callback;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.controlsfx.glyphfont.FontAwesome;
import org.json.JSONArray;
import org.json.JSONObject;

public class PurchaseOrderPaneViewerSummary
extends IPurchasePane {
    @FXML
    private StackPane stackPane;
    @FXML
    private TableView<PurchaseOrder> table;
    @FXML
    private TableColumn colSn;
    @FXML
    private TableColumn colPOCode;
    @FXML
    private TableColumn colOrderNum;
    @FXML
    private TableColumn colUser;
    @FXML
    private TableColumn colDateCreated;
    @FXML
    private TableColumn colDueDate;
    @FXML
    private TableColumn colAmount;
    @FXML
    private TableColumn colTaxAmount;
    @FXML
    private TableColumn colTotalAmount;
    @FXML
    private TableColumn colCurrency;
    @FXML
    private TableColumn colVendor;
    @FXML
    private TableColumn colPayTerm;
    @FXML
    private TableColumn colView;
    @FXML
    private TableColumn colPrint;
    @FXML
    private TableColumn colSAPNo;
    @FXML
    private JFXTextField tbSearch;
    @FXML
    private JFXDatePicker from;
    @FXML
    private JFXDatePicker to;
    @FXML
    private JFXButton btnSearch;
    @FXML
    private JFXTextField txtFilter;
    @FXML
    private JFXButton btnReload;
    VBox progressContainer = null;
    PurchaseOrderDataList purchaseOrderDataList;
    PurchaseOrderDataList purchaseOrderDataListAll = null;
    StoreDataList storeDataList;
    int counter = 0;

    public PurchaseOrderPaneViewerSummary(Santa app) {
        super("PurchaseOrderPaneViewerSummary.fxml", app);
        this.title = "Purchase Order View Summary";
        this.readOnly = true;
        if (this.santa.Products.isEmpty()) {
            try {
                this.santa.Products.addAll(StockItemList.selectAllYuProducts(this.da));
            }
            catch (SQLException ex) {
                Logger.getLogger(PurchaseOrderPane.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.from.setValue((Object)LocalDate.now().minusDays(1L));
        this.to.setValue((Object)LocalDate.now());
        this.purchaseOrderDataList = new PurchaseOrderDataList(this.da);
        this.purchaseOrderDataListAll = new PurchaseOrderDataList(this.da);
        this.colSn.setCellValueFactory((Callback)new PropertyValueFactory("sn"));
        this.colPOCode.setCellValueFactory((Callback)new PropertyValueFactory("code"));
        this.colOrderNum.setCellValueFactory((Callback)new PropertyValueFactory("OrderNo"));
        this.colUser.setCellValueFactory((Callback)new PropertyValueFactory("createdBy"));
        this.colDateCreated.setCellValueFactory((Callback)new PropertyValueFactory("dateCreatedString"));
        this.colDueDate.setCellValueFactory((Callback)new PropertyValueFactory("dueDateString"));
        this.colAmount.setCellValueFactory((Callback)new PropertyValueFactory("dockTotal"));
        this.colTaxAmount.setCellValueFactory((Callback)new PropertyValueFactory("tax"));
        this.colTotalAmount.setCellValueFactory((Callback)new PropertyValueFactory("totalAmount"));
        this.colCurrency.setCellValueFactory((Callback)new PropertyValueFactory("currency"));
        this.colVendor.setCellValueFactory((Callback)new PropertyValueFactory("supplierName"));
        this.colPayTerm.setCellValueFactory((Callback)new PropertyValueFactory("paymentTerm"));
        this.colSAPNo.setCellValueFactory((Callback)new PropertyValueFactory("sapCode"));
        this.colTotalAmount.setCellFactory(col -> new TableCell<PurchaseOrder, Number>(){

            public void updateItem(Number price, boolean empty) {
                super.updateItem((Object)price, empty);
                if (empty) {
                    this.setText(null);
                } else if (price != null) {
                    this.setText(General.formatDecimalToMoneyString(price.doubleValue()));
                }
            }
        });
        this.colAmount.setCellFactory(col -> new TableCell<PurchaseOrder, Number>(){

            public void updateItem(Number price, boolean empty) {
                super.updateItem((Object)price, empty);
                if (empty) {
                    this.setText(null);
                } else if (price != null) {
                    this.setText(General.formatDecimalToMoneyString(price.doubleValue()));
                }
            }
        });
        this.colTaxAmount.setCellFactory(col -> new TableCell<PurchaseOrder, Number>(){

            public void updateItem(Number price, boolean empty) {
                super.updateItem((Object)price, empty);
                if (empty) {
                    this.setText(null);
                } else if (price != null) {
                    this.setText(General.formatDecimalToMoneyString(price.doubleValue()));
                }
            }
        });
        this.colPrint.setCellValueFactory((Callback)new PropertyValueFactory("DUMMY"));
        Callback<TableColumn<PurchaseOrder, String>, TableCell<PurchaseOrder, String>> cellFactoryPrintRelease = new Callback<TableColumn<PurchaseOrder, String>, TableCell<PurchaseOrder, String>>(){

            public TableCell call(TableColumn<PurchaseOrder, String> param) {
                TableCell<PurchaseOrder, String> cell = new TableCell<PurchaseOrder, String>(){
                    final Button btn = new Button("Print");

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                            this.setText(null);
                        } else {
                            this.btn.setStyle("-fx-background-color: #11982A;");
                            PurchaseOrder po = (PurchaseOrder)this.getTableView().getItems().get(this.getIndex());
                            if (po.getStatus().equals("PO Raised") && ((String)po.syncErrorProperty().get()).isEmpty()) {
                                this.btn.setOnAction(c -> {
                                    try {
                                        JFXDialog dialog = new JFXDialog();
                                        dialog.setDialogContainer(PurchaseOrderPaneViewerSummary.this.stackPane);
                                        dialog.setContent((Region)new ReportPane(PurchaseOrderPaneViewerSummary.this.santa, dialog, po));
                                        dialog.setTransitionType(JFXDialog.DialogTransition.CENTER);
                                        dialog.setOverlayClose(false);
                                        dialog.show();
                                    }
                                    catch (Exception ex) {
                                        Logger.getLogger(PurchaseOrderPaneViewerPane.class.getName()).log(Level.SEVERE, null, ex);
                                    }
                                });
                            } else {
                                this.btn.setVisible(false);
                            }
                            this.setGraphic((Node)this.btn);
                            this.setAlignment(Pos.CENTER);
                            this.setText(null);
                        }
                    }
                };
                return cell;
            }
        };
        this.colPrint.setCellFactory((Callback)cellFactoryPrintRelease);
        this.colView.setCellValueFactory((Callback)new PropertyValueFactory("DUMMY"));
        Callback<TableColumn<PurchaseOrder, String>, TableCell<PurchaseOrder, String>> cellView = new Callback<TableColumn<PurchaseOrder, String>, TableCell<PurchaseOrder, String>>(){

            public TableCell call(TableColumn<PurchaseOrder, String> param) {
                TableCell<PurchaseOrder, String> cell = new TableCell<PurchaseOrder, String>(){
                    final Button btn = new Button("Items");

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                            this.setText(null);
                        } else {
                            this.btn.setStyle("-fx-background-color: #117598;");
                            this.btn.setOnAction(c -> {
                                try {
                                    PurchaseOrder po;
                                    PurchaseOrderPaneViewerSummary.this.dialog = new JFXDialog();
                                    PurchaseOrderPaneViewerSummary.this.dialog.setDialogContainer(PurchaseOrderPaneViewerSummary.this.stackPane);
                                    PurchaseOrderPaneViewerSummary.this.purchaseOrder = po = (PurchaseOrder)this.getTableView().getItems().get(this.getIndex());
                                    PurchaseOrderPaneViewerSummary.this.dialog.setContent((Region)new PurchaseItemView(PurchaseOrderPaneViewerSummary.this));
                                    PurchaseOrderPaneViewerSummary.this.dialog.setTransitionType(JFXDialog.DialogTransition.CENTER);
                                    PurchaseOrderPaneViewerSummary.this.dialog.setOverlayClose(false);
                                    PurchaseOrderPaneViewerSummary.this.dialog.show();
                                }
                                catch (Exception ex) {
                                    Logger.getLogger(PurchaseOrderPaneViewerPane.class.getName()).log(Level.SEVERE, null, ex);
                                }
                            });
                            this.setGraphic((Node)this.btn);
                            this.setAlignment(Pos.CENTER);
                            this.setText(null);
                        }
                    }
                };
                return cell;
            }
        };
        this.colView.setCellFactory((Callback)cellView);
        this.btnReload.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.REFRESH).color(Color.WHITE).size(15.0));
        this.btnReload.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                PurchaseOrderPaneViewerSummary.this.loadMine();
            }
        });
        this.btnSearch.setOnAction(v -> this.loadMine());
        this.loadMine();
    }

    void loadMine() {
        JFXProgressBar progressIndicator = new JFXProgressBar();
        progressIndicator.setProgress(-1.0);
        final VBox box = new VBox(new Node[]{progressIndicator});
        box.setAlignment(Pos.CENTER);
        this.progressContainer = box;
        this.stackPane.getChildren().add((Object)box);
        Service service = new Service(){

            protected Task createTask() {
                return new Task(){

                    protected Object call() throws Exception {
                        try {
                            String url = PurchaseOrderPaneViewerSummary.this.santa.syncSetting.getBEURL() + "RPurchaseOrder/GetPurchaseRequests";
                            HttpGet httpGet = new HttpGet(url);
                            RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectTimeout(Santa.connectionTimeOut).setSocketTimeout(Santa.socketTimeOut).setConnectionRequestTimeout(Santa.socketTimeOut).build();
                            httpGet.setHeader("Content-type", "application/json");
                            ArrayList<BasicNameValuePair> listParam = new ArrayList<BasicNameValuePair>();
                            BasicNameValuePair param1 = new BasicNameValuePair("searchString", PurchaseOrderPaneViewerSummary.this.tbSearch.getText());
                            listParam.add(param1);
                            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                            LocalDateTime Strtdatetime = LocalDate.of(((LocalDate)PurchaseOrderPaneViewerSummary.this.from.getValue()).getYear(), ((LocalDate)PurchaseOrderPaneViewerSummary.this.from.getValue()).getMonth().getValue(), ((LocalDate)PurchaseOrderPaneViewerSummary.this.from.getValue()).getDayOfMonth()).atTime(0, 0, 0);
                            LocalDateTime Enddatetime = LocalDate.of(((LocalDate)PurchaseOrderPaneViewerSummary.this.to.getValue()).getYear(), ((LocalDate)PurchaseOrderPaneViewerSummary.this.to.getValue()).getMonth().getValue(), ((LocalDate)PurchaseOrderPaneViewerSummary.this.to.getValue()).getDayOfMonth()).atTime(23, 59, 0);
                            String fromDt = format.format(Date.from(Strtdatetime.atZone(ZoneId.systemDefault()).toInstant()));
                            String toDt = format.format(Date.from(Enddatetime.atZone(ZoneId.systemDefault()).toInstant()));
                            BasicNameValuePair param2 = new BasicNameValuePair("startDate", fromDt);
                            listParam.add(param2);
                            BasicNameValuePair param3 = new BasicNameValuePair("endDate", toDt);
                            listParam.add(param3);
                            CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(defaultRequestConfig).build();
                            URI uri = new URIBuilder(httpGet.getURI()).addParameters(listParam).build();
                            httpGet.setURI(uri);
                            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
                            if (response.getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 204) {
                                String output;
                                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                StringBuilder stringBuilder = new StringBuilder();
                                System.out.println("Output from Server .... \n");
                                while ((output = br.readLine()) != null) {
                                    System.out.println(output);
                                    stringBuilder.append(output + "\n");
                                }
                                br.close();
                                httpClient.getConnectionManager().shutdown();
                                String result = stringBuilder.toString();
                                JSONArray ra = new JSONArray(result);
                                PurchaseOrderDataList podl = new PurchaseOrderDataList(PurchaseOrderPaneViewerSummary.this.da);
                                if (ra.length() > 0) {
                                    for (int i = 0; i < ra.length(); ++i) {
                                        JSONObject jSONObject = ra.getJSONObject(i);
                                        PurchaseOrder po = new PurchaseOrder(PurchaseOrderPaneViewerSummary.this.da);
                                        po.DocEntry = jSONObject.isNull("DocEntry") ? 0 : jSONObject.getInt("DocEntry");
                                        po.DockNum = jSONObject.isNull("DocNum") ? 0 : jSONObject.getInt("DocNum");
                                        po.CurrentEditStage = jSONObject.isNull("CurrentEditStage") ? "" : jSONObject.getString("CurrentEditStage");
                                        po.CurrentCloseStage = jSONObject.isNull("CurrentCloseStage") ? "" : jSONObject.getString("CurrentCloseStage");
                                        po.CurrentEditStatus = jSONObject.isNull("CurrentEditStatus") ? "" : jSONObject.getString("CurrentEditStatus");
                                        po.CurrentCloseStatus = jSONObject.isNull("CurrentCloseStatus") ? "" : jSONObject.getString("CurrentCloseStatus");
                                        System.out.println(po.getCode() + " Edit Stage is:" + po.CurrentEditStage);
                                        po.BaseDocumentNum = jSONObject.isNull("BaseDocumentNum") ? 0 : jSONObject.getInt("BaseDocumentNum");
                                        po.setSapCode(jSONObject.isNull("SAPCode") ? "" : jSONObject.getString("SAPCode"));
                                        po.approvingUser = jSONObject.isNull("ApprovingUser") ? "" : jSONObject.getString("ApprovingUser");
                                        po.remark = jSONObject.isNull("Comment") ? "" : jSONObject.getString("Comment");
                                        po.dockTotalProperty().set(jSONObject.isNull("DocTotal") ? 0.0 : jSONObject.getDouble("DocTotal"));
                                        System.out.println(jSONObject.getString("Code") + " " + Double.toString(jSONObject.getDouble("DocTotal")));
                                        po.setCode(jSONObject.isNull("Code") ? "" : jSONObject.getString("Code"));
                                        po.setSupplierCode(jSONObject.isNull("VendorId") ? "" : jSONObject.getString("VendorId"));
                                        po.setSupplierName(jSONObject.isNull("VendorName") ? "" : jSONObject.getString("VendorName"));
                                        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'");
                                        java.util.Date dt = df.parse(jSONObject.getString("DocDate"));
                                        po.setDateCreated(dt);
                                        po.dateCreatedStringProperty().set((Object)new SimpleDateFormat("yyyy-MM-dd").format(dt));
                                        dt = df.parse(jSONObject.getString("DeliveryDate"));
                                        po.setDueDate(new java.util.Date(dt.getTime()));
                                        po.dueDateStringProperty().set((Object)new SimpleDateFormat("yyyy-MM-dd").format(dt));
                                        po.setCurrency(jSONObject.isNull("Currency") ? "" : jSONObject.getString("Currency"));
                                        po.setStatus(jSONObject.isNull("Status") ? "" : jSONObject.getString("Status"));
                                        po.createCommentProperty().set((Object)(jSONObject.isNull("Comment") ? "" : jSONObject.getString("Comment")));
                                        po.createdByProperty().set((Object)(jSONObject.isNull("PurchasingOfficer") ? "" : jSONObject.getString("PurchasingOfficer")));
                                        po.setParentTemplateDescription(jSONObject.isNull("ApprovalTemplateDescription") ? "" : jSONObject.getString("ApprovalTemplateDescription"));
                                        po.setPurchaseType(jSONObject.isNull("PurchaseType") ? "" : jSONObject.getString("PurchaseType"));
                                        po.syncErrorProperty().set((Object)(jSONObject.isNull("SyncError") ? "" : jSONObject.getString("SyncError")));
                                        po.dateApproved = new java.util.Date(dt.getTime());
                                        ObservableList<NameValueObject> paymentTerms = NameValueObject.select(NameValueObjectType.PaymentTerm.name(), PurchaseOrderPaneViewerSummary.this.da);
                                        if (!jSONObject.isNull("PaymentTerm") && !jSONObject.getString("PaymentTerm").isEmpty()) {
                                            String str = jSONObject.getString("PaymentTerm");
                                            String paymentType = paymentTerms.stream().filter(c -> c.getKey().equals(str)).findAny().get().getData();
                                            po.setPaymentTerm(paymentType);
                                        }
                                        po.OrderNoProperty().set((Object)(jSONObject.isNull("OrderNo") ? "" : jSONObject.getString("OrderNo")));
                                        po.setCurrentStage(jSONObject.isNull("CurrentStage") ? "" : jSONObject.getString("CurrentStage"));
                                        JSONArray lineArray = jSONObject.getJSONArray("LineItems");
                                        for (int j = 0; j < lineArray.length(); ++j) {
                                            JSONObject jsono = lineArray.getJSONObject(j);
                                            PurchaseLineItem purchaseLineItem = new PurchaseLineItem(PurchaseOrderPaneViewerSummary.this.da);
                                            purchaseLineItem.setParentPurchase(po);
                                            purchaseLineItem.setLineNumber(jsono.isNull("LineNumber") ? 0 : jsono.getInt("LineNumber"));
                                            purchaseLineItem.setBaseLineNumber(jsono.isNull("BaseLineNumber") ? 0 : jsono.getInt("BaseLineNumber"));
                                            purchaseLineItem.setItemCode(jsono.isNull("ItemCode") ? "" : jsono.getString("ItemCode"));
                                            purchaseLineItem.setQuantity(jsono.isNull("Qty") ? 0 : jsono.getInt("Qty"));
                                            purchaseLineItem.setOpenQty(jsono.isNull("OpenQty") ? 0 : jsono.getInt("OpenQty"));
                                            purchaseLineItem.setPrice(jsono.isNull("UnitPrice") ? 0.0 : jsono.getDouble("UnitPrice"));
                                            purchaseLineItem.setTax(jsono.isNull("TaxAmount") ? 0.0 : jsono.getDouble("TaxAmount"));
                                            purchaseLineItem.setCostCenter(jsono.isNull("CostCentre") ? "" : jsono.getString("CostCentre"));
                                            purchaseLineItem.setStoreCode(jsono.isNull("StoreCode") ? "" : jsono.getString("StoreCode"));
                                            purchaseLineItem.setTaxCode(jsono.isNull("TaxCode") ? "" : jsono.getString("TaxCode"));
                                            purchaseLineItem.setItemName(jsono.isNull("ItemName") ? "" : jsono.getString("ItemName"));
                                            purchaseLineItem.setCurrency(jsono.isNull("Currency") ? "" : jsono.getString("Currency"));
                                            purchaseLineItem.setCode(jsono.isNull("Code") ? "" : jsono.getString("Code"));
                                            purchaseLineItem.setIsDeleted(jsono.isNull("Deleted") ? false : jsono.getBoolean("Deleted"));
                                            po.getItems().add((Object)purchaseLineItem);
                                        }
                                        JSONArray requestEditHistoryArray = jSONObject.getJSONArray("EditHistories");
                                        for (int j = 0; j < requestEditHistoryArray.length(); ++j) {
                                            JSONObject jsono = requestEditHistoryArray.getJSONObject(j);
                                            PurchaseOrder poEditHistory = new PurchaseOrder(PurchaseOrderPaneViewerSummary.this.da);
                                            poEditHistory.setSapCode(jsono.isNull("SAPCode") ? "" : jsono.getString("SAPCode"));
                                            poEditHistory.DocEntry = jsono.isNull("DocEntry") ? 0 : jsono.getInt("DocEntry");
                                            poEditHistory.DockNum = jsono.isNull("DocNum") ? 0 : jsono.getInt("DocNum");
                                            poEditHistory.BaseDocumentNum = jsono.isNull("BaseDocumentNum") ? 0 : jsono.getInt("BaseDocumentNum");
                                            poEditHistory.setTotal(jsono.isNull("DocTotal") ? 0.0 : jsono.getDouble("DocTotal"));
                                            poEditHistory.setCode(jsono.isNull("Code") ? "" : jsono.getString("Code"));
                                            poEditHistory.setSupplierCode(jsono.isNull("VendorId") ? "" : jsono.getString("VendorId"));
                                            poEditHistory.setSupplierName(jsono.isNull("VendorName") ? "" : jsono.getString("VendorName"));
                                            dt = df.parse(jsono.getString("DocDate"));
                                            poEditHistory.setDateCreated(new java.util.Date(dt.getTime()));
                                            dt = df.parse(jsono.getString("DeliveryDate"));
                                            poEditHistory.setDueDate(new java.util.Date(dt.getTime()));
                                            poEditHistory.setStatus(jsono.isNull("Status") ? "" : jsono.getString("Status"));
                                            poEditHistory.createCommentProperty().set((Object)(jsono.isNull("Comment") ? "" : jsono.getString("Comment")));
                                            poEditHistory.createdByProperty().set((Object)(jsono.isNull("PurchasingOfficer") ? "" : jsono.getString("PurchasingOfficer")));
                                            poEditHistory.OrderNoProperty().set((Object)(jsono.isNull("OrderNo") ? "" : jsono.getString("OrderNo")));
                                            JSONArray lineArrayPdn = jsono.getJSONArray("LineItems");
                                            for (int k = 0; k < lineArrayPdn.length(); ++k) {
                                                JSONObject jsonoItem = lineArrayPdn.getJSONObject(k);
                                                PurchaseLineItem purchaseLineItem = new PurchaseLineItem(PurchaseOrderPaneViewerSummary.this.da);
                                                purchaseLineItem.setParentPurchase(poEditHistory);
                                                purchaseLineItem.setLineNumber(jsonoItem.isNull("LineNumber") ? 0 : jsonoItem.getInt("LineNumber"));
                                                purchaseLineItem.setBaseLineNumber(jsonoItem.isNull("BaseLineNumber") ? 0 : jsonoItem.getInt("BaseLineNumber"));
                                                purchaseLineItem.setItemCode(jsonoItem.isNull("ItemCode") ? "" : jsonoItem.getString("ItemCode"));
                                                purchaseLineItem.setQuantity(jsonoItem.isNull("Qty") ? 0 : jsonoItem.getInt("Qty"));
                                                purchaseLineItem.setOpenQty(jsonoItem.isNull("OpenQty") ? 0 : jsonoItem.getInt("OpenQty"));
                                                purchaseLineItem.setPrice(jsonoItem.isNull("UnitPrice") ? 0.0 : jsonoItem.getDouble("UnitPrice"));
                                                purchaseLineItem.setCostCenter(jsonoItem.isNull("CostCentre") ? "" : jsonoItem.getString("CostCentre"));
                                                purchaseLineItem.setStoreCode(jsonoItem.isNull("StoreCode") ? "" : jsonoItem.getString("StoreCode"));
                                                purchaseLineItem.setTaxCode(jsonoItem.isNull("TaxCode") ? "" : jsonoItem.getString("TaxCode"));
                                                purchaseLineItem.setItemName(jsonoItem.isNull("ItemName") ? "" : jsonoItem.getString("ItemName"));
                                                purchaseLineItem.setCurrency(jsonoItem.isNull("Currency") ? "" : jsonoItem.getString("Currency"));
                                                purchaseLineItem.setCode(jsonoItem.isNull("Code") ? "" : jsonoItem.getString("Code"));
                                                purchaseLineItem.setPartNumber(jsonoItem.isNull("PartNumber") ? "" : jsonoItem.getString("PartNumber"));
                                                poEditHistory.getItems().add((Object)purchaseLineItem);
                                            }
                                            po.getPOHistory().add((Object)poEditHistory);
                                        }
                                        JSONArray requestArray = jSONObject.getJSONArray("DeliveryNotes");
                                        for (int j = 0; j < requestArray.length(); ++j) {
                                            JSONObject jsono = requestArray.getJSONObject(j);
                                            PurchaseDeliveryNote purchaseDeliveryNote = new PurchaseDeliveryNote(PurchaseOrderPaneViewerSummary.this.da);
                                            purchaseDeliveryNote.setSapCode(jsono.isNull("SAPCode") ? "" : jsono.getString("SAPCode"));
                                            purchaseDeliveryNote.DocEntry = jsono.isNull("DocEntry") ? 0 : jsono.getInt("DocEntry");
                                            purchaseDeliveryNote.DockNum = jsono.isNull("DocNum") ? 0 : jsono.getInt("DocNum");
                                            purchaseDeliveryNote.BaseDocumentNum = jsono.isNull("BaseDocumentNum") ? 0 : jsono.getInt("BaseDocumentNum");
                                            purchaseDeliveryNote.setTotal(jsono.isNull("DocTotal") ? 0.0 : jsono.getDouble("DocTotal"));
                                            purchaseDeliveryNote.setCode(jsono.isNull("Code") ? "" : jsono.getString("Code"));
                                            purchaseDeliveryNote.setSupplierCode(jsono.isNull("VendorId") ? "" : jsono.getString("VendorId"));
                                            purchaseDeliveryNote.setSupplierName(jsono.isNull("VendorName") ? "" : jsono.getString("VendorName"));
                                            dt = df.parse(jsono.getString("DocDate"));
                                            purchaseDeliveryNote.setDateCreated(new java.util.Date(dt.getTime()));
                                            dt = df.parse(jsono.getString("DeliveryDate"));
                                            purchaseDeliveryNote.setDueDate(new java.util.Date(dt.getTime()));
                                            purchaseDeliveryNote.setStatus(jsono.isNull("Status") ? "" : jsono.getString("Status"));
                                            purchaseDeliveryNote.createCommentProperty().set((Object)(jsono.isNull("Comment") ? "" : jsono.getString("Comment")));
                                            purchaseDeliveryNote.createdByProperty().set((Object)(jsono.isNull("PurchasingOfficer") ? "" : jsono.getString("PurchasingOfficer")));
                                            purchaseDeliveryNote.setPoCode(jsono.isNull("ParentCode") ? "" : jsono.getString("ParentCode"));
                                            purchaseDeliveryNote.OrderNoProperty().set((Object)(jsono.isNull("OrderNo") ? "" : jsono.getString("OrderNo")));
                                            JSONArray lineArrayPdn = jsono.getJSONArray("LineItems");
                                            for (int k = 0; k < lineArrayPdn.length(); ++k) {
                                                JSONObject jsonoItem = lineArrayPdn.getJSONObject(k);
                                                PurchaseLineItem purchaseLineItem = new PurchaseLineItem(PurchaseOrderPaneViewerSummary.this.da);
                                                purchaseLineItem.setParentPurchase(purchaseDeliveryNote);
                                                purchaseLineItem.setLineNumber(jsonoItem.isNull("LineNumber") ? 0 : jsonoItem.getInt("LineNumber"));
                                                purchaseLineItem.setBaseLineNumber(jsonoItem.isNull("BaseLineNumber") ? 0 : jsonoItem.getInt("BaseLineNumber"));
                                                purchaseLineItem.setItemCode(jsonoItem.isNull("ItemCode") ? "" : jsonoItem.getString("ItemCode"));
                                                purchaseLineItem.setQuantity(jsonoItem.isNull("Qty") ? 0 : jsonoItem.getInt("Qty"));
                                                purchaseLineItem.setOpenQty(jsonoItem.isNull("OpenQty") ? 0 : jsonoItem.getInt("OpenQty"));
                                                purchaseLineItem.setPrice(jsonoItem.isNull("UnitPrice") ? 0.0 : jsonoItem.getDouble("UnitPrice"));
                                                purchaseLineItem.setCostCenter(jsonoItem.isNull("CostCentre") ? "" : jsonoItem.getString("CostCentre"));
                                                purchaseLineItem.setStoreCode(jsonoItem.isNull("StoreCode") ? "" : jsonoItem.getString("StoreCode"));
                                                purchaseLineItem.setTaxCode(jsonoItem.isNull("TaxCode") ? "" : jsonoItem.getString("TaxCode"));
                                                purchaseLineItem.setItemName(jsonoItem.isNull("ItemName") ? "" : jsonoItem.getString("ItemName"));
                                                purchaseLineItem.setCurrency(jsonoItem.isNull("Currency") ? "" : jsonoItem.getString("Currency"));
                                                purchaseLineItem.setCode(jsonoItem.isNull("Code") ? "" : jsonoItem.getString("Code"));
                                                purchaseDeliveryNote.getItems().add((Object)purchaseLineItem);
                                            }
                                            po.getDeleveryNotes().add((Object)purchaseDeliveryNote);
                                        }
                                        JSONArray historiesArray = jSONObject.getJSONArray("histories");
                                        for (int j = 0; j < historiesArray.length(); ++j) {
                                            JSONObject jsono = historiesArray.getJSONObject(j);
                                            POApprovalHistory pOApprovalHistory = new POApprovalHistory(PurchaseOrderPaneViewerSummary.this.da);
                                            pOApprovalHistory.setStage(jsono.isNull("Stage") ? "" : jsono.getString("Stage"));
                                            pOApprovalHistory.setCode(jsono.isNull("Code") ? "" : jsono.getString("Code"));
                                            pOApprovalHistory.setApprovingUser(jsono.isNull("ApprovingUser") ? "" : jsono.getString("ApprovingUser"));
                                            dt = df.parse(jsono.getString("DateCreated"));
                                            pOApprovalHistory.setDateCreated(new java.util.Date(dt.getTime()));
                                            pOApprovalHistory.setRemark(jsono.isNull("Remark") ? "" : jsono.getString("Remark"));
                                            pOApprovalHistory.setActionTaken(jsono.isNull("ActionTaken") ? "" : jsono.getString("ActionTaken"));
                                            po.getHistories().add((Object)pOApprovalHistory);
                                        }
                                        po.resetNumbering();
                                        podl.getOriginalList().add((Object)po);
                                    }
                                    Platform.runLater(() -> {
                                        PurchaseOrderPaneViewerSummary.this.stackPane.getChildren().remove((Object)box);
                                        PurchaseOrderPaneViewerSummary.this.table.getItems().clear();
                                        PurchaseOrderPaneViewerSummary.this.purchaseOrderDataList.getOriginalList().clear();
                                        PurchaseOrderPaneViewerSummary.this.purchaseOrderDataList.getOriginalList().addAll(podl.getOriginalList());
                                        PurchaseOrderPaneViewerSummary.this.counter = 0;
                                        PurchaseOrderPaneViewerSummary.this.purchaseOrderDataList.getOriginalList().forEach(c -> {
                                            ++PurchaseOrderPaneViewerSummary.this.counter;
                                            c.setSn(PurchaseOrderPaneViewerSummary.this.counter);
                                            c.getItems().forEach(z -> {
                                                c.setTaxAmount(c.getTaxAmount() + z.getTax());
                                                c.dockTotalProperty().set(c.dockTotalProperty().get() - z.getTax());
                                            });
                                            c.setTotalAmount(c.getTaxAmount() + c.getTotal());
                                        });
                                        PurchaseOrderPaneViewerSummary.this.table.setItems(PurchaseOrderPaneViewerSummary.this.purchaseOrderDataList.getOriginalList());
                                        PurchaseOrderPaneViewerSummary.this.table.refresh();
                                    });
                                } else {
                                    Platform.runLater(() -> {
                                        PurchaseOrderPaneViewerSummary.this.stackPane.getChildren().remove((Object)box);
                                        PurchaseOrderPaneViewerSummary.this.table.getItems().clear();
                                        PurchaseOrderPaneViewerSummary.this.purchaseOrderDataList.getOriginalList().clear();
                                        PurchaseOrderPaneViewerSummary.this.table.refresh();
                                        PurchaseOrderPaneViewerSummary.this.mainPage.showNotification(NotificationType.Information, "No Purchase Request Found", PurchaseOrderPaneViewerSummary.this);
                                    });
                                }
                            } else {
                                String output;
                                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                StringBuilder stringBuilder = new StringBuilder();
                                while ((output = br.readLine()) != null) {
                                    System.out.println(output);
                                    stringBuilder.append(output + "\n");
                                }
                                br.close();
                                String fullError = stringBuilder.toString();
                                Platform.runLater(() -> {
                                    System.out.println("line 593 " + fullError);
                                    PurchaseOrderPaneViewerSummary.this.stackPane.getChildren().remove((Object)box);
                                    PurchaseOrderPaneViewerSummary.this.mainPage.showNotification(NotificationType.Error, fullError, PurchaseOrderPaneViewerSummary.this);
                                });
                            }
                        }
                        catch (Exception e) {
                            Platform.runLater(() -> {
                                PurchaseOrderPaneViewerSummary.this.stackPane.getChildren().remove((Object)box);
                                System.out.println("line 600 " + e.getMessage());
                                PurchaseOrderPaneViewerSummary.this.mainPage.showNotification(NotificationType.Error, e.getMessage(), PurchaseOrderPaneViewerSummary.this);
                            });
                        }
                        return null;
                    }
                };
            }
        };
        progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
        service.start();
    }
}

