/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXComboBox;
import com.jfoenix.controls.JFXDatePicker;
import com.jfoenix.controls.JFXDialog;
import com.jfoenix.controls.JFXListView;
import com.jfoenix.controls.JFXProgressBar;
import com.jfoenix.controls.JFXTabPane;
import com.jfoenix.controls.JFXTextArea;
import com.jfoenix.controls.JFXTextField;
import com.xputertechnologies.santa.Approval;
import com.xputertechnologies.santa.ExcelReportObject;
import com.xputertechnologies.santa.NameValueObject;
import com.xputertechnologies.santa.NameValueObjectType;
import com.xputertechnologies.santa.POApprovalHistory;
import com.xputertechnologies.santa.PurchaseDeliveryNote;
import com.xputertechnologies.santa.PurchaseLineItem;
import com.xputertechnologies.santa.PurchaseOrder;
import com.xputertechnologies.santa.list.ApprovalDataList;
import com.xputertechnologies.santa.list.PurchaseOrderDataList;
import com.xputertechnologies.santa.list.StockItemList;
import com.xputertechnologies.santa.ui.General;
import com.xputertechnologies.santa.ui.IPurchasePane;
import com.xputertechnologies.santa.ui.NotificationType;
import com.xputertechnologies.santa.ui.PDNViewDialog;
import com.xputertechnologies.santa.ui.POHistoryView;
import com.xputertechnologies.santa.ui.PurchaseOrderApprovalEditDialog;
import com.xputertechnologies.santa.ui.PurchaseOrderHistory;
import com.xputertechnologies.santa.ui.PurchaseOrderPane;
import com.xputertechnologies.santa.ui.ReportPane;
import com.xputertechnologies.santa.ui.Santa;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URI;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Pagination;
import javafx.scene.control.Tab;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Callback;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.controlsfx.control.HyperlinkLabel;
import org.controlsfx.glyphfont.FontAwesome;
import org.json.JSONArray;
import org.json.JSONObject;

public class PurchaseOrderPaneViewerPane
extends IPurchasePane {
    @FXML
    private JFXTextField tbSearch;
    @FXML
    private JFXDatePicker from;
    @FXML
    private JFXDatePicker from1;
    @FXML
    private JFXDatePicker to;
    @FXML
    private JFXDatePicker to1;
    @FXML
    private JFXComboBox<Approval> cmbApproval;
    @FXML
    private JFXButton btnSearch;
    @FXML
    private JFXButton btnSearch1;
    @FXML
    private JFXButton btnPrint;
    @FXML
    private JFXButton btnPrint1;
    @FXML
    private JFXButton btnExptExcel1;
    @FXML
    private JFXButton btnExptExcel;
    @FXML
    Pagination pager;
    @FXML
    Pagination pager1;
    @FXML
    Label lblCurrStage;
    @FXML
    Label lblStatus;
    @FXML
    Label lblCurrStage1;
    @FXML
    Label lblStatus1;
    @FXML
    Label lblTotal;
    @FXML
    Label lblTotal1;
    @FXML
    Label lblCurrency;
    @FXML
    Label lblCurrency1;
    @FXML
    private Tab tabMine;
    @FXML
    JFXTabPane tabPane;
    @FXML
    JFXListView<PurchaseOrder> list;
    @FXML
    JFXListView<PurchaseOrder> list1;
    @FXML
    JFXTextArea approvalComment;
    @FXML
    JFXTextArea approvalComment1;
    @FXML
    private VBox vbHistory;
    @FXML
    private VBox vbHistory1;
    @FXML
    private TableView<PurchaseLineItem> table;
    @FXML
    private TableView<PurchaseLineItem> table1;
    @FXML
    private JFXButton btnReload;
    @FXML
    private JFXButton btnReload1;
    @FXML
    public StackPane stackPane;
    @FXML
    private TableColumn colDescription;
    @FXML
    private TableColumn colItemCode;
    @FXML
    private TableColumn colPrice;
    @FXML
    private TableColumn colSn;
    @FXML
    private TableColumn colCostCenter;
    @FXML
    private TableColumn colTaxCode;
    @FXML
    private TableColumn colQty;
    @FXML
    private TableColumn colDescription1;
    @FXML
    private TableColumn colItemCode1;
    @FXML
    private TableColumn colPrice1;
    @FXML
    private TableColumn colSn1;
    @FXML
    private TableColumn colCostCenter1;
    @FXML
    private TableColumn colTaxCode1;
    @FXML
    private TableColumn colQty1;
    @FXML
    private TableColumn colPartNumber2;
    @FXML
    private TableColumn colPartNumber1;
    VBox progressContainer = null;
    PurchaseOrderDataList purchaseOrderDataList;
    PurchaseOrderDataList purchaseOrderDataListAll = null;
    @FXML
    Hyperlink lblPolink;
    @FXML
    Hyperlink lblPolink1;

    public PurchaseOrderPaneViewerPane(Santa app) {
        super("PurchaseOrderPaneViewerPane.fxml", app);
        this.title = "Purchase Order View";
        this.readOnly = true;
        if (this.santa.Products.isEmpty()) {
            try {
                this.santa.Products.addAll(StockItemList.selectAllYuProducts(this.da));
            }
            catch (SQLException ex) {
                Logger.getLogger(PurchaseOrderPane.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.from.setValue((Object)LocalDate.now().minusDays(1L));
        this.to.setValue((Object)LocalDate.now());
        this.from1.setValue((Object)LocalDate.now().minusDays(1L));
        this.to1.setValue((Object)LocalDate.now());
        ApprovalDataList approvalDataList = new ApprovalDataList(this.da);
        approvalDataList.selectAll(this.da);
        approvalDataList.getOriginalList().add(0, (Object)new Approval("None", this.da));
        this.cmbApproval.setItems(approvalDataList.getOriginalList());
        this.cmbApproval.valueProperty().addListener((ChangeListener)new ChangeListener<Approval>(){

            public void changed(ObservableValue<? extends Approval> observable, Approval oldValue, Approval newValue) {
                if (newValue != null && !newValue.getDescription().equals("None")) {
                    PurchaseOrderPaneViewerPane.this.tbSearch.clear();
                }
            }
        });
        this.lblPolink.setOnAction(event -> {
            Hyperlink h = (Hyperlink)event.getTarget();
            String s = h.getTooltip().getText();
            this.santa.getHostServices().showDocument(s);
        });
        this.lblPolink1.setOnAction(event -> {
            HyperlinkLabel h = (HyperlinkLabel)event.getTarget();
            String s = h.getTooltip().getText();
            this.santa.getHostServices().showDocument(s);
            event.consume();
        });
        final ObservableList<NameValueObject> costcenters = NameValueObject.select(NameValueObjectType.CostCentre.name(), this.da);
        final ObservableList<NameValueObject> taxCodes = NameValueObject.select(NameValueObjectType.TaxCodes.name(), this.da);
        this.purchaseOrderDataList = new PurchaseOrderDataList(this.da);
        this.purchaseOrderDataListAll = new PurchaseOrderDataList(this.da);
        this.colSn.setCellValueFactory((Callback)new PropertyValueFactory("sn"));
        this.colDescription.setCellValueFactory((Callback)new PropertyValueFactory("itemName"));
        this.colItemCode.setCellValueFactory((Callback)new PropertyValueFactory("itemCode"));
        this.colQty.setCellValueFactory((Callback)new PropertyValueFactory("quantity"));
        this.colPrice.setCellValueFactory((Callback)new PropertyValueFactory("price"));
        this.colCostCenter.setCellValueFactory((Callback)new PropertyValueFactory("costCenter"));
        this.colTaxCode.setCellValueFactory((Callback)new PropertyValueFactory("taxCode"));
        this.colPartNumber1.setCellValueFactory((Callback)new PropertyValueFactory("partNumber"));
        this.colSn1.setCellValueFactory((Callback)new PropertyValueFactory("sn"));
        this.colDescription1.setCellValueFactory((Callback)new PropertyValueFactory("itemName"));
        this.colItemCode1.setCellValueFactory((Callback)new PropertyValueFactory("itemCode"));
        this.colQty1.setCellValueFactory((Callback)new PropertyValueFactory("quantity"));
        this.colPrice1.setCellValueFactory((Callback)new PropertyValueFactory("price"));
        this.colCostCenter1.setCellValueFactory((Callback)new PropertyValueFactory("costCenter"));
        this.colTaxCode1.setCellValueFactory((Callback)new PropertyValueFactory("taxCode"));
        this.colPartNumber2.setCellValueFactory((Callback)new PropertyValueFactory("partNumber"));
        this.lblTotal.setText("");
        this.lblTotal1.setText("");
        this.lblCurrency.setText("");
        this.lblCurrency1.setText("");
        this.lblPolink.setVisible(false);
        this.list.setItems(this.purchaseOrderDataList.getOriginalList());
        this.list.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<PurchaseOrder>(){

            public void changed(ObservableValue<? extends PurchaseOrder> observable, PurchaseOrder oldValue, PurchaseOrder newValue) {
                if (newValue != null) {
                    if (((String)newValue.attachmentLinkProperty().get()).isEmpty()) {
                        PurchaseOrderPaneViewerPane.this.lblPolink.setVisible(false);
                    } else {
                        PurchaseOrderPaneViewerPane.this.lblPolink.setTooltip(new Tooltip((String)newValue.attachmentLinkProperty().get()));
                        PurchaseOrderPaneViewerPane.this.lblPolink.setVisible(true);
                    }
                    PurchaseOrderPaneViewerPane.this.table.setItems(newValue.getItems());
                    PurchaseOrderPaneViewerPane.this.approvalComment.setText(newValue.getCreateComment());
                    PurchaseOrderPaneViewerPane.this.vbHistory.getChildren().clear();
                    newValue.getHistories().forEach(v -> PurchaseOrderPaneViewerPane.this.vbHistory.getChildren().add((Object)new PurchaseOrderHistory(PurchaseOrderPaneViewerPane.this.santa, (POApprovalHistory)v)));
                    if (newValue.CurrentCloseStage.isEmpty() && newValue.CurrentEditStage.isEmpty()) {
                        PurchaseOrderPaneViewerPane.this.lblCurrStage.setText(newValue.getCurrentStage());
                        PurchaseOrderPaneViewerPane.this.lblStatus.setText(newValue.getStatus());
                    } else if (!newValue.CurrentCloseStage.isEmpty()) {
                        PurchaseOrderPaneViewerPane.this.lblCurrStage.setText(newValue.CurrentCloseStage);
                        PurchaseOrderPaneViewerPane.this.lblStatus.setText(newValue.CurrentCloseStatus);
                    } else if (!newValue.CurrentEditStage.isEmpty()) {
                        PurchaseOrderPaneViewerPane.this.lblCurrStage.setText(newValue.CurrentEditStage);
                        PurchaseOrderPaneViewerPane.this.lblStatus.setText(newValue.CurrentEditStatus);
                    }
                    PurchaseOrderPaneViewerPane.this.lblCurrency.setText(newValue.getCurrency());
                    newValue.resetNumbering();
                    newValue.recalculateTotal();
                    PurchaseOrderPaneViewerPane.this.lblTotal.setText(General.formatDecimalToMoneyString(newValue.getTotalAmount()));
                }
            }
        });
        this.list1.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<PurchaseOrder>(){

            public void changed(ObservableValue<? extends PurchaseOrder> observable, PurchaseOrder oldValue, PurchaseOrder newValue) {
                if (newValue != null) {
                    if (((String)newValue.attachmentLinkProperty().get()).isEmpty()) {
                        PurchaseOrderPaneViewerPane.this.lblPolink1.setVisible(false);
                    } else {
                        PurchaseOrderPaneViewerPane.this.lblPolink1.setTooltip(new Tooltip((String)newValue.attachmentLinkProperty().get()));
                    }
                    PurchaseOrderPaneViewerPane.this.table1.setItems(newValue.getItems());
                    PurchaseOrderPaneViewerPane.this.approvalComment1.setText(newValue.getCreateComment());
                    PurchaseOrderPaneViewerPane.this.vbHistory1.getChildren().clear();
                    newValue.getHistories().forEach(v -> PurchaseOrderPaneViewerPane.this.vbHistory1.getChildren().add((Object)new PurchaseOrderHistory(PurchaseOrderPaneViewerPane.this.santa, (POApprovalHistory)v)));
                    if (newValue.CurrentCloseStage.isEmpty() && newValue.CurrentEditStage.isEmpty()) {
                        PurchaseOrderPaneViewerPane.this.lblCurrStage1.setText(newValue.getCurrentStage());
                        PurchaseOrderPaneViewerPane.this.lblStatus1.setText(newValue.getStatus());
                    } else if (!newValue.CurrentCloseStage.isEmpty()) {
                        PurchaseOrderPaneViewerPane.this.lblCurrStage1.setText(newValue.CurrentCloseStage);
                        PurchaseOrderPaneViewerPane.this.lblStatus1.setText(newValue.CurrentCloseStatus);
                    } else if (!newValue.CurrentEditStage.isEmpty()) {
                        PurchaseOrderPaneViewerPane.this.lblCurrStage1.setText(newValue.CurrentEditStage);
                        PurchaseOrderPaneViewerPane.this.lblStatus1.setText(newValue.CurrentEditStatus);
                    }
                    PurchaseOrderPaneViewerPane.this.lblCurrency1.setText(newValue.getCurrency());
                    newValue.resetNumbering();
                    newValue.recalculateTotal();
                    PurchaseOrderPaneViewerPane.this.lblTotal1.setText(General.formatDecimalToMoneyString(newValue.getTotalAmount()));
                }
            }
        });
        this.list.setCellFactory((Callback)new Callback<ListView<PurchaseOrder>, ListCell<PurchaseOrder>>(){

            public ListCell<PurchaseOrder> call(ListView<PurchaseOrder> param) {
                final Tooltip tooltip = new Tooltip();
                ListCell<PurchaseOrder> cell = new ListCell<PurchaseOrder>(){

                    public void updateItem(PurchaseOrder po, boolean empty) {
                        super.updateItem((Object)po, empty);
                        if (empty) {
                            this.setText(null);
                            this.setGraphic(null);
                        } else {
                            this.setText(null);
                            Label code = new Label();
                            code.setText(po.getCode());
                            HBox bLabel = new HBox(new Node[]{code});
                            if (!((String)po.syncErrorProperty().get()).isEmpty()) {
                                code.setTextFill((Paint)Color.web((String)"#FF0000"));
                            }
                            bLabel.setAlignment(Pos.BOTTOM_LEFT);
                            JFXButton appRelea = new JFXButton();
                            appRelea.setGraphic((Node)new ImageView(new Image("/com/xputertechnologies/santa/ui/Images/likependind.png")));
                            if (po.getStatus().equals("PO Raised") && po.CurrentEditStage.isEmpty()) {
                                appRelea.setGraphic((Node)new ImageView(new Image("/com/xputertechnologies/santa/ui/Images/poRaised_s.png")));
                            }
                            if (po.getStatus().equals("PO Raised") && !po.CurrentEditStage.isEmpty()) {
                                appRelea.setGraphic((Node)new ImageView(new Image("/com/xputertechnologies/santa/ui/Images/poRaisedEdited_s.png")));
                            } else if (po.getStatus().equals("Declined")) {
                                appRelea.setGraphic((Node)PurchaseOrderPaneViewerPane.this.fontAwesome.create((Enum)FontAwesome.Glyph.THUMBS_ALT_DOWN).color(Color.web((String)"#FF0000")).size(18.0));
                            } else if (po.getStatus().equals("PO Closed")) {
                                appRelea.setGraphic((Node)PurchaseOrderPaneViewerPane.this.fontAwesome.create((Enum)FontAwesome.Glyph.LOCK).color(Color.web((String)"#FF0000")).size(18.0));
                            } else if (po.getStatus().equals("PO Cancelled")) {
                                appRelea.setGraphic((Node)PurchaseOrderPaneViewerPane.this.fontAwesome.create((Enum)FontAwesome.Glyph.CLOSE).color(Color.web((String)"#FF0000")).size(18.0));
                            }
                            JFXButton print = new JFXButton();
                            print.setGraphic((Node)new ImageView(new Image("/com/xputertechnologies/santa/ui/Images/printer.png")));
                            print.setOnAction(c -> {
                                try {
                                    JFXDialog dialog = new JFXDialog();
                                    dialog.setDialogContainer(PurchaseOrderPaneViewerPane.this.stackPane);
                                    dialog.setContent((Region)new ReportPane(PurchaseOrderPaneViewerPane.this.santa, dialog, po));
                                    dialog.setTransitionType(JFXDialog.DialogTransition.CENTER);
                                    dialog.setOverlayClose(false);
                                    dialog.show();
                                }
                                catch (Exception ex) {
                                    Logger.getLogger(PurchaseOrderPaneViewerPane.class.getName()).log(Level.SEVERE, null, ex);
                                }
                            });
                            print.setPrefSize(25.0, 25.0);
                            appRelea.setPrefSize(25.0, 25.0);
                            JFXButton viewPdn = new JFXButton();
                            viewPdn.setOnAction(v -> {
                                PurchaseOrderPaneViewerPane.this.purchaseOrder = po;
                                PurchaseOrderPaneViewerPane.this.dialog = new JFXDialog(PurchaseOrderPaneViewerPane.this.stackPane, (Region)new PDNViewDialog(PurchaseOrderPaneViewerPane.this), JFXDialog.DialogTransition.CENTER);
                                PurchaseOrderPaneViewerPane.this.dialog.setOverlayClose(false);
                                PurchaseOrderPaneViewerPane.this.dialog.show();
                            });
                            viewPdn.setTooltip(new Tooltip("View Inbound(s)"));
                            viewPdn.setGraphic((Node)PurchaseOrderPaneViewerPane.this.fontAwesome.create((Enum)FontAwesome.Glyph.EYE).color(Color.web((String)"#00A86B")).size(18.0));
                            JFXButton viewPOHistory = new JFXButton();
                            viewPOHistory.setOnAction(v -> {
                                PurchaseOrderPaneViewerPane.this.purchaseOrder = po;
                                PurchaseOrderPaneViewerPane.this.dialog = new JFXDialog(PurchaseOrderPaneViewerPane.this.stackPane, (Region)new POHistoryView(PurchaseOrderPaneViewerPane.this), JFXDialog.DialogTransition.CENTER);
                                PurchaseOrderPaneViewerPane.this.dialog.setOverlayClose(false);
                                PurchaseOrderPaneViewerPane.this.dialog.show();
                            });
                            viewPOHistory.setTooltip(new Tooltip("View PO History"));
                            viewPOHistory.setGraphic((Node)PurchaseOrderPaneViewerPane.this.fontAwesome.create((Enum)FontAwesome.Glyph.EYE).color(Color.web((String)"#00FF00")).size(18.0));
                            HBox root = new HBox();
                            root.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
                            HBox hBoxRight = new HBox(10.0);
                            code.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
                            Pane spacer = new Pane();
                            HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
                            spacer.setMinSize(10.0, 1.0);
                            if (po.getStatus().equals("PO Raised") && ((String)po.syncErrorProperty().get()).isEmpty()) {
                                hBoxRight.getChildren().addAll((Object[])new Node[]{bLabel, spacer, print});
                                if (!po.getDeleveryNotes().isEmpty()) {
                                    hBoxRight.getChildren().add((Object)viewPdn);
                                }
                                if (!po.getPOHistory().isEmpty()) {
                                    hBoxRight.getChildren().add((Object)viewPOHistory);
                                }
                                hBoxRight.getChildren().add((Object)appRelea);
                                root.getChildren().addAll((Object[])new Node[]{bLabel, spacer, hBoxRight});
                            } else {
                                root.getChildren().addAll((Object[])new Node[]{bLabel, spacer, appRelea});
                            }
                            tooltip.setText((String)po.syncErrorProperty().get());
                            this.setTooltip(tooltip);
                            this.setGraphic((Node)root);
                        }
                    }
                };
                return cell;
            }
        });
        this.list.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (event.getButton() == MouseButton.PRIMARY && event.getClickCount() == 2 && event.getTarget() instanceof Label) {
                    PurchaseOrderPaneViewerPane.this.purchaseOrder = (PurchaseOrder)PurchaseOrderPaneViewerPane.this.list.getSelectionModel().getSelectedItem();
                    PurchaseOrderPaneViewerPane.this.dialog = new JFXDialog(PurchaseOrderPaneViewerPane.this.stackPane, (Region)new PurchaseOrderApprovalEditDialog(PurchaseOrderPaneViewerPane.this), JFXDialog.DialogTransition.CENTER);
                    PurchaseOrderPaneViewerPane.this.dialog.setOverlayClose(false);
                    PurchaseOrderPaneViewerPane.this.dialog.show();
                }
            }
        });
        this.list1.setCellFactory((Callback)new Callback<ListView<PurchaseOrder>, ListCell<PurchaseOrder>>(){

            public ListCell<PurchaseOrder> call(ListView<PurchaseOrder> param) {
                final Tooltip tooltip = new Tooltip();
                ListCell<PurchaseOrder> cell = new ListCell<PurchaseOrder>(){

                    public void updateItem(PurchaseOrder po, boolean empty) {
                        super.updateItem((Object)po, empty);
                        if (empty) {
                            this.setText(null);
                            this.setGraphic(null);
                        } else {
                            this.setText(null);
                            Label code = new Label();
                            code.setText(po.getCode());
                            HBox bLabel = new HBox(new Node[]{code});
                            if (!((String)po.syncErrorProperty().get()).isEmpty()) {
                                code.setTextFill((Paint)Color.web((String)"#FF0000"));
                            }
                            bLabel.setAlignment(Pos.BOTTOM_LEFT);
                            JFXButton appRelea = new JFXButton();
                            appRelea.setGraphic((Node)new ImageView(new Image("/com/xputertechnologies/santa/ui/Images/likependind.png")));
                            if (po.getStatus().equals("PO Raised") && po.CurrentEditStage.isEmpty()) {
                                appRelea.setGraphic((Node)new ImageView(new Image("/com/xputertechnologies/santa/ui/Images/poRaised_s.png")));
                            }
                            if (po.getStatus().equals("PO Raised") && !po.CurrentEditStage.isEmpty()) {
                                appRelea.setGraphic((Node)new ImageView(new Image("/com/xputertechnologies/santa/ui/Images/poRaisedEdited_s.png")));
                            } else if (po.getStatus().equals("Declined")) {
                                appRelea.setGraphic((Node)PurchaseOrderPaneViewerPane.this.fontAwesome.create((Enum)FontAwesome.Glyph.THUMBS_ALT_DOWN).color(Color.web((String)"#FF0000")).size(18.0));
                            } else if (po.getStatus().equals("PO Closed")) {
                                appRelea.setGraphic((Node)PurchaseOrderPaneViewerPane.this.fontAwesome.create((Enum)FontAwesome.Glyph.LOCK).color(Color.web((String)"#FF0000")).size(18.0));
                            } else if (po.getStatus().equals("PO Cancelled")) {
                                appRelea.setGraphic((Node)PurchaseOrderPaneViewerPane.this.fontAwesome.create((Enum)FontAwesome.Glyph.CLOSE).color(Color.web((String)"#FF0000")).size(18.0));
                            }
                            JFXButton print = new JFXButton();
                            print.setGraphic((Node)new ImageView(new Image("/com/xputertechnologies/santa/ui/Images/printer.png")));
                            print.setOnAction(c -> {
                                try {
                                    JFXDialog dialog = new JFXDialog();
                                    dialog.setDialogContainer(PurchaseOrderPaneViewerPane.this.stackPane);
                                    dialog.setContent((Region)new ReportPane(PurchaseOrderPaneViewerPane.this.santa, dialog, po));
                                    dialog.setTransitionType(JFXDialog.DialogTransition.CENTER);
                                    dialog.setOverlayClose(false);
                                    dialog.show();
                                }
                                catch (Exception ex) {
                                    Logger.getLogger(PurchaseOrderPaneViewerPane.class.getName()).log(Level.SEVERE, null, ex);
                                }
                            });
                            print.setPrefSize(25.0, 25.0);
                            appRelea.setPrefSize(25.0, 25.0);
                            JFXButton viewPdn = new JFXButton();
                            viewPdn.setOnAction(v -> {
                                PurchaseOrderPaneViewerPane.this.purchaseOrder = po;
                                PurchaseOrderPaneViewerPane.this.dialog = new JFXDialog(PurchaseOrderPaneViewerPane.this.stackPane, (Region)new PDNViewDialog(PurchaseOrderPaneViewerPane.this), JFXDialog.DialogTransition.CENTER);
                                PurchaseOrderPaneViewerPane.this.dialog.setOverlayClose(false);
                                PurchaseOrderPaneViewerPane.this.dialog.show();
                            });
                            viewPdn.setTooltip(new Tooltip("View Inbound(s)"));
                            viewPdn.setGraphic((Node)PurchaseOrderPaneViewerPane.this.fontAwesome.create((Enum)FontAwesome.Glyph.EYE).color(Color.web((String)"#00A86B")).size(18.0));
                            JFXButton viewPOHistory = new JFXButton();
                            viewPOHistory.setOnAction(v -> {
                                PurchaseOrderPaneViewerPane.this.purchaseOrder = po;
                                PurchaseOrderPaneViewerPane.this.dialog = new JFXDialog(PurchaseOrderPaneViewerPane.this.stackPane, (Region)new POHistoryView(PurchaseOrderPaneViewerPane.this), JFXDialog.DialogTransition.CENTER);
                                PurchaseOrderPaneViewerPane.this.dialog.setOverlayClose(false);
                                PurchaseOrderPaneViewerPane.this.dialog.show();
                            });
                            viewPOHistory.setTooltip(new Tooltip("View PO History"));
                            viewPOHistory.setGraphic((Node)PurchaseOrderPaneViewerPane.this.fontAwesome.create((Enum)FontAwesome.Glyph.EYE).color(Color.web((String)"#00FF00")).size(18.0));
                            HBox root = new HBox();
                            root.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
                            HBox hBoxRight = new HBox(10.0);
                            code.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
                            Pane spacer = new Pane();
                            HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
                            spacer.setMinSize(10.0, 1.0);
                            if (po.getStatus().equals("PO Raised") && ((String)po.syncErrorProperty().get()).isEmpty()) {
                                hBoxRight.getChildren().addAll((Object[])new Node[]{bLabel, spacer, print});
                                if (!po.getDeleveryNotes().isEmpty()) {
                                    hBoxRight.getChildren().add((Object)viewPdn);
                                }
                                if (!po.getPOHistory().isEmpty()) {
                                    hBoxRight.getChildren().add((Object)viewPOHistory);
                                }
                                hBoxRight.getChildren().add((Object)appRelea);
                                root.getChildren().addAll((Object[])new Node[]{bLabel, spacer, hBoxRight});
                            } else {
                                root.getChildren().addAll((Object[])new Node[]{bLabel, spacer, appRelea});
                            }
                            tooltip.setText((String)po.syncErrorProperty().get());
                            this.setTooltip(tooltip);
                            this.setGraphic((Node)root);
                        }
                    }
                };
                return cell;
            }
        });
        this.list1.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (event.getButton() == MouseButton.PRIMARY && event.getClickCount() == 2 && event.getTarget() instanceof Label) {
                    PurchaseOrderPaneViewerPane.this.purchaseOrder = (PurchaseOrder)PurchaseOrderPaneViewerPane.this.list1.getSelectionModel().getSelectedItem();
                    PurchaseOrderPaneViewerPane.this.dialog = new JFXDialog(PurchaseOrderPaneViewerPane.this.stackPane, (Region)new PurchaseOrderApprovalEditDialog(PurchaseOrderPaneViewerPane.this), JFXDialog.DialogTransition.CENTER);
                    PurchaseOrderPaneViewerPane.this.dialog.setOverlayClose(false);
                    PurchaseOrderPaneViewerPane.this.dialog.show();
                }
            }
        });
        this.btnReload.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.REFRESH).color(Color.WHITE).size(15.0));
        this.btnReload.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                PurchaseOrderPaneViewerPane.this.loadMine();
            }
        });
        Callback<TableColumn<PurchaseLineItem, String>, TableCell<PurchaseLineItem, String>> cellFactoryCostCenter = new Callback<TableColumn<PurchaseLineItem, String>, TableCell<PurchaseLineItem, String>>(){

            public TableCell call(TableColumn<PurchaseLineItem, String> param) {
                TableCell<PurchaseLineItem, String> cell = new TableCell<PurchaseLineItem, String>(){
                    final Label label = new Label();

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                            this.setText(null);
                        } else {
                            PurchaseLineItem req = (PurchaseLineItem)this.getTableView().getItems().get(this.getIndex());
                            if (!req.getCostCenter().isEmpty()) {
                                this.label.setText(costcenters.stream().filter(x -> x.getKey().equals(req.getCostCenter())).findAny().get().getData());
                            }
                            this.setGraphic((Node)this.label);
                            this.setAlignment(Pos.CENTER);
                            this.setText(null);
                        }
                    }
                };
                return cell;
            }
        };
        this.colCostCenter.setCellFactory((Callback)cellFactoryCostCenter);
        Callback<TableColumn<PurchaseLineItem, String>, TableCell<PurchaseLineItem, String>> cellFactoryTax = new Callback<TableColumn<PurchaseLineItem, String>, TableCell<PurchaseLineItem, String>>(){

            public TableCell call(TableColumn<PurchaseLineItem, String> param) {
                TableCell<PurchaseLineItem, String> cell = new TableCell<PurchaseLineItem, String>(){
                    final Label label = new Label();

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                            this.setText(null);
                        } else {
                            PurchaseLineItem req = (PurchaseLineItem)this.getTableView().getItems().get(this.getIndex());
                            if (!req.getCostCenter().isEmpty()) {
                                this.label.setText(taxCodes.stream().filter(x -> x.getKey().equals(req.getTaxCode())).findAny().get().getData());
                            }
                            this.setGraphic((Node)this.label);
                            this.setAlignment(Pos.CENTER);
                            this.setText(null);
                        }
                    }
                };
                return cell;
            }
        };
        this.colTaxCode.setCellFactory((Callback)cellFactoryTax);
        Callback<TableColumn<PurchaseLineItem, String>, TableCell<PurchaseLineItem, String>> cellFactoryCostCenter1 = new Callback<TableColumn<PurchaseLineItem, String>, TableCell<PurchaseLineItem, String>>(){

            public TableCell call(TableColumn<PurchaseLineItem, String> param) {
                TableCell<PurchaseLineItem, String> cell = new TableCell<PurchaseLineItem, String>(){
                    final Label label = new Label();

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                            this.setText(null);
                        } else {
                            PurchaseLineItem req = (PurchaseLineItem)this.getTableView().getItems().get(this.getIndex());
                            if (!req.getCostCenter().isEmpty()) {
                                this.label.setText(costcenters.stream().filter(x -> x.getKey().equals(req.getCostCenter())).findAny().get().getData());
                            }
                            this.setGraphic((Node)this.label);
                            this.setAlignment(Pos.CENTER);
                            this.setText(null);
                        }
                    }
                };
                return cell;
            }
        };
        this.colCostCenter1.setCellFactory((Callback)cellFactoryCostCenter1);
        Callback<TableColumn<PurchaseLineItem, String>, TableCell<PurchaseLineItem, String>> cellFactoryTax1 = new Callback<TableColumn<PurchaseLineItem, String>, TableCell<PurchaseLineItem, String>>(){

            public TableCell call(TableColumn<PurchaseLineItem, String> param) {
                TableCell<PurchaseLineItem, String> cell = new TableCell<PurchaseLineItem, String>(){
                    final Label label = new Label();

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                            this.setText(null);
                        } else {
                            PurchaseLineItem req = (PurchaseLineItem)this.getTableView().getItems().get(this.getIndex());
                            if (!req.getCostCenter().isEmpty()) {
                                this.label.setText(taxCodes.stream().filter(x -> x.getKey().equals(req.getTaxCode())).findAny().get().getData());
                            }
                            this.setGraphic((Node)this.label);
                            this.setAlignment(Pos.CENTER);
                            this.setText(null);
                        }
                    }
                };
                return cell;
            }
        };
        this.colTaxCode1.setCellFactory((Callback)cellFactoryTax1);
        this.colPrice.setCellFactory(col -> new TableCell<PurchaseLineItem, Number>(){

            public void updateItem(Number price, boolean empty) {
                super.updateItem((Object)price, empty);
                if (empty) {
                    this.setText(null);
                } else if (price != null) {
                    this.setText(General.formatDecimalToMoneyString(price.doubleValue()));
                }
            }
        });
        this.colPrice1.setCellFactory(col -> new TableCell<PurchaseLineItem, Number>(){

            public void updateItem(Number price, boolean empty) {
                super.updateItem((Object)price, empty);
                if (empty) {
                    this.setText(null);
                } else if (price != null) {
                    this.setText(General.formatDecimalToMoneyString(price.doubleValue()));
                }
            }
        });
        this.btnReload1.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.REFRESH).color(Color.WHITE).size(15.0));
        this.btnExptExcel1.setTooltip(new Tooltip("Export PO to Excel"));
        this.btnExptExcel1.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.FILE_EXCEL_ALT).color(Color.web((String)"#7D3C98")).size(18.0));
        this.btnExptExcel.setTooltip(new Tooltip("Export PO to Excel"));
        this.btnExptExcel.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.FILE_EXCEL_ALT).color(Color.web((String)"#7D3C98")).size(18.0));
        this.btnReload1.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                PurchaseOrderPaneViewerPane.this.loadAll();
            }
        });
        this.tabPane.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<Tab>(){

            public void changed(ObservableValue<? extends Tab> observable, Tab oldValue, Tab newValue) {
                if (!PurchaseOrderPaneViewerPane.this.tabMine.equals(newValue) && PurchaseOrderPaneViewerPane.this.purchaseOrderDataListAll.getOriginalList().isEmpty()) {
                    PurchaseOrderPaneViewerPane.this.loadAll();
                }
            }
        });
        this.loadMine();
        this.btnPrint.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.PRINT).color(Color.WHITE).size(18.0));
        this.btnPrint1.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.PRINT).color(Color.WHITE).size(18.0));
        this.btnPrint.setOnAction(v -> {
            if (!this.purchaseOrderDataList.getOriginalList().isEmpty()) {
                try {
                    JFXDialog dialog = new JFXDialog();
                    dialog.setDialogContainer(this.stackPane);
                    dialog.setContent((Region)new ReportPane(this.santa, dialog, this.purchaseOrderDataList.getOriginalList()));
                    dialog.setTransitionType(JFXDialog.DialogTransition.CENTER);
                    dialog.setOverlayClose(false);
                    dialog.show();
                }
                catch (Exception ex) {
                    Logger.getLogger(PurchaseOrderPaneViewerPane.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        this.btnPrint1.setOnAction(v -> {
            if (!this.purchaseOrderDataListAll.getOriginalList().isEmpty()) {
                try {
                    JFXDialog dialog = new JFXDialog();
                    dialog.setDialogContainer(this.stackPane);
                    dialog.setContent((Region)new ReportPane(this.santa, dialog, this.purchaseOrderDataListAll.getOriginalList()));
                    dialog.setTransitionType(JFXDialog.DialogTransition.CENTER);
                    dialog.setOverlayClose(false);
                    dialog.show();
                }
                catch (Exception ex) {
                    Logger.getLogger(PurchaseOrderPaneViewerPane.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        this.btnSearch.setOnAction(v -> this.loadMine());
        this.btnSearch1.setOnAction(v -> this.loadAll());
        this.btnExptExcel1.setOnAction(v -> {
            ExcelReportObject excelReportObject = new ExcelReportObject();
            excelReportObject.getHeaders().addAll(Arrays.asList("PO Code", "Supplier Name", "Date Created", "Item Name", "Item Code", "Qty", "Price", "Tax Amount"));
            this.list1.getItems().forEach(x -> {
                for (PurchaseLineItem item : x.getItems()) {
                    ArrayList<String> lst = new ArrayList<String>();
                    lst.addAll(Arrays.asList(x.getCode(), x.getSupplierName(), new SimpleDateFormat("dd-MM-yyyy").format(x.getDateCreated()), item.getItemName(), item.getItemCode(), Integer.toString(item.getQuantity()), Double.toString(item.getPrice()), Double.toString(item.taxProperty().get())));
                    excelReportObject.getValues().add(lst);
                }
            });
            if (General.writeToExcel(app.stage, excelReportObject)) {
                this.mainPage.showNotification(NotificationType.Success, "P.O Exported", this);
            }
        });
        this.btnExptExcel.setOnAction(v -> {
            ExcelReportObject excelReportObject = new ExcelReportObject();
            excelReportObject.getHeaders().addAll(Arrays.asList("PO Code", "Supplier Name", "Date Created", "Item Name", "Item Code", "Qty", "Price", "Tax Amount"));
            this.list.getItems().forEach(x -> {
                for (PurchaseLineItem item : x.getItems()) {
                    ArrayList<String> lst = new ArrayList<String>();
                    lst.addAll(Arrays.asList(x.getCode(), x.getSupplierName(), new SimpleDateFormat("dd-MM-yyyy").format(x.getDateCreated()), item.getItemName(), item.getItemCode(), Integer.toString(item.getQuantity()), Double.toString(item.getPrice()), Double.toString(item.taxProperty().get())));
                    excelReportObject.getValues().add(lst);
                }
            });
            if (General.writeToExcel(app.stage, excelReportObject)) {
                this.mainPage.showNotification(NotificationType.Success, "P.O Exported", this);
            }
        });
    }

    void loadMine() {
        JFXProgressBar progressIndicator = new JFXProgressBar();
        progressIndicator.setProgress(-1.0);
        final VBox box = new VBox(new Node[]{progressIndicator});
        box.setAlignment(Pos.CENTER);
        this.progressContainer = box;
        this.stackPane.getChildren().add((Object)box);
        Service service = new Service(){

            protected Task createTask() {
                return new Task(){

                    protected Object call() throws Exception {
                        try {
                            String url = PurchaseOrderPaneViewerPane.this.santa.syncSetting.getBEURL() + "RPurchaseOrder/GetPurchaseRequests";
                            HttpGet httpGet = new HttpGet(url);
                            RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectTimeout(Santa.connectionTimeOut).setSocketTimeout(Santa.socketTimeOut).setConnectionRequestTimeout(Santa.socketTimeOut).build();
                            httpGet.setHeader("Content-type", "application/json");
                            ArrayList<BasicNameValuePair> listParam = new ArrayList<BasicNameValuePair>();
                            BasicNameValuePair param1 = new BasicNameValuePair("searchString", PurchaseOrderPaneViewerPane.this.currentUser.getUserName());
                            listParam.add(param1);
                            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                            LocalDateTime Strtdatetime = LocalDate.of(((LocalDate)PurchaseOrderPaneViewerPane.this.from.getValue()).getYear(), ((LocalDate)PurchaseOrderPaneViewerPane.this.from.getValue()).getMonth().getValue(), ((LocalDate)PurchaseOrderPaneViewerPane.this.from.getValue()).getDayOfMonth()).atTime(0, 0, 0);
                            LocalDateTime Enddatetime = LocalDate.of(((LocalDate)PurchaseOrderPaneViewerPane.this.to.getValue()).getYear(), ((LocalDate)PurchaseOrderPaneViewerPane.this.to.getValue()).getMonth().getValue(), ((LocalDate)PurchaseOrderPaneViewerPane.this.to.getValue()).getDayOfMonth()).atTime(23, 59, 0);
                            String fromDt = format.format(java.sql.Date.from(Strtdatetime.atZone(ZoneId.systemDefault()).toInstant()));
                            String toDt = format.format(java.sql.Date.from(Enddatetime.atZone(ZoneId.systemDefault()).toInstant()));
                            BasicNameValuePair param2 = new BasicNameValuePair("startDate", fromDt);
                            listParam.add(param2);
                            BasicNameValuePair param3 = new BasicNameValuePair("endDate", toDt);
                            listParam.add(param3);
                            CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(defaultRequestConfig).build();
                            URI uri = new URIBuilder(httpGet.getURI()).addParameters(listParam).build();
                            httpGet.setURI(uri);
                            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
                            if (response.getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 204) {
                                String output;
                                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                StringBuilder stringBuilder = new StringBuilder();
                                System.out.println("Output from Server .... \n");
                                while ((output = br.readLine()) != null) {
                                    System.out.println(output);
                                    stringBuilder.append(output + "\n");
                                }
                                br.close();
                                httpClient.getConnectionManager().shutdown();
                                String result = stringBuilder.toString();
                                JSONArray ra = new JSONArray(result);
                                PurchaseOrderDataList podl = new PurchaseOrderDataList(PurchaseOrderPaneViewerPane.this.da);
                                if (ra.length() > 0) {
                                    for (int i = 0; i < ra.length(); ++i) {
                                        JSONObject jSONObject = ra.getJSONObject(i);
                                        PurchaseOrder po = new PurchaseOrder(PurchaseOrderPaneViewerPane.this.da);
                                        po.DocEntry = jSONObject.isNull("DocEntry") ? 0 : jSONObject.getInt("DocEntry");
                                        po.DockNum = jSONObject.isNull("DocNum") ? 0 : jSONObject.getInt("DocNum");
                                        po.CurrentEditStage = jSONObject.isNull("CurrentEditStage") ? "" : jSONObject.getString("CurrentEditStage");
                                        po.CurrentCloseStage = jSONObject.isNull("CurrentCloseStage") ? "" : jSONObject.getString("CurrentCloseStage");
                                        po.CurrentEditStatus = jSONObject.isNull("CurrentEditStatus") ? "" : jSONObject.getString("CurrentEditStatus");
                                        po.CurrentCloseStatus = jSONObject.isNull("CurrentCloseStatus") ? "" : jSONObject.getString("CurrentCloseStatus");
                                        System.out.println(po.getCode() + " Edit Stage is:" + po.CurrentEditStage);
                                        po.BaseDocumentNum = jSONObject.isNull("BaseDocumentNum") ? 0 : jSONObject.getInt("BaseDocumentNum");
                                        po.setSapCode(jSONObject.isNull("SAPCode") ? "" : jSONObject.getString("SAPCode"));
                                        po.approvingUser = jSONObject.isNull("ApprovingUser") ? "" : jSONObject.getString("ApprovingUser");
                                        po.remark = jSONObject.isNull("Comment") ? "" : jSONObject.getString("Comment");
                                        po.setTotal(jSONObject.isNull("DocTotal") ? 0.0 : jSONObject.getDouble("DocTotal"));
                                        System.out.println(jSONObject.getString("Code") + " " + Double.toString(jSONObject.getDouble("DocTotal")));
                                        po.setCode(jSONObject.isNull("Code") ? "" : jSONObject.getString("Code"));
                                        po.setSupplierCode(jSONObject.isNull("VendorId") ? "" : jSONObject.getString("VendorId"));
                                        po.setSupplierName(jSONObject.isNull("VendorName") ? "" : jSONObject.getString("VendorName"));
                                        po.attachmentLinkProperty().set((Object)(jSONObject.isNull("Attachment") ? "" : jSONObject.getString("Attachment")));
                                        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss");
                                        Date dt = df.parse(jSONObject.getString("DocDate"));
                                        po.setDateCreated(new Date(dt.getTime()));
                                        dt = df.parse(jSONObject.getString("DeliveryDate"));
                                        po.setDueDate(new Date(dt.getTime()));
                                        dt = df.parse(jSONObject.getString("DateApproved"));
                                        po.dateApproved = new Date(dt.getTime());
                                        po.setCurrency(jSONObject.isNull("Currency") ? "" : jSONObject.getString("Currency"));
                                        po.setStatus(jSONObject.isNull("Status") ? "" : jSONObject.getString("Status"));
                                        po.createCommentProperty().set((Object)(jSONObject.isNull("Comment") ? "" : jSONObject.getString("Comment")));
                                        po.createdByProperty().set((Object)(jSONObject.isNull("PurchasingOfficer") ? "" : jSONObject.getString("PurchasingOfficer")));
                                        po.setParentTemplateDescription(jSONObject.isNull("ApprovalTemplateDescription") ? "" : jSONObject.getString("ApprovalTemplateDescription"));
                                        po.setPurchaseType(jSONObject.isNull("PurchaseType") ? "" : jSONObject.getString("PurchaseType"));
                                        po.syncErrorProperty().set((Object)(jSONObject.isNull("SyncError") ? "" : jSONObject.getString("SyncError")));
                                        ObservableList<NameValueObject> paymentTerms = NameValueObject.select(NameValueObjectType.PaymentTerm.name(), PurchaseOrderPaneViewerPane.this.da);
                                        if (!jSONObject.isNull("PaymentTerm") && !jSONObject.getString("PaymentTerm").isEmpty()) {
                                            String str = jSONObject.getString("PaymentTerm");
                                            String paymentType = paymentTerms.stream().filter(c -> c.getKey().equals(str)).findAny().get().getData();
                                            po.setPaymentTerm(paymentType);
                                        }
                                        po.OrderNoProperty().set((Object)(jSONObject.isNull("OrderNo") ? "" : jSONObject.getString("OrderNo")));
                                        po.setCurrentStage(jSONObject.isNull("CurrentStage") ? "" : jSONObject.getString("CurrentStage"));
                                        JSONArray lineArray = jSONObject.getJSONArray("LineItems");
                                        for (int j = 0; j < lineArray.length(); ++j) {
                                            JSONObject jsono = lineArray.getJSONObject(j);
                                            PurchaseLineItem purchaseLineItem = new PurchaseLineItem(PurchaseOrderPaneViewerPane.this.da);
                                            purchaseLineItem.setParentPurchase(po);
                                            purchaseLineItem.setLineNumber(jsono.isNull("LineNumber") ? 0 : jsono.getInt("LineNumber"));
                                            purchaseLineItem.setBaseLineNumber(jsono.isNull("BaseLineNumber") ? 0 : jsono.getInt("BaseLineNumber"));
                                            purchaseLineItem.setItemCode(jsono.isNull("ItemCode") ? "" : jsono.getString("ItemCode"));
                                            purchaseLineItem.setQuantity(jsono.isNull("Qty") ? 0 : jsono.getInt("Qty"));
                                            purchaseLineItem.setOpenQty(jsono.isNull("OpenQty") ? 0 : jsono.getInt("OpenQty"));
                                            purchaseLineItem.setPrice(jsono.isNull("UnitPrice") ? 0.0 : jsono.getDouble("UnitPrice"));
                                            purchaseLineItem.setTax(jsono.isNull("TaxAmount") ? 0.0 : jsono.getDouble("TaxAmount"));
                                            purchaseLineItem.setCostCenter(jsono.isNull("CostCentre") ? "" : jsono.getString("CostCentre"));
                                            purchaseLineItem.setStoreCode(jsono.isNull("StoreCode") ? "" : jsono.getString("StoreCode"));
                                            purchaseLineItem.setTaxCode(jsono.isNull("TaxCode") ? "" : jsono.getString("TaxCode"));
                                            purchaseLineItem.setItemName(jsono.isNull("ItemName") ? "" : jsono.getString("ItemName"));
                                            purchaseLineItem.setCurrency(jsono.isNull("Currency") ? "" : jsono.getString("Currency"));
                                            purchaseLineItem.setCode(jsono.isNull("Code") ? "" : jsono.getString("Code"));
                                            purchaseLineItem.setIsDeleted(jsono.isNull("Deleted") ? false : jsono.getBoolean("Deleted"));
                                            purchaseLineItem.setPartNumber(jsono.isNull("PartNumber") ? "" : jsono.getString("PartNumber"));
                                            po.getItems().add((Object)purchaseLineItem);
                                        }
                                        JSONArray requestEditHistoryArray = jSONObject.getJSONArray("EditHistories");
                                        for (int j = 0; j < requestEditHistoryArray.length(); ++j) {
                                            JSONObject jsono = requestEditHistoryArray.getJSONObject(j);
                                            PurchaseOrder poEditHistory = new PurchaseOrder(PurchaseOrderPaneViewerPane.this.da);
                                            poEditHistory.setSapCode(jsono.isNull("SAPCode") ? "" : jsono.getString("SAPCode"));
                                            poEditHistory.DocEntry = jsono.isNull("DocEntry") ? 0 : jsono.getInt("DocEntry");
                                            poEditHistory.DockNum = jsono.isNull("DocNum") ? 0 : jsono.getInt("DocNum");
                                            poEditHistory.BaseDocumentNum = jsono.isNull("BaseDocumentNum") ? 0 : jsono.getInt("BaseDocumentNum");
                                            poEditHistory.setTotal(jsono.isNull("DocTotal") ? 0.0 : jsono.getDouble("DocTotal"));
                                            poEditHistory.setCode(jsono.isNull("Code") ? "" : jsono.getString("Code"));
                                            poEditHistory.setSupplierCode(jsono.isNull("VendorId") ? "" : jsono.getString("VendorId"));
                                            poEditHistory.setSupplierName(jsono.isNull("VendorName") ? "" : jsono.getString("VendorName"));
                                            dt = df.parse(jsono.getString("DocDate"));
                                            poEditHistory.setDateCreated(new Date(dt.getTime()));
                                            dt = df.parse(jsono.getString("DeliveryDate"));
                                            poEditHistory.setDueDate(new Date(dt.getTime()));
                                            poEditHistory.setStatus(jsono.isNull("Status") ? "" : jsono.getString("Status"));
                                            poEditHistory.createCommentProperty().set((Object)(jsono.isNull("Comment") ? "" : jsono.getString("Comment")));
                                            poEditHistory.createdByProperty().set((Object)(jsono.isNull("PurchasingOfficer") ? "" : jsono.getString("PurchasingOfficer")));
                                            poEditHistory.OrderNoProperty().set((Object)(jsono.isNull("OrderNo") ? "" : jsono.getString("OrderNo")));
                                            JSONArray lineArrayPdn = jsono.getJSONArray("LineItems");
                                            for (int k = 0; k < lineArrayPdn.length(); ++k) {
                                                JSONObject jsonoItem = lineArrayPdn.getJSONObject(k);
                                                PurchaseLineItem purchaseLineItem = new PurchaseLineItem(PurchaseOrderPaneViewerPane.this.da);
                                                purchaseLineItem.setParentPurchase(poEditHistory);
                                                purchaseLineItem.setLineNumber(jsonoItem.isNull("LineNumber") ? 0 : jsonoItem.getInt("LineNumber"));
                                                purchaseLineItem.setBaseLineNumber(jsonoItem.isNull("BaseLineNumber") ? 0 : jsonoItem.getInt("BaseLineNumber"));
                                                purchaseLineItem.setItemCode(jsonoItem.isNull("ItemCode") ? "" : jsonoItem.getString("ItemCode"));
                                                purchaseLineItem.setQuantity(jsonoItem.isNull("Qty") ? 0 : jsonoItem.getInt("Qty"));
                                                purchaseLineItem.setOpenQty(jsonoItem.isNull("OpenQty") ? 0 : jsonoItem.getInt("OpenQty"));
                                                purchaseLineItem.setPrice(jsonoItem.isNull("UnitPrice") ? 0.0 : jsonoItem.getDouble("UnitPrice"));
                                                purchaseLineItem.setCostCenter(jsonoItem.isNull("CostCentre") ? "" : jsonoItem.getString("CostCentre"));
                                                purchaseLineItem.setStoreCode(jsonoItem.isNull("StoreCode") ? "" : jsonoItem.getString("StoreCode"));
                                                purchaseLineItem.setTaxCode(jsonoItem.isNull("TaxCode") ? "" : jsonoItem.getString("TaxCode"));
                                                purchaseLineItem.setItemName(jsonoItem.isNull("ItemName") ? "" : jsonoItem.getString("ItemName"));
                                                purchaseLineItem.setCurrency(jsonoItem.isNull("Currency") ? "" : jsonoItem.getString("Currency"));
                                                purchaseLineItem.setCode(jsonoItem.isNull("Code") ? "" : jsonoItem.getString("Code"));
                                                purchaseLineItem.setPartNumber(jsonoItem.isNull("PartNumber") ? "" : jsonoItem.getString("PartNumber"));
                                                poEditHistory.getItems().add((Object)purchaseLineItem);
                                            }
                                            po.getPOHistory().add((Object)poEditHistory);
                                        }
                                        JSONArray requestArray = jSONObject.getJSONArray("DeliveryNotes");
                                        for (int j = 0; j < requestArray.length(); ++j) {
                                            JSONObject jsono = requestArray.getJSONObject(j);
                                            PurchaseDeliveryNote purchaseDeliveryNote = new PurchaseDeliveryNote(PurchaseOrderPaneViewerPane.this.da);
                                            purchaseDeliveryNote.setSapCode(jsono.isNull("SAPCode") ? "" : jsono.getString("SAPCode"));
                                            purchaseDeliveryNote.DocEntry = jsono.isNull("DocEntry") ? 0 : jsono.getInt("DocEntry");
                                            purchaseDeliveryNote.DockNum = jsono.isNull("DocNum") ? 0 : jsono.getInt("DocNum");
                                            purchaseDeliveryNote.BaseDocumentNum = jsono.isNull("BaseDocumentNum") ? 0 : jsono.getInt("BaseDocumentNum");
                                            purchaseDeliveryNote.setTotal(jsono.isNull("DocTotal") ? 0.0 : jsono.getDouble("DocTotal"));
                                            purchaseDeliveryNote.setCode(jsono.isNull("Code") ? "" : jsono.getString("Code"));
                                            purchaseDeliveryNote.setSupplierCode(jsono.isNull("VendorId") ? "" : jsono.getString("VendorId"));
                                            purchaseDeliveryNote.setSupplierName(jsono.isNull("VendorName") ? "" : jsono.getString("VendorName"));
                                            dt = df.parse(jsono.getString("DocDate"));
                                            purchaseDeliveryNote.setDateCreated(new Date(dt.getTime()));
                                            dt = df.parse(jsono.getString("DeliveryDate"));
                                            purchaseDeliveryNote.setDueDate(new Date(dt.getTime()));
                                            purchaseDeliveryNote.setStatus(jsono.isNull("Status") ? "" : jsono.getString("Status"));
                                            purchaseDeliveryNote.createCommentProperty().set((Object)(jsono.isNull("Comment") ? "" : jsono.getString("Comment")));
                                            purchaseDeliveryNote.createdByProperty().set((Object)(jsono.isNull("PurchasingOfficer") ? "" : jsono.getString("PurchasingOfficer")));
                                            purchaseDeliveryNote.setPoCode(jsono.isNull("ParentCode") ? "" : jsono.getString("ParentCode"));
                                            purchaseDeliveryNote.OrderNoProperty().set((Object)(jsono.isNull("OrderNo") ? "" : jsono.getString("OrderNo")));
                                            purchaseDeliveryNote.currency = po.getCurrency();
                                            JSONArray lineArrayPdn = jsono.getJSONArray("LineItems");
                                            for (int k = 0; k < lineArrayPdn.length(); ++k) {
                                                JSONObject jsonoItem = lineArrayPdn.getJSONObject(k);
                                                PurchaseLineItem purchaseLineItem = new PurchaseLineItem(PurchaseOrderPaneViewerPane.this.da);
                                                purchaseLineItem.setParentPurchase(purchaseDeliveryNote);
                                                purchaseLineItem.setLineNumber(jsonoItem.isNull("LineNumber") ? 0 : jsonoItem.getInt("LineNumber"));
                                                purchaseLineItem.setBaseLineNumber(jsonoItem.isNull("BaseLineNumber") ? 0 : jsonoItem.getInt("BaseLineNumber"));
                                                purchaseLineItem.setItemCode(jsonoItem.isNull("ItemCode") ? "" : jsonoItem.getString("ItemCode"));
                                                purchaseLineItem.setQuantity(jsonoItem.isNull("Qty") ? 0 : jsonoItem.getInt("Qty"));
                                                purchaseLineItem.setOpenQty(jsonoItem.isNull("OpenQty") ? 0 : jsonoItem.getInt("OpenQty"));
                                                purchaseLineItem.setPrice(jsonoItem.isNull("UnitPrice") ? 0.0 : jsonoItem.getDouble("UnitPrice"));
                                                purchaseLineItem.setCostCenter(jsonoItem.isNull("CostCentre") ? "" : jsonoItem.getString("CostCentre"));
                                                purchaseLineItem.setStoreCode(jsonoItem.isNull("StoreCode") ? "" : jsonoItem.getString("StoreCode"));
                                                purchaseLineItem.setTaxCode(jsonoItem.isNull("TaxCode") ? "" : jsonoItem.getString("TaxCode"));
                                                purchaseLineItem.setItemName(jsonoItem.isNull("ItemName") ? "" : jsonoItem.getString("ItemName"));
                                                purchaseLineItem.setCurrency(jsonoItem.isNull("Currency") ? "" : jsonoItem.getString("Currency"));
                                                purchaseLineItem.setCode(jsonoItem.isNull("Code") ? "" : jsonoItem.getString("Code"));
                                                purchaseLineItem.setTax(jsonoItem.isNull("TaxAmount") ? 0.0 : jsonoItem.getDouble("TaxAmount"));
                                                purchaseLineItem.setPartNumber(jsonoItem.isNull("PartNumber") ? "" : jsonoItem.getString("PartNumber"));
                                                purchaseLineItem.lineTotalWithTaxProperty().set(purchaseLineItem.getQuantity() == 0 ? purchaseLineItem.getPrice() + purchaseLineItem.getTax() : purchaseLineItem.getPrice() * (double)purchaseLineItem.getQuantity() + purchaseLineItem.getTax());
                                                purchaseDeliveryNote.getItems().add((Object)purchaseLineItem);
                                            }
                                            purchaseDeliveryNote.recalculateTotal();
                                            po.getDeleveryNotes().add((Object)purchaseDeliveryNote);
                                        }
                                        JSONArray historiesArray = jSONObject.getJSONArray("histories");
                                        for (int j = 0; j < historiesArray.length(); ++j) {
                                            JSONObject jsono = historiesArray.getJSONObject(j);
                                            POApprovalHistory pOApprovalHistory = new POApprovalHistory(PurchaseOrderPaneViewerPane.this.da);
                                            pOApprovalHistory.setStage(jsono.isNull("Stage") ? "" : jsono.getString("Stage"));
                                            pOApprovalHistory.setCode(jsono.isNull("Code") ? "" : jsono.getString("Code"));
                                            pOApprovalHistory.setApprovingUser(jsono.isNull("ApprovingUser") ? "" : jsono.getString("ApprovingUser"));
                                            dt = df.parse(jsono.getString("DateCreated"));
                                            pOApprovalHistory.setDateCreated(new Date(dt.getTime()));
                                            pOApprovalHistory.setRemark(jsono.isNull("Remark") ? "" : jsono.getString("Remark"));
                                            pOApprovalHistory.setActionTaken(jsono.isNull("ActionTaken") ? "" : jsono.getString("ActionTaken"));
                                            po.getHistories().add((Object)pOApprovalHistory);
                                        }
                                        podl.getOriginalList().add((Object)po);
                                    }
                                    Platform.runLater(() -> {
                                        PurchaseOrderPaneViewerPane.this.stackPane.getChildren().remove((Object)box);
                                        PurchaseOrderPaneViewerPane.this.table.getItems().clear();
                                        PurchaseOrderPaneViewerPane.this.purchaseOrderDataList.getOriginalList().clear();
                                        PurchaseOrderPaneViewerPane.this.purchaseOrderDataList.getOriginalList().addAll(podl.getOriginalList());
                                        podl.getOriginalList().forEach(x -> x.getItems().forEach(z -> x.setTotalAmount(x.getTotalAmount() + z.getTax() + z.getLineTotal())));
                                        PurchaseOrderPaneViewerPane.this.vbHistory.getChildren().clear();
                                        PurchaseOrderPaneViewerPane.this.lblCurrStage.setText("");
                                        PurchaseOrderPaneViewerPane.this.lblStatus.setText("");
                                        PurchaseOrderPaneViewerPane.this.lblCurrency.setText("");
                                        PurchaseOrderPaneViewerPane.this.lblTotal.setText("");
                                        PurchaseOrderPaneViewerPane.this.approvalComment.clear();
                                        PurchaseOrderPaneViewerPane.this.table.refresh();
                                        PurchaseOrderPaneViewerPane.this.list.setItems(PurchaseOrderPaneViewerPane.this.purchaseOrderDataList.getOriginalList());
                                        PurchaseOrderPaneViewerPane.this.list.refresh();
                                    });
                                } else {
                                    Platform.runLater(() -> {
                                        PurchaseOrderPaneViewerPane.this.stackPane.getChildren().remove((Object)box);
                                        PurchaseOrderPaneViewerPane.this.table.getItems().clear();
                                        PurchaseOrderPaneViewerPane.this.purchaseOrderDataList.getOriginalList().clear();
                                        PurchaseOrderPaneViewerPane.this.vbHistory.getChildren().clear();
                                        PurchaseOrderPaneViewerPane.this.lblCurrStage.setText("");
                                        PurchaseOrderPaneViewerPane.this.lblStatus.setText("");
                                        PurchaseOrderPaneViewerPane.this.lblCurrency.setText("");
                                        PurchaseOrderPaneViewerPane.this.lblTotal.setText("");
                                        PurchaseOrderPaneViewerPane.this.approvalComment.clear();
                                        PurchaseOrderPaneViewerPane.this.table.refresh();
                                        PurchaseOrderPaneViewerPane.this.list.setItems(PurchaseOrderPaneViewerPane.this.purchaseOrderDataList.getOriginalList());
                                        PurchaseOrderPaneViewerPane.this.list.refresh();
                                        PurchaseOrderPaneViewerPane.this.mainPage.showNotification(NotificationType.Information, "No Purchase Request Found", PurchaseOrderPaneViewerPane.this);
                                    });
                                }
                            } else {
                                String output;
                                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                StringBuilder stringBuilder = new StringBuilder();
                                while ((output = br.readLine()) != null) {
                                    System.out.println(output);
                                    stringBuilder.append(output + "\n");
                                }
                                br.close();
                                String fullError = stringBuilder.toString();
                                Platform.runLater(() -> {
                                    PurchaseOrderPaneViewerPane.this.stackPane.getChildren().remove((Object)box);
                                    PurchaseOrderPaneViewerPane.this.mainPage.showNotification(NotificationType.Error, fullError, PurchaseOrderPaneViewerPane.this);
                                });
                            }
                        }
                        catch (Exception e) {
                            Platform.runLater(() -> {
                                PurchaseOrderPaneViewerPane.this.stackPane.getChildren().remove((Object)box);
                                PurchaseOrderPaneViewerPane.this.mainPage.showNotification(NotificationType.Error, e.getMessage(), PurchaseOrderPaneViewerPane.this);
                            });
                        }
                        return null;
                    }
                };
            }
        };
        progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
        service.start();
    }

    void loadAll() {
        JFXProgressBar progressIndicator = new JFXProgressBar();
        progressIndicator.setProgress(-1.0);
        final VBox box = new VBox(new Node[]{progressIndicator});
        box.setAlignment(Pos.CENTER);
        this.progressContainer = box;
        this.stackPane.getChildren().add((Object)box);
        Service service = new Service(){

            protected Task createTask() {
                return new Task(){

                    protected Object call() throws Exception {
                        try {
                            String output;
                            StringBuilder stringBuilder;
                            BufferedReader br;
                            BasicNameValuePair param3;
                            BasicNameValuePair param2;
                            String toDt;
                            String fromDt;
                            LocalDateTime Enddatetime;
                            LocalDateTime Strtdatetime;
                            SimpleDateFormat format;
                            String url = PurchaseOrderPaneViewerPane.this.santa.syncSetting.getBEURL() + "RPurchaseOrder/GetPurchaseRequests";
                            HttpGet httpGet = new HttpGet(url);
                            RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectTimeout(Santa.connectionTimeOut).setSocketTimeout(Santa.socketTimeOut).setConnectionRequestTimeout(Santa.socketTimeOut).build();
                            httpGet.setHeader("Content-type", "application/json");
                            CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(defaultRequestConfig).build();
                            ArrayList<BasicNameValuePair> listParam = new ArrayList<BasicNameValuePair>();
                            if (!PurchaseOrderPaneViewerPane.this.tbSearch.getText().isEmpty() || PurchaseOrderPaneViewerPane.this.cmbApproval.getSelectionModel().getSelectedItem() != null) {
                                BasicNameValuePair param1;
                                if (!PurchaseOrderPaneViewerPane.this.tbSearch.getText().isEmpty()) {
                                    param1 = new BasicNameValuePair("searchString", PurchaseOrderPaneViewerPane.this.tbSearch.getText());
                                    listParam.add(param1);
                                } else if (!((Approval)PurchaseOrderPaneViewerPane.this.cmbApproval.getSelectionModel().getSelectedItem()).getDescription().equals("None")) {
                                    param1 = new BasicNameValuePair("searchString", ((Approval)PurchaseOrderPaneViewerPane.this.cmbApproval.getSelectionModel().getSelectedItem()).getDescription());
                                    listParam.add(param1);
                                }
                                format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                                Strtdatetime = LocalDate.of(2017, 1, 1).atTime(0, 0, 0);
                                Enddatetime = LocalDate.of(2050, 1, 1).atTime(23, 59, 0);
                                fromDt = format.format(java.sql.Date.from(Strtdatetime.atZone(ZoneId.systemDefault()).toInstant()));
                                toDt = format.format(java.sql.Date.from(Enddatetime.atZone(ZoneId.systemDefault()).toInstant()));
                                param2 = new BasicNameValuePair("startDate", fromDt);
                                listParam.add(param2);
                                param3 = new BasicNameValuePair("endDate", toDt);
                                listParam.add(param3);
                            } else {
                                format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                                Strtdatetime = LocalDate.of(((LocalDate)PurchaseOrderPaneViewerPane.this.from1.getValue()).getYear(), ((LocalDate)PurchaseOrderPaneViewerPane.this.from1.getValue()).getMonth().getValue(), ((LocalDate)PurchaseOrderPaneViewerPane.this.from1.getValue()).getDayOfMonth()).atTime(0, 0, 0);
                                Enddatetime = LocalDate.of(((LocalDate)PurchaseOrderPaneViewerPane.this.to1.getValue()).getYear(), ((LocalDate)PurchaseOrderPaneViewerPane.this.to1.getValue()).getMonth().getValue(), ((LocalDate)PurchaseOrderPaneViewerPane.this.to1.getValue()).getDayOfMonth()).atTime(23, 59, 0);
                                fromDt = format.format(java.sql.Date.from(Strtdatetime.atZone(ZoneId.systemDefault()).toInstant()));
                                toDt = format.format(java.sql.Date.from(Enddatetime.atZone(ZoneId.systemDefault()).toInstant()));
                                param2 = new BasicNameValuePair("startDate", fromDt);
                                listParam.add(param2);
                                param3 = new BasicNameValuePair("endDate", toDt);
                                listParam.add(param3);
                            }
                            URI uri = new URIBuilder(httpGet.getURI()).addParameters(listParam).build();
                            httpGet.setURI(uri);
                            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
                            if (response.getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 204) {
                                br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                stringBuilder = new StringBuilder();
                                System.out.println("Output from Server .... \n");
                                while ((output = br.readLine()) != null) {
                                    System.out.println(output);
                                    stringBuilder.append(output + "\n");
                                }
                                br.close();
                                httpClient.getConnectionManager().shutdown();
                                String result = stringBuilder.toString();
                                JSONArray ra = new JSONArray(result);
                                PurchaseOrderDataList podl = new PurchaseOrderDataList(PurchaseOrderPaneViewerPane.this.da);
                                if (ra.length() > 0) {
                                    for (int i = 0; i < ra.length(); ++i) {
                                        JSONObject jSONObject = ra.getJSONObject(i);
                                        PurchaseOrder po = new PurchaseOrder(PurchaseOrderPaneViewerPane.this.da);
                                        po.DocEntry = jSONObject.isNull("DocEntry") ? 0 : jSONObject.getInt("DocEntry");
                                        po.DockNum = jSONObject.isNull("DocNum") ? 0 : jSONObject.getInt("DocNum");
                                        po.BaseDocumentNum = jSONObject.isNull("BaseDocumentNum") ? 0 : jSONObject.getInt("BaseDocumentNum");
                                        po.setSapCode(jSONObject.isNull("SAPCode") ? "" : jSONObject.getString("SAPCode"));
                                        po.CurrentEditStage = jSONObject.isNull("CurrentEditStage") ? "" : jSONObject.getString("CurrentEditStage");
                                        po.CurrentCloseStage = jSONObject.isNull("CurrentCloseStage") ? "" : jSONObject.getString("CurrentCloseStage");
                                        po.CurrentEditStatus = jSONObject.isNull("CurrentEditStatus") ? "" : jSONObject.getString("CurrentEditStatus");
                                        po.CurrentCloseStatus = jSONObject.isNull("CurrentCloseStatus") ? "" : jSONObject.getString("CurrentCloseStatus");
                                        po.approvingUser = jSONObject.isNull("ApprovingUser") ? "" : jSONObject.getString("ApprovingUser");
                                        po.remark = jSONObject.isNull("Comment") ? "" : jSONObject.getString("Comment");
                                        po.setTotal(jSONObject.isNull("DocTotal") ? 0.0 : jSONObject.getDouble("DocTotal"));
                                        System.out.println(jSONObject.getString("Code") + " " + Double.toString(jSONObject.getDouble("DocTotal")));
                                        po.setCode(jSONObject.isNull("Code") ? "" : jSONObject.getString("Code"));
                                        po.setSupplierCode(jSONObject.isNull("VendorId") ? "" : jSONObject.getString("VendorId"));
                                        po.setSupplierName(jSONObject.isNull("VendorName") ? "" : jSONObject.getString("VendorName"));
                                        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss");
                                        Date dt = df.parse(jSONObject.getString("DocDate"));
                                        po.setDateCreated(new Date(dt.getTime()));
                                        dt = df.parse(jSONObject.getString("DeliveryDate"));
                                        po.setDueDate(new Date(dt.getTime()));
                                        po.setCurrency(jSONObject.isNull("Currency") ? "" : jSONObject.getString("Currency"));
                                        po.setStatus(jSONObject.isNull("Status") ? "" : jSONObject.getString("Status"));
                                        po.createCommentProperty().set((Object)(jSONObject.isNull("Comment") ? "" : jSONObject.getString("Comment")));
                                        po.createdByProperty().set((Object)(jSONObject.isNull("PurchasingOfficer") ? "" : jSONObject.getString("PurchasingOfficer")));
                                        po.setParentTemplateDescription(jSONObject.isNull("ApprovalTemplateDescription") ? "" : jSONObject.getString("ApprovalTemplateDescription"));
                                        po.setPurchaseType(jSONObject.isNull("PurchaseType") ? "" : jSONObject.getString("PurchaseType"));
                                        po.syncErrorProperty().set((Object)(jSONObject.isNull("SyncError") ? "" : jSONObject.getString("SyncError")));
                                        po.dateApproved = new Date(dt.getTime());
                                        po.attachmentLinkProperty().set((Object)(jSONObject.isNull("Attachment") ? "" : jSONObject.getString("Attachment")));
                                        ObservableList<NameValueObject> paymentTerms = NameValueObject.select(NameValueObjectType.PaymentTerm.name(), PurchaseOrderPaneViewerPane.this.da);
                                        if (!jSONObject.isNull("PaymentTerm") && !jSONObject.getString("PaymentTerm").isEmpty()) {
                                            String str = jSONObject.getString("PaymentTerm");
                                            String paymentType = paymentTerms.stream().filter(c -> c.getKey().equals(str)).findAny().get().getData();
                                            po.setPaymentTerm(paymentType);
                                        }
                                        po.OrderNoProperty().set((Object)(jSONObject.isNull("OrderNo") ? "" : jSONObject.getString("OrderNo")));
                                        po.setCurrentStage(jSONObject.isNull("CurrentStage") ? "" : jSONObject.getString("CurrentStage"));
                                        JSONArray lineArray = jSONObject.getJSONArray("LineItems");
                                        for (int j = 0; j < lineArray.length(); ++j) {
                                            JSONObject jsono = lineArray.getJSONObject(j);
                                            PurchaseLineItem purchaseLineItem = new PurchaseLineItem(PurchaseOrderPaneViewerPane.this.da);
                                            purchaseLineItem.setParentPurchase(po);
                                            purchaseLineItem.setLineNumber(jsono.isNull("LineNumber") ? 0 : jsono.getInt("LineNumber"));
                                            purchaseLineItem.setBaseLineNumber(jsono.isNull("BaseLineNumber") ? 0 : jsono.getInt("BaseLineNumber"));
                                            purchaseLineItem.setItemCode(jsono.isNull("ItemCode") ? "" : jsono.getString("ItemCode"));
                                            purchaseLineItem.setQuantity(jsono.isNull("Qty") ? 0 : jsono.getInt("Qty"));
                                            purchaseLineItem.setOpenQty(jsono.isNull("OpenQty") ? 0 : jsono.getInt("OpenQty"));
                                            purchaseLineItem.setPrice(jsono.isNull("UnitPrice") ? 0.0 : jsono.getDouble("UnitPrice"));
                                            purchaseLineItem.setTax(jsono.isNull("TaxAmount") ? 0.0 : jsono.getDouble("TaxAmount"));
                                            purchaseLineItem.setCostCenter(jsono.isNull("CostCentre") ? "" : jsono.getString("CostCentre"));
                                            purchaseLineItem.setStoreCode(jsono.isNull("StoreCode") ? "" : jsono.getString("StoreCode"));
                                            purchaseLineItem.setTaxCode(jsono.isNull("TaxCode") ? "" : jsono.getString("TaxCode"));
                                            purchaseLineItem.setItemName(jsono.isNull("ItemName") ? "" : jsono.getString("ItemName"));
                                            purchaseLineItem.setCurrency(jsono.isNull("Currency") ? "" : jsono.getString("Currency"));
                                            purchaseLineItem.setCode(jsono.isNull("Code") ? "" : jsono.getString("Code"));
                                            purchaseLineItem.setIsDeleted(jsono.isNull("Deleted") ? false : jsono.getBoolean("Deleted"));
                                            purchaseLineItem.setPartNumber(jsono.isNull("PartNumber") ? "" : jsono.getString("PartNumber"));
                                            po.getItems().add((Object)purchaseLineItem);
                                        }
                                        JSONArray requestEditHistoryArray = jSONObject.getJSONArray("EditHistories");
                                        for (int j = 0; j < requestEditHistoryArray.length(); ++j) {
                                            JSONObject jsono = requestEditHistoryArray.getJSONObject(j);
                                            PurchaseOrder poEditHistory = new PurchaseOrder(PurchaseOrderPaneViewerPane.this.da);
                                            poEditHistory.setSapCode(jsono.isNull("SAPCode") ? "" : jsono.getString("SAPCode"));
                                            poEditHistory.DocEntry = jsono.isNull("DocEntry") ? 0 : jsono.getInt("DocEntry");
                                            poEditHistory.DockNum = jsono.isNull("DocNum") ? 0 : jsono.getInt("DocNum");
                                            poEditHistory.BaseDocumentNum = jsono.isNull("BaseDocumentNum") ? 0 : jsono.getInt("BaseDocumentNum");
                                            poEditHistory.setTotal(jsono.isNull("DocTotal") ? 0.0 : jsono.getDouble("DocTotal"));
                                            poEditHistory.setCode(jsono.isNull("Code") ? "" : jsono.getString("Code"));
                                            poEditHistory.setSupplierCode(jsono.isNull("VendorId") ? "" : jsono.getString("VendorId"));
                                            poEditHistory.setSupplierName(jsono.isNull("VendorName") ? "" : jsono.getString("VendorName"));
                                            dt = df.parse(jsono.getString("DocDate"));
                                            poEditHistory.setDateCreated(new Date(dt.getTime()));
                                            dt = df.parse(jsono.getString("DeliveryDate"));
                                            poEditHistory.setDueDate(new Date(dt.getTime()));
                                            poEditHistory.setStatus(jsono.isNull("Status") ? "" : jsono.getString("Status"));
                                            poEditHistory.createCommentProperty().set((Object)(jsono.isNull("Comment") ? "" : jsono.getString("Comment")));
                                            poEditHistory.createdByProperty().set((Object)(jsono.isNull("PurchasingOfficer") ? "" : jsono.getString("PurchasingOfficer")));
                                            poEditHistory.OrderNoProperty().set((Object)(jsono.isNull("OrderNo") ? "" : jsono.getString("OrderNo")));
                                            JSONArray lineArrayPdn = jsono.getJSONArray("LineItems");
                                            for (int k = 0; k < lineArrayPdn.length(); ++k) {
                                                JSONObject jsonoItem = lineArrayPdn.getJSONObject(k);
                                                PurchaseLineItem purchaseLineItem = new PurchaseLineItem(PurchaseOrderPaneViewerPane.this.da);
                                                purchaseLineItem.setParentPurchase(poEditHistory);
                                                purchaseLineItem.setLineNumber(jsonoItem.isNull("LineNumber") ? 0 : jsonoItem.getInt("LineNumber"));
                                                purchaseLineItem.setBaseLineNumber(jsonoItem.isNull("BaseLineNumber") ? 0 : jsonoItem.getInt("BaseLineNumber"));
                                                purchaseLineItem.setItemCode(jsonoItem.isNull("ItemCode") ? "" : jsonoItem.getString("ItemCode"));
                                                purchaseLineItem.setQuantity(jsonoItem.isNull("Qty") ? 0 : jsonoItem.getInt("Qty"));
                                                purchaseLineItem.setOpenQty(jsonoItem.isNull("OpenQty") ? 0 : jsonoItem.getInt("OpenQty"));
                                                purchaseLineItem.setPrice(jsonoItem.isNull("UnitPrice") ? 0.0 : jsonoItem.getDouble("UnitPrice"));
                                                purchaseLineItem.setCostCenter(jsonoItem.isNull("CostCentre") ? "" : jsonoItem.getString("CostCentre"));
                                                purchaseLineItem.setStoreCode(jsonoItem.isNull("StoreCode") ? "" : jsonoItem.getString("StoreCode"));
                                                purchaseLineItem.setTaxCode(jsonoItem.isNull("TaxCode") ? "" : jsonoItem.getString("TaxCode"));
                                                purchaseLineItem.setItemName(jsonoItem.isNull("ItemName") ? "" : jsonoItem.getString("ItemName"));
                                                purchaseLineItem.setCurrency(jsonoItem.isNull("Currency") ? "" : jsonoItem.getString("Currency"));
                                                purchaseLineItem.setCode(jsonoItem.isNull("Code") ? "" : jsonoItem.getString("Code"));
                                                purchaseLineItem.setPartNumber(jsonoItem.isNull("PartNumber") ? "" : jsonoItem.getString("PartNumber"));
                                                poEditHistory.getItems().add((Object)purchaseLineItem);
                                            }
                                            po.getPOHistory().add((Object)poEditHistory);
                                        }
                                        JSONArray requestArray = jSONObject.getJSONArray("DeliveryNotes");
                                        for (int j = 0; j < requestArray.length(); ++j) {
                                            JSONObject jsono = requestArray.getJSONObject(j);
                                            PurchaseDeliveryNote purchaseDeliveryNote = new PurchaseDeliveryNote(PurchaseOrderPaneViewerPane.this.da);
                                            purchaseDeliveryNote.setSapCode(jsono.isNull("SAPCode") ? "" : jsono.getString("SAPCode"));
                                            purchaseDeliveryNote.DocEntry = jsono.isNull("DocEntry") ? 0 : jsono.getInt("DocEntry");
                                            purchaseDeliveryNote.DockNum = jsono.isNull("DocNum") ? 0 : jsono.getInt("DocNum");
                                            purchaseDeliveryNote.BaseDocumentNum = jsono.isNull("BaseDocumentNum") ? 0 : jsono.getInt("BaseDocumentNum");
                                            purchaseDeliveryNote.setTotal(jsono.isNull("DocTotal") ? 0.0 : jsono.getDouble("DocTotal"));
                                            purchaseDeliveryNote.setCode(jsono.isNull("Code") ? "" : jsono.getString("Code"));
                                            purchaseDeliveryNote.setSupplierCode(jsono.isNull("VendorId") ? "" : jsono.getString("VendorId"));
                                            purchaseDeliveryNote.setSupplierName(jsono.isNull("VendorName") ? "" : jsono.getString("VendorName"));
                                            dt = df.parse(jsono.getString("DocDate"));
                                            purchaseDeliveryNote.setDateCreated(new Date(dt.getTime()));
                                            dt = df.parse(jsono.getString("DeliveryDate"));
                                            purchaseDeliveryNote.setDueDate(new Date(dt.getTime()));
                                            purchaseDeliveryNote.setStatus(jsono.isNull("Status") ? "" : jsono.getString("Status"));
                                            purchaseDeliveryNote.createCommentProperty().set((Object)(jsono.isNull("Comment") ? "" : jsono.getString("Comment")));
                                            purchaseDeliveryNote.createdByProperty().set((Object)(jsono.isNull("PurchasingOfficer") ? "" : jsono.getString("PurchasingOfficer")));
                                            purchaseDeliveryNote.setPoCode(jsono.isNull("ParentCode") ? "" : jsono.getString("ParentCode"));
                                            purchaseDeliveryNote.OrderNoProperty().set((Object)(jsono.isNull("OrderNo") ? "" : jsono.getString("OrderNo")));
                                            purchaseDeliveryNote.currency = po.getCurrency();
                                            JSONArray lineArrayPdn = jsono.getJSONArray("LineItems");
                                            for (int k = 0; k < lineArrayPdn.length(); ++k) {
                                                JSONObject jsonoItem = lineArrayPdn.getJSONObject(k);
                                                PurchaseLineItem purchaseLineItem = new PurchaseLineItem(PurchaseOrderPaneViewerPane.this.da);
                                                purchaseLineItem.setParentPurchase(purchaseDeliveryNote);
                                                purchaseLineItem.setLineNumber(jsonoItem.isNull("LineNumber") ? 0 : jsonoItem.getInt("LineNumber"));
                                                purchaseLineItem.setBaseLineNumber(jsonoItem.isNull("BaseLineNumber") ? 0 : jsonoItem.getInt("BaseLineNumber"));
                                                purchaseLineItem.setItemCode(jsonoItem.isNull("ItemCode") ? "" : jsonoItem.getString("ItemCode"));
                                                purchaseLineItem.setQuantity(jsonoItem.isNull("Qty") ? 0 : jsonoItem.getInt("Qty"));
                                                purchaseLineItem.setOpenQty(jsonoItem.isNull("OpenQty") ? 0 : jsonoItem.getInt("OpenQty"));
                                                purchaseLineItem.setPrice(jsonoItem.isNull("UnitPrice") ? 0.0 : jsonoItem.getDouble("UnitPrice"));
                                                purchaseLineItem.setCostCenter(jsonoItem.isNull("CostCentre") ? "" : jsonoItem.getString("CostCentre"));
                                                purchaseLineItem.setStoreCode(jsonoItem.isNull("StoreCode") ? "" : jsonoItem.getString("StoreCode"));
                                                purchaseLineItem.setTaxCode(jsonoItem.isNull("TaxCode") ? "" : jsonoItem.getString("TaxCode"));
                                                purchaseLineItem.setItemName(jsonoItem.isNull("ItemName") ? "" : jsonoItem.getString("ItemName"));
                                                purchaseLineItem.setCurrency(jsonoItem.isNull("Currency") ? "" : jsonoItem.getString("Currency"));
                                                purchaseLineItem.setCode(jsonoItem.isNull("Code") ? "" : jsonoItem.getString("Code"));
                                                purchaseLineItem.setTax(jsonoItem.isNull("TaxAmount") ? 0.0 : jsonoItem.getDouble("TaxAmount"));
                                                purchaseLineItem.setPartNumber(jsonoItem.isNull("PartNumber") ? "" : jsonoItem.getString("PartNumber"));
                                                purchaseLineItem.lineTotalWithTaxProperty().set(purchaseLineItem.getQuantity() == 0 ? purchaseLineItem.getPrice() + purchaseLineItem.getTax() : purchaseLineItem.getPrice() * (double)purchaseLineItem.getQuantity() + purchaseLineItem.getTax());
                                                purchaseDeliveryNote.getItems().add((Object)purchaseLineItem);
                                            }
                                            purchaseDeliveryNote.recalculateTotal();
                                            po.getDeleveryNotes().add((Object)purchaseDeliveryNote);
                                        }
                                        JSONArray historiesArray = jSONObject.getJSONArray("histories");
                                        for (int j = 0; j < historiesArray.length(); ++j) {
                                            JSONObject jsono = historiesArray.getJSONObject(j);
                                            POApprovalHistory pOApprovalHistory = new POApprovalHistory(PurchaseOrderPaneViewerPane.this.da);
                                            pOApprovalHistory.setStage(jsono.isNull("Stage") ? "" : jsono.getString("Stage"));
                                            pOApprovalHistory.setCode(jsono.isNull("Code") ? "" : jsono.getString("Code"));
                                            pOApprovalHistory.setApprovingUser(jsono.isNull("ApprovingUser") ? "" : jsono.getString("ApprovingUser"));
                                            dt = df.parse(jsono.getString("DateCreated"));
                                            pOApprovalHistory.setDateCreated(new Date(dt.getTime()));
                                            pOApprovalHistory.setRemark(jsono.isNull("Remark") ? "" : jsono.getString("Remark"));
                                            pOApprovalHistory.setActionTaken(jsono.isNull("ActionTaken") ? "" : jsono.getString("ActionTaken"));
                                            po.getHistories().add((Object)pOApprovalHistory);
                                        }
                                        po.resetNumbering();
                                        podl.getOriginalList().add((Object)po);
                                    }
                                    Platform.runLater(() -> {
                                        PurchaseOrderPaneViewerPane.this.stackPane.getChildren().remove((Object)box);
                                        PurchaseOrderPaneViewerPane.this.table1.getItems().clear();
                                        PurchaseOrderPaneViewerPane.this.purchaseOrderDataListAll.getOriginalList().clear();
                                        PurchaseOrderPaneViewerPane.this.purchaseOrderDataListAll.getOriginalList().addAll(podl.getOriginalList());
                                        podl.getOriginalList().forEach(x -> x.getItems().forEach(z -> x.setTotalAmount(x.getTotalAmount() + z.getTax() + z.getLineTotal())));
                                        PurchaseOrderPaneViewerPane.this.vbHistory1.getChildren().clear();
                                        PurchaseOrderPaneViewerPane.this.lblCurrStage1.setText("");
                                        PurchaseOrderPaneViewerPane.this.lblStatus1.setText("");
                                        PurchaseOrderPaneViewerPane.this.lblCurrency1.setText("");
                                        PurchaseOrderPaneViewerPane.this.lblTotal1.setText("");
                                        PurchaseOrderPaneViewerPane.this.table1.refresh();
                                        PurchaseOrderPaneViewerPane.this.approvalComment1.clear();
                                        PurchaseOrderPaneViewerPane.this.list1.setItems(PurchaseOrderPaneViewerPane.this.purchaseOrderDataListAll.getOriginalList());
                                        PurchaseOrderPaneViewerPane.this.list1.refresh();
                                    });
                                } else {
                                    Platform.runLater(() -> {
                                        PurchaseOrderPaneViewerPane.this.stackPane.getChildren().remove((Object)box);
                                        PurchaseOrderPaneViewerPane.this.table1.getItems().clear();
                                        PurchaseOrderPaneViewerPane.this.purchaseOrderDataListAll.getOriginalList().clear();
                                        PurchaseOrderPaneViewerPane.this.table1.refresh();
                                        PurchaseOrderPaneViewerPane.this.vbHistory1.getChildren().clear();
                                        PurchaseOrderPaneViewerPane.this.lblCurrStage1.setText("");
                                        PurchaseOrderPaneViewerPane.this.lblStatus1.setText("");
                                        PurchaseOrderPaneViewerPane.this.approvalComment1.clear();
                                        PurchaseOrderPaneViewerPane.this.lblCurrency1.setText("");
                                        PurchaseOrderPaneViewerPane.this.lblTotal1.setText("");
                                        PurchaseOrderPaneViewerPane.this.list1.setItems(PurchaseOrderPaneViewerPane.this.purchaseOrderDataListAll.getOriginalList());
                                        PurchaseOrderPaneViewerPane.this.list1.refresh();
                                        PurchaseOrderPaneViewerPane.this.mainPage.showNotification(NotificationType.Information, "No Purchase Request Found", PurchaseOrderPaneViewerPane.this);
                                    });
                                }
                            } else {
                                br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                stringBuilder = new StringBuilder();
                                while ((output = br.readLine()) != null) {
                                    System.out.println(output);
                                    stringBuilder.append(output + "\n");
                                }
                                br.close();
                                String fullError = stringBuilder.toString();
                                Platform.runLater(() -> {
                                    PurchaseOrderPaneViewerPane.this.stackPane.getChildren().remove((Object)box);
                                    PurchaseOrderPaneViewerPane.this.mainPage.showNotification(NotificationType.Error, fullError, PurchaseOrderPaneViewerPane.this);
                                });
                            }
                        }
                        catch (Exception e) {
                            Platform.runLater(() -> {
                                PurchaseOrderPaneViewerPane.this.stackPane.getChildren().remove((Object)box);
                                PurchaseOrderPaneViewerPane.this.mainPage.showNotification(NotificationType.Error, e.getMessage(), PurchaseOrderPaneViewerPane.this);
                            });
                        }
                        return null;
                    }
                };
            }
        };
        progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
        service.start();
    }
}

