/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXDatePicker;
import com.jfoenix.controls.JFXTextArea;
import com.jfoenix.controls.JFXTextField;
import com.xputertechnologies.santa.PromoVoucher;
import com.xputertechnologies.santa.ui.UIParent;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Collection;
import java.util.Date;
import java.util.Random;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;

public class PromoVoucherDialog
extends UIParent {
    @FXML
    private JFXDatePicker from;
    @FXML
    private JFXDatePicker to;
    @FXML
    private JFXTextField tbVoucherCount;
    @FXML
    private JFXTextField tbVoucherAmt;
    @FXML
    private JFXTextField tbVoucherAmtMin;
    @FXML
    private JFXTextArea tAreaRemark;
    @FXML
    private JFXButton btnDone;
    @FXML
    private JFXButton btnCancel;
    com.xputertechnologies.santa.ui.PromoVoucher parent;

    public PromoVoucherDialog(final com.xputertechnologies.santa.ui.PromoVoucher parent) {
        super("PromoVoucherDialog.fxml", parent.santa);
        this.santa = parent.santa;
        this.title = "Product";
        this.parent = parent;
        this.from.setValue((Object)LocalDate.now());
        this.to.setValue((Object)LocalDate.now());
        if (parent.isEdit) {
            this.tbVoucherCount.setText(Long.toString(parent.table.getItems().stream().filter(x -> x.getIsUsed() == false).count()));
            this.tAreaRemark.setDisable(true);
            this.tbVoucherCount.setDisable(true);
            this.tAreaRemark.setText(((PromoVoucher)parent.table.getItems().get(0)).getRemark());
        }
        this.btnDone.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (parent.isEdit) {
                    parent.table.getItems().stream().filter(x -> x.getIsUsed() == false).forEach(val -> {
                        val.setCreatedBy(PromoVoucherDialog.this.santa.currentUser.getUserName());
                        LocalDateTime nextTime = ((LocalDate)PromoVoucherDialog.this.from.getValue()).atTime(0, 0, 0);
                        Instant fromDate = nextTime.toInstant(ZoneOffset.UTC);
                        LocalDateTime nextTimeTill = ((LocalDate)PromoVoucherDialog.this.to.getValue()).atTime(22, 59, 0);
                        Instant fromDateTill = nextTimeTill.toInstant(ZoneOffset.UTC);
                        val.setValidFrom(Date.from(fromDate));
                        val.setValidTill(Date.from(fromDateTill));
                        val.setPromoVoucherAmt(Double.valueOf(PromoVoucherDialog.this.tbVoucherAmt.getText()));
                        val.setMinAmt(Double.valueOf(PromoVoucherDialog.this.tbVoucherAmtMin.getText()));
                    });
                } else {
                    int count = Integer.valueOf(PromoVoucherDialog.this.tbVoucherCount.getText());
                    int total = parent.table.getItems().size();
                    ObservableList list = FXCollections.observableArrayList();
                    for (int i = 0; i < count; ++i) {
                        PromoVoucher voucher = new PromoVoucher();
                        voucher.setCode(PromoVoucherDialog.this.generateVoucher(10));
                        voucher.setCreatedBy(PromoVoucherDialog.this.santa.currentUser.getUserName());
                        voucher.setIsUsed(false);
                        voucher.setRemark(PromoVoucherDialog.this.tAreaRemark.getText());
                        LocalDateTime nextTime = ((LocalDate)PromoVoucherDialog.this.from.getValue()).atTime(0, 0, 0);
                        Instant fromDate = nextTime.toInstant(ZoneOffset.UTC);
                        LocalDateTime nextTimeTill = ((LocalDate)PromoVoucherDialog.this.to.getValue()).atTime(22, 59, 0);
                        Instant fromDateTill = nextTimeTill.toInstant(ZoneOffset.UTC);
                        voucher.setValidFrom(Date.from(fromDate));
                        voucher.setValidTill(Date.from(fromDateTill));
                        voucher.setStatus("Pending");
                        voucher.setSn(String.valueOf(total + 1 + i));
                        voucher.setPromoVoucherAmt(Double.valueOf(PromoVoucherDialog.this.tbVoucherAmt.getText()));
                        voucher.setMinAmt(Double.valueOf(PromoVoucherDialog.this.tbVoucherAmtMin.getText()));
                        list.add((Object)voucher);
                    }
                    parent.table.getItems().addAll((Collection)list);
                    parent.table.refresh();
                }
                parent.dialog.close();
            }
        });
        this.btnCancel.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                parent.dialog.close();
            }
        });
    }

    String generateVoucher(int length) {
        String characters = "1234567890";
        StringBuilder result = new StringBuilder();
        while (length > 0) {
            Random rand = new Random();
            result.append("1234567890".charAt(rand.nextInt("1234567890".length())));
            --length;
        }
        return result.toString();
    }
}

