/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXCheckBox;
import com.jfoenix.controls.JFXComboBox;
import com.jfoenix.controls.JFXTextField;
import com.xputertechnologies.santa.NameValueObject;
import com.xputertechnologies.santa.NameValueObjectType;
import com.xputertechnologies.santa.StockItem;
import com.xputertechnologies.santa.ui.NewProductPane;
import com.xputertechnologies.santa.ui.UIParent;
import java.util.Collection;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.TextField;
import org.controlsfx.control.textfield.TextFields;

public class NewProductDialog
extends UIParent {
    @FXML
    private JFXTextField tbName;
    @FXML
    private JFXTextField tbItemCode;
    @FXML
    private JFXTextField tbPartNumber;
    @FXML
    private JFXComboBox cmbGroup;
    @FXML
    private JFXCheckBox chkActive;
    @FXML
    private JFXTextField tbItemUnit;
    @FXML
    private JFXComboBox<String> cmbManufacturer;
    @FXML
    private JFXButton btnSave;
    @FXML
    private JFXButton btnNew;
    @FXML
    private JFXButton btnCancel;
    StockItem product;
    NewProductPane parent;
    ObservableList<String> manufactures = FXCollections.observableArrayList();

    public NewProductDialog(final NewProductPane parent) {
        super("NewProductDialog.fxml", parent.santa);
        this.santa = parent.santa;
        this.title = "Product";
        this.parent = parent;
        ObservableList<NameValueObject> itemGroups = NameValueObject.select(NameValueObjectType.ItemGroups.name(), this.da);
        final ObservableList<NameValueObject> manufactureList = NameValueObject.select(NameValueObjectType.Manufacturers.name(), this.da);
        manufactureList.forEach(c -> this.manufactures.add((Object)c.getData()));
        this.cmbManufacturer.setItems(this.manufactures);
        this.cmbManufacturer.setEditable(true);
        TextFields.bindAutoCompletion((TextField)this.cmbManufacturer.getEditor(), (Collection)this.cmbManufacturer.getItems());
        if (parent.selectedStock == null) {
            this.product = new StockItem(this.da);
            this.product.setSn(parent.stockList.getOriginalList().size() + 1);
            this.product.setSyncFlag(false);
        } else {
            this.product = parent.selectedStock;
            if (this.product.getType() != null && !this.product.getType().isEmpty()) {
                this.cmbGroup.getSelectionModel().select((Object)itemGroups.stream().filter(k -> k.getData().equals(this.product.getType())).findAny().get());
            }
            if (this.product.getManufacture() != null && !this.product.getManufacture().isEmpty() && manufactureList.stream().filter(k -> k.getData().equals(this.product.getManufacture())).count() > 0L) {
                this.cmbManufacturer.getSelectionModel().select((Object)manufactureList.stream().filter(k -> k.getData().equals(this.product.getManufacture())).findAny().get().getData());
            }
        }
        this.chkActive.selectedProperty().bindBidirectional((Property)this.product.isActiveProperty());
        this.cmbGroup.setItems(itemGroups);
        this.cmbManufacturer.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (newValue != null && manufactureList.stream().filter(k -> k.getData().equals(newValue)).count() > 0L) {
                    NewProductDialog.this.product.setManufacture(newValue);
                }
            }
        });
        this.cmbGroup.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<NameValueObject>(){

            public void changed(ObservableValue<? extends NameValueObject> observable, NameValueObject oldValue, NameValueObject newValue) {
                if (newValue != null) {
                    NewProductDialog.this.product.setType(newValue.getData());
                }
            }
        });
        this.tbName.textProperty().bindBidirectional((Property)this.product.nameProperty());
        this.tbItemUnit.textProperty().bindBidirectional((Property)this.product.itemUnitProperty());
        this.tbItemCode.textProperty().bindBidirectional((Property)this.product.itemCodeProperty());
        this.btnCancel.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                parent.refreshTb();
                parent.dialog.close();
            }
        });
        this.btnSave.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (parent.selectedStock == null || !((String)parent.selectedStock.tempCodeProperty().get()).equals(NewProductDialog.this.product.tempCodeProperty().get())) {
                    parent.stockList.getOriginalList().add((Object)NewProductDialog.this.product);
                }
                parent.refreshTb();
                parent.dialog.close();
            }
        });
        this.btnNew.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                NewProductDialog.this.rebind();
            }
        });
    }

    public void rebind() {
        this.tbName.textProperty().unbindBidirectional((Property)this.product.nameProperty());
        this.tbItemUnit.textProperty().unbindBidirectional((Property)this.product.itemUnitProperty());
        this.tbItemCode.textProperty().unbindBidirectional((Property)this.product.itemCodeProperty());
        this.cmbGroup.getSelectionModel().clearSelection();
        this.cmbManufacturer.getSelectionModel().clearSelection();
        this.chkActive.selectedProperty().unbindBidirectional((Property)this.product.isActiveProperty());
        if (this.parent.selectedStock == null || !this.parent.selectedStock.getItemCode().equals(this.product.getItemCode())) {
            this.parent.stockList.getOriginalList().add((Object)this.product);
        }
        this.product = new StockItem(this.parent.da);
        this.product.setSn(this.parent.stockList.getOriginalList().size() + 1);
        this.product.setSyncFlag(false);
        this.tbName.textProperty().bindBidirectional((Property)this.product.nameProperty());
        this.tbItemCode.textProperty().bindBidirectional((Property)this.product.itemCodeProperty());
        this.chkActive.selectedProperty().bindBidirectional((Property)this.product.isActiveProperty());
        this.tbItemUnit.textProperty().bindBidirectional((Property)this.product.itemUnitProperty());
    }
}

