/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.xputertechnologies.santa.ManualPendingStatus;
import com.xputertechnologies.santa.NameValueObject;
import com.xputertechnologies.santa.Request;
import com.xputertechnologies.santa.RequestStatus;
import com.xputertechnologies.santa.Sale;
import com.xputertechnologies.santa.SaleStatus;
import com.xputertechnologies.santa.UserType;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.list.CompanyDataList;
import com.xputertechnologies.santa.list.RequestDataList;
import com.xputertechnologies.santa.list.SaleList;
import com.xputertechnologies.santa.list.StockItemList;
import com.xputertechnologies.santa.ui.AppInfoPane;
import com.xputertechnologies.santa.ui.DlgInterface;
import com.xputertechnologies.santa.ui.JFXNotifications;
import com.xputertechnologies.santa.ui.MenuControl;
import com.xputertechnologies.santa.ui.NotificationType;
import com.xputertechnologies.santa.ui.PromptDialog;
import com.xputertechnologies.santa.ui.Santa;
import com.xputertechnologies.santa.ui.TempRoleManagement;
import com.xputertechnologies.santa.ui.TransferPane;
import com.xputertechnologies.santa.ui.TransferReleasePane;
import com.xputertechnologies.santa.ui.UIParent;
import java.net.URISyntaxException;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SplitMenuButton;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.util.Duration;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.control.Notifications;

public class MainPage
extends UIParent {
    @FXML
    private SplitMenuButton splitUser;
    @FXML
    private MenuItem logOut;
    @FXML
    public ScrollPane hbCenter;
    public MenuControl menuControl = null;
    ArrayList<UIParent> pages = new ArrayList();
    @FXML
    public Button btnMenu;
    @FXML
    public Button btnCloseBusiness;
    @FXML
    public Button btnFormClose;
    @FXML
    public Button btnSucccess;
    @FXML
    public Button btnCancel;
    @FXML
    public Button btnBusinessDate;
    @FXML
    public Label lbllTittle;
    @FXML
    StackPane stackPane;
    @FXML
    private Label lblNotificatn;
    @FXML
    private Label lblSuccess;
    @FXML
    private Label lblNotifCancel;
    @FXML
    private Label lblCompanyName;
    @FXML
    private Button btnNo;
    @FXML
    private ImageView imgLogo;
    @FXML
    private HBox hboxYesNo;
    @FXML
    private BorderPane topPanel;
    @FXML
    public BorderPane pnlPositioning;
    @FXML
    private Button btnYes;
    Timeline timeline;
    @FXML
    public Button btnPrev;
    @FXML
    public BorderPane hbBottom;
    boolean isToMenu = true;
    public UIParent currentContent;
    public String notificationString;
    @FXML
    Dialog dialog;
    private ImageView ImgCloseBtn;
    int notificationTimeInSecond = 10;
    public List<NameValueObject> dimensions = new ArrayList<NameValueObject>();
    public SaleList saleList = null;
    public SaleList manualSaleList = null;

    public MainPage(final Santa santa) throws URISyntaxException {
        super("MainPage.fxml", santa);
        this.santa.mainpage = this;
        try {
            this.dimensions = StockItemList.selectAllNameValue(this.da, "SalesDimension", "Code", "Stream", "Name");
        }
        catch (SQLException ex) {
            Logger.getLogger(MainPage.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.loadSales();
        this.lbllTittle.setText("Main Page");
        this.splitUser.setText(this.currentUser.getUserName());
        Button button = new Button("notification");
        this.notificationPane = new NotificationPane((Node)button);
        this.notificationPane.setPrefHeight(40.0);
        this.notificationPane = this.notificationPane;
        this.logOut.setOnAction(v -> {
            try {
                santa.logOut();
            }
            catch (Exception ex) {
                Logger.getLogger(MainPage.class.getName()).log(Level.SEVERE, null, ex);
            }
        });
        this.setCompanyName();
        this.btnBusinessDate.setOnAction(v -> {
            try {
                this.dialog = new Dialog();
                this.dialog.initStyle(StageStyle.UTILITY);
                this.dialog.initOwner((Window)santa.stage);
                this.dialog.setTitle("Application Information");
                this.dialog.setResizable(true);
                this.dialog.getDialogPane().setContent((Node)new AppInfoPane(santa));
                this.dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.CANCEL});
                this.dialog.show();
            }
            catch (Exception ex) {
                Logger.getLogger(MainPage.class.getName()).log(Level.SEVERE, null, ex);
            }
        });
        this.btnCloseBusiness.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                MainPage.this.dialog = new Dialog();
                SimpleDateFormat sfd = new SimpleDateFormat("dd/MM/yyyy");
                final String date = sfd.format(Date.valueOf(santa.currentUser.getParentCompany().getCurrentDay()));
                new PromptDialog(santa, "Close Business", "This concludes Sale for the day,you will not be able to make sale for today " + date + " again.", MainPage.this.stackPane, new DlgInterface(){

                    @Override
                    public void ok() {
                        new PromptDialog(santa, "Confirm Business Close", "Are you sure you want to close business for today " + date + "?", MainPage.this.stackPane, new DlgInterface(){

                            @Override
                            public void ok() {
                                try {
                                    CompanyDataList companyDataList = new CompanyDataList(santa.da);
                                    santa.currentUser.getParentCompany().setCloseOfBusiness(true);
                                    Calendar calendar = Calendar.getInstance();
                                    calendar.setTime(Date.valueOf(santa.currentUser.getParentCompany().getCurrentDay()));
                                    calendar.add(5, 1);
                                    santa.currentUser.getParentCompany().setCurrentDay(new Date(calendar.getTime().getTime()).toLocalDate());
                                    companyDataList.getOriginalList().add((Object)santa.currentUser.getParentCompany());
                                    santa.currentUser.getParentCompany().setCloseOfBusiness(true);
                                    companyDataList.update();
                                    santa.logOut();
                                }
                                catch (Exception ex) {
                                    Logger.getLogger(MainPage.class.getName()).log(Level.SEVERE, null, ex);
                                }
                            }

                            @Override
                            public void cancel() {
                            }
                        });
                    }

                    @Override
                    public void cancel() {
                    }
                });
            }
        });
        this.menuControl = new MenuControl(this);
        this.menuControl.setTiles();
        this.hbCenter.setContent((Node)this.menuControl);
        this.hbBottom.setVisible(false);
        this.btnMenu.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                MainPage.this.backToMenu();
            }
        });
        this.btnPrev.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (!MainPage.this.hasParent) {
                    MainPage.this.isToMenu = true;
                }
                MainPage.this.previous();
            }
        });
        this.showNotificationRequest();
        this.pnlPositioning.setTop((Node)this.topPanel);
    }

    public void loadSales() {
        this.saleList = new SaleList(this.da);
        this.manualSaleList = new SaleList(this.da);
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime start = now.with(LocalTime.MIN);
        Timestamp startTime = Timestamp.valueOf(start);
        LocalDateTime end = now.with(LocalTime.MAX);
        Timestamp endTime = Timestamp.valueOf(end);
        this.saleList.selectAll("Select * From Sale  where   \"date\" >= " + startTime.getTime() + " And \"date\" <=" + endTime.getTime() + " ORDER by invoiceNumber DESC", this.da.getEmptyParameterValues());
        this.manualSaleList.selectAllFull("select * from Sale where syncflag = 0 and saleId='' and isManual = ? and manualSaleStatus <> ? and manualSaleStatus <> ? ", new ParameterValue[]{new ParameterValue("isManual", JDBCType.INTEGER, 1), new ParameterValue("manualSaleStatus", JDBCType.VARCHAR, ManualPendingStatus.Completed.name()), new ParameterValue("manualSaleStatus", JDBCType.VARCHAR, ManualPendingStatus.Declined.name())});
    }

    public void updateSalesList(ArrayList<Sale> sales) {
        sales.forEach(sa -> {
            Sale found;
            if (sa.getSaleStatus().equals(SaleStatus.COMPLETED.name())) {
                found = this.saleList.getOriginalList().stream().filter(prdct -> prdct.getInvoiceNumber() == sa.getInvoiceNumber()).findAny().orElse(null);
                if (found != null) {
                    found = sa;
                } else {
                    this.saleList.getOriginalList().add(sa);
                }
            }
            if (!sa.getManualSaleStatus().equals(ManualPendingStatus.Completed.name())) {
                found = this.manualSaleList.getOriginalList().stream().filter(prdct -> prdct.getInvoiceNumber() == sa.getInvoiceNumber()).findAny().orElse(null);
                sa.saleCreated = true;
                if (found != null) {
                    found.setApprovals(sa.getApprovals());
                    found.setSaleStatus(sa.getSaleStatus());
                    found.setSalesRejectedBy(sa.getSalesRejectedBy());
                } else {
                    this.manualSaleList.getOriginalList().add(sa);
                }
                if (this.menuControl != null && this.menuControl.salesPane != null) {
                    this.menuControl.salesPane.listManualSales.refresh();
                }
            }
        });
    }

    private void buildTopBar() {
        HBox hbBusinessClose = new HBox();
        hbBusinessClose.prefWidth(400.0);
        hbBusinessClose.setSpacing(10.0);
        hbBusinessClose.setAlignment(Pos.CENTER);
        this.imgLogo = new ImageView();
        this.imgLogo.setFitHeight(30.0);
        this.imgLogo.setFitWidth(120.0);
        this.imgLogo.setPickOnBounds(true);
        this.imgLogo.setPreserveRatio(true);
        this.lblCompanyName = new Label();
        this.lblCompanyName.setPrefHeight(16.0);
        this.lblCompanyName.setStyle("-fx-text-fill: white");
        this.lblCompanyName.setFont(Font.font((String)"Verdana", (double)15.0));
        this.lblCompanyName.setPadding(new Insets(0.0, 0.0, 0.0, 5.0));
        hbBusinessClose.getChildren().addAll((Object[])new Node[]{this.imgLogo, this.lblCompanyName});
        this.lbllTittle = new Label();
        this.lbllTittle.setStyle("-fx-text-fill: white;");
        this.lbllTittle.setFont(Font.font((String)"System", (FontWeight)FontWeight.BOLD, (double)14.0));
        BorderPane.setMargin((Node)this.lbllTittle, (Insets)new Insets(5.0, 0.0, 0.0, 0.0));
        HBox right = new HBox();
        BorderPane.setMargin((Node)right, (Insets)new Insets(5.0, 0.0, 3.0, 0.0));
        BorderPane.setAlignment((Node)right, (Pos)Pos.TOP_LEFT);
        this.btnBusinessDate = new Button();
        String css = "-fx-background-color:#7a0c5e,linear-gradient(#fefafb, #fce8f0),linear-gradient(#aa4b5b 0%, #752e3a 49%, #87515a 50%, #7a0c5e 100%);-fx-background-insets: 0,1,2;-fx-background-radius: 3,2,1;-fx-padding: 3 30 3 30;-fx-text-fill: white; -fx-font-size: 16px;";
        this.btnBusinessDate.setStyle(css);
        HBox.setMargin((Node)this.btnBusinessDate, (Insets)new Insets(5.0, 0.0, 0.0, 0.0));
        this.btnCloseBusiness = new Button("Close Business");
        HBox.setMargin((Node)this.btnBusinessDate, (Insets)new Insets(5.0, 10.0, 0.0, 10.0));
        String roundCss = "-fx-background-color: #349227;-fx-background-radius: 5em; -fx-min-width: 20px; -fx-min-height: 20px;-fx-max-width: 20px; -fx-max-height: 20px;-fx-text-fill: white;-fx-font-size: 12px;";
        this.btnSucccess = new Button();
        this.btnSucccess.setStyle(roundCss);
        this.lblSuccess = new Label();
        this.lblSuccess.setStyle("-fx-text-fill: white;");
        this.lblSuccess.setFont(Font.font((String)"System", (FontWeight)FontWeight.BOLD, (double)12.0));
        this.btnSucccess.setGraphic((Node)this.lblSuccess);
        HBox.setMargin((Node)this.btnSucccess, (Insets)new Insets(5.0, 0.0, 0.0, 0.0));
        this.btnCancel = new Button();
        this.btnCancel.setStyle(roundCss);
        this.lblNotifCancel = new Label();
        this.lblNotifCancel.setStyle("-fx-text-fill: white;");
        this.lblNotifCancel.setFont(Font.font((String)"System", (FontWeight)FontWeight.BOLD, (double)12.0));
        this.btnCancel.setGraphic((Node)this.lblSuccess);
        HBox.setMargin((Node)this.btnSucccess, (Insets)new Insets(5.0, 0.0, 0.0, 0.0));
        this.splitUser = new SplitMenuButton();
        this.logOut = new MenuItem("Logout");
        this.splitUser.getItems().add((Object)this.logOut);
        BorderPane.setMargin((Node)this.splitUser, (Insets)new Insets(0.0, 0.0, 5.0, 0.0));
        right.getChildren().addAll((Object[])new Node[]{this.btnBusinessDate, this.btnCloseBusiness, this.btnSucccess, this.btnCancel, this.splitUser});
    }

    public void showClosableNotification(int count) {
        Notifications notifications = Notifications.create().title("Transfer Notification").text("You have " + Integer.toString(count) + " New Notification").graphic((Node)new ImageView(new Image("/com/xputertechnologies/santa/ui/Images/transfertruck.png"))).hideAfter(Duration.seconds((double)5.0)).position(Pos.BOTTOM_RIGHT).onAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                try {
                    if (TempRoleManagement.wareHouseAlone(UserType.valueOf(MainPage.this.mainPage.currentUser.getRoleDescription()))) {
                        TransferReleasePane transferPane = new TransferReleasePane(MainPage.this.santa);
                        MainPage.this.pnlPositioning.getTop().setVisible(true);
                        MainPage.this.lbllTittle.setText(transferPane.title);
                        MainPage.this.hbCenter.setContent((Node)transferPane);
                    } else {
                        TransferPane transferPane = new TransferPane(MainPage.this.santa);
                        MainPage.this.pnlPositioning.getTop().setVisible(true);
                        MainPage.this.lbllTittle.setText(transferPane.title);
                        MainPage.this.hbCenter.setContent((Node)transferPane);
                    }
                }
                catch (Exception ex) {
                    Logger.getLogger(MenuControl.class.getName()).log(Level.SEVERE, null, ex);
                }
                MainPage.this.setBottomVisibilityTrue();
            }
        });
        notifications.show();
    }

    public void showNotificationRequest() {
        String style = "-fx-background-color: #349227; -fx-background-radius: 5em; -fx-min-width: 20px; -fx-min-height: 20px; -fx-max-width: 20px; -fx-max-height: 20px; -fx-text-fill: white; -fx-font-size: 12px; ";
        RequestDataList requestDataList = new RequestDataList(this.da);
        requestDataList.selectAll("Select * From Request where isNew=?", new ParameterValue[]{new ParameterValue("isNew", JDBCType.CHAR, true)});
        if (requestDataList.getOriginalList().size() > 0) {
            Object timer;
            int counter;
            Object s;
            final ObservableList requestsSuccess = requestDataList.getOriginalList().stream().filter(p -> p.getStatus().equals(RequestStatus.APPROVED.name())).collect(Collectors.collectingAndThen(Collectors.toList(), l -> FXCollections.observableArrayList((Collection)l)));
            final ObservableList requestsCancelled = requestDataList.getOriginalList().stream().filter(p -> p.getStatus().equals(RequestStatus.CANCELLED.name())).collect(Collectors.collectingAndThen(Collectors.toList(), l -> FXCollections.observableArrayList((Collection)l)));
            if (requestsSuccess.size() > 0) {
                s = "";
                counter = 0;
                for (Request request : requestsSuccess) {
                    s = (String)s + "(" + Integer.toString(++counter) + "). Your " + request.getRequestType() + " Request raised on the " + request.getRequestDate().toString() + " \n By user (" + request.getoriginatedUser() + ") has been approved.";
                }
                if (requestsCancelled.size() == 0) {
                    this.btnCancel.setVisible(false);
                }
                this.btnSucccess.setVisible(true);
                timer = new Timer();
                ((Timer)timer).scheduleAtFixedRate(new TimerTask(){

                    @Override
                    public void run() {
                        Platform.runLater(() -> MainPage.this.lblSuccess.setText(Integer.toString(requestsSuccess.size())));
                    }
                }, 1000L, 1000L);
                Tooltip tpSuccess = new Tooltip((String)s);
                this.btnSucccess.setTooltip(tpSuccess);
                this.btnSucccess.setOnAction(e -> {
                    TransferPane transferPane = new TransferPane(this.santa);
                    this.pnlPositioning.getTop().setVisible(true);
                    this.lbllTittle.setText(transferPane.title);
                    this.hbCenter.setContent((Node)transferPane);
                    this.setBottomVisibilityTrue();
                });
            }
            if (requestsCancelled.size() > 0) {
                s = "";
                counter = 0;
                for (Request request : requestsCancelled) {
                    s = (String)s + Integer.toString(++counter) + " Your " + request.getRequestType() + " Request raised on the " + request.getRequestDate().toString() + " \n By " + request.getoriginatedUser() + " has been cancelled.";
                }
                if (requestsSuccess.size() == 0) {
                    this.btnSucccess.setVisible(false);
                }
                this.btnCancel.setVisible(true);
                timer = new Timer();
                ((Timer)timer).scheduleAtFixedRate(new TimerTask(){

                    @Override
                    public void run() {
                        Platform.runLater(() -> MainPage.this.lblNotifCancel.setText(Integer.toString(requestsCancelled.size())));
                    }
                }, 1000L, 1000L);
                Tooltip tpCancel = new Tooltip((String)s);
                this.btnCancel.setTooltip(tpCancel);
                this.btnCancel.setOnAction(e -> {
                    TransferPane transferPane = new TransferPane(this.santa);
                    this.pnlPositioning.getTop().setVisible(true);
                    this.lbllTittle.setText(transferPane.title);
                    this.hbCenter.setContent((Node)transferPane);
                    this.setBottomVisibilityTrue();
                });
            }
        } else {
            this.btnCancel.setVisible(false);
            this.btnSucccess.setVisible(false);
        }
    }

    public void showAppNotification(String text) {
        if (this.currentContent != null) {
            this.showNotification(NotificationType.Information, text, this.currentContent);
        }
    }

    public void resetTitle() {
    }

    @Override
    public void closeNotification() {
        this.resetTitle();
    }

    public boolean yesNotification() {
        this.pnlPositioning.getTop().setVisible(false);
        return true;
    }

    public boolean noNotification() {
        this.pnlPositioning.getTop().setVisible(false);
        return false;
    }

    public void showChild(UIParent child) {
        child.hasParent = true;
        child.mainParent = (UIParent)this.hbCenter.getContent();
        this.hbCenter.setContent((Node)child);
        this.lbllTittle.setText(child.title);
        this.btnMenu.setVisible(false);
    }

    private void backToMenu() {
        this.hbCenter.setContent((Node)this.menuControl);
        this.menuControl.setTiles();
        this.lbllTittle.setText("Main Page");
        this.hbBottom.setVisible(false);
        this.resetTitle();
        if (this.timeline != null) {
            this.timeline.stop();
        }
        this.pnlPositioning.getTop().setVisible(true);
    }

    public void setBottomVisibilityTrue() {
        this.hbBottom.setVisible(true);
    }

    public void setBottomVisibilityFalse() {
        this.hbBottom.setVisible(false);
    }

    public void hideShowNotification(String msg) {
        this.pnlPositioning.setTop((Node)this.topPanel);
    }

    public void setContent(UIParent node, Boolean visibleTop) {
        this.pnlPositioning.getTop().setVisible(visibleTop.booleanValue());
        this.lbllTittle.setText(node.title);
        this.hbCenter.setContent((Node)node);
        this.currentContent = node;
    }

    public void showNotification(NotificationType notificationType, String msg, UIParent content) {
        if (content != null) {
            this.currentContent = content;
        }
        if (this.timeline != null) {
            this.timeline.stop();
        }
        if (notificationType == NotificationType.Error) {
            JFXNotifications.create().title("Error").text(msg).hideAfter(Duration.seconds((double)5.0)).owner((Window)this.santa.stage).position(Pos.BOTTOM_RIGHT).showError();
        } else if (notificationType == NotificationType.Success) {
            JFXNotifications.create().title("Success ").text(msg).hideAfter(Duration.seconds((double)5.0)).owner((Window)this.santa.stage).position(Pos.BOTTOM_RIGHT).showSuccess();
        } else if (notificationType == NotificationType.Information) {
            JFXNotifications.create().title("Info").text(msg).hideAfter(Duration.seconds((double)5.0)).owner((Window)this.santa.stage).position(Pos.BOTTOM_RIGHT).showInfo();
        } else {
            JFXNotifications.create().title("Info").text(msg).hideAfter(Duration.seconds((double)5.0)).owner((Window)this.santa.stage).position(Pos.BOTTOM_RIGHT).showMessage();
        }
    }

    private void previous() {
        UIParent d = (UIParent)this.hbCenter.getContent();
        int getPosition = this.santa.getScenes().indexOf((Object)d);
        if (getPosition >= 0 && d.validateControl()) {
            if (getPosition == 0 || this.isToMenu) {
                if (!d.needToSave) {
                    this.backToMenu();
                    return;
                }
                d.completeControl();
                if (!this.isToMenu) {
                    return;
                }
                this.backToMenu();
                return;
            }
            this.hbCenter.setContent((Node)this.santa.getScenes().get(getPosition - 1));
            this.hbBottom.setVisible(true);
        } else if (d.mainParent != null && d.validateControl()) {
            getPosition = this.santa.getScenes().indexOf((Object)d.mainParent);
            d.completeControl();
            this.hbCenter.setContent((Node)d.mainParent);
            d.mainParent.backFromChild();
            this.hbBottom.setVisible(true);
            this.btnMenu.setVisible(true);
            this.lbllTittle.setText(d.mainParent.title);
        } else if (!d.validateControl() && d.mainParent != null) {
            d.completeControl();
        } else {
            this.backToMenu();
        }
    }

    private void setCompanyName() {
        if (this.currentUser != null) {
            this.lblCompanyName.setText(this.currentUser.getParentCompany().getStoreName());
        }
    }
}

