/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.xputertechnologies.santa.ui.JFXNotificationBar;
import com.xputertechnologies.santa.ui.MainPage;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.ParallelTransition;
import javafx.animation.Timeline;
import javafx.animation.Transition;
import javafx.beans.value.WritableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.geometry.Pos;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.image.ImageView;
import javafx.stage.Popup;
import javafx.stage.PopupWindow;
import javafx.stage.Screen;
import javafx.stage.Window;
import javafx.util.Duration;

public class JFXNotifications {
    private String title;
    private String text;
    private String typeMessage;
    private Node graphic;
    private Pos position = Pos.BOTTOM_RIGHT;
    private Duration hideAfterDuration = Duration.seconds((double)5.0);
    private boolean hideCloseButton;
    private EventHandler<ActionEvent> onAction;
    private Window owner;
    private Screen screen = Screen.getPrimary();
    private List<String> styleClass = new ArrayList<String>();

    private JFXNotifications() {
    }

    public static JFXNotifications create() {
        return new JFXNotifications();
    }

    public JFXNotifications text(String text) {
        this.text = text;
        return this;
    }

    public JFXNotifications title(String title) {
        this.title = title;
        return this;
    }

    public JFXNotifications graphic(Node graphic) {
        this.graphic = graphic;
        return this;
    }

    public JFXNotifications position(Pos position) {
        this.position = position;
        return this;
    }

    public JFXNotifications owner(Window owner) {
        this.owner = owner;
        return this;
    }

    public JFXNotifications hideAfter(Duration duration) {
        this.hideAfterDuration = duration;
        return this;
    }

    public JFXNotifications onAction(EventHandler<ActionEvent> onAction) {
        this.onAction = onAction;
        return this;
    }

    public JFXNotifications hideCloseButton() {
        this.hideCloseButton = true;
        return this;
    }

    public void showMessage() {
        this.graphic((Node)new ImageView(JFXNotifications.class.getResource("dialog-message.png").toExternalForm()));
        this.typeMessage = "MESSAGE";
        this.show();
    }

    public void showSuccess() {
        this.graphic((Node)new ImageView(JFXNotifications.class.getResource("dialog-success.png").toExternalForm()));
        this.typeMessage = "SUCCESS";
        this.show();
    }

    public void showError() {
        this.graphic((Node)new ImageView(JFXNotifications.class.getResource("dialog-error.png").toExternalForm()));
        this.typeMessage = "ERROR";
        this.show();
    }

    public void showWarning() {
        this.graphic((Node)new ImageView(JFXNotifications.class.getResource("warning_32.png").toExternalForm()));
        this.typeMessage = "WARNING";
        this.show();
    }

    public void showInfo() {
        this.graphic((Node)new ImageView(JFXNotifications.class.getResource("dialog-warning.png").toExternalForm()));
        this.typeMessage = "INFO";
        this.show();
    }

    private void show() {
        NotificationPopupHandler.getInstance().show(this);
    }

    public static Window getWindow(Object owner) throws IllegalArgumentException {
        if (owner == null) {
            Window window = null;
            ObservableList windows = Window.getWindows();
            for (int i = 0; i < windows.size() && (!((Window)windows.get(i)).isFocused() || windows.get(i) instanceof PopupWindow); ++i) {
            }
            return window;
        }
        if (owner instanceof Window) {
            return (Window)owner;
        }
        if (owner instanceof Node) {
            return ((MainPage)((Object)owner)).santa.stage.getOwner();
        }
        throw new IllegalArgumentException("Unknown owner: " + owner.getClass());
    }

    private static final class NotificationPopupHandler {
        private static final NotificationPopupHandler INSTANCE = new NotificationPopupHandler();
        private double startX;
        private double startY;
        private double screenWidth;
        private double screenHeight;
        private final Map<Pos, List<Popup>> popupsMap = new HashMap<Pos, List<Popup>>();
        private final double padding = 15.0;
        private ParallelTransition parallelTransition = new ParallelTransition();
        private boolean isShowing = false;

        private NotificationPopupHandler() {
        }

        static final NotificationPopupHandler getInstance() {
            return INSTANCE;
        }

        public void show(JFXNotifications notification) {
            Window window;
            if (notification.owner == null) {
                Rectangle2D screenBounds = notification.screen.getVisualBounds();
                this.startX = screenBounds.getMinX();
                this.startY = screenBounds.getMinY();
                this.screenWidth = screenBounds.getWidth();
                this.screenHeight = screenBounds.getHeight();
                window = JFXNotifications.getWindow(null);
            } else {
                this.startX = notification.owner.getX();
                this.startY = notification.owner.getY();
                this.screenWidth = notification.owner.getWidth();
                this.screenHeight = notification.owner.getHeight();
                window = notification.owner;
            }
            this.show(window, notification);
        }

        private void show(Window owner, final JFXNotifications notification) {
            Window ownerWindow = owner;
            while (ownerWindow instanceof PopupWindow) {
                ownerWindow = ((PopupWindow)ownerWindow).getOwnerWindow();
            }
            Scene ownerScene = notification.owner.getScene();
            if (ownerScene != null) {
                String stylesheetUrl = JFXNotifications.class.getResource("notificationpopup.css").toExternalForm();
                if (!ownerScene.getStylesheets().contains((Object)stylesheetUrl)) {
                    ownerScene.getStylesheets().add(0, (Object)stylesheetUrl);
                }
            }
            final Popup popup = new Popup();
            popup.setAutoFix(false);
            final Pos p = notification.position;
            JFXNotificationBar notificationBar = new JFXNotificationBar(){

                @Override
                public String getTitle() {
                    return notification.title;
                }

                @Override
                public String getText() {
                    return notification.text;
                }

                @Override
                public String getTypeNotification() {
                    return notification.typeMessage;
                }

                @Override
                public Node getGraphic() {
                    return notification.graphic;
                }

                @Override
                public boolean isShowing() {
                    return isShowing;
                }

                protected double computeMinWidth(double height) {
                    String text = this.getText();
                    Node graphic = this.getGraphic();
                    if ((text == null || text.isEmpty()) && graphic != null) {
                        return graphic.minWidth(height);
                    }
                    return 400.0;
                }

                @Override
                protected double computeMinHeight(double width) {
                    String text = this.getText();
                    Node graphic = this.getGraphic();
                    if ((text == null || text.isEmpty()) && graphic != null) {
                        return graphic.minHeight(width);
                    }
                    return 100.0;
                }

                @Override
                public boolean isShowFromTop() {
                    return this.isShowFromTop(notification.position);
                }

                @Override
                public void hide() {
                    isShowing = false;
                    this.createHideTimeline(popup, this, p, Duration.ZERO).play();
                }

                @Override
                public boolean isCloseButtonVisible() {
                    return !notification.hideCloseButton;
                }

                @Override
                public double getContainerHeight() {
                    return startY + screenHeight;
                }

                @Override
                public void relocateInParent(double x, double y) {
                    switch (p) {
                        case BOTTOM_LEFT: 
                        case BOTTOM_CENTER: 
                        case BOTTOM_RIGHT: {
                            popup.setAnchorY(y - 15.0);
                            break;
                        }
                    }
                }
            };
            notificationBar.getStyleClass().addAll((Collection)notification.styleClass);
            notificationBar.setOnMouseClicked(e -> {
                if (notification.onAction != null) {
                    ActionEvent actionEvent = new ActionEvent((Object)notificationBar, (EventTarget)notificationBar);
                    notification.onAction.handle((Event)actionEvent);
                    this.createHideTimeline(popup, notificationBar, p, Duration.ZERO).play();
                }
            });
            popup.getContent().add((Object)notificationBar);
            popup.show(owner, 0.0, 0.0);
            double anchorX = 0.0;
            double anchorY = 0.0;
            double barWidth = notificationBar.getWidth();
            double barHeight = notificationBar.getHeight();
            switch (p) {
                case BOTTOM_LEFT: 
                case TOP_LEFT: 
                case CENTER_LEFT: {
                    anchorX = 15.0 + this.startX;
                    break;
                }
                case BOTTOM_CENTER: 
                case TOP_CENTER: 
                case CENTER: {
                    anchorX = this.startX + this.screenWidth / 2.0 - barWidth / 2.0 - 7.5;
                    break;
                }
                default: {
                    anchorX = this.startX + this.screenWidth - barWidth - 15.0;
                }
            }
            switch (p) {
                case TOP_LEFT: 
                case TOP_CENTER: 
                case TOP_RIGHT: {
                    anchorY = 15.0 + this.startY;
                    break;
                }
                case CENTER_LEFT: 
                case CENTER: 
                case CENTER_RIGHT: {
                    anchorY = this.startY + this.screenHeight / 2.0 - barHeight / 2.0 - 7.5;
                    break;
                }
                default: {
                    anchorY = this.startY + this.screenHeight - barHeight - 15.0;
                }
            }
            popup.setAnchorX(anchorX);
            popup.setAnchorY(anchorY);
            this.isShowing = true;
            notificationBar.doShow();
            this.addPopupToMap(p, popup);
            Timeline timeline = this.createHideTimeline(popup, notificationBar, p, notification.hideAfterDuration);
            timeline.play();
        }

        private void hide(Popup popup, Pos p) {
            popup.hide();
            this.removePopupFromMap(p, popup);
        }

        private Timeline createHideTimeline(final Popup popup, JFXNotificationBar bar, final Pos p, Duration startDelay) {
            KeyValue fadeOutBegin = new KeyValue((WritableValue)bar.opacityProperty(), (Object)1.0);
            KeyValue fadeOutEnd = new KeyValue((WritableValue)bar.opacityProperty(), (Object)0.0);
            KeyFrame kfBegin = new KeyFrame(Duration.ZERO, new KeyValue[]{fadeOutBegin});
            KeyFrame kfEnd = new KeyFrame(Duration.millis((double)500.0), new KeyValue[]{fadeOutEnd});
            Timeline timeline = new Timeline(new KeyFrame[]{kfBegin, kfEnd});
            timeline.setDelay(startDelay);
            timeline.setOnFinished((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent e) {
                    this.hide(popup, p);
                }
            });
            return timeline;
        }

        private void addPopupToMap(Pos p, Popup popup) {
            List<Object> popups;
            if (!this.popupsMap.containsKey(p)) {
                popups = new LinkedList();
                this.popupsMap.put(p, popups);
            } else {
                popups = this.popupsMap.get(p);
            }
            this.doAnimation(p, popup);
            popups.add(popup);
        }

        private void removePopupFromMap(Pos p, Popup popup) {
            if (this.popupsMap.containsKey(p)) {
                List<Popup> popups = this.popupsMap.get(p);
                popups.remove(popup);
            }
        }

        private void doAnimation(Pos p, Popup changedPopup) {
            Popup _popup;
            int i;
            List<Popup> popups = this.popupsMap.get(p);
            if (popups == null) {
                return;
            }
            double newPopupHeight = ((Node)changedPopup.getContent().get(0)).getBoundsInParent().getHeight();
            this.parallelTransition.stop();
            this.parallelTransition.getChildren().clear();
            boolean isShowFromTop = this.isShowFromTop(p);
            double sum = 0.0;
            double[] targetAnchors = new double[popups.size()];
            for (i = popups.size() - 1; i >= 0; --i) {
                _popup = popups.get(i);
                double popupHeight = ((Node)_popup.getContent().get(0)).getBoundsInParent().getHeight();
                if (isShowFromTop) {
                    sum = i == popups.size() - 1 ? this.startY + newPopupHeight + 15.0 : (sum += popupHeight);
                    targetAnchors[i] = sum;
                    continue;
                }
                sum = i == popups.size() - 1 ? changedPopup.getAnchorY() - popupHeight : (sum -= popupHeight);
                targetAnchors[i] = sum;
            }
            for (i = popups.size() - 1; i >= 0; --i) {
                _popup = popups.get(i);
                double anchorYTarget = targetAnchors[i];
                if (anchorYTarget < 0.0) {
                    _popup.hide();
                }
                double oldAnchorY = _popup.getAnchorY();
                double distance = anchorYTarget - oldAnchorY;
                CustomTransition t = new CustomTransition(_popup, oldAnchorY, distance);
                t.setCycleCount(1);
                this.parallelTransition.getChildren().add((Object)t);
            }
            this.parallelTransition.play();
        }

        private boolean isShowFromTop(Pos p) {
            switch (p) {
                case TOP_LEFT: 
                case TOP_CENTER: 
                case TOP_RIGHT: {
                    return true;
                }
            }
            return false;
        }

        class CustomTransition
        extends Transition {
            private WeakReference<Popup> popupWeakReference;
            private double oldAnchorY;
            private double distance;

            CustomTransition(Popup popup, double oldAnchorY, double distance) {
                this.popupWeakReference = new WeakReference<Popup>(popup);
                this.oldAnchorY = oldAnchorY;
                this.distance = distance;
                this.setCycleDuration(Duration.millis((double)350.0));
            }

            protected void interpolate(double frac) {
                Popup popup = (Popup)this.popupWeakReference.get();
                if (popup != null) {
                    double newAnchorY = this.oldAnchorY + this.distance * frac;
                    popup.setAnchorY(newAnchorY);
                }
            }
        }
    }
}

