/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXCheckBox;
import com.jfoenix.controls.JFXTextArea;
import com.jfoenix.controls.JFXTextField;
import com.xputertechnologies.santa.BatchStatusEnum;
import com.xputertechnologies.santa.ui.AdminPaymentBatchPane;
import com.xputertechnologies.santa.ui.General;
import com.xputertechnologies.santa.ui.NotificationType;
import com.xputertechnologies.santa.ui.UIParent;
import javafx.beans.property.Property;
import javafx.beans.property.StringProperty;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.input.KeyEvent;
import javafx.util.StringConverter;
import javafx.util.converter.DoubleStringConverter;
import javafx.util.converter.IntegerStringConverter;

public class AdminPaymentBatchEdit
extends UIParent {
    protected StringConverter<? extends Number> dConverter = new DoubleStringConverter(){

        public String toString(Double object) {
            if (object != null) {
                return General.formatDecimalToMoneyString(object);
            }
            return null;
        }

        public Double fromString(String string) {
            Double d = 0.0;
            if (!string.isEmpty()) {
                string = string.replace(",", "");
                d = Double.parseDouble(string);
            }
            return d;
        }
    };
    @FXML
    private JFXCheckBox chkPass;
    @FXML
    private Label lblBatchNo;
    @FXML
    private Label lblAmtDeposited;
    @FXML
    private JFXTextField tbTellerNo;
    @FXML
    private Label lblBalance;
    @FXML
    private JFXTextField tbBalance;
    @FXML
    private JFXTextArea tArearemark;
    @FXML
    private JFXButton btnDone;
    @FXML
    private JFXButton btnCancel;
    protected StringConverter<? extends Number> intConverter = new IntegerStringConverter(){

        public String toString(Integer object) {
            if (object != null) {
                return Integer.toString(object);
            }
            return null;
        }

        public Integer fromString(String string) {
            Integer d = 0;
            if (!string.isEmpty()) {
                string = string.replace(",", "");
                d = Integer.parseInt(string);
            }
            return d;
        }
    };
    AdminPaymentBatchPane parent;
    String errormsg = "";

    public AdminPaymentBatchEdit(AdminPaymentBatchPane parent) {
        super("AdminPaymentBatchEdit.fxml", parent.santa);
        this.santa = parent.santa;
        this.title = "Payment Batch Edit";
        this.parent = parent;
        this.lblBatchNo.setText(parent.selectedPaymentBatch.getBatchCode());
        this.lblAmtDeposited.setText(String.valueOf(parent.selectedPaymentBatch.initialAmountDeposited));
        this.tbTellerNo.textProperty().bindBidirectional((Property)parent.selectedPaymentBatch.tellerNoProperty());
        double balance = parent.selectedPaymentBatch.getAmount() - parent.selectedPaymentBatch.initialAmt;
        this.lblBalance.setText("Balance(" + String.valueOf(balance) + "):");
        this.chkPass.setDisable(parent.selectedPaymentBatch.getAmountDeposited() <= parent.selectedPaymentBatch.getAmount());
        if (balance > 0.0) {
            this.tbBalance.textProperty().bindBidirectional((Property)parent.selectedPaymentBatch.currentAmtProperty(), this.dConverter);
        } else {
            this.tbBalance.setDisable(true);
        }
        this.tArearemark.textProperty().bindBidirectional((Property)parent.selectedPaymentBatch.adminRemarkProperty());
        this.btnDone.setOnAction(v -> {
            if (this.validate()) {
                if (parent.selectedPaymentBatch.currentAmtProperty().get() + parent.selectedPaymentBatch.initialAmt == parent.selectedPaymentBatch.getAmount() || this.chkPass.selectedProperty().get()) {
                    parent.selectedPaymentBatch.setStatus(BatchStatusEnum.Passed.name());
                }
                if (parent.selectedPaymentBatch.currentAmtProperty().get() + parent.selectedPaymentBatch.initialAmt != parent.selectedPaymentBatch.getAmount() && !this.chkPass.selectedProperty().get()) {
                    parent.selectedPaymentBatch.setStatus(BatchStatusEnum.Failed.name());
                }
                parent.dialog.close();
            } else {
                parent.mainPage.showNotification(NotificationType.Information, this.errormsg, parent);
            }
        });
        this.btnCancel.setOnAction(v -> parent.dialog.close());
        this.tbBalance.textProperty().addListener((observable, oldValue, newValue) -> {
            try {
                Double i = Double.valueOf(newValue);
                if (!(i >= 0.0) || !(i <= balance)) {
                    ((StringProperty)observable).setValue(oldValue);
                }
            }
            catch (Exception e) {
                ((StringProperty)observable).setValue(oldValue);
            }
        });
        this.tbBalance.addEventFilter(KeyEvent.KEY_TYPED, General.decimal_validation());
    }

    private boolean validate() {
        this.errormsg = "";
        if (this.parent.selectedPaymentBatch.getAdminRemark().isEmpty()) {
            this.errormsg = "Please supply remark/comment";
        }
        if (this.parent.selectedPaymentBatch.getTellerNo().isEmpty()) {
            this.errormsg = this.errormsg + "Please supply teller Number";
        }
        return this.errormsg.isEmpty();
    }
}

