/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.report;

import java.io.IOException;
import java.io.Writer;
import java.util.List;

public class CSVUtils {
    private static final char DEFAULT_SEPERATOR = ',';

    public static void writeLine(Writer w, List<String> values) throws IOException {
        CSVUtils.writeLine(w, values, ',', ' ');
    }

    public static void writeLine(Writer w, List<String> values, char separators) {
        CSVUtils.writeLine(w, values, ' ');
    }

    private static String followCSVFormat(String value) {
        Object result = value;
        if (((String)result).contains("\"")) {
            result = ((String)result).replaceAll("\"", "\"\"");
        }
        result = "\"" + (String)result + "\"";
        return result;
    }

    public static void writeLine(Writer w, List<String> values, char separators, char cutomQuotes) throws IOException {
        boolean first = true;
        if (separators == ' ') {
            separators = (char)44;
        }
        StringBuilder sb = new StringBuilder();
        for (String value : values) {
            if (!first) {
                sb.append(separators);
            }
            if (cutomQuotes == ' ') {
                sb.append(CSVUtils.followCSVFormat(value));
            } else {
                sb.append(cutomQuotes).append(CSVUtils.followCSVFormat(value)).append(cutomQuotes);
            }
            first = false;
        }
        sb.append("\n");
        w.append(sb.toString());
    }
}

