/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.list;

import com.xputertechnologies.santa.NameValueObject;
import com.xputertechnologies.santa.NameValueObjectType;
import com.xputertechnologies.santa.SearchClass;
import com.xputertechnologies.santa.StockItem;
import com.xputertechnologies.santa.StockItemData;
import com.xputertechnologies.santa.core.DataAccess;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.core.SearchCondition;
import com.xputertechnologies.santa.list.DataList;
import com.xputertechnologies.santa.list.SaleList;
import java.sql.JDBCType;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class StockItemList
extends DataList<StockItem> {
    int counter = 0;

    public StockItemList(DataAccess da) {
        this.t = new StockItem(da);
    }

    public StockItemList() {
    }

    @Override
    public void select() {
    }

    public void resetNumbering() {
        this.counter = 0;
        this.getOriginalList().forEach(val -> {
            ++this.counter;
            val.setSn(this.counter);
        });
    }

    public int countStock() {
        try {
            ResultSet rslt = this.getDataAccess().select("select count(*) as Total from STOCKITEM", this.getDataAccess().getEmptyParameterValues());
            if (rslt != null) {
                if (rslt.next()) {
                    return rslt.getInt("Total");
                }
                rslt.close();
                this.getDataAccess().closeConnection();
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(SaleList.class.getName()).log(Level.SEVERE, null, ex);
        }
        return 0;
    }

    public void searchStock(String searchString) {
        ArrayList<ParameterValue> tempParamValue = new ArrayList<ParameterValue>();
        tempParamValue.add(new ParameterValue("barCode", JDBCType.VARCHAR, "%" + searchString + "%"));
        tempParamValue.add(new ParameterValue("companyName", JDBCType.VARCHAR, "%" + searchString + "%"));
        tempParamValue.add(new ParameterValue("maker", JDBCType.VARCHAR, "%" + searchString + "%"));
        tempParamValue.add(new ParameterValue("name", JDBCType.VARCHAR, "%" + searchString + "%"));
        tempParamValue.add(new ParameterValue("size", JDBCType.VARCHAR, "%" + searchString + "%"));
        tempParamValue.add(new ParameterValue("itemCode", JDBCType.VARCHAR, "%" + searchString + "%"));
        tempParamValue.add(new ParameterValue("type", JDBCType.VARCHAR, "%" + searchString + "%"));
        SearchCondition searchCondition = new SearchCondition();
        searchCondition.setParametersvalues(tempParamValue);
        if (!searchString.equals("") && searchString != null) {
            this.select(searchCondition, true, false);
        } else {
            this.selectAll("Select * From StockItem order by name", this.getDataAccess().getEmptyParameterValues());
        }
    }

    public void searPrecise(String searString) {
        String query = "Select Distinct * From StockItem where itemCode=? order by name";
        try {
            this.getOriginalList().clear();
            ResultSet rs = this.getDataAccess().select(query, new ParameterValue[]{new ParameterValue("itemCode", JDBCType.VARCHAR, searString)});
            int i = 1;
            if (rs != null) {
                while (rs.next()) {
                    StockItem stockItem = new StockItem(rs.getString("itemCode"), rs.getString("companyName"), rs.getDouble("costPrice"), rs.getBytes("image") == null ? (byte[])this.getDataAccess().getNull("byte[]") : rs.getBytes("image"), rs.getString("maker"), rs.getString("name"), rs.getBoolean("preload"), Float.valueOf(rs.getFloat("quantity")), Float.valueOf(rs.getFloat("cnsQty")), Float.valueOf(rs.getFloat("dspQty")), rs.getDouble("sellingPrice"), rs.getString("size"), rs.getString("stockUnit"), rs.getString("type"), rs.getDouble("directPurchaseQty"), rs.getDate("dateLastSold"), rs.getDouble("priceB2B"), rs.getBoolean("isActive"), rs.getBoolean("syncFlag"), rs.getString("manufacture"), rs.getString("itemUnit"), rs.getFloat("netWeight"), this.getDataAccess());
                    stockItem.setSn(i);
                    stockItem.setTotalQty();
                    stockItem.vclone = stockItem.clone();
                    this.getOriginalList().add((Object)stockItem);
                    ++i;
                }
                rs.close();
                this.getDataAccess().closeConnection();
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(StockItemList.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void selectWithSerial(String serial) {
        try {
            String query = "select  STOCKITEM.\"NAME\",STOCKITEM.ItemCode,barCode,size,companyName,PRODUCTSERIAL.WHSCODE,STOCKITEM.COSTPRICE,stockUnit, STOCKITEM.CNSQTY, STOCKITEM.DATELASTSOLD, STOCKITEM.DIRECTPURCHASEQTY, PRODUCTSERIAL.SERIAL, STOCKITEM.DSPQTY, STOCKITEM.MAKER, STOCKITEM.PRICEB2B, PRODUCTSERIAL.STATUS,PRODUCTSERIAL.SYSSERIAL, PRODUCTSERIAL.QUANTITY, STOCKITEM.SELLINGPRICE, STOCKITEM.\"TYPE\" from PRODUCTSERIAL JOIN   STOCKITEM on PRODUCTSERIAL.ITEMCODE= STOCKITEM.ITEMCODE where PRODUCTSERIAL.SERIAL=?";
            this.getOriginalList().clear();
            ParameterValue[] param = new ParameterValue[]{new ParameterValue("serial", JDBCType.VARCHAR, serial)};
            ResultSet rs = this.getDataAccess().select(query, param);
            if (rs != null) {
                int i = 1;
                while (rs.next()) {
                    StockItem stockItem = new StockItem(rs.getString("itemCode"), rs.getString("companyName"), rs.getDouble("costPrice"), (byte[])this.getDataAccess().getNull("byte[]"), rs.getString("maker"), rs.getString("name"), false, Float.valueOf(rs.getFloat("quantity")), Float.valueOf(rs.getFloat("cnsQty")), Float.valueOf(rs.getFloat("dspQty")), rs.getDouble("sellingPrice"), rs.getString("size"), rs.getString("stockUnit"), rs.getString("type"), rs.getDouble("directPurchaseQty"), rs.getDate("dateLastSold"), rs.getDouble("priceB2B"), rs.getString("serial"), rs.getString("status"), rs.getInt("sysSerial"), rs.getString("WHSCODE"), "", "", Float.valueOf(rs.getFloat("netWeight")), this.getDataAccess());
                    stockItem.setSn(i);
                    stockItem.setTotalQty();
                    stockItem.vclone = stockItem.clone();
                    this.getOriginalList().add((Object)stockItem);
                    ++i;
                }
                rs.close();
                this.getDataAccess().closeConnection();
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(StockItemList.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void selectWithSerialRequest(String serial) {
        try {
            String query = "select  STOCKITEM.\"NAME\",STOCKITEM.ItemCode,barCode,size,companyName,STOCKITEM.COSTPRICE,stockUnit, STOCKITEM.CNSQTY, STOCKITEM.DATELASTSOLD, STOCKITEM.DIRECTPURCHASEQTY,  REQUESTITEMSERIAL.SERIAL, STOCKITEM.DSPQTY, STOCKITEM.MAKER, STOCKITEM.PRICEB2B, REQUESTITEMSERIAL.ISACCEPTED as Status, PRODUCTSERIAL.QUANTITY, STOCKITEM.SELLINGPRICE, STOCKITEM.\"TYPE\" from REQUESTITEMSERIAL JOIN   STOCKITEM on REQUESTITEMSERIAL.ITEMCODE= STOCKITEM.ITEMCODE where REQUESTITEMSERIAL.SERIAL=?";
            this.getOriginalList().clear();
            ParameterValue[] param = new ParameterValue[]{new ParameterValue("serial", JDBCType.VARCHAR, serial)};
            ResultSet rs = this.getDataAccess().select(query, param);
            if (rs != null) {
                int i = 1;
                while (rs.next()) {
                    StockItem stockItem = new StockItem(rs.getString("itemCode"), rs.getString("companyName"), rs.getDouble("costPrice"), (byte[])this.getDataAccess().getNull("byte[]"), rs.getString("maker"), rs.getString("name"), false, Float.valueOf(rs.getFloat("quantity")), Float.valueOf(rs.getFloat("cnsQty")), Float.valueOf(rs.getFloat("dspQty")), rs.getDouble("sellingPrice"), rs.getString("size"), rs.getString("stockUnit"), rs.getString("type"), rs.getDouble("directPurchaseQty"), rs.getDate("dateLastSold"), rs.getDouble("priceB2B"), rs.getString("serial"), rs.getString("status"), 0, "", "", "", Float.valueOf(rs.getFloat("netWeight")), this.getDataAccess());
                    stockItem.setSn(i);
                    stockItem.setTotalQty();
                    stockItem.vclone = stockItem.clone();
                    this.getOriginalList().add((Object)stockItem);
                    ++i;
                }
                rs.close();
                this.getDataAccess().closeConnection();
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(StockItemList.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void selectAll(String query, ParameterValue[] param) {
        try {
            this.getOriginalList().clear();
            ResultSet rs = this.getDataAccess().select(query, param);
            if (rs != null) {
                int i = 1;
                while (rs.next()) {
                    StockItem stockItem = new StockItem(rs.getString("itemCode"), rs.getString("companyName"), rs.getDouble("costPrice"), rs.getBytes("image") == null ? (byte[])this.getDataAccess().getNull("byte[]") : rs.getBytes("image"), rs.getString("maker"), rs.getString("name"), rs.getBoolean("preload"), Float.valueOf(rs.getFloat("quantity")), Float.valueOf(rs.getFloat("cnsQty")), Float.valueOf(rs.getFloat("dspQty")), rs.getDouble("sellingPrice"), rs.getString("size"), rs.getString("stockUnit"), rs.getString("type"), rs.getDouble("directPurchaseQty"), rs.getDate("dateLastSold"), rs.getDouble("priceB2B"), rs.getBoolean("isActive"), rs.getBoolean("syncFlag"), rs.getString("manufacture"), rs.getString("itemUnit"), rs.getFloat("netWeight"), this.getDataAccess());
                    stockItem.setSn(i);
                    stockItem.setTotalQty();
                    stockItem.vclone = stockItem.clone();
                    this.getOriginalList().add((Object)stockItem);
                    ++i;
                }
                rs.close();
                this.getDataAccess().closeConnection();
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(StockItemList.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void zeroRizeAllProduct(DataAccess da) {
        try {
            da.performDbOperation("update StockItem set quantity=?,cnsQty=?,dspQty=?", new ParameterValue[]{new ParameterValue("quantity", JDBCType.FLOAT, Float.valueOf(0.0f)), new ParameterValue("cnsQty", JDBCType.FLOAT, Float.valueOf(0.0f)), new ParameterValue("dspQty", JDBCType.FLOAT, Float.valueOf(0.0f))});
        }
        catch (Exception ex) {
            Logger.getLogger(StockItemList.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void deleteAllProductwithItemCodeFromProductSerial(DataAccess da, String itemCode) {
        try {
            da.performDbOperation("delete from PRODUCTSERIAL where itemCode=?", new ParameterValue[]{new ParameterValue("itemCode", JDBCType.VARCHAR, itemCode)});
        }
        catch (Exception ex) {
            Logger.getLogger(StockItemList.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void select(SearchCondition searchCondition, boolean forward, boolean reset) {
        DataAccess dt = this.getDataAccess();
        if (reset) {
            this.currentPage = 0;
        }
        Object query = "Select * From StockItem Where ";
        for (ParameterValue pv : searchCondition.getParametersvalues()) {
            query = (String)query + pv.getParameterName() + " like ? or ";
        }
        query = ((String)query).substring(0, ((String)query).length() - 3);
        Objects.requireNonNull(this);
        query = (String)query + "order by itemCode ASC Limit " + 50 + " Offset " + this.currentPage;
        ParameterValue[] parameterValue = searchCondition.ConvertoparameterValuesArray();
        ResultSet rs = dt.select((String)query, parameterValue);
        if (rs != null) {
            try {
                int i = 1;
                while (rs.next()) {
                    StockItem stockItem = new StockItem(rs.getString("itemCode"), rs.getString("companyName"), rs.getDouble("costPrice"), rs.getBytes("image"), rs.getString("maker"), rs.getString("name"), rs.getBoolean("preload"), Float.valueOf(rs.getFloat("quantity")), Float.valueOf(rs.getFloat("cnsQty")), Float.valueOf(rs.getFloat("dspQty")), rs.getDouble("sellingPrice"), rs.getString("size"), rs.getString("stockUnit"), rs.getString("type"), rs.getDouble("directpurchaseqty"), rs.getDate("dateLastSold"), rs.getDouble("priceB2B"), rs.getBoolean("isActive"), rs.getBoolean("syncFlag"), rs.getString("manufacture"), rs.getString("itemUnit"), rs.getFloat("netWeight"), dt);
                    stockItem.setSn(i);
                    stockItem.setTotalQty();
                    stockItem.vclone = stockItem.clone();
                    this.getOriginalList().add((Object)stockItem);
                    ++i;
                }
                if (!forward) {
                    this.currentPage = this.currentPage > 0 ? (this.currentPage = this.currentPage - 1) : 0;
                }
                rs.close();
                dt.closeConnection();
            }
            catch (SQLException ex) {
                Logger.getLogger(StockItemList.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void BatchInsert() throws Exception {
        ArrayList<ParameterValue[]> parameters = new ArrayList<ParameterValue[]>();
        this.getOriginalList().forEach(val -> {
            ParameterValue[] paramValue = new ParameterValue[]{new ParameterValue("itemCode", JDBCType.VARCHAR, val.getItemCode()), new ParameterValue("companyName", JDBCType.VARCHAR, val.getParentCompany().getName()), new ParameterValue("costPrice", JDBCType.DOUBLE, val.getCostPrice()), new ParameterValue("image", JDBCType.BINARY, val.getImage()), new ParameterValue("maker", JDBCType.VARCHAR, val.getMaker()), new ParameterValue("name", JDBCType.VARCHAR, val.getName()), new ParameterValue("preload", JDBCType.CHAR, val.isPreload()), new ParameterValue("quantity", JDBCType.FLOAT, Float.valueOf(val.getQuantity())), new ParameterValue("cnsQty", JDBCType.FLOAT, Float.valueOf(val.getCnsQty())), new ParameterValue("dspQty", JDBCType.FLOAT, Float.valueOf(val.getDspQty())), new ParameterValue("sellingPrice", JDBCType.DOUBLE, val.getSellingPrice()), new ParameterValue("size", JDBCType.VARCHAR, val.getSize()), new ParameterValue("stockUnit", JDBCType.VARCHAR, val.getStockUnit()), new ParameterValue("type", JDBCType.VARCHAR, val.getType()), new ParameterValue("directPurchaseQty", JDBCType.DOUBLE, val.getDirectPurchaseQty()), new ParameterValue("dateLastSold", JDBCType.DATE, val.getDateLastSold()), new ParameterValue("priceB2B", JDBCType.DOUBLE, val.getPriceB2B()), new ParameterValue("isActive", JDBCType.CHAR, val.getIsActive()), new ParameterValue("syncFlag", JDBCType.CHAR, val.getSyncFlag()), new ParameterValue("manufacture", JDBCType.VARCHAR, val.getManufacture()), new ParameterValue("itemUnit", JDBCType.VARCHAR, val.getItemUnit()), new ParameterValue("netWeight", JDBCType.FLOAT, Float.valueOf(val.getNetWeight()))};
            parameters.add(paramValue);
        });
        this.getDataAccess().performDbOperationBatch(StockItem.insertQuery, parameters);
    }

    public void BatchUpdate() throws Exception {
        ArrayList<ParameterValue[]> parameters = new ArrayList<ParameterValue[]>();
        this.getOriginalList().forEach(val -> {
            ParameterValue[] paramValue = new ParameterValue[]{new ParameterValue("itemCode", JDBCType.VARCHAR, val.getItemCode()), new ParameterValue("companyName", JDBCType.VARCHAR, val.getParentCompany().getName()), new ParameterValue("costPrice", JDBCType.DOUBLE, val.getCostPrice()), new ParameterValue("image", JDBCType.BINARY, val.getImage()), new ParameterValue("maker", JDBCType.VARCHAR, val.getMaker()), new ParameterValue("name", JDBCType.VARCHAR, val.getName()), new ParameterValue("preload", JDBCType.CHAR, val.isPreload()), new ParameterValue("quantity", JDBCType.FLOAT, Float.valueOf(val.getQuantity())), new ParameterValue("cnsQty", JDBCType.FLOAT, Float.valueOf(val.getCnsQty())), new ParameterValue("dspQty", JDBCType.FLOAT, Float.valueOf(val.getDspQty())), new ParameterValue("sellingPrice", JDBCType.DOUBLE, val.getSellingPrice()), new ParameterValue("size", JDBCType.VARCHAR, val.getSize()), new ParameterValue("stockUnit", JDBCType.VARCHAR, val.getStockUnit()), new ParameterValue("type", JDBCType.VARCHAR, val.getType()), new ParameterValue("directPurchaseQty", JDBCType.DOUBLE, val.getDirectPurchaseQty()), new ParameterValue("dateLastSold", JDBCType.DATE, val.getDateLastSold()), new ParameterValue("priceB2B", JDBCType.DOUBLE, val.getPriceB2B()), new ParameterValue("isActive", JDBCType.CHAR, val.getIsActive()), new ParameterValue("syncFlag", JDBCType.CHAR, val.getSyncFlag()), new ParameterValue("manufacture", JDBCType.VARCHAR, val.getManufacture()), new ParameterValue("itemUnit", JDBCType.VARCHAR, val.getItemUnit()), new ParameterValue("netWeight", JDBCType.FLOAT, Float.valueOf(val.getNetWeight())), new ParameterValue("cloneItemCode", JDBCType.VARCHAR, val.vclone.getItemCode())};
            parameters.add(paramValue);
        });
        this.getDataAccess().performDbOperationBatch(StockItem.updateQuery, parameters);
    }

    public static ArrayList<SearchClass> selectAutoComplete(String searchString, DataAccess dt, Boolean productOnly) throws SQLException {
        ParameterValue[] parameterValue;
        ArrayList<SearchClass> result = new ArrayList<SearchClass>();
        ArrayList<ParameterValue> tempParamValue = new ArrayList<ParameterValue>();
        tempParamValue.add(new ParameterValue("name", JDBCType.VARCHAR, "%" + searchString + "%"));
        tempParamValue.add(new ParameterValue("itemCode", JDBCType.VARCHAR, "%" + searchString + "%"));
        tempParamValue.add(new ParameterValue("type", JDBCType.VARCHAR, "%" + searchString + "%"));
        SearchCondition searchCondition = new SearchCondition();
        searchCondition.setParametersvalues(tempParamValue);
        Object query = "Select Distinct * From StockItem Where ";
        for (ParameterValue pv : searchCondition.getParametersvalues()) {
            query = (String)query + pv.getParameterName() + " like ? or ";
        }
        query = ((String)query).substring(0, ((String)query).length() - 3);
        ResultSet rs = dt.select((String)(query = (String)query + "order by itemCode ASC"), parameterValue = searchCondition.ConvertoparameterValuesArray());
        if (rs != null) {
            try {
                while (rs.next()) {
                    if (!productOnly.booleanValue()) {
                        result.add(new SearchClass(rs.getString("itemCode"), rs.getString("name") + "[" + rs.getString("itemCode") + "]Qty:" + rs.getFloat("quantity")));
                        continue;
                    }
                    result.add(new SearchClass(rs.getString("name"), rs.getString("itemCode")));
                }
                rs.close();
                dt.closeConnection();
            }
            catch (Exception ex) {
                if (rs != null) {
                    rs.close();
                    dt.closeConnection();
                }
                Logger.getLogger(StockItemList.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return result;
    }

    public static void insertChannels(List<NameValueObject> channels, DataAccess da) throws Exception {
        da.performDbOperation("Delete From SaleChannel", da.getEmptyParameterValues());
        String query = "INSERT INTO SaleChannel(Description,Code) Values(?,?)";
        for (NameValueObject channel : channels) {
            ParameterValue[] parameterValues = new ParameterValue[]{new ParameterValue("Code", JDBCType.VARCHAR, channel.getKey()), new ParameterValue("Description", JDBCType.VARCHAR, channel.getData())};
            da.performDbOperation(query, parameterValues);
        }
    }

    public static void insertPaymentTerm(List<NameValueObject> channels, DataAccess da) throws Exception {
        ArrayList<ParameterValue[]> parameters = new ArrayList<ParameterValue[]>();
        da.performDbOperation("Delete From PaymentTerm", da.getEmptyParameterValues());
        String query = "INSERT INTO PaymentTerm(PaymentTerm,Description) Values(?,?)";
        for (NameValueObject channel : channels) {
            ParameterValue[] parameterValues = new ParameterValue[]{new ParameterValue("PaymentTerm", JDBCType.VARCHAR, channel.getKey()), new ParameterValue("Description", JDBCType.VARCHAR, channel.getData())};
            parameters.add(parameterValues);
        }
        da.performDbOperationBatch(query, parameters);
    }

    public static void insertPaymentMode(List<NameValueObject> channels, DataAccess da) throws Exception {
        da.performDbOperation("Delete From PaymentMode", da.getEmptyParameterValues());
        String query = "INSERT INTO PaymentMode(PaymentMode,Description) Values(?,?)";
        ArrayList<ParameterValue[]> parameters = new ArrayList<ParameterValue[]>();
        for (NameValueObject channel : channels) {
            ParameterValue[] parameterValues = new ParameterValue[]{new ParameterValue("PaymentMode", JDBCType.VARCHAR, channel.getKey()), new ParameterValue("Description", JDBCType.VARCHAR, channel.getData())};
            parameters.add(parameterValues);
        }
        da.performDbOperationBatch(query, parameters);
    }

    public static void insertDimensions(List<NameValueObject> channels, DataAccess da) throws Exception {
        ParameterValue[] parameterValues;
        da.performDbOperation("Delete From BusinessStream", da.getEmptyParameterValues());
        String query = "INSERT INTO BusinessStream(BusinessStream,Name) Values(?,?)";
        ArrayList<Object> parameters = new ArrayList<ParameterValue[]>();
        for (NameValueObject channel : channels.stream().filter(f -> f.getType().equals(NameValueObjectType.BusinessStream.name())).collect(Collectors.toList())) {
            parameterValues = new ParameterValue[]{new ParameterValue("BusinessStream", JDBCType.VARCHAR, channel.getKey()), new ParameterValue("Name", JDBCType.VARCHAR, channel.getData())};
            parameters.add(parameterValues);
        }
        da.performDbOperationBatch(query, parameters);
        da.performDbOperation("Delete From BusinessUnit", da.getEmptyParameterValues());
        query = "INSERT INTO BusinessUnit(BusinessUnit,Name) Values(?,?)";
        parameters = new ArrayList();
        for (NameValueObject channel : channels.stream().filter(f -> f.getType().equals(NameValueObjectType.BusinessUnit.name())).collect(Collectors.toList())) {
            parameterValues = new ParameterValue[]{new ParameterValue("BusinessUnit", JDBCType.VARCHAR, channel.getKey()), new ParameterValue("Name", JDBCType.VARCHAR, channel.getData())};
            parameters.add(parameterValues);
        }
        da.performDbOperationBatch(query, parameters);
        da.performDbOperation("Delete From CostCenter", da.getEmptyParameterValues());
        query = "INSERT INTO CostCenter(CostCenter,Name) Values(?,?)";
        parameters = new ArrayList();
        for (NameValueObject channel : channels.stream().filter(f -> f.getType().equals(NameValueObjectType.CostCentre.name())).collect(Collectors.toList())) {
            parameterValues = new ParameterValue[]{new ParameterValue("CostCenter", JDBCType.VARCHAR, channel.getKey()), new ParameterValue("Name", JDBCType.VARCHAR, channel.getData())};
            parameters.add(parameterValues);
        }
        da.performDbOperationBatch(query, parameters);
    }

    public static void insertSalesDimension(List<NameValueObject> channels, DataAccess da) throws Exception {
        da.performDbOperation("Delete From SalesDimension", da.getEmptyParameterValues());
        String query = "INSERT INTO SalesDimension(Code,Stream,Name) Values(?,?,?)";
        ArrayList<ParameterValue[]> parameters = new ArrayList<ParameterValue[]>();
        for (NameValueObject channel : channels) {
            ParameterValue[] parameterValues = new ParameterValue[]{new ParameterValue("Code", JDBCType.VARCHAR, channel.getKey()), new ParameterValue("Stream", JDBCType.VARCHAR, channel.getData()), new ParameterValue("Name", JDBCType.VARCHAR, channel.getType())};
            parameters.add(parameterValues);
        }
        da.performDbOperationBatch(query, parameters);
    }

    public static List<NameValueObject> selectAllNameValue(DataAccess dt, String tableName, String colunmKey, String columnValue, String optional) throws SQLException {
        ArrayList<NameValueObject> channelList = new ArrayList<NameValueObject>();
        ResultSet rs = dt.select("Select * from " + tableName, dt.getEmptyParameterValues());
        if (rs != null) {
            try {
                while (rs.next()) {
                    NameValueObject nv = new NameValueObject(rs.getString(colunmKey), rs.getString(columnValue), rs.getString(optional), dt);
                    channelList.add(nv);
                }
                rs.close();
                dt.closeConnection();
            }
            catch (Exception ex) {
                if (rs != null) {
                    rs.close();
                    dt.closeConnection();
                }
                Logger.getLogger(StockItemList.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return channelList;
    }

    public static List<NameValueObject> selectAllNameValue(DataAccess dt, String tableName, String colunmKey, String columnValue) throws SQLException {
        ArrayList<NameValueObject> channelList = new ArrayList<NameValueObject>();
        ResultSet rs = dt.select("Select * from " + tableName, dt.getEmptyParameterValues());
        if (rs != null) {
            try {
                while (rs.next()) {
                    NameValueObject nv = new NameValueObject(rs.getString(colunmKey), rs.getString(columnValue), dt);
                    channelList.add(nv);
                }
                rs.close();
                dt.closeConnection();
            }
            catch (Exception ex) {
                if (rs != null) {
                    rs.close();
                    dt.closeConnection();
                }
                Logger.getLogger(StockItemList.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return channelList;
    }

    public static List<NameValueObject> selectAllChannels(DataAccess dt) throws SQLException {
        ArrayList<NameValueObject> channelList = new ArrayList<NameValueObject>();
        ResultSet rs = dt.select("Select * from SaleChannel", dt.getEmptyParameterValues());
        if (rs != null) {
            try {
                while (rs.next()) {
                    channelList.add(new NameValueObject(rs.getString("Code"), rs.getString("Description"), dt));
                }
                rs.close();
                dt.closeConnection();
            }
            catch (Exception ex) {
                if (rs != null) {
                    rs.close();
                    dt.closeConnection();
                }
                Logger.getLogger(StockItemList.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return channelList;
    }

    public static void insertAllYudalaProduct(List<StockItemData> stockItemDatas, DataAccess da) throws Exception {
        da.performDbOperation("Delete From YUPRODUCT", da.getEmptyParameterValues());
        String query = "INSERT INTO YUPRODUCT(itemCode,itemName) Values(?,?)";
        ArrayList<ParameterValue[]> parameters = new ArrayList<ParameterValue[]>();
        for (StockItemData stockItemData : stockItemDatas) {
            ParameterValue[] parameterValues = new ParameterValue[]{new ParameterValue("itemCode", JDBCType.VARCHAR, stockItemData.getItemCode()), new ParameterValue("description", JDBCType.VARCHAR, stockItemData.getDescription())};
            parameters.add(parameterValues);
        }
        da.performDbOperationBatch(query, parameters);
    }

    public static void insertYudalaProduct(List<StockItemData> stockItemDatas, DataAccess da) throws Exception {
        String query = "INSERT INTO YUPRODUCT(itemCode,itemName) Values(?,?)";
        ArrayList<ParameterValue[]> parameters = new ArrayList<ParameterValue[]>();
        for (StockItemData stockItemData : stockItemDatas) {
            da.performDbOperation("Delete From YUPRODUCT where ItemCode=?", new ParameterValue[]{new ParameterValue("ItemCode", JDBCType.VARCHAR, stockItemData.getItemCode())});
            ParameterValue[] parameterValues = new ParameterValue[]{new ParameterValue("itemCode", JDBCType.VARCHAR, stockItemData.getItemCode()), new ParameterValue("description", JDBCType.VARCHAR, stockItemData.getDescription())};
            parameters.add(parameterValues);
        }
        da.performDbOperationBatch(query, parameters);
    }

    public static List<StockItemData> selectAllYuProducts(DataAccess dt) throws SQLException {
        ArrayList<StockItemData> stockItemDatas = new ArrayList<StockItemData>();
        ResultSet rs = dt.select("Select * from YUPRODUCT", dt.getEmptyParameterValues());
        if (rs != null) {
            try {
                while (rs.next()) {
                    stockItemDatas.add(new StockItemData(rs.getString("itemCode"), rs.getString("itemName")));
                }
                rs.close();
                dt.closeConnection();
            }
            catch (Exception ex) {
                if (rs != null) {
                    rs.close();
                    dt.closeConnection();
                }
                Logger.getLogger(StockItemList.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return stockItemDatas;
    }

    public static boolean checkIFTableHasData(DataAccess dt, String tabeleName) throws SQLException {
        ResultSet rs = dt.select("Select  * from STORE Limit 3", dt.getEmptyParameterValues());
        if (rs != null) {
            try {
                if (rs.next()) {
                    rs.close();
                    dt.closeConnection();
                    return true;
                }
                rs.close();
                dt.closeConnection();
            }
            catch (Exception ex) {
                rs.close();
                dt.closeConnection();
                Logger.getLogger(StockItemList.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return false;
    }

    public static void deleteAll(DataAccess da) throws Exception {
        da.performDbOperation("Delete From StockItem", da.getEmptyParameterValues());
    }

    public static void deleteAll(String tableName, DataAccess da) throws Exception {
        da.performDbOperation("Delete From " + tableName, da.getEmptyParameterValues());
    }

    public static void deleteAll(String qry, ParameterValue[] parameterValueses, DataAccess da) throws Exception {
        da.performDbOperation(qry, parameterValueses);
    }
}

