/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.list;

import com.xputertechnologies.santa.SearchClass;
import com.xputertechnologies.santa.StockItemB2B;
import com.xputertechnologies.santa.core.DataAccess;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.core.SearchCondition;
import com.xputertechnologies.santa.list.DataList;
import com.xputertechnologies.santa.list.SaleList;
import java.sql.JDBCType;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StockItemB2BList
extends DataList<StockItemB2B> {
    int counter = 0;

    public StockItemB2BList(DataAccess da) {
        this.t = new StockItemB2B(da);
    }

    public StockItemB2BList() {
    }

    @Override
    public void select() {
    }

    public void resetNumbering() {
        this.counter = 0;
        this.getOriginalList().forEach(val -> {
            ++this.counter;
            val.setSn(this.counter);
        });
    }

    public int countStock() {
        try {
            ResultSet rslt = this.getDataAccess().select("select count(*) as Total from StockItemB2B", this.getDataAccess().getEmptyParameterValues());
            if (rslt != null) {
                if (rslt.next()) {
                    return rslt.getInt("Total");
                }
                rslt.close();
                this.getDataAccess().closeConnection();
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(SaleList.class.getName()).log(Level.SEVERE, null, ex);
        }
        return 0;
    }

    public void searchStock(String searchString) {
        ArrayList<ParameterValue> tempParamValue = new ArrayList<ParameterValue>();
        tempParamValue.add(new ParameterValue("itemCode", JDBCType.VARCHAR, "%" + searchString + "%"));
        tempParamValue.add(new ParameterValue("companyName", JDBCType.VARCHAR, "%" + searchString + "%"));
        tempParamValue.add(new ParameterValue("make", JDBCType.VARCHAR, "%" + searchString + "%"));
        tempParamValue.add(new ParameterValue("name", JDBCType.VARCHAR, "%" + searchString + "%"));
        tempParamValue.add(new ParameterValue("size", JDBCType.VARCHAR, "%" + searchString + "%"));
        tempParamValue.add(new ParameterValue("itemCode", JDBCType.VARCHAR, "%" + searchString + "%"));
        SearchCondition searchCondition = new SearchCondition();
        searchCondition.setParametersvalues(tempParamValue);
        if (!searchString.equals("") && searchString != null) {
            this.select(searchCondition, true, false);
        } else {
            this.selectAll("Select * From StockItemB2B order by name", this.getDataAccess().getEmptyParameterValues());
        }
    }

    public void searPrecise(String searString) {
        String query = "Select Distinct * From StockItemB2B where itemCode=? order by name";
        try {
            this.getOriginalList().clear();
            ResultSet rs = this.getDataAccess().select(query, new ParameterValue[]{new ParameterValue("itemCode", JDBCType.VARCHAR, searString)});
            int i = 1;
            if (rs != null) {
                while (rs.next()) {
                    StockItemB2B stockItem = new StockItemB2B(rs.getString("itemCode"), rs.getString("companyName"), rs.getDouble("costPrice"), rs.getString("make"), rs.getString("name"), rs.getString("size"), rs.getDate("lastSyncDate"), Float.valueOf(rs.getFloat("quantity")), Float.valueOf(rs.getFloat("netWeight")), rs.getDouble("price"), rs.getBoolean("isActive"), rs.getBoolean("syncFlag"), rs.getString("storeName"), this.getDataAccess());
                    stockItem.setSn(i);
                    stockItem.vclone = stockItem.clone();
                    this.getOriginalList().add((Object)stockItem);
                    ++i;
                }
                rs.close();
                this.getDataAccess().closeConnection();
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(StockItemB2BList.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void selectAll(String query, ParameterValue[] param) {
        try {
            this.getOriginalList().clear();
            ResultSet rs = this.getDataAccess().select(query, param);
            if (rs != null) {
                int i = 1;
                while (rs.next()) {
                    StockItemB2B stockItem = new StockItemB2B(rs.getString("itemCode"), rs.getString("companyName"), rs.getDouble("costPrice"), rs.getString("make"), rs.getString("name"), rs.getString("size"), rs.getDate("lastSyncDate"), Float.valueOf(rs.getFloat("quantity")), Float.valueOf(rs.getFloat("netWeight")), rs.getDouble("price"), rs.getBoolean("isActive"), rs.getBoolean("syncFlag"), rs.getString("storeName"), this.getDataAccess());
                    stockItem.setSn(i);
                    stockItem.vclone = stockItem.clone();
                    this.getOriginalList().add((Object)stockItem);
                    ++i;
                }
                rs.close();
                this.getDataAccess().closeConnection();
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(StockItemB2BList.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void zeroRizeAllProduct(DataAccess da) {
        try {
            da.performDbOperation("update StockItemB2B set quantity=?", new ParameterValue[]{new ParameterValue("quantity", JDBCType.FLOAT, Float.valueOf(0.0f))});
        }
        catch (Exception ex) {
            Logger.getLogger(StockItemB2BList.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void select(SearchCondition searchCondition, boolean forward, boolean reset) {
        DataAccess dt = this.getDataAccess();
        if (reset) {
            this.currentPage = 0;
        }
        Object query = "Select * From StockItemB2B Where ";
        for (ParameterValue pv : searchCondition.getParametersvalues()) {
            query = (String)query + pv.getParameterName() + " like ? or ";
        }
        query = ((String)query).substring(0, ((String)query).length() - 3);
        Objects.requireNonNull(this);
        query = (String)query + "order by itemCode ASC Limit " + 50 + " Offset " + this.currentPage;
        ParameterValue[] parameterValue = searchCondition.ConvertoparameterValuesArray();
        ResultSet rs = dt.select((String)query, parameterValue);
        if (rs != null) {
            try {
                int i = 1;
                while (rs.next()) {
                    StockItemB2B stockItem = new StockItemB2B(rs.getString("itemCode"), rs.getString("companyName"), rs.getDouble("costPrice"), rs.getString("make"), rs.getString("name"), rs.getString("size"), rs.getDate("lastSyncDate"), Float.valueOf(rs.getFloat("quantity")), Float.valueOf(rs.getFloat("netWeight")), rs.getDouble("price"), rs.getBoolean("isActive"), rs.getBoolean("syncFlag"), rs.getString("storeName"), dt);
                    stockItem.setSn(i);
                    stockItem.vclone = stockItem.clone();
                    this.getOriginalList().add((Object)stockItem);
                    ++i;
                }
                if (!forward) {
                    this.currentPage = this.currentPage > 0 ? (this.currentPage = this.currentPage - 1) : 0;
                }
                rs.close();
                dt.closeConnection();
            }
            catch (SQLException ex) {
                Logger.getLogger(StockItemB2BList.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void BatchInsert() throws Exception {
        ArrayList<ParameterValue[]> parameters = new ArrayList<ParameterValue[]>();
        this.getOriginalList().forEach(val -> {
            ParameterValue[] paramValue = new ParameterValue[]{new ParameterValue("itemCode", JDBCType.VARCHAR, val.getItemCode()), new ParameterValue("companyName", JDBCType.VARCHAR, val.getParentCompany().getName()), new ParameterValue("costPrice", JDBCType.DOUBLE, val.getCostPrice()), new ParameterValue("make", JDBCType.VARCHAR, val.getMake()), new ParameterValue("name", JDBCType.VARCHAR, val.getName()), new ParameterValue("quantity", JDBCType.FLOAT, Float.valueOf(val.getQuantity())), new ParameterValue("price", JDBCType.DOUBLE, val.getPrice()), new ParameterValue("size", JDBCType.VARCHAR, val.getSize()), new ParameterValue("netWeight", JDBCType.FLOAT, Float.valueOf(val.getNetWeight())), new ParameterValue("syncFlag", JDBCType.CHAR, val.getSyncFlag()), new ParameterValue("isActive", JDBCType.CHAR, val.getIsActive()), new ParameterValue("lastSyncDate", JDBCType.DATE, val.getLastSyncDate()), new ParameterValue("storeName", JDBCType.VARCHAR, val.getStoreName())};
            parameters.add(paramValue);
        });
        this.getDataAccess().performDbOperationBatch(StockItemB2B.insertQuery, parameters);
    }

    public void BatchUpdate() throws Exception {
        ArrayList<ParameterValue[]> parameters = new ArrayList<ParameterValue[]>();
        this.getOriginalList().forEach(val -> {
            ParameterValue[] paramValue = new ParameterValue[]{new ParameterValue("itemCode", JDBCType.VARCHAR, val.getItemCode()), new ParameterValue("companyName", JDBCType.VARCHAR, val.getParentCompany().getName()), new ParameterValue("costPrice", JDBCType.DOUBLE, val.getCostPrice()), new ParameterValue("make", JDBCType.VARCHAR, val.getMake()), new ParameterValue("name", JDBCType.VARCHAR, val.getName()), new ParameterValue("quantity", JDBCType.FLOAT, Float.valueOf(val.getQuantity())), new ParameterValue("price", JDBCType.DOUBLE, val.getPrice()), new ParameterValue("size", JDBCType.VARCHAR, val.getSize()), new ParameterValue("netWeight", JDBCType.FLOAT, Float.valueOf(val.getNetWeight())), new ParameterValue("syncFlag", JDBCType.CHAR, val.getSyncFlag()), new ParameterValue("isActive", JDBCType.CHAR, val.getIsActive()), new ParameterValue("lastSyncDate", JDBCType.DATE, val.getLastSyncDate()), new ParameterValue("storeName", JDBCType.VARCHAR, val.getStoreName()), new ParameterValue("cloneItemCode", JDBCType.VARCHAR, val.vclone.getItemCode())};
            parameters.add(paramValue);
        });
        this.getDataAccess().performDbOperationBatch(StockItemB2B.updateQuery, parameters);
    }

    public static ArrayList<SearchClass> selectAutoComplete(String searchString, DataAccess dt) throws SQLException {
        ParameterValue[] parameterValue;
        ArrayList<SearchClass> result = new ArrayList<SearchClass>();
        ArrayList<ParameterValue> tempParamValue = new ArrayList<ParameterValue>();
        tempParamValue.add(new ParameterValue("name", JDBCType.VARCHAR, "%" + searchString + "%"));
        tempParamValue.add(new ParameterValue("itemCode", JDBCType.VARCHAR, "%" + searchString + "%"));
        tempParamValue.add(new ParameterValue("make", JDBCType.VARCHAR, "%" + searchString + "%"));
        SearchCondition searchCondition = new SearchCondition();
        searchCondition.setParametersvalues(tempParamValue);
        Object query = "Select Distinct * From StockItemB2B Where ";
        for (ParameterValue pv : searchCondition.getParametersvalues()) {
            query = (String)query + pv.getParameterName() + " like ? or ";
        }
        query = ((String)query).substring(0, ((String)query).length() - 3);
        ResultSet rs = dt.select((String)(query = (String)query + "order by itemCode ASC"), parameterValue = searchCondition.ConvertoparameterValuesArray());
        if (rs != null) {
            try {
                while (rs.next()) {
                    result.add(new SearchClass(rs.getString("name"), rs.getString("itemCode")));
                }
                rs.close();
                dt.closeConnection();
            }
            catch (Exception ex) {
                if (rs != null) {
                    rs.close();
                    dt.closeConnection();
                }
                Logger.getLogger(StockItemB2BList.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return result;
    }

    public static void deleteAll(DataAccess da) throws Exception {
        da.performDbOperation("Delete From StockItemB2B", da.getEmptyParameterValues());
    }

    public static void deleteAll(String tableName, DataAccess da) throws Exception {
        da.performDbOperation("Delete From " + tableName, da.getEmptyParameterValues());
    }

    public static void deleteAll(String qry, ParameterValue[] parameterValueses, DataAccess da) throws Exception {
        da.performDbOperation(qry, parameterValueses);
    }
}

