/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.list;

import com.xputertechnologies.santa.PurchaseItem;
import com.xputertechnologies.santa.core.DataAccess;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.core.SearchCondition;
import com.xputertechnologies.santa.list.DataList;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PurchaseItemList
extends DataList<PurchaseItem> {
    public PurchaseItemList(DataAccess dt) {
        this.t = new PurchaseItem(dt);
    }

    @Override
    public void select() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void selectAll(String query, ParameterValue[] param) {
        try {
            DataAccess dt = this.getDataAccess();
            this.getOriginalList().clear();
            ResultSet rslt = dt.select(query, param);
            if (rslt != null) {
                while (rslt.next()) {
                    PurchaseItem purchaseItem = new PurchaseItem(Float.valueOf(rslt.getFloat("quantity")), Float.valueOf(rslt.getFloat("costPrice")), rslt.getDouble("sellingPrice"), rslt.getString("purchaseUnit"), rslt.getString("purchaseCode"), rslt.getString("stockItemBarcode"), Float.valueOf(rslt.getFloat("outStandingQty")), dt);
                    purchaseItem.vClone = purchaseItem.clone();
                    this.getOriginalList().add((Object)purchaseItem);
                }
                rslt.close();
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(PurchaseItemList.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void select(SearchCondition searchCondition, boolean forward, boolean reset) {
        try {
            DataAccess dt = this.getDataAccess();
            if (reset) {
                this.currentPage = 0;
            }
            Object query = "Select * From PurchaseItem Where ";
            for (ParameterValue pv : searchCondition.getParametersvalues()) {
                query = (String)query + pv.getParameterName() + " like ? or ";
            }
            query = ((String)query).substring(0, ((String)query).length() - 3);
            Objects.requireNonNull(this);
            query = (String)query + "order by purchaseCode,stockItemBarcode ASC Limit " + 50 + " Offset " + this.currentPage;
            ParameterValue[] parameterValue = searchCondition.ConvertoparameterValuesArray();
            ResultSet rs = dt.select((String)query, parameterValue);
            if (rs != null) {
                while (rs.next()) {
                    try {
                        PurchaseItem pur = new PurchaseItem(Float.valueOf(rs.getFloat("quantity")), Float.valueOf(rs.getFloat("costPrice")), rs.getDouble("sellingPrice"), rs.getString("purchaseUnit"), rs.getString("purchaseCode"), rs.getString("stockItemBarcode"), Float.valueOf(rs.getFloat("outStandingQty")), dt);
                        pur.vClone = pur.clone();
                        this.getOriginalList().add((Object)pur);
                    }
                    catch (SQLException ex) {
                        Logger.getLogger(PurchaseItemList.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                ++this.currentPage;
                rs.close();
                dt.closeConnection();
                this.currentPage = forward ? ++this.currentPage : (this.currentPage > 0 ? (this.currentPage = this.currentPage - 1) : 0);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(PurchaseItemList.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

