/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa;

import com.xputertechnologies.santa.Company;
import com.xputertechnologies.santa.DbEntity;
import com.xputertechnologies.santa.Role;
import com.xputertechnologies.santa.core.BaseConcurrencyException;
import com.xputertechnologies.santa.core.DataAccess;
import com.xputertechnologies.santa.core.ObjectState;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.core.SearchCondition;
import com.xputertechnologies.santa.core.Searchable;
import com.xputertechnologies.santa.list.CompanyDataList;
import com.xputertechnologies.santa.list.RoleList;
import com.xputertechnologies.santa.list.UserDataList;
import java.sql.Date;
import java.sql.JDBCType;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;

public class User
extends DbEntity {
    private Company parentCompany;
    private Role parentRole;
    public User vclone;
    private boolean isclone;
    public boolean isEdit = false;
    private StringProperty firstName = new SimpleStringProperty();
    private StringProperty lastName = new SimpleStringProperty();
    private StringProperty userName = new SimpleStringProperty();
    private StringProperty password = new SimpleStringProperty();
    private StringProperty status = new SimpleStringProperty("Active");
    private ObjectProperty dateCreated = new SimpleObjectProperty((Object)Date.valueOf(LocalDate.now()));
    private String roleDescription;
    private String companyName;

    public User(Date dateCreated, String firstName, String lastName, String password, String roleDescription, String status, String userName, String companyName, DataAccess dbAccess) {
        super(dbAccess);
        this.firstName.set((Object)firstName);
        this.lastName.set((Object)lastName);
        this.userName.set((Object)userName);
        this.password.set((Object)password);
        this.status.set((Object)status);
        this.dateCreated.set((Object)dateCreated);
        this.roleDescription = roleDescription;
        this.companyName = companyName;
        this.setMustClone(true);
        this.setState(ObjectState.Unchanged);
        this.initializeListener();
    }

    public User(DataAccess dbAccess) {
        super(dbAccess);
        this.initializeListener();
    }

    public String getFirstName() {
        return (String)this.firstName.get();
    }

    public void setFirstName(String firstName) {
        if (!this.isclone && this.isMustClone()) {
            this.vclone = this.clone();
        }
        this.firstName.set((Object)firstName);
        this.changeObjectState();
    }

    public StringProperty firstNameProperty() {
        return this.firstName;
    }

    public String getLastName() {
        return (String)this.lastName.get();
    }

    public void setLastName(String lastName) {
        if (!this.isclone && this.isMustClone()) {
            this.vclone = this.clone();
        }
        this.lastName.set((Object)lastName);
        this.changeObjectState();
    }

    public StringProperty lastNameProperty() {
        return this.lastName;
    }

    public String getUserName() {
        return (String)this.userName.get();
    }

    public void setUserName(String userName) {
        if (!this.isclone && this.isMustClone()) {
            this.vclone = this.clone();
        }
        this.userName.set((Object)userName);
        this.changeObjectState();
    }

    public String getFullName() {
        return (String)this.firstName.get() + " " + (String)this.lastName.get();
    }

    public StringProperty userNameProperty() {
        return this.userName;
    }

    public String getPassword() {
        return (String)this.password.get();
    }

    public void setPassword(String password) {
        if (!this.isclone && this.isMustClone()) {
            this.vclone = this.clone();
        }
        this.password.set((Object)password);
        this.changeObjectState();
    }

    public StringProperty passwordProperty() {
        return this.password;
    }

    public String getStatus() {
        return (String)this.status.get();
    }

    public void setStatus(String status) {
        if (!this.isclone && this.isMustClone()) {
            this.vclone = this.clone();
        }
        this.status.set((Object)status);
        this.changeObjectState();
    }

    public User() {
        this.initializeListener();
    }

    public StringProperty statusProperty() {
        return this.status;
    }

    public Date getDateCreated() {
        return (Date)this.dateCreated.get();
    }

    public void setDateCreated(Date dateCreated) {
        if (!this.isclone && this.isMustClone()) {
            this.vclone = this.clone();
        }
        this.dateCreated.set((Object)dateCreated);
        this.changeObjectState();
    }

    public ObjectProperty dateCreatedProperty() {
        return this.dateCreated;
    }

    private static Company getSataticParentCompany(String companyName, DataAccess dt) {
        CompanyDataList compList = new CompanyDataList(dt);
        String query = "Select * From Company where name=?";
        compList.selectAll(query, new ParameterValue[]{new ParameterValue("name", JDBCType.VARCHAR, companyName)});
        if (compList.getOriginalList().size() == 1) {
            return (Company)compList.getOriginalList().get(0);
        }
        return null;
    }

    public static User validateUser(String username, String password, DataAccess da) {
        UserDataList userlist = new UserDataList(da);
        ParameterValue[] param = new ParameterValue[]{new ParameterValue("username", JDBCType.VARCHAR, username), new ParameterValue("password", JDBCType.VARCHAR, password), new ParameterValue("status", JDBCType.VARCHAR, "Active")};
        userlist.selectAll("Select * from \"User\" where username = ? and password=? and status=?", param, da);
        if (userlist.getOriginalList().size() == 1) {
            ((User)userlist.getOriginalList().get((int)0)).parentCompany = User.getSataticParentCompany(((User)userlist.getOriginalList().get((int)0)).companyName, da);
        }
        return userlist.getOriginalList().size() > 0 ? (User)userlist.getOriginalList().get(0) : null;
    }

    public User clone() {
        User cloneTemp = new User(this.getDbAccess());
        cloneTemp.setMustClone(false);
        cloneTemp.dateCreated.set(this.dateCreated.get());
        cloneTemp.firstName.set((Object)((String)this.firstName.get()));
        cloneTemp.lastName.set((Object)((String)this.lastName.get()));
        cloneTemp.password.set((Object)((String)this.password.get()));
        cloneTemp.setRoleDescription(this.getRoleDescription());
        cloneTemp.status.set((Object)((String)this.status.get()));
        cloneTemp.userName.set((Object)((String)this.userName.get()));
        cloneTemp.setMustClone(true);
        this.isclone = true;
        return cloneTemp;
    }

    public User outerClone() {
        User cloneTemp = new User(this.getDbAccess());
        cloneTemp.setMustClone(false);
        cloneTemp.dateCreated.set(this.dateCreated.get());
        cloneTemp.firstName.set((Object)((String)this.firstName.get()));
        cloneTemp.lastName.set((Object)((String)this.lastName.get()));
        cloneTemp.password.set((Object)((String)this.password.get()));
        cloneTemp.setRoleDescription(this.getRoleDescription());
        cloneTemp.status.set((Object)((String)this.status.get()));
        cloneTemp.userName.set((Object)((String)this.userName.get()));
        cloneTemp.setMustClone(true);
        return cloneTemp;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        User user = (User)object;
        return user.getUserName().equals(this.getUserName());
    }

    private void rollBack() {
        this.dateCreated.set(this.vclone.dateCreated.get());
        this.firstName.set((Object)((String)this.vclone.firstName.get()));
        this.lastName.set((Object)((String)this.vclone.lastName.get()));
        this.password.set((Object)((String)this.vclone.password.get()));
        this.setRoleDescription(this.vclone.getRoleDescription());
        this.status.set((Object)((String)this.vclone.status.get()));
        this.userName.set((Object)((String)this.vclone.userName.get()));
        this.isclone = false;
        this.setMustClone(true);
    }

    public void setParentCompany(Company cp) {
        this.parentCompany = cp;
        this.companyName = cp == null ? "" : cp.getName();
        this.changeObjectState();
    }

    private void loadParentCompany() {
        CompanyDataList compList = new CompanyDataList(this.getDbAccess());
        String query = "Select * From Company ";
        compList.selectAll(query, new ParameterValue[]{new ParameterValue("name", JDBCType.VARCHAR, this.companyName)});
        if (compList.getOriginalList().size() > 0) {
            this.parentCompany = (Company)compList.getOriginalList().get(0);
        }
    }

    public Company getParentCompany() {
        if (this.parentCompany == null) {
            this.loadParentCompany();
        }
        return this.parentCompany;
    }

    public void setParentRole(Role cp) {
        if (!this.isclone) {
            this.vclone = this.clone();
        }
        this.parentRole = cp;
        this.setRoleDescription(cp == null ? "" : cp.getDescription());
        this.changeObjectState();
    }

    public void loadParentRole() {
        RoleList roleList = new RoleList(this.getDbAccess());
        String query = "Select * From Role Where description=?";
        roleList.selectAll(query, new ParameterValue[]{new ParameterValue("description", JDBCType.VARCHAR, this.getRoleDescription())});
        if (roleList.getOriginalList().size() > 0) {
            this.parentRole = (Role)roleList.getOriginalList().get(0);
        }
    }

    public Role getParentRole() {
        if (this.parentRole == null) {
            this.loadParentRole();
        }
        return this.parentRole;
    }

    public static UserDataList search(String qry, ParameterValue[] param, DataAccess dt) {
        UserDataList supplierPaymentDataList = new UserDataList(dt);
        supplierPaymentDataList.selectAll(qry, param);
        return supplierPaymentDataList;
    }

    public static UserDataList search(String searchString, DataAccess dt) {
        UserDataList userDataList = new UserDataList(dt);
        ArrayList<ParameterValue> tempParamValue = new ArrayList<ParameterValue>();
        tempParamValue.clear();
        tempParamValue.add(new ParameterValue("username", JDBCType.VARCHAR, "%" + searchString + "%"));
        tempParamValue.add(new ParameterValue("firstname", JDBCType.VARCHAR, "%" + searchString + "%"));
        tempParamValue.add(new ParameterValue("lastname", JDBCType.VARCHAR, "%" + searchString + "%"));
        SearchCondition searchCondition = new SearchCondition();
        searchCondition.setParametersvalues(tempParamValue);
        UserDataList tempuserList = new UserDataList(dt);
        tempuserList.select(searchCondition, true, false);
        userDataList.getOriginalList().addAll(tempuserList.getOriginalList());
        return userDataList;
    }

    @Override
    public void insert() throws Exception {
        try {
            ParameterValue[] paramValue = new ParameterValue[]{new ParameterValue("dateCreated", JDBCType.DATE, this.dateCreated.get()), new ParameterValue("firstName", JDBCType.VARCHAR, this.firstName.get()), new ParameterValue("lastName", JDBCType.VARCHAR, this.lastName.get()), new ParameterValue("password", JDBCType.VARCHAR, this.password.get()), new ParameterValue("roleDescription", JDBCType.VARCHAR, this.roleDescription), new ParameterValue("status", JDBCType.VARCHAR, this.status.get()), new ParameterValue("userName", JDBCType.VARCHAR, this.userName.get()), new ParameterValue("CompanyName", JDBCType.VARCHAR, this.companyName)};
            String query = "insert into \"User\" (dateCreated,firstName,lastName,password,roleDescription ,status,userName,companyname) values(?,?,?,?,?,?,?,?)";
            this.getDbAccess().performDbOperation(query, paramValue);
            this.vclone = this.clone();
        }
        catch (Exception ex) {
            this.rollBack();
            this.isclone = false;
            throw ex;
        }
    }

    @Override
    public void update() throws BaseConcurrencyException, Exception {
        String query = "update \"User\" set dateCreated=?,firstName=?,lastName=?,password=?,roleDescription=?,status=? where userName=?";
        try {
            ParameterValue[] paramValue = new ParameterValue[]{new ParameterValue("dateCreated", JDBCType.DATE, this.dateCreated.get()), new ParameterValue("firstName", JDBCType.VARCHAR, this.firstName.get()), new ParameterValue("lastName", JDBCType.VARCHAR, this.lastName.get()), new ParameterValue("password", JDBCType.VARCHAR, this.password.get()), new ParameterValue("roleDescription", JDBCType.VARCHAR, this.roleDescription), new ParameterValue("status", JDBCType.VARCHAR, this.status.get()), new ParameterValue("cloneUserName", JDBCType.VARCHAR, this.vclone.userName.get())};
            this.getDbAccess().performDbOperation(query, paramValue, true);
            this.vclone = this.clone();
        }
        catch (Exception ex) {
            this.rollBack();
            if (ex instanceof BaseConcurrencyException) {
                throw new BaseConcurrencyException("This object has been modified by another user, please reload your data", null);
            }
            throw ex;
        }
    }

    @Override
    public void delete() {
        String query = "Delete from \"User\" where userName=? ";
        try {
            this.getDbAccess().performDbOperation(query, new ParameterValue[]{new ParameterValue("userName", JDBCType.VARCHAR, this.userName.get())});
        }
        catch (Exception ex) {
            Logger.getLogger(User.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public Searchable getSearchable() {
        Searchable sb = new Searchable();
        String[] parameters = new String[]{"dateCreated", "firstName", "lastName", "password", "roleDescription", "status", "userName"};
        sb.setTableName("User");
        sb.setParameters(parameters);
        return sb;
    }

    @Override
    public void beforeInsert() {
    }

    @Override
    public void afterInsert() {
        this.setState(ObjectState.Unchanged);
    }

    @Override
    public void beforeUpdate() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void afterUpdate() {
        this.setState(ObjectState.Unchanged);
    }

    @Override
    public void initializeListener() {
        this.firstName.addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                User.this.setFirstName(newValue);
            }
        });
        this.lastName.addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                User.this.setLastName(newValue);
            }
        });
        this.userName.addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                User.this.setUserName(newValue);
            }
        });
        this.password.addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                User.this.setPassword(newValue);
            }
        });
        this.status.addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                User.this.setStatus(newValue);
            }
        });
    }

    public String getRoleDescription() {
        return this.roleDescription;
    }

    public void setRoleDescription(String roleDescription) {
        if (!this.isclone && this.isMustClone()) {
            this.vclone = this.clone();
        }
        this.roleDescription = roleDescription;
        this.changeObjectState();
    }
}

