/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa;

import com.xputertechnologies.santa.Company;
import com.xputertechnologies.santa.DbEntity;
import com.xputertechnologies.santa.Expenses;
import com.xputertechnologies.santa.User;
import com.xputertechnologies.santa.core.BaseConcurrencyException;
import com.xputertechnologies.santa.core.ConsequentialConcurrencyException;
import com.xputertechnologies.santa.core.DataAccess;
import com.xputertechnologies.santa.core.ObjectState;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.core.Searchable;
import com.xputertechnologies.santa.list.CompanyDataList;
import com.xputertechnologies.santa.list.IncomeDataList;
import com.xputertechnologies.santa.list.UserDataList;
import java.sql.Date;
import java.sql.JDBCType;
import java.text.DecimalFormat;
import java.time.LocalDate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class Income
extends DbEntity {
    public Income vClone;
    private boolean isCloned;
    private DataAccess dataAccess = this.getDbAccess();
    public boolean isEdit = false;
    private ObjectProperty<Date> date = new SimpleObjectProperty((Object)Date.valueOf(LocalDate.now()));
    private DoubleProperty amount = new SimpleDoubleProperty();
    private DoubleProperty balanceBf = new SimpleDoubleProperty();
    private User parentUser;
    private Company parentCompany;
    private StringProperty description = new SimpleStringProperty(){

        public void set(String value) {
            super.set(value);
        }
    };
    private StringProperty userName = new SimpleStringProperty();
    private StringProperty code = new SimpleStringProperty();
    private String companyName;
    private IncomeDataList incomes = new IncomeDataList();
    public DecimalFormat df = new DecimalFormat("#.##");
    public StringBinding totalAmountBinding = new StringBinding(){

        protected String computeValue() {
            double result = 0.0;
            for (Income object : Income.this.incomes.getOriginalList()) {
                if (!(object.getAmount() > 0.0)) continue;
                result += object.getAmount();
            }
            return String.valueOf(Float.valueOf(Income.this.df.format(result)));
        }
    };

    public Income(DataAccess dbAccess) {
        super(dbAccess);
    }

    public Income(Date date, double amount, String description, String userName, String code, String companyName, double balanceBf, DataAccess dbAccess) {
        super(dbAccess);
        this.balanceBf.set(balanceBf);
        this.date.set((Object)date);
        this.amount.set(amount);
        this.description.set((Object)description);
        this.userName.set((Object)userName);
        this.code.set((Object)code);
        this.companyName = companyName;
        this.setState(ObjectState.Unchanged);
        this.setMustClone(true);
        this.initializeListener();
    }

    public ObjectProperty<Date> dateProperty() {
        return this.date;
    }

    public Date getDate() {
        return (Date)this.dateProperty().get();
    }

    public void setDate(Date date) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.dateProperty().set((Object)date);
    }

    public DoubleProperty amountProperty() {
        return this.amount;
    }

    public double getAmount() {
        return this.amountProperty().get();
    }

    public DoubleProperty balanceBfProperty() {
        return this.balanceBf;
    }

    public double getBalanceBf() {
        return this.balanceBf.get();
    }

    public void setBalanceBf(double balanceBf) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.balanceBf.set(balanceBf);
        this.changeObjectState();
    }

    public void setAmount(double amount) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.amountProperty().set(amount);
    }

    public void setParentUser(User user) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.userNameProperty().set((Object)(user == null ? "" : user.getUserName()));
    }

    public void loadParentUser() {
        UserDataList userList = new UserDataList();
        String query = "Select * From User Where userName =?";
        userList.selectAll(query, new ParameterValue[]{new ParameterValue("receivingStaffName", JDBCType.VARCHAR, this.userNameProperty())});
        if (userList.getOriginalList().size() > 0) {
            this.parentUser = (User)userList.getOriginalList().get(0);
        }
    }

    public User getParentUser() {
        if (this.parentUser == null) {
            this.loadParentUser();
        }
        return this.parentUser;
    }

    public void setParentCompany(Company company) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.parentCompany = company;
        this.companyName = company == null ? "" : company.getName();
        this.changeObjectState();
    }

    public void loadParentCompany() {
        CompanyDataList companyList = new CompanyDataList(this.getDbAccess());
        String query = "Select * From COMPANY";
        companyList.selectAll(query, this.dataAccess.getEmptyParameterValues());
        if (companyList.getOriginalList().size() > 0) {
            this.parentCompany = (Company)companyList.getOriginalList().get(0);
        }
    }

    public Company getParentCompany() {
        if (this.parentCompany == null) {
            this.loadParentCompany();
        }
        return this.parentCompany;
    }

    public StringProperty descriptionProperty() {
        return this.description;
    }

    public String getDescription() {
        return (String)this.descriptionProperty().get();
    }

    public void setDescription(String description) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.descriptionProperty().set((Object)description);
    }

    public StringProperty userNameProperty() {
        return this.userName;
    }

    public String getUserName() {
        return (String)this.userNameProperty().get();
    }

    public void setUserName(String userName) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.userNameProperty().set((Object)userName);
    }

    public StringProperty codeProperty() {
        return this.code;
    }

    public String getCode() {
        return (String)this.codeProperty().get();
    }

    public void setCode(String code) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.codeProperty().set((Object)code);
    }

    public Income clone() {
        Income income = new Income(this.dataAccess);
        income.setMustClone(false);
        income.amount.set(this.amount.get());
        income.code.set((Object)((String)this.code.get()));
        income.companyName = this.companyName;
        income.date.set((Object)((Date)this.date.get()));
        income.description.set((Object)((String)this.description.get()));
        income.userName.set((Object)((String)this.userName.get()));
        income.balanceBf.set(this.balanceBf.get());
        this.setMustClone(true);
        this.isCloned = true;
        return income;
    }

    protected void rollBack() {
        this.amount.set(this.vClone.amount.get());
        this.code.set((Object)((String)this.vClone.code.get()));
        this.companyName = this.vClone.companyName;
        this.date.set((Object)((Date)this.vClone.date.get()));
        this.description.set((Object)((String)this.vClone.description.get()));
        this.userName.set((Object)((String)this.vClone.userName.get()));
        this.balanceBf.set(this.vClone.balanceBf.get());
        this.setMustClone(true);
    }

    public ObservableList<Income> search(Date FromDate, Date ToDate, DataAccess dt) {
        ObservableList res = FXCollections.observableArrayList();
        IncomeDataList result = new IncomeDataList(dt);
        result.selectAll("select * from INCOME where  \"date\" between ? And ?", new ParameterValue[]{new ParameterValue("ParamFromDate", JDBCType.DATE, FromDate), new ParameterValue("ParamToDate", JDBCType.DATE, ToDate)});
        for (Income object : result.getOriginalList()) {
            res.add((Object)object);
        }
        return res;
    }

    @Override
    public void insert() throws Exception {
        try {
            String query = "INSERT INTO INCOME( \"date\", amount, description, userName,code,companyName,balanceBf) Values(?,?,?,?,?,?,?)";
            ParameterValue[] parameterValues = new ParameterValue[]{new ParameterValue("date", JDBCType.DATE, this.date.get()), new ParameterValue("amount", JDBCType.DOUBLE, this.amount.get()), new ParameterValue("description", JDBCType.VARCHAR, this.description.get()), new ParameterValue("userName", JDBCType.VARCHAR, this.userName.get()), new ParameterValue("code", JDBCType.VARCHAR, this.code.get()), new ParameterValue("companyName", JDBCType.VARCHAR, this.companyName), new ParameterValue("balanceBf", JDBCType.DOUBLE, this.balanceBf.get())};
            this.dataAccess.performDbOperation(query, parameterValues);
            this.vClone = this.clone();
        }
        catch (Exception e) {
            this.rollBack();
            this.isCloned = false;
            throw e;
        }
    }

    @Override
    public void update() throws Exception {
        try {
            String query = "UPDATE INCOME SET  \"date\"=?, amount=?, description=?, userName=?,code=?, companyName=?, balanceBf=? WHERE code=? ";
            ParameterValue[] parameterValues = new ParameterValue[]{new ParameterValue("date", JDBCType.DATE, this.date.get()), new ParameterValue("amount", JDBCType.DOUBLE, this.amount.get()), new ParameterValue("description", JDBCType.VARCHAR, this.description.get()), new ParameterValue("userName", JDBCType.VARCHAR, this.userName.get()), new ParameterValue("code", JDBCType.VARCHAR, this.code.get()), new ParameterValue("companyName", JDBCType.VARCHAR, this.companyName), new ParameterValue("cloneCode", JDBCType.VARCHAR, this.vClone.code.get()), new ParameterValue("balanceBf", JDBCType.DOUBLE, this.balanceBf.get())};
            this.dataAccess.performDbOperation(query, parameterValues, true);
            this.vClone = this.clone();
        }
        catch (Exception e) {
            if (e instanceof BaseConcurrencyException) {
                String message = e.getMessage();
                throw new ConsequentialConcurrencyException(message, (Object)null);
            }
            throw e;
        }
    }

    @Override
    public void delete() {
        try {
            String query = "DELETE FROM INCOME WHERE code=?";
            ParameterValue[] parameterValues = new ParameterValue[]{new ParameterValue("vCloneCode", JDBCType.VARCHAR, this.code.get())};
            this.dataAccess.performDbOperation(query, parameterValues);
        }
        catch (Exception ex) {
            Logger.getLogger(Income.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public Searchable getSearchable() {
        Searchable searchable = new Searchable();
        searchable.setTableName("Income");
        String[] parameters = new String[]{"\"date\"", "amount", "description", "userName", "code", "companyName"};
        searchable.setParameters(parameters);
        return searchable;
    }

    @Override
    public void beforeInsert() {
        this.getParentCompany().setLastIncomeExpenseCount(this.getParentCompany().getLastIncomeExpenseCount() + 1);
        this.codeProperty().set((Object)String.valueOf(this.getParentCompany().getLastIncomeExpenseCount()));
        this.balanceBf.set(this.getParentCompany().getBalanceBf());
        this.getParentCompany().setBalanceBf(this.getParentCompany().getBalanceBf() + this.getAmount());
        try {
            this.parentCompany.update();
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Exception ex) {
                Logger.getLogger(Income.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    @Override
    public void afterInsert() {
        this.setState(ObjectState.Unchanged);
    }

    @Override
    public void beforeUpdate() {
        this.parentCompany.setLastIncomeExpenseCount(this.parentCompany.getLastIncomeExpenseCount() + 1);
        this.codeProperty().set((Object)String.valueOf(this.parentCompany.getLastIncomeExpenseCount()));
        try {
            this.parentCompany.update();
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Exception ex) {
                Logger.getLogger(Expenses.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    @Override
    public void afterUpdate() {
        this.setState(ObjectState.Unchanged);
    }

    public IncomeDataList getIncomeItemsList() {
        return this.incomes;
    }

    public void setIncomeItemsList(IncomeDataList incomes) {
        this.incomes = incomes;
    }

    @Override
    public void initializeListener() {
        this.code.addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                Income.this.setCode(newValue);
            }
        });
        this.userName.addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                Income.this.setUserName(newValue);
            }
        });
        this.description.addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                Income.this.setDescription(newValue);
            }
        });
        this.amount.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                Income.this.setAmount((Double)newValue);
            }
        });
        this.date.addListener((ChangeListener)new ChangeListener<Date>(){

            public void changed(ObservableValue<? extends Date> observable, Date oldValue, Date newValue) {
                Income.this.setDate(newValue);
            }
        });
    }
}

