/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa;

import com.xputertechnologies.santa.Customer;
import com.xputertechnologies.santa.DbEntity;
import com.xputertechnologies.santa.core.BaseConcurrencyException;
import com.xputertechnologies.santa.core.ConsequentialConcurrencyException;
import com.xputertechnologies.santa.core.DataAccess;
import com.xputertechnologies.santa.core.ObjectState;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.core.Searchable;
import java.sql.JDBCType;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class Employee
extends DbEntity {
    private StringProperty empId = new SimpleStringProperty();
    private StringProperty empName = new SimpleStringProperty();
    public Employee vClone;
    private boolean isCloned;
    DataAccess dt = this.getDbAccess();
    private int sn;

    public String getEmpId() {
        return (String)this.empId.get();
    }

    public void setEmpId(String empId) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.empId.set((Object)empId);
    }

    public String getEmpName() {
        return (String)this.empName.get();
    }

    public void setEmpName(String empName) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.empName.set((Object)empName);
    }

    public Employee(DataAccess dt) {
        super(dt);
    }

    public Employee(String empId, String empName, DataAccess dbAccess) {
        super(dbAccess);
        this.empId.set((Object)empId);
        this.empName.set((Object)empName);
        this.setState(ObjectState.Unchanged);
        this.setMustClone(true);
        this.initializeListener();
    }

    public Employee clone() {
        Employee employee = new Employee(this.dt);
        employee.setMustClone(false);
        employee.empId.set((Object)((String)this.empId.get()));
        employee.empName.set((Object)((String)this.empName.get()));
        this.setMustClone(true);
        this.isCloned = true;
        return employee;
    }

    protected void rollBack() {
        this.empId.set((Object)((String)this.vClone.empId.get()));
        this.empName.set((Object)((String)this.vClone.empName.get()));
        this.setMustClone(true);
    }

    @Override
    public void insert() throws Exception {
        try {
            String query = "INSERT INTO Employee (empId,empName) Values(?,?)";
            ParameterValue[] parameterValues = new ParameterValue[]{new ParameterValue("empId", JDBCType.VARCHAR, this.empId.get()), new ParameterValue("empName", JDBCType.VARCHAR, this.empName.get())};
            this.getDbAccess().performDbOperation(query, parameterValues);
            this.vClone = this.clone();
        }
        catch (Exception e) {
            this.rollBack();
            this.isCloned = false;
            throw e;
        }
    }

    @Override
    public void update() throws Exception {
        try {
            String query = "UPDATE Employee SET empId=?, empName=? WHERE empId=?";
            ParameterValue[] parameterValues = new ParameterValue[]{new ParameterValue("empId", JDBCType.VARCHAR, this.empId.get()), new ParameterValue("email", JDBCType.VARCHAR, this.empName.get()), new ParameterValue("empId", JDBCType.VARCHAR, this.vClone.empId.get())};
            this.getDbAccess().performDbOperation(query, parameterValues, true);
            this.vClone = this.clone();
        }
        catch (Exception e) {
            if (e instanceof BaseConcurrencyException) {
                String message = e.getMessage();
                throw new ConsequentialConcurrencyException(message, (Object)null);
            }
            throw e;
        }
    }

    @Override
    public void delete() {
        String query = "DELETE FROM Employee WHERE empId=?";
        ParameterValue[] parameterValues = new ParameterValue[]{new ParameterValue("code", JDBCType.VARCHAR, this.empId.get())};
        try {
            this.getDbAccess().performDbOperation(query, parameterValues);
        }
        catch (Exception ex) {
            Logger.getLogger(Customer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void beforeInsert() {
    }

    @Override
    public void afterInsert() {
    }

    @Override
    public void beforeUpdate() {
    }

    @Override
    public void afterUpdate() {
    }

    @Override
    public Searchable getSearchable() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void initializeListener() {
    }

    public int getSn() {
        return this.sn;
    }

    public void setSn(int sn) {
        this.sn = sn;
    }

    public String toString() {
        return String.valueOf(this.empName.get());
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        Employee store = (Employee)object;
        return ((String)this.empId.get()).equals(store.empId.get());
    }
}

