/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.xputertechnologies.santa.DbEntity;
import com.xputertechnologies.santa.Request;
import com.xputertechnologies.santa.RequestItem;
import com.xputertechnologies.santa.RequestStatus;
import com.xputertechnologies.santa.RequestType;
import com.xputertechnologies.santa.RequestitemSerial;
import com.xputertechnologies.santa.UserType;
import com.xputertechnologies.santa.list.StockItemList;
import com.xputertechnologies.santa.ui.CustomEditableTableColumnNumberInteger;
import com.xputertechnologies.santa.ui.CustomEditableTableColumnsRequestItemItemCodeAutocomplete;
import com.xputertechnologies.santa.ui.NewRequestPane;
import com.xputertechnologies.santa.ui.Santa;
import com.xputertechnologies.santa.ui.TempRoleManagement;
import com.xputertechnologies.santa.ui.UIParent;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.util.Callback;
import javafx.util.Duration;
import javafx.util.StringConverter;
import javafx.util.converter.IntegerStringConverter;

public class TransferSaleItemScanDialogB2B
extends UIParent {
    protected StringConverter<? extends Number> IntConverter = new IntegerStringConverter(){

        public String toString(Integer object) {
            if (object != null) {
                return Integer.toString(object);
            }
            return null;
        }

        public Integer fromString(String string) {
            Integer d = 0;
            if (!string.isEmpty()) {
                string = string.replace(",", "");
                d = Integer.parseInt(string);
            }
            return d;
        }
    };
    Request request;
    @FXML
    Label errorLbl;
    @FXML
    TextArea comment;
    @FXML
    HBox hbox;
    @FXML
    Button btnAdd;
    @FXML
    ListView<RequestitemSerial> listview;
    @FXML
    TextField TFscan;
    @FXML
    private TableColumn colItemCode;
    @FXML
    private TableColumn colName;
    @FXML
    private TableColumn colQtyAppr;
    @FXML
    private TableColumn colQtyReq;
    @FXML
    private TableColumn colQtyRel;
    @FXML
    private TableColumn colQtyAccp;
    @FXML
    private TableView<RequestItem> table;
    Timeline timeline;

    public TransferSaleItemScanDialogB2B(Santa app, final Request request) {
        super("TransferSaleItemScanDialogB2B.fxml", app);
        this.title = "Accept/Release B2B";
        this.btnAdd.setVisible(false);
        this.errorLbl.setVisible(false);
        if (request.getItems().isEmpty()) {
            request.loadRequestItems();
        }
        if (request.getStatus().equals(RequestStatus.PENDING.name())) {
            this.comment.textProperty().bindBidirectional((Property)request.approvalCommentProperty());
            request.getItems().forEach(v -> v.setApprovedQty(v.getQuantity()));
            this.hbox.setVisible(false);
        }
        if (request.getStatus().equals(RequestStatus.APPROVED.name())) {
            this.comment.textProperty().bindBidirectional((Property)request.releaseCommentProperty());
            request.getItems().forEach(v -> {
                v.setReleasedQuantity(v.getQuantity());
                v.setTempQty(v.getQuantity());
            });
        }
        if (request.getStatus().equals(RequestStatus.RELEASED.name()) || request.getStatus().equals(RequestStatus.ACCEPTED.name())) {
            this.comment.textProperty().bindBidirectional((Property)request.acceptedCommentProperty());
            request.getItems().forEach(v -> {
                if (request.getStatus().equals(RequestStatus.ACCEPTED.name())) {
                    if (v.getAcceptedQty().intValue() == v.getReleasedQuantity()) {
                        v.hasAccepted = true;
                        v.setTempQty(v.getAcceptedQty());
                    } else {
                        v.setTempQty(v.getReleasedQuantity() - v.getAcceptedQty());
                    }
                } else {
                    v.setTempQty(v.getReleasedQuantity());
                }
            });
        }
        this.colItemCode.setCellValueFactory((Callback)new PropertyValueFactory("itemCode"));
        if (request.getStatus().equals(RequestStatus.APPROVED.name()) && request.getRequestType().equals(RequestType.Outbound.name()) && TempRoleManagement.headOfficeOnly(UserType.valueOf(this.mainPage.currentUser.getRoleDescription()))) {
            if (this.santa.Products.isEmpty()) {
                try {
                    this.santa.Products.addAll(StockItemList.selectAllYuProducts(this.da));
                }
                catch (SQLException ex) {
                    Logger.getLogger(NewRequestPane.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            Callback itemCodeFactory = param -> new CustomEditableTableColumnsRequestItemItemCodeAutocomplete(this.santa.Products);
            this.colItemCode.setCellFactory(itemCodeFactory);
        }
        this.colName.setCellValueFactory((Callback)new PropertyValueFactory("itemName"));
        this.colQtyAppr.setCellValueFactory((Callback)new PropertyValueFactory("approvedQty"));
        this.colQtyReq.setCellValueFactory((Callback)new PropertyValueFactory("quantity"));
        Callback QtyApprFactory = param -> new CustomEditableTableColumnNumberInteger(this);
        this.colQtyAppr.setCellFactory(QtyApprFactory);
        if (!request.getStatus().equals(RequestStatus.PENDING.name()) || !TempRoleManagement.canApproveTransfer(UserType.valueOf(this.currentUser.getRoleDescription()))) {
            this.colQtyAppr.setEditable(false);
        }
        Callback QtyReqFactory = param -> new CustomEditableTableColumnNumberInteger(this);
        this.colQtyReq.setCellFactory(QtyReqFactory);
        Callback QtyRelFactory = param -> new CustomEditableTableColumnNumberInteger(this);
        this.colQtyRel.setCellFactory(QtyRelFactory);
        if (!request.getStatus().equals(RequestStatus.APPROVED.name()) || !request.getToStoreCode().equals(this.currentUser.getParentCompany().getB2bLocationCode()) && request.getRequestType().equals(RequestType.Inbound.name()) || !request.getFromStoreCode().equals(this.currentUser.getParentCompany().getB2bLocationCode()) && request.getRequestType().equals(RequestType.Outbound.name())) {
            this.colQtyRel.setEditable(false);
            this.colQtyRel.setCellValueFactory((Callback)new PropertyValueFactory("releasedQuantity"));
            this.colQtyAccp.setCellValueFactory((Callback)new PropertyValueFactory("tempQty"));
        }
        Callback QtyAccpFactory = param -> new CustomEditableTableColumnNumberInteger(this);
        this.colQtyAccp.setCellFactory(QtyAccpFactory);
        if (!request.getStatus().equals(RequestStatus.RELEASED.name()) && !request.getStatus().equals(RequestStatus.ACCEPTED.name()) || !request.getFromStoreCode().equals(this.currentUser.getParentCompany().getB2bLocationCode()) && request.getRequestType().equals(RequestType.Inbound.name()) || !request.getToStoreCode().equals(this.currentUser.getParentCompany().getB2bLocationCode()) && request.getRequestType().equals(RequestType.Outbound.name())) {
            this.colQtyAccp.setEditable(false);
            this.colQtyRel.setCellValueFactory((Callback)new PropertyValueFactory("tempQty"));
            this.colQtyAccp.setCellValueFactory((Callback)new PropertyValueFactory("acceptedQty"));
        }
        this.table.setItems(request.getItems());
        this.table.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.disableProperty().bind((ObservableValue)Bindings.select((ObservableValue)row.itemProperty(), (String[])new String[]{"hasAccepted"}).isEqualTo((Object)true));
            return row;
        });
        this.TFscan.setOnAction(v -> {
            if (this.table.getSelectionModel().getSelectedItem() != null) {
                RequestItem requestItem = (RequestItem)this.table.getSelectionModel().getSelectedItem();
                if (request.getStatus().equals(RequestStatus.APPROVED.name())) {
                    if (requestItem.getSerials().stream().filter(p -> p.getSerial().equals(this.TFscan.getText().trim())).findAny().orElse(null) == null) {
                        RequestitemSerial serial = new RequestitemSerial(this.da);
                        serial.setItemCode(requestItem.getItemCode());
                        serial.setRequestItemCode(requestItem.getCode());
                        serial.setRequestCode(request.getCode());
                        serial.setSerial(this.TFscan.getText().trim());
                        if (requestItem.getApprovedQty() > requestItem.getSerials().size()) {
                            if (requestItem.getSerials().size() == 0) {
                                requestItem.setReleasedQuantity(0);
                            }
                            requestItem.setReleasedQuantity(requestItem.getReleasedQuantity() + 1);
                            requestItem.getSerials().add((Object)serial);
                        }
                    } else {
                        this.showNotif(false, "Item with the same serial " + this.TFscan.getText() + " already exist");
                        this.listview.getSelectionModel().select((Object)requestItem.getSerials().stream().filter(p -> p.getSerial().equals(this.TFscan.getText().trim())).findAny().get());
                    }
                    this.TFscan.clear();
                    this.TFscan.requestFocus();
                } else {
                    RequestitemSerial serial = requestItem.getSerials().stream().filter(p -> p.getSerial().equals(this.TFscan.getText().trim())).findAny().orElse(null);
                    if (!(requestItem.getReleasedQuantity() <= requestItem.getSerials().size() || serial != null && serial.getIsAccepted().booleanValue())) {
                        if (requestItem.getSerials().size() == 0) {
                            requestItem.setAcceptedQty(0);
                        }
                        requestItem.setAcceptedQty(requestItem.getAcceptedQty() + 1);
                        if (serial == null) {
                            serial = new RequestitemSerial(this.da);
                            serial.setItemCode(requestItem.getItemCode());
                            serial.setRequestItemCode(requestItem.getCode());
                            serial.setRequestCode(request.getCode());
                            serial.setSerial(this.TFscan.getText().trim());
                            requestItem.getSerials().add((Object)serial);
                            serial.setIsAccepted(Boolean.TRUE);
                        }
                    }
                    this.TFscan.clear();
                    this.TFscan.requestFocus();
                }
            }
        });
        this.btnAdd.setOnAction(val -> {
            if (!this.TFscan.getText().isEmpty() && this.table.getSelectionModel().getSelectedItem() != null) {
                RequestItem requestItem = (RequestItem)this.table.getSelectionModel().getSelectedItem();
                if (requestItem.getSerials().stream().filter(p -> p.getSerial().equals(this.TFscan.getText())).findAny().orElse(null) == null) {
                    RequestitemSerial serial = new RequestitemSerial(this.da);
                    serial.setItemCode(requestItem.getItemCode());
                    serial.setRequestItemCode(requestItem.getCode());
                    serial.setSerial(this.TFscan.getText().trim());
                    requestItem.getSerials().add((Object)serial);
                    if (requestItem.getReleasedQuantity() < requestItem.getSerials().size()) {
                        requestItem.setReleasedQuantity(requestItem.getReleasedQuantity() + 1);
                    }
                } else {
                    this.showNotif(false, "Item with the same serial " + this.TFscan.getText() + " already exist");
                    this.listview.getSelectionModel().select((Object)requestItem.getSerials().stream().filter(p -> p.getSerial().equals(this.TFscan.getText().trim())).findAny().get());
                }
            } else {
                this.showNotif(false, "Please select item and  supply serial in the search box then try again ");
            }
            this.TFscan.clear();
            this.TFscan.requestFocus();
            this.btnAdd.setVisible(false);
            this.errorLbl.setVisible(false);
        });
        this.listview.setCellFactory((Callback)new Callback<ListView<RequestitemSerial>, ListCell<RequestitemSerial>>(){

            public ListCell<RequestitemSerial> call(ListView<RequestitemSerial> param) {
                final Tooltip tooltip = new Tooltip();
                ListCell<RequestitemSerial> cell = new ListCell<RequestitemSerial>(){

                    public void updateItem(final RequestitemSerial requstSerial, boolean empty) {
                        super.updateItem((Object)requstSerial, empty);
                        if (empty) {
                            this.setText(null);
                            this.setGraphic(null);
                        } else {
                            this.setText(null);
                            GridPane grid = new GridPane();
                            grid.setHgap(10.0);
                            grid.setVgap(4.0);
                            grid.setPadding(new Insets(0.0, 10.0, 0.0, 10.0));
                            Label lblSerial = new Label();
                            lblSerial.setText(requstSerial.getSerial());
                            String cachelistname = "-fx-font-weight: bold;";
                            lblSerial.setStyle(cachelistname);
                            grid.add((Node)lblSerial, 0, 0);
                            ImageView btnRemove = new ImageView();
                            btnRemove.setFitHeight(20.0);
                            btnRemove.setFitWidth(20.0);
                            btnRemove.setImage(new Image("/com/xputertechnologies/santa/ui/Images/decline.png"));
                            grid.add((Node)btnRemove, 1, 0);
                            btnRemove.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

                                public void handle(MouseEvent event) {
                                    event.consume();
                                    RequestItem requestItem = (RequestItem)TransferSaleItemScanDialogB2B.this.table.getSelectionModel().getSelectedItem();
                                    if (request.getStatus().equals(RequestStatus.APPROVED.name())) {
                                        requestItem.getSerials().remove((Object)requstSerial);
                                        requestItem.setReleasedQuantity(requestItem.getReleasedQuantity() - 1);
                                    } else {
                                        requestItem.getSerials().remove((Object)requstSerial);
                                        requstSerial.setIsAccepted(false);
                                        requestItem.setAcceptedQty(requestItem.getAcceptedQty() - 1);
                                    }
                                    TransferSaleItemScanDialogB2B.this.table.refresh();
                                }
                            });
                            this.setTooltip(tooltip);
                            this.setGraphic((Node)grid);
                        }
                    }
                };
                return cell;
            }
        });
        this.table.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<RequestItem>(){

            public void changed(ObservableValue<? extends RequestItem> observable, RequestItem oldValue, RequestItem newValue) {
                if (newValue != null) {
                    TransferSaleItemScanDialogB2B.this.listview.setItems(newValue.getSerials());
                }
            }
        });
    }

    @Override
    public void propertyChange(DbEntity data) {
        RequestItem req = (RequestItem)data;
    }

    void showNotif(boolean iswarning, String msg) {
        int notificationTimeInSecond = 10;
        if (iswarning) {
            this.btnAdd.setVisible(true);
        }
        this.errorLbl.setText(msg);
        this.errorLbl.setVisible(true);
        this.timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)notificationTimeInSecond), ae -> {
            this.btnAdd.setVisible(false);
            this.errorLbl.setVisible(false);
        }, new KeyValue[0])});
        this.timeline.play();
    }
}

