/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXCheckBox;
import com.xputertechnologies.santa.Sale;
import com.xputertechnologies.santa.SaleItem;
import com.xputertechnologies.santa.ui.NotificationType;
import com.xputertechnologies.santa.ui.SalesReturnLine;
import com.xputertechnologies.santa.ui.SalesReturnPane;
import com.xputertechnologies.santa.ui.UIControlBase;
import com.xputertechnologies.santa.ui.UIParent;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.layout.VBox;

public class SalesReturn
extends UIControlBase {
    @FXML
    private JFXButton btnReturn;
    @FXML
    private JFXCheckBox chkAll;
    @FXML
    private TextArea tbComment;
    @FXML
    private Label lblInvoiceNo;
    @FXML
    private Label lblSaleId;
    @FXML
    private VBox vbItems;

    public SalesReturn(final Sale sale, UIParent uIParent) {
        this.lblInvoiceNo.setText(Integer.toString(sale.getInvoiceNumber()));
        this.lblSaleId.setText(sale.getSaleId());
        this.btnReturn.setOnAction(eh -> {
            if (this.tbComment.getText().isEmpty()) {
                ((SalesReturnPane)uIParent).mainPage.showNotification(NotificationType.Warning, "Please return supply comment", uIParent);
            } else {
                ((SalesReturnPane)uIParent).returnSale(sale);
            }
        });
        this.chkAll.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (newValue.booleanValue()) {
                    sale.getSaleItemsList().forEach(action -> action.setQtyToreturnQty(action.getQuantity()));
                }
            }
        });
        this.chkAll.setSelected(true);
        this.chkAll.setDisable(true);
        this.tbComment.textProperty().bindBidirectional(sale.returnCommentProperty());
        this.setLines(sale.getSaleItemsList());
    }

    void setLines(ObservableList<SaleItem> lines) {
        this.vbItems.getChildren().clear();
        for (int i = 0; i < lines.size(); ++i) {
            SalesReturnLine saleReturnLine = new SalesReturnLine((SaleItem)lines.get(i), i);
            this.vbItems.getChildren().add((Object)saleReturnLine);
        }
    }
}

