/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.jfoenix.controls.JFXButton;
import com.xputertechnologies.santa.ExcelReportObject;
import com.xputertechnologies.santa.Request;
import com.xputertechnologies.santa.RequestStatus;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.list.RequestItemDataList;
import com.xputertechnologies.santa.ui.General;
import com.xputertechnologies.santa.ui.Santa;
import com.xputertechnologies.santa.ui.TransferPane;
import com.xputertechnologies.santa.ui.UIParent;
import java.sql.JDBCType;
import java.util.ArrayList;
import java.util.Arrays;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.VBox;
import javafx.util.Callback;

public class RequestItem
extends UIParent {
    @FXML
    private VBox vbApprovals;
    @FXML
    private VBox vbDeclines;
    @FXML
    private JFXButton btnResendApproval;
    @FXML
    private Label lblPending;
    @FXML
    private Label lblCancel;
    @FXML
    private Label lblClose;
    @FXML
    private Label lblDecline;
    @FXML
    private TableView<com.xputertechnologies.santa.RequestItem> tbRequest;
    @FXML
    private TableColumn<com.xputertechnologies.santa.RequestItem, String> colSn;
    @FXML
    private TableColumn<com.xputertechnologies.santa.RequestItem, String> colName;
    @FXML
    private TableColumn<com.xputertechnologies.santa.RequestItem, String> colPartNo;
    @FXML
    private TableColumn<com.xputertechnologies.santa.RequestItem, String> colQty;
    @FXML
    private TableColumn<com.xputertechnologies.santa.RequestItem, String> colQtyAppr;
    @FXML
    private TableColumn<com.xputertechnologies.santa.RequestItem, String> colQtyRel;
    @FXML
    private TableColumn<com.xputertechnologies.santa.RequestItem, String> colQtyAcp;
    @FXML
    private TableColumn<com.xputertechnologies.santa.RequestItem, String> colQtyRtn;
    Request request;
    @FXML
    private JFXButton btnExport;

    public RequestItem(Santa app, Request request, UIParent parentPane) {
        super("RequestItem.fxml", app);
        Label lbl;
        String[] splits;
        String css;
        this.request = request;
        this.santa = app;
        this.title = "Request Items";
        this.colSn.setCellValueFactory((Callback)new PropertyValueFactory("Sn"));
        this.colName.setCellValueFactory((Callback)new PropertyValueFactory("itemName"));
        this.colPartNo.setCellValueFactory((Callback)new PropertyValueFactory("itemCode"));
        this.colQty.setCellValueFactory((Callback)new PropertyValueFactory("quantity"));
        this.colQtyAppr.setCellValueFactory((Callback)new PropertyValueFactory("approvedQty"));
        this.colQtyRel.setCellValueFactory((Callback)new PropertyValueFactory("releasedQuantity"));
        this.colQtyAcp.setCellValueFactory((Callback)new PropertyValueFactory("acceptedQty"));
        this.colQtyRtn.setCellValueFactory((Callback)new PropertyValueFactory("returnedQty"));
        if (request.getItems().isEmpty()) {
            this.loadRequestItems();
        } else {
            this.tbRequest.setItems(request.getItems());
        }
        if (request.getApprovingUser() != null && !request.getApprovingUser().isEmpty()) {
            css = "-fx-text-fill:white;-fx-background-color:Green; -fx-padding: 3 3 3 3";
            for (String split : splits = request.getApprovingUser().split(",")) {
                lbl = new Label(split);
                lbl.setStyle(css);
                this.vbApprovals.getChildren().add((Object)lbl);
            }
        }
        if (request.getDeclineBy() != null && !request.getDeclineBy().isEmpty()) {
            css = "-fx-text-fill:white;-fx-background-color:Red; -fx-padding: 3 3 3 3";
            for (String split : splits = request.getDeclineBy().split(",")) {
                lbl = new Label(split);
                lbl.setStyle(css);
                this.vbDeclines.getChildren().add((Object)lbl);
            }
        }
        this.btnResendApproval.setVisible(request.getStatus().equals(RequestStatus.PENDING.name()) && this.currentUser.getParentCompany().getStoreCode().equals(request.getFromStoreCode()));
        this.btnResendApproval.setOnAction(eh -> ((TransferPane)parentPane).resendMail(request));
        this.btnExport.setOnAction(x -> {
            ExcelReportObject excelReportObject = new ExcelReportObject();
            excelReportObject.getHeaders().addAll(Arrays.asList("Transfer Code", "Status", "Item Name", "Item Code", "Requested Qty", "Approved Qty", "Released Qty", "Accepted Qty", "Return Qty"));
            for (com.xputertechnologies.santa.RequestItem item : this.tbRequest.getItems()) {
                ArrayList<String> lst = new ArrayList<String>();
                lst.addAll(Arrays.asList(request.getCode(), request.getStatus(), item.getItemName(), item.getItemCode(), Integer.toString(item.getQuantity()), Integer.toString(item.getApprovedQty()), Integer.toString(item.releaseQtyProperty().get()), Integer.toString(item.acceptedQtyProperty().get()), Integer.toString(item.getReturnedQty())));
                excelReportObject.getValues().add(lst);
            }
            General.writeToExcel(app.stage, excelReportObject);
        });
    }

    private void loadRequestItems() {
        RequestItemDataList requestItemDataList = new RequestItemDataList(this.da);
        requestItemDataList.selectAll("Select * from RequestItem where requestCode=?", new ParameterValue[]{new ParameterValue("requestCode", JDBCType.VARCHAR, this.request.getCode())});
        this.tbRequest.setItems(requestItemDataList.getOriginalList());
    }
}

