/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXComboBox;
import com.jfoenix.controls.JFXDatePicker;
import com.jfoenix.controls.JFXDialog;
import com.jfoenix.controls.JFXProgressBar;
import com.jfoenix.controls.JFXTextArea;
import com.xputertechnologies.santa.NameValueObject;
import com.xputertechnologies.santa.NameValueObjectType;
import com.xputertechnologies.santa.PurchaseLineItem;
import com.xputertechnologies.santa.PurchaseOrder;
import com.xputertechnologies.santa.PurchaseType;
import com.xputertechnologies.santa.StockItemData;
import com.xputertechnologies.santa.Store;
import com.xputertechnologies.santa.core.ObjectState;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.list.PurchaseItemSerialDataList;
import com.xputertechnologies.santa.list.PurchaseLineItemDataList;
import com.xputertechnologies.santa.list.PurchaseOrderDataList;
import com.xputertechnologies.santa.list.StockItemList;
import com.xputertechnologies.santa.list.StoreDataList;
import com.xputertechnologies.santa.report.CSVUtils;
import com.xputertechnologies.santa.ui.General;
import com.xputertechnologies.santa.ui.IPurchasePane;
import com.xputertechnologies.santa.ui.NewRequestPane;
import com.xputertechnologies.santa.ui.NotificationType;
import com.xputertechnologies.santa.ui.PurchaseOrderDialog;
import com.xputertechnologies.santa.ui.SalesReturnPaneAudit;
import com.xputertechnologies.santa.ui.Santa;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.sql.JDBCType;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import javafx.util.Callback;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.controlsfx.control.textfield.TextFields;
import org.controlsfx.glyphfont.FontAwesome;
import org.json.JSONArray;
import org.json.JSONObject;

public class PurchaseOrderPane
extends IPurchasePane {
    @FXML
    public Label lblTotal;
    @FXML
    private HBox hbox;
    @FXML
    private MenuItem itemMenu;
    @FXML
    private MenuItem serviceMenu;
    @FXML
    private MenuItem newitemMenu;
    @FXML
    private MenuItem newServiceMenu;
    @FXML
    private JFXDatePicker dueDate;
    @FXML
    private JFXTextArea tbcomment;
    @FXML
    private JFXComboBox<NameValueObject> cmbPayType;
    @FXML
    private JFXComboBox<NameValueObject> cmbCurrency;
    @FXML
    private JFXComboBox<NameValueObject> cmbCostCenter;
    @FXML
    private JFXComboBox<String> cmbSupplier;
    @FXML
    private JFXComboBox<Store> cmbStore;
    @FXML
    private TableView<PurchaseLineItem> table;
    @FXML
    private JFXButton btnPost;
    @FXML
    private JFXButton btnUpload;
    @FXML
    private JFXButton btnNew;
    @FXML
    private JFXButton btnSaveCont;
    @FXML
    private JFXButton btnAttachment;
    @FXML
    private StackPane stackPane;
    @FXML
    private TableColumn colDescription;
    @FXML
    private TableColumn colItemCode;
    @FXML
    private TableColumn colPrice;
    @FXML
    private TableColumn colDelete;
    @FXML
    private TableColumn colSn;
    @FXML
    private TableColumn colEdit;
    @FXML
    private TableColumn colHasSynced;
    @FXML
    private TableColumn colCostCenter;
    @FXML
    private TableColumn colTaxCode;
    @FXML
    private TableColumn colQty;
    @FXML
    private TableColumn colTotal;
    VBox progressContainer;
    double dockTotal = 0.0;
    StoreDataList storeDataList = null;
    ObservableList<String> suppliersList = FXCollections.observableArrayList();
    File attachment;

    public PurchaseOrderPane(Santa app) {
        super("PurchaseOrderPane.fxml", app);
        this.title = "Purchase Order";
        if (this.santa.Products.isEmpty()) {
            try {
                this.santa.Products.addAll(StockItemList.selectAllYuProducts(this.da));
            }
            catch (SQLException ex) {
                Logger.getLogger(PurchaseOrderPane.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        ObservableList<NameValueObject> paymentTerms = NameValueObject.select(NameValueObjectType.PaymentTerm.name(), this.da);
        final ObservableList<NameValueObject> suppliers = NameValueObject.select(NameValueObjectType.Supplier.name(), this.da);
        final ObservableList<NameValueObject> costcenters = NameValueObject.select(NameValueObjectType.CostCentre.name(), this.da);
        final ObservableList<NameValueObject> taxCodes = NameValueObject.select(NameValueObjectType.TaxCodes.name(), this.da);
        suppliers.forEach(c -> this.suppliersList.add((Object)c.getData()));
        ObservableList<NameValueObject> currencies = NameValueObject.select(NameValueObjectType.Currencies.name(), this.da);
        PurchaseOrderDataList podl = new PurchaseOrderDataList(this.da);
        podl.selectAll(this.da);
        this.lblTotal.setText("");
        this.storeDataList = new StoreDataList(this.da);
        this.storeDataList.selectAll("Select *from store", this.da.getEmptyParameterValues());
        this.cmbStore.setItems(this.storeDataList.getOriginalList());
        this.cmbSupplier.setItems(this.suppliersList);
        this.cmbPayType.setItems(paymentTerms);
        this.cmbCostCenter.setItems(costcenters);
        this.cmbCurrency.setItems(currencies);
        this.hbox.setDisable(true);
        this.cmbSupplier.setEditable(true);
        this.btnAttachment.setTooltip(new Tooltip("No attachment loaded"));
        this.btnAttachment.setOnAction(v -> {
            FileChooser fileChooser = new FileChooser();
            this.attachment = fileChooser.showOpenDialog((Window)this.santa.stage);
            if (this.attachment != null) {
                if (this.attachment.length() / 1024L > 2048L) {
                    this.attachment = null;
                    this.btnAttachment.setTooltip(new Tooltip("No attachment loaded"));
                    this.mainPage.showNotification(NotificationType.Information, "Attachment File cannot be more than 2M.", this);
                } else {
                    this.btnAttachment.setTooltip(new Tooltip(this.attachment.getAbsolutePath()));
                }
            } else {
                this.btnAttachment.setTooltip(new Tooltip("No attachment loaded"));
            }
        });
        TextFields.bindAutoCompletion((TextField)this.cmbSupplier.getEditor(), (Collection)this.cmbSupplier.getItems());
        if (!podl.getOriginalList().isEmpty()) {
            this.purchaseOrder = (PurchaseOrder)podl.getOriginalList().get(0);
            this.purchaseOrder.loadPurchaseItem();
            this.purchaseOrder.resetNumbering();
            this.lblTotal.textProperty().bindBidirectional((Property)this.purchaseOrder.totalProperty(), this.dConverter);
            this.dueDate.setValue((Object)this.purchaseOrder.getDueDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
            if (!this.purchaseOrder.getSupplierCode().isEmpty() && suppliers.stream().filter(k -> k.getKey().equals(this.purchaseOrder.getSupplierCode())).count() > 0L) {
                this.cmbSupplier.getSelectionModel().select((Object)suppliers.stream().filter(k -> k.getKey().equals(this.purchaseOrder.getSupplierCode())).findAny().get().getData());
            }
            if (!this.purchaseOrder.getPaymentTerm().isEmpty() && paymentTerms.stream().filter(k -> k.getKey().equals(this.purchaseOrder.getPaymentTerm())).count() > 0L) {
                this.cmbPayType.getSelectionModel().select((Object)paymentTerms.stream().filter(k -> k.getKey().equals(this.purchaseOrder.getPaymentTerm())).findAny().get());
            }
            if (!this.purchaseOrder.getCurrency().isEmpty() && currencies.stream().filter(k -> k.getKey().equals(this.purchaseOrder.getCurrency())).count() > 0L) {
                this.cmbCurrency.getSelectionModel().select((Object)currencies.stream().filter(k -> k.getKey().equals(this.purchaseOrder.getCurrency())).findAny().get());
            }
            if (!this.purchaseOrder.getCostCenter().isEmpty() && costcenters.stream().filter(k -> k.getKey().equals(this.purchaseOrder.getCostCenter())).count() > 0L) {
                this.cmbCostCenter.getSelectionModel().select((Object)costcenters.stream().filter(k -> k.getKey().equals(this.purchaseOrder.getCostCenter())).findAny().get());
            }
            this.tbcomment.textProperty().bindBidirectional((Property)this.purchaseOrder.createCommentProperty());
            this.table.setItems(this.purchaseOrder.getItems());
            this.hbox.setDisable(false);
            if (!this.purchaseOrder.getStoreCode().isEmpty()) {
                this.cmbStore.getSelectionModel().select((Object)this.storeDataList.getOriginalList().stream().filter(c -> c.getCode().equals(this.purchaseOrder.getStoreCode())).findAny().get());
            }
            if (this.purchaseOrder.getPurchaseType().equals(PurchaseType.Item.name())) {
                this.colItemCode.setVisible(true);
                this.colQty.setVisible(true);
                this.colTotal.setVisible(true);
            } else {
                this.colItemCode.setVisible(false);
                this.colQty.setVisible(false);
                this.colTotal.setVisible(false);
            }
        }
        this.btnUpload.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.UPLOAD).color(Color.WHITE).size(13.0));
        this.btnNew.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.PLUS).color(Color.WHITE).size(15.0));
        this.btnSaveCont.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.SAVE).color(Color.WHITE).size(13.0));
        this.dueDate.setOnAction(v -> {
            Instant instant = Instant.from(((LocalDate)this.dueDate.getValue()).atStartOfDay(ZoneId.of("GMT")));
            this.purchaseOrder.setDueDate(Date.from(instant));
        });
        this.cmbStore.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<Store>(){

            public void changed(ObservableValue<? extends Store> observable, Store oldValue, Store newValue) {
                if (PurchaseOrderPane.this.purchaseOrder != null) {
                    if (newValue != null) {
                        PurchaseOrderPane.this.purchaseOrder.setStoreCode(newValue.getCode());
                    }
                } else {
                    PurchaseOrderPane.this.mainPage.showNotification(NotificationType.Information, "Please click new and try again", PurchaseOrderPane.this);
                }
            }
        });
        this.cmbCostCenter.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<NameValueObject>(){

            public void changed(ObservableValue<? extends NameValueObject> observable, NameValueObject oldValue, NameValueObject newValue) {
                if (PurchaseOrderPane.this.purchaseOrder != null) {
                    if (newValue != null) {
                        PurchaseOrderPane.this.purchaseOrder.setCostCenter(newValue.getKey());
                    }
                } else {
                    PurchaseOrderPane.this.mainPage.showNotification(NotificationType.Information, "Please click new and try again", PurchaseOrderPane.this);
                }
            }
        });
        this.cmbSupplier.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (PurchaseOrderPane.this.purchaseOrder != null) {
                    if (newValue != null && suppliers.stream().filter(x -> x.getData().equals(newValue)).count() > 0L) {
                        PurchaseOrderPane.this.purchaseOrder.setSupplierCode(suppliers.stream().filter(x -> x.getData().equals(newValue)).findAny().get().getKey());
                        PurchaseOrderPane.this.purchaseOrder.setSupplierName(newValue);
                    }
                } else {
                    PurchaseOrderPane.this.mainPage.showNotification(NotificationType.Information, "Please click new and try again", PurchaseOrderPane.this);
                }
            }
        });
        this.cmbPayType.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<NameValueObject>(){

            public void changed(ObservableValue<? extends NameValueObject> observable, NameValueObject oldValue, NameValueObject newValue) {
                if (PurchaseOrderPane.this.purchaseOrder != null) {
                    if (newValue != null) {
                        PurchaseOrderPane.this.purchaseOrder.setPaymentTerm(newValue.getKey());
                    }
                } else {
                    PurchaseOrderPane.this.mainPage.showNotification(NotificationType.Information, "Please click new and try again", PurchaseOrderPane.this);
                }
            }
        });
        this.cmbCurrency.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<NameValueObject>(){

            public void changed(ObservableValue<? extends NameValueObject> observable, NameValueObject oldValue, NameValueObject newValue) {
                if (PurchaseOrderPane.this.purchaseOrder != null) {
                    if (newValue != null) {
                        PurchaseOrderPane.this.purchaseOrder.setCurrency(newValue.getKey());
                    }
                } else {
                    PurchaseOrderPane.this.mainPage.showNotification(NotificationType.Information, "Please click new and try again", PurchaseOrderPane.this);
                }
            }
        });
        this.newServiceMenu.setOnAction(v -> {
            try {
                if (this.purchaseOrder != null) {
                    this.tbcomment.textProperty().unbindBidirectional((Property)this.purchaseOrder.createCommentProperty());
                }
                this.purchaseOrder = new PurchaseOrder(this.da);
                this.purchaseOrder.setCurrency("NGN");
                this.purchaseOrder.setCostCenter("8000001");
                this.tbcomment.textProperty().bindBidirectional((Property)this.purchaseOrder.createCommentProperty());
                this.cmbCurrency.getSelectionModel().clearSelection();
                this.cmbPayType.getSelectionModel().clearSelection();
                this.cmbCurrency.getSelectionModel().select((Object)currencies.stream().filter(k -> k.getKey().equals(this.purchaseOrder.getCurrency())).findAny().get());
                this.purchaseOrder.setPurchaseType(PurchaseType.Service.name());
                this.table.setItems(this.purchaseOrder.getItems());
                this.hbox.setDisable(false);
                this.cmbSupplier.getSelectionModel().clearSelection();
                this.cmbStore.getSelectionModel().select((Object)this.storeDataList.getOriginalList().stream().filter(c -> c.getCode().equals("Isolo")).findAny().get());
                this.cmbCostCenter.getSelectionModel().select((Object)costcenters.stream().filter(c -> c.getKey().equals("8000001")).findAny().get());
                this.dueDate.setValue((Object)LocalDate.now());
                this.colItemCode.setVisible(false);
                this.colQty.setVisible(false);
                this.btnAttachment.setTooltip(new Tooltip("No attachment loaded"));
                this.attachment = null;
                this.lblTotal.textProperty().bindBidirectional((Property)this.purchaseOrder.totalProperty(), this.dConverter);
                StockItemList.deleteAll("PurchaseOrder", this.da);
                StockItemList.deleteAll("PurchaseLineItem", this.da);
            }
            catch (Exception ex) {
                Logger.getLogger(PurchaseOrderPane.class.getName()).log(Level.SEVERE, null, ex);
            }
        });
        this.newitemMenu.setOnAction(v -> {
            try {
                if (this.purchaseOrder != null) {
                    this.tbcomment.textProperty().unbindBidirectional((Property)this.purchaseOrder.createCommentProperty());
                }
                this.purchaseOrder = new PurchaseOrder(this.da);
                this.purchaseOrder.setCurrency("NGN");
                this.purchaseOrder.setCostCenter("8000001");
                this.tbcomment.textProperty().bindBidirectional((Property)this.purchaseOrder.createCommentProperty());
                this.cmbCurrency.getSelectionModel().clearSelection();
                this.cmbPayType.getSelectionModel().clearSelection();
                this.cmbCurrency.getSelectionModel().select((Object)currencies.stream().filter(k -> k.getKey().equals(this.purchaseOrder.getCurrency())).findAny().get());
                this.purchaseOrder.setPurchaseType(PurchaseType.Item.name());
                this.table.setItems(this.purchaseOrder.getItems());
                this.btnAttachment.setTooltip(new Tooltip("No attachment loaded"));
                this.attachment = null;
                this.hbox.setDisable(false);
                this.cmbSupplier.getSelectionModel().clearSelection();
                this.cmbCostCenter.getSelectionModel().select((Object)costcenters.stream().filter(c -> c.getKey().equals("8000001")).findAny().get());
                this.dueDate.setValue((Object)LocalDate.now());
                this.cmbStore.getSelectionModel().select((Object)this.storeDataList.getOriginalList().stream().filter(c -> c.getCode().equals("Isolo")).findAny().get());
                this.colItemCode.setVisible(true);
                this.colQty.setVisible(true);
                this.colTotal.setVisible(true);
                this.lblTotal.textProperty().bindBidirectional((Property)this.purchaseOrder.totalProperty(), this.dConverter);
                StockItemList.deleteAll("PurchaseOrder", this.da);
                StockItemList.deleteAll("PurchaseLineItem", this.da);
            }
            catch (Exception ex) {
                Logger.getLogger(PurchaseOrderPane.class.getName()).log(Level.SEVERE, null, ex);
            }
        });
        this.colSn.setCellValueFactory((Callback)new PropertyValueFactory("sn"));
        this.colDescription.setCellValueFactory((Callback)new PropertyValueFactory("itemName"));
        this.colItemCode.setCellValueFactory((Callback)new PropertyValueFactory("itemCode"));
        this.colQty.setCellValueFactory((Callback)new PropertyValueFactory("quantity"));
        this.colPrice.setCellValueFactory((Callback)new PropertyValueFactory("price"));
        this.colCostCenter.setCellValueFactory((Callback)new PropertyValueFactory("costCenter"));
        this.colTaxCode.setCellValueFactory((Callback)new PropertyValueFactory("taxCode"));
        this.colTotal.setCellValueFactory((Callback)new PropertyValueFactory("lineTotal"));
        this.colDelete.setCellValueFactory((Callback)new PropertyValueFactory(""));
        this.colEdit.setCellValueFactory((Callback)new PropertyValueFactory(""));
        this.colHasSynced.setCellValueFactory((Callback)new PropertyValueFactory(""));
        Callback<TableColumn<PurchaseLineItem, String>, TableCell<PurchaseLineItem, String>> cellFactoryCostCenter = new Callback<TableColumn<PurchaseLineItem, String>, TableCell<PurchaseLineItem, String>>(){

            public TableCell call(TableColumn<PurchaseLineItem, String> param) {
                TableCell<PurchaseLineItem, String> cell = new TableCell<PurchaseLineItem, String>(){
                    final Label label = new Label();

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                            this.setText(null);
                        } else {
                            PurchaseLineItem req = (PurchaseLineItem)this.getTableView().getItems().get(this.getIndex());
                            if (!req.getCostCenter().isEmpty()) {
                                this.label.setText(costcenters.stream().filter(x -> x.getKey().equals(req.getCostCenter())).findAny().get().getData());
                            }
                            this.setGraphic((Node)this.label);
                            this.setAlignment(Pos.CENTER);
                            this.setText(null);
                        }
                    }
                };
                return cell;
            }
        };
        this.colCostCenter.setCellFactory((Callback)cellFactoryCostCenter);
        Callback<TableColumn<PurchaseLineItem, String>, TableCell<PurchaseLineItem, String>> cellFactoryTax = new Callback<TableColumn<PurchaseLineItem, String>, TableCell<PurchaseLineItem, String>>(){

            public TableCell call(TableColumn<PurchaseLineItem, String> param) {
                TableCell<PurchaseLineItem, String> cell = new TableCell<PurchaseLineItem, String>(){
                    final Label label = new Label();

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                            this.setText(null);
                        } else {
                            PurchaseLineItem req = (PurchaseLineItem)this.getTableView().getItems().get(this.getIndex());
                            if (!req.getCostCenter().isEmpty()) {
                                this.label.setText(taxCodes.stream().filter(x -> x.getKey().equals(req.getTaxCode())).findAny().get().getData());
                            }
                            this.setGraphic((Node)this.label);
                            this.setAlignment(Pos.CENTER);
                            this.setText(null);
                        }
                    }
                };
                return cell;
            }
        };
        this.colTaxCode.setCellFactory((Callback)cellFactoryTax);
        Callback<TableColumn<PurchaseLineItem, String>, TableCell<PurchaseLineItem, String>> cellFactoryViewDelete = new Callback<TableColumn<PurchaseLineItem, String>, TableCell<PurchaseLineItem, String>>(){

            public TableCell call(TableColumn<PurchaseLineItem, String> param) {
                TableCell<PurchaseLineItem, String> cell = new TableCell<PurchaseLineItem, String>(){
                    final JFXButton btn = new JFXButton();

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                            this.setText(null);
                        } else {
                            this.btn.setButtonType(JFXButton.ButtonType.RAISED);
                            this.btn.setGraphic((Node)PurchaseOrderPane.this.fontAwesome.create((Enum)FontAwesome.Glyph.TIMES).color(Color.RED).size(15.0));
                            PurchaseLineItem req = (PurchaseLineItem)this.getTableView().getItems().get(this.getIndex());
                            this.btn.setOnAction(event -> PurchaseOrderPane.this.purchaseOrder.getItems().remove((Object)req));
                            PurchaseOrderPane.this.purchaseOrder.recalculateTotal();
                            this.setGraphic((Node)this.btn);
                            this.setAlignment(Pos.CENTER);
                            this.setText(null);
                        }
                    }
                };
                return cell;
            }
        };
        this.colDelete.setCellFactory((Callback)cellFactoryViewDelete);
        Callback<TableColumn<PurchaseLineItem, String>, TableCell<PurchaseLineItem, String>> cellFactoryViewEdit = new Callback<TableColumn<PurchaseLineItem, String>, TableCell<PurchaseLineItem, String>>(){

            public TableCell call(TableColumn<PurchaseLineItem, String> param) {
                TableCell<PurchaseLineItem, String> cell = new TableCell<PurchaseLineItem, String>(){
                    final JFXButton btn = new JFXButton();

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                            this.setText(null);
                        } else {
                            this.btn.setButtonType(JFXButton.ButtonType.FLAT);
                            this.btn.setGraphic((Node)PurchaseOrderPane.this.fontAwesome.create((Enum)FontAwesome.Glyph.EDIT).color(Color.WHITE).size(20.0));
                            this.btn.setStyle("-fx-background-color: #4FC4F6;");
                            PurchaseLineItem req = (PurchaseLineItem)this.getTableView().getItems().get(this.getIndex());
                            this.btn.setOnAction(event -> {
                                PurchaseOrderPane.this.selectedStock = req;
                                PurchaseOrderPane.this.showDialog();
                            });
                            this.setGraphic((Node)this.btn);
                            this.setAlignment(Pos.CENTER);
                            this.setText(null);
                        }
                    }
                };
                return cell;
            }
        };
        this.colEdit.setCellFactory((Callback)cellFactoryViewEdit);
        Callback<TableColumn<PurchaseLineItem, String>, TableCell<PurchaseLineItem, String>> cellFactoryVieSync = new Callback<TableColumn<PurchaseLineItem, String>, TableCell<PurchaseLineItem, String>>(){

            public TableCell call(TableColumn<PurchaseLineItem, String> param) {
                TableCell<PurchaseLineItem, String> cell = new TableCell<PurchaseLineItem, String>(){
                    final Label lbl = new Label();

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                            this.setText(null);
                        } else {
                            PurchaseLineItem req = (PurchaseLineItem)this.getTableView().getItems().get(this.getIndex());
                            this.lbl.setPadding(new Insets(0.0, 5.0, 0.0, 5.0));
                            if (PurchaseOrderPane.this.purchaseOrder.getSyncFlag().booleanValue()) {
                                this.lbl.setText("Posted");
                                this.lbl.setStyle("-fx-background-color: #00A86B;-fx-text-fill: #FFFFFF;-fx-font-size: 12.0px;");
                            } else {
                                this.lbl.setText("Not Posted");
                                this.lbl.setStyle("-fx-background-color: #FF0000;-fx-text-fill: #FFFFFF;-fx-font-size: 12.0px;");
                            }
                            this.setGraphic((Node)this.lbl);
                            this.setAlignment(Pos.CENTER);
                            this.setText(null);
                        }
                    }
                };
                return cell;
            }
        };
        this.colHasSynced.setCellFactory((Callback)cellFactoryVieSync);
        this.colTotal.setCellFactory(col -> new TableCell<PurchaseLineItem, Number>(){

            public void updateItem(Number price, boolean empty) {
                super.updateItem((Object)price, empty);
                if (empty) {
                    this.setText(null);
                } else if (price != null) {
                    this.setText(General.formatDecimalToMoneyString(price.doubleValue()));
                }
            }
        });
        this.colPrice.setCellFactory(col -> new TableCell<PurchaseLineItem, Number>(){

            public void updateItem(Number price, boolean empty) {
                super.updateItem((Object)price, empty);
                if (empty) {
                    this.setText(null);
                } else if (price != null) {
                    this.setText(General.formatDecimalToMoneyString(price.doubleValue()));
                }
            }
        });
        this.btnSaveCont.setOnAction(x -> {
            if (this.purchaseOrder != null) {
                try {
                    PurchaseOrderDataList pdndl = new PurchaseOrderDataList(this.da);
                    pdndl.selectAll("Select * From PurchaseOrder where code=? and isSaveForPDN=?", new ParameterValue[]{new ParameterValue("isSaveForPDN", JDBCType.CHAR, false)});
                    if (pdndl.getOriginalList().size() > 0) {
                        StockItemList.deleteAll("delete from PurchaseOrder where isSaveForPDN=?", new ParameterValue[]{new ParameterValue("isSaveForPDN", JDBCType.CHAR, false)}, this.da);
                        pdndl.getOriginalList().forEach(p -> {
                            try {
                                StockItemList.deleteAll("delete From PurchaseLineItem where parentCode=?", new ParameterValue[]{new ParameterValue("parentCode", JDBCType.VARCHAR, p.getCode())}, this.da);
                            }
                            catch (Exception ex) {
                                Logger.getLogger(PurchaseOrderPane.class.getName()).log(Level.SEVERE, null, ex);
                            }
                        });
                    }
                    PurchaseOrderDataList podl1 = new PurchaseOrderDataList(this.da);
                    this.purchaseOrder.setState(ObjectState.New);
                    this.purchaseOrder.setIsSaveForPDN(false);
                    podl1.getOriginalList().add((Object)this.purchaseOrder);
                    PurchaseLineItemDataList purchaseLineItemDataList = new PurchaseLineItemDataList(this.da);
                    PurchaseItemSerialDataList purchaseSerilaLineItemDataList = new PurchaseItemSerialDataList(this.da);
                    this.purchaseOrder.getItems().forEach(u -> {
                        u.setState(ObjectState.New);
                        purchaseLineItemDataList.getOriginalList().add(u);
                        u.getSerials().forEach(z -> {
                            z.setState(ObjectState.New);
                            purchaseSerilaLineItemDataList.getOriginalList().add(z);
                        });
                    });
                    this.da.start();
                    podl1.update();
                    purchaseLineItemDataList.update();
                    purchaseSerilaLineItemDataList.update();
                    this.da.end();
                    this.mainPage.showNotification(NotificationType.Success, "Purchase request saved successfully", this);
                }
                catch (Exception ex) {
                    Logger.getLogger(PurchaseOrderPane.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        this.btnNew.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (PurchaseOrderPane.this.purchaseOrder != null) {
                    PurchaseOrderPane.this.selectedStock = null;
                    PurchaseOrderPane.this.showDialog();
                } else {
                    PurchaseOrderPane.this.mainPage.showNotification(NotificationType.Information, "Please select New Purchase Type and try again", PurchaseOrderPane.this);
                }
            }
        });
        this.btnUpload.setOnAction(v -> this.upload());
        this.itemMenu.setOnAction(v -> this.download(true));
        this.serviceMenu.setOnAction(v -> this.download(false));
        this.btnPost.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (PurchaseOrderPane.this.purchaseOrder != null && !PurchaseOrderPane.this.purchaseOrder.getSyncFlag().booleanValue()) {
                    if (PurchaseOrderPane.this.validateControlHere()) {
                        PurchaseOrderPane.this.purchaseOrder.setParentTemplateDescription("Purchase Approval Template");
                        JFXProgressBar progressIndicator = new JFXProgressBar();
                        progressIndicator.setProgress(-1.0);
                        final VBox box = new VBox(new Node[]{progressIndicator});
                        box.setAlignment(Pos.CENTER);
                        PurchaseOrderPane.this.progressContainer = box;
                        PurchaseOrderPane.this.stackPane.getChildren().add((Object)box);
                        Service service = new Service(){

                            protected Task createTask() {
                                return new Task(){

                                    protected Object call() throws Exception {
                                        try {
                                            Object url = PurchaseOrderPane.this.santa.syncSetting.getBEURL();
                                            url = (String)url + "RPurchaseOrder/CreatePurchaseRequests";
                                            JSONArray jSONArray = new JSONArray();
                                            JSONObject job = new JSONObject();
                                            job.put("DocNum", PurchaseOrderPane.this.purchaseOrder.DockNum);
                                            job.put("DocEntry", PurchaseOrderPane.this.purchaseOrder.DocEntry);
                                            job.put("BaseDocumentNum", PurchaseOrderPane.this.purchaseOrder.BaseDocumentNum);
                                            job.put("VendorId", (Object)PurchaseOrderPane.this.purchaseOrder.getSupplierCode());
                                            job.put("VendorName", (Object)PurchaseOrderPane.this.purchaseOrder.getSupplierName());
                                            job.put("DocDate", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(PurchaseOrderPane.this.purchaseOrder.getDateCreated()));
                                            job.put("DeliveryDate", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(PurchaseOrderPane.this.purchaseOrder.getDueDate()));
                                            job.put("Currency", (Object)PurchaseOrderPane.this.purchaseOrder.getCurrency());
                                            job.put("Status", (Object)PurchaseOrderPane.this.purchaseOrder.getStatus());
                                            job.put("Code", (Object)PurchaseOrderPane.this.purchaseOrder.getCode());
                                            PurchaseOrderPane.this.dockTotal = 0.0;
                                            PurchaseOrderPane.this.purchaseOrder.getItems().forEach(v -> {
                                                if (PurchaseOrderPane.this.purchaseOrder.getPurchaseType().equals(PurchaseType.Service.name())) {
                                                    v.setLineTotal(v.getPrice());
                                                    System.out.println("Price service: " + v.getPrice());
                                                }
                                                PurchaseOrderPane.this.dockTotal += v.getLineTotal();
                                                v.setCurrency(PurchaseOrderPane.this.purchaseOrder.getCurrency());
                                            });
                                            job.put("DocTotal", PurchaseOrderPane.this.dockTotal);
                                            job.put("Comment", PurchaseOrderPane.this.purchaseOrder.createCommentProperty().get());
                                            job.put("PurchasingOfficer", (Object)PurchaseOrderPane.this.currentUser.getUserName());
                                            job.put("ApprovalTemplateDescription", (Object)PurchaseOrderPane.this.purchaseOrder.getParentTemplateDescription());
                                            job.put("PurchaseType", (Object)PurchaseOrderPane.this.purchaseOrder.getPurchaseType());
                                            job.put("PaymentTerm", (Object)PurchaseOrderPane.this.purchaseOrder.getPaymentTerm());
                                            job.put("OrderNo", PurchaseOrderPane.this.purchaseOrder.OrderNoProperty().get());
                                            JSONArray jab = new JSONArray();
                                            for (PurchaseLineItem purchaseLineItem : PurchaseOrderPane.this.purchaseOrder.getItems()) {
                                                JSONObject joItem = new JSONObject();
                                                joItem.put("LineNumber", -1);
                                                joItem.put("BaseLineNumber", purchaseLineItem.getBaseLineNumber());
                                                joItem.put("ItemCode", (Object)purchaseLineItem.getItemCode());
                                                joItem.put("Qty", purchaseLineItem.getQuantity());
                                                joItem.put("OpenQty", purchaseLineItem.getOpenQty());
                                                joItem.put("UnitPrice", purchaseLineItem.getPrice());
                                                joItem.put("CostCentre", (Object)purchaseLineItem.getCostCenter());
                                                joItem.put("StoreCode", (Object)purchaseLineItem.getStoreCode());
                                                joItem.put("TaxCode", (Object)purchaseLineItem.getTaxCode());
                                                joItem.put("ItemName", (Object)purchaseLineItem.getItemName());
                                                joItem.put("Currency", (Object)PurchaseOrderPane.this.purchaseOrder.getCurrency());
                                                joItem.put("LineTotal", purchaseLineItem.getQuantity() > 0 ? (double)purchaseLineItem.getQuantity() * purchaseLineItem.getPrice() : purchaseLineItem.getPrice());
                                                joItem.put("Code", (Object)purchaseLineItem.getCode());
                                                joItem.put("Deleted", false);
                                                joItem.put("StoreCode", (Object)PurchaseOrderPane.this.purchaseOrder.getStoreCode());
                                                jab.put((Object)joItem);
                                            }
                                            job.put("LineItems", (Object)jab);
                                            jSONArray.put((Object)job);
                                            HttpPost httpPost = new HttpPost((String)url);
                                            RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectTimeout(Santa.connectionTimeOut).setSocketTimeout(Santa.socketTimeOut).setConnectionRequestTimeout(Santa.socketTimeOut).build();
                                            CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(defaultRequestConfig).build();
                                            File f = Santa.writePayLoadToFileAll(jSONArray.toString());
                                            HttpEntity reqEntity = null;
                                            reqEntity = PurchaseOrderPane.this.attachment != null ? MultipartEntityBuilder.create().setMode(HttpMultipartMode.BROWSER_COMPATIBLE).addBinaryBody("payload", f, ContentType.DEFAULT_BINARY, f.getName()).addBinaryBody("attachment", PurchaseOrderPane.this.attachment, ContentType.DEFAULT_BINARY, PurchaseOrderPane.this.attachment.getName()).build() : MultipartEntityBuilder.create().setMode(HttpMultipartMode.BROWSER_COMPATIBLE).addBinaryBody("payload", f, ContentType.DEFAULT_BINARY, f.getName()).build();
                                            httpPost.setEntity(reqEntity);
                                            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
                                            if (response.getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 204) {
                                                String output;
                                                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                                StringBuilder stringBuilder = new StringBuilder();
                                                System.out.println("Output from Server .... \n");
                                                while ((output = br.readLine()) != null) {
                                                    System.out.println(output);
                                                    stringBuilder.append(output + "\n");
                                                }
                                                br.close();
                                                httpClient.getConnectionManager().shutdown();
                                                String result = stringBuilder.toString();
                                                JSONArray ra = new JSONArray(result);
                                                Platform.runLater(() -> {
                                                    try {
                                                        JSONObject jsono = ra.getJSONObject(0);
                                                        if (jsono != null) {
                                                            if (jsono.isNull("ErrMessage")) {
                                                                String pOCode = jsono.getString("POCode");
                                                                PurchaseOrderPane.this.purchaseOrder.setSyncFlag(Boolean.TRUE);
                                                                StockItemList.deleteAll("PurchaseOrder", PurchaseOrderPane.this.da);
                                                                StockItemList.deleteAll("PurchaseLineItem", PurchaseOrderPane.this.da);
                                                                PurchaseOrderPane.this.table.refresh();
                                                            }
                                                            PurchaseOrderPane.this.stackPane.getChildren().remove((Object)box);
                                                            if (jsono.isNull("ErrMessage")) {
                                                                PurchaseOrderPane.this.mainPage.showNotification(NotificationType.Success, "Purchase request created successfully", PurchaseOrderPane.this);
                                                            } else {
                                                                String error = jsono.getString("ErrMessage");
                                                                PurchaseOrderPane.this.mainPage.showNotification(NotificationType.Error, error, PurchaseOrderPane.this);
                                                            }
                                                            PurchaseOrderPane.this.attachment = null;
                                                        }
                                                    }
                                                    catch (Exception ex) {
                                                        PurchaseOrderPane.this.stackPane.getChildren().remove((Object)box);
                                                        PurchaseOrderPane.this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), PurchaseOrderPane.this);
                                                    }
                                                });
                                            } else {
                                                String output;
                                                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                                StringBuilder stringBuilder = new StringBuilder();
                                                while ((output = br.readLine()) != null) {
                                                    System.out.println(output);
                                                    stringBuilder.append(output + "\n");
                                                }
                                                br.close();
                                                String fullError = stringBuilder.toString();
                                                Platform.runLater(() -> {
                                                    PurchaseOrderPane.this.stackPane.getChildren().remove((Object)box);
                                                    PurchaseOrderPane.this.mainPage.showNotification(NotificationType.Error, fullError, PurchaseOrderPane.this);
                                                });
                                            }
                                        }
                                        catch (Exception ex) {
                                            Platform.runLater(() -> {
                                                PurchaseOrderPane.this.stackPane.getChildren().remove((Object)box);
                                                PurchaseOrderPane.this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), PurchaseOrderPane.this);
                                            });
                                        }
                                        return null;
                                    }
                                };
                            }
                        };
                        progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
                        service.start();
                    }
                } else {
                    PurchaseOrderPane.this.mainPage.showNotification(NotificationType.Information, "No new purchase to post", PurchaseOrderPane.this);
                }
            }
        });
    }

    boolean validateControlHere() {
        this.errorMessage = "";
        if (this.purchaseOrder.getSupplierCode().isEmpty()) {
            this.errorMessage = this.errorMessage + "No supplier selected\n";
            this.mainPage.showNotification(NotificationType.Error, this.errorMessage, this);
            return false;
        }
        if (this.purchaseOrder.getPaymentTerm().isEmpty()) {
            this.errorMessage = this.errorMessage + "No payment term selected";
            this.mainPage.showNotification(NotificationType.Error, this.errorMessage, this);
            return false;
        }
        if (this.purchaseOrder.getCurrency().isEmpty()) {
            this.errorMessage = this.errorMessage + "No currency selected";
            this.mainPage.showNotification(NotificationType.Error, this.errorMessage, this);
            return false;
        }
        if (((String)this.purchaseOrder.createCommentProperty().get()).isEmpty()) {
            this.errorMessage = this.errorMessage + "Please supply comment";
            this.mainPage.showNotification(NotificationType.Error, this.errorMessage, this);
            return false;
        }
        if (this.purchaseOrder.getItems().isEmpty()) {
            this.errorMessage = this.errorMessage + "No Line Item available";
            this.mainPage.showNotification(NotificationType.Error, this.errorMessage, this);
            return false;
        }
        if (this.purchaseOrder.getItems().stream().filter(val -> val.getQuantity() == 0).count() > 0L) {
            this.errorMessage = this.errorMessage + "One or more items do not have quantity, please specify quantity for all items and try again ";
            this.mainPage.showNotification(NotificationType.Error, this.errorMessage, this);
            return false;
        }
        return true;
    }

    void showDialog() {
        this.dialog.setDialogContainer(this.stackPane);
        this.dialog.setTransitionType(JFXDialog.DialogTransition.CENTER);
        this.dialog.setContent((Region)new PurchaseOrderDialog(this));
        this.dialog.setOverlayClose(false);
        this.dialog.show();
    }

    void download(boolean isItem) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Save Template");
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("CSV Document", Arrays.asList("*.csv", "*.CSV")));
        File file = fileChooser.showSaveDialog((Window)this.santa.stage);
        FileWriter fileWriter = null;
        try {
            if (file != null) {
                fileWriter = new FileWriter(file);
                if (isItem) {
                    CSVUtils.writeLine(fileWriter, Arrays.asList("Item Code", "Quantity", "Price"));
                } else {
                    CSVUtils.writeLine(fileWriter, Arrays.asList("Description", "Price"));
                }
                fileWriter.flush();
                fileWriter.close();
                this.mainPage.showNotification(NotificationType.Information, "Template downloaded successfully", this);
            }
        }
        catch (Exception ex) {
            this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), this);
            Logger.getLogger(NewRequestPane.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    void upload() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Save Template");
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("CSV Document", Arrays.asList("*.csv", "*.CSV")));
        String FieldDelimiter = ",";
        File file = fileChooser.showOpenDialog((Window)this.santa.stage);
        try {
            if (file != null) {
                String line;
                BufferedReader br = new BufferedReader(new FileReader(file));
                boolean isItem = this.purchaseOrder.getPurchaseType().equals(PurchaseType.Item.name());
                ArrayList<PurchaseLineItem> purchaseLineItemmmm = new ArrayList<PurchaseLineItem>();
                int count = 0;
                while ((line = br.readLine()) != null) {
                    String[] fields = line.split(FieldDelimiter, -1);
                    if (count > 0) {
                        if (!fields[0].isEmpty()) {
                            StockItemData data = this.santa.Products.stream().filter(v -> v.getItemCode().equals(fields[0].toUpperCase().trim())).findAny().orElse(null);
                            PurchaseLineItem purchaseLineItemExist = this.purchaseOrder.getItems().stream().filter(v -> isItem ? v.getItemCode().equals(fields[0].trim()) : v.getItemName().equals(fields[0].trim())).findAny().orElse(null);
                            if (purchaseLineItemExist == null) {
                                PurchaseLineItem puItem = new PurchaseLineItem(this.da);
                                if (isItem) {
                                    puItem.setItemCode(fields[0].isEmpty() ? "" : fields[0].trim());
                                    puItem.setItemName(data != null ? data.getDescription() : "");
                                    puItem.setQuantity(fields[1].isEmpty() ? 0 : Integer.valueOf(fields[1].trim()));
                                    puItem.setPrice(fields[2].isEmpty() ? 0.0 : Double.parseDouble(fields[2].trim()));
                                    puItem.setParentCode(this.purchaseOrder.getCode());
                                    puItem.setParentPurchase(this.purchaseOrder);
                                } else {
                                    puItem.setItemName(fields[0].trim());
                                    puItem.setPrice(fields[1].isEmpty() ? 0.0 : Double.parseDouble(fields[1].trim()));
                                    puItem.setParentCode(this.purchaseOrder.getCode());
                                    puItem.setParentPurchase(this.purchaseOrder);
                                }
                                puItem.setTaxCode("EX");
                                puItem.setStoreCode("Isolo");
                                puItem.setCostCenter(this.purchaseOrder.getCostCenter());
                                purchaseLineItemmmm.add(puItem);
                            } else {
                                if (purchaseLineItemExist.getCostCenter().isEmpty()) {
                                    purchaseLineItemExist.setCostCenter(this.purchaseOrder.getCostCenter());
                                }
                                if (isItem) {
                                    purchaseLineItemExist.setItemCode(fields[0].isEmpty() ? "" : fields[0].trim());
                                    purchaseLineItemExist.setItemName(data != null ? data.getDescription() : "");
                                    purchaseLineItemExist.setQuantity(fields[1].isEmpty() ? 0 : Integer.valueOf(fields[1].trim()));
                                    purchaseLineItemExist.setPrice(fields[2].isEmpty() ? 0.0 : Double.parseDouble(fields[2].trim()));
                                } else {
                                    purchaseLineItemExist.setItemName(fields[0].trim());
                                    purchaseLineItemExist.setPrice(fields[1].isEmpty() ? 0.0 : Double.parseDouble(fields[1].trim()));
                                }
                            }
                        } else {
                            this.mainPage.showNotification(NotificationType.Information, isItem ? "Item Code cannot be empty" : "Decription cannot be empty", this);
                            break;
                        }
                    }
                    ++count;
                }
                this.purchaseOrder.getItems().addAll(purchaseLineItemmmm);
                this.purchaseOrder.resetNumbering();
                this.purchaseOrder.recalculateTotal();
                this.table.setItems(this.purchaseOrder.getItems());
                this.table.refresh();
                this.mainPage.showNotification(NotificationType.Information, "Data uploaded successfully", this);
            }
        }
        catch (Exception ex) {
            this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), this);
            Logger.getLogger(NewRequestPane.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void loadProduct(final String itemCode, final PurchaseOrderDialog purchaseOrderDialog) {
        JFXProgressBar progressIndicator = new JFXProgressBar();
        progressIndicator.setProgress(-1.0);
        final VBox box = new VBox(new Node[]{progressIndicator});
        box.setAlignment(Pos.CENTER);
        this.progressContainer = box;
        this.stackPane.getChildren().add((Object)box);
        Service service = new Service(){

            protected Task createTask() {
                return new Task(){

                    protected Object call() throws Exception {
                        HttpGet httpget = null;
                        try {
                            String url = PurchaseOrderPane.this.santa.syncSetting.getBEURL();
                            httpget = new HttpGet(url + "RProduct/GetSAPItemsByItemCode?itemCode=" + itemCode);
                            CloseableHttpClient client = HttpClientBuilder.create().build();
                            httpget.setHeader("Content-type", "application/json");
                            HttpResponse response = client.execute((HttpUriRequest)httpget);
                            if (response.getStatusLine().getStatusCode() == 200) {
                                String output;
                                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                StringBuilder stringBuilder = new StringBuilder();
                                while ((output = br.readLine()) != null) {
                                    stringBuilder.append(output + "\n");
                                }
                                br.close();
                                client.getConnectionManager().shutdown();
                                String result = stringBuilder.toString();
                                System.out.println("String " + result);
                                JSONArray ra = new JSONArray(result);
                                System.out.println("JSon " + ra.toString());
                                if (ra.length() > 0) {
                                    ArrayList<StockItemData> list = new ArrayList<StockItemData>();
                                    for (int i = 0; i < ra.length(); ++i) {
                                        JSONObject jo = ra.getJSONObject(i);
                                        StockItemData stkData = new StockItemData();
                                        stkData.setDescription(jo.isNull("ItemName") ? "" : jo.getString("ItemName"));
                                        stkData.setItemCode(jo.isNull("ItemCode") ? "" : jo.getString("ItemCode"));
                                        list.add(stkData);
                                    }
                                    StockItemList.insertYudalaProduct(list, PurchaseOrderPane.this.da);
                                    list.forEach(x -> PurchaseOrderPane.this.santa.Products.removeIf(xy -> xy.getItemCode().equals(x.getItemCode())));
                                    PurchaseOrderPane.this.santa.Products.addAll(list);
                                    Platform.runLater(() -> {
                                        purchaseOrderDialog.populateResult((StockItemData)list.get(0));
                                        PurchaseOrderPane.this.stackPane.getChildren().remove((Object)box);
                                    });
                                } else {
                                    Platform.runLater(() -> {
                                        PurchaseOrderPane.this.stackPane.getChildren().remove((Object)box);
                                        PurchaseOrderPane.this.mainPage.showNotification(NotificationType.Information, "no result found", PurchaseOrderPane.this);
                                    });
                                }
                            } else {
                                String output;
                                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                StringBuilder stringBuilder = new StringBuilder();
                                while ((output = br.readLine()) != null) {
                                    System.out.println(output);
                                    stringBuilder.append(output + "\n");
                                }
                                br.close();
                                String fullError = stringBuilder.toString();
                                Platform.runLater(() -> {
                                    PurchaseOrderPane.this.mainPage.showNotification(NotificationType.Error, fullError, PurchaseOrderPane.this);
                                    PurchaseOrderPane.this.stackPane.getChildren().remove((Object)box);
                                });
                            }
                        }
                        catch (Exception e) {
                            Platform.runLater(() -> {
                                PurchaseOrderPane.this.mainPage.showNotification(NotificationType.Error, e.getMessage(), PurchaseOrderPane.this);
                                PurchaseOrderPane.this.stackPane.getChildren().remove((Object)box);
                                Logger.getLogger(SalesReturnPaneAudit.class.getName()).log(Level.SEVERE, null, e);
                            });
                        }
                        return null;
                    }
                };
            }
        };
        progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
        service.start();
    }
}

