/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.xputertechnologies.santa.Expenses;
import com.xputertechnologies.santa.core.DataAccess;
import com.xputertechnologies.santa.ui.ExpenseContainer;
import com.xputertechnologies.santa.ui.ExpensesPane;
import com.xputertechnologies.santa.ui.NotificationType;
import com.xputertechnologies.santa.ui.UIParent;
import java.sql.Connection;
import javafx.beans.property.Property;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.util.StringConverter;
import javafx.util.converter.DoubleStringConverter;
import org.dbunit.database.DatabaseConnection;

public class Expense
extends UIParent {
    public static DataAccess da;
    private static Connection con;
    private static DatabaseConnection dc;
    @FXML
    private Button btnAddNew;
    @FXML
    private Button cancelbutton;
    @FXML
    private TextArea desTxt;
    @FXML
    private TextField amtTxt;
    private ExpensesPane expensesPane;
    private Expenses expenses = null;
    StringConverter<? extends Number> dconverter = new DoubleStringConverter();

    public Expense(ExpensesPane expensesPane, Expenses expenses, boolean launch) throws Exception {
        super("Expense.fxml", expensesPane.santa);
        this.expensesPane = expensesPane;
        this.expenses = expenses;
        this.mainParent = expensesPane;
        this.hasParent = true;
        this.desTxt.textProperty().bindBidirectional((Property)expenses.descriptionProperty());
        this.amtTxt.textProperty().bindBidirectional((Property)expenses.amountProperty(), this.dconverter);
        this.cancelbutton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                Expense.this.cancel();
            }
        });
        this.btnAddNew.setOnAction(event -> this.addNewExpense());
        if (launch) {
            expensesPane.mainPage.hbCenter.setContent((Node)this);
            expensesPane.mainPage.hbBottom.setVisible(true);
        }
    }

    private void addNewExpense() {
        if (this.validateControl() && this.needToSave && !this.expenses.isEdit) {
            this.expenses.isEdit = true;
            this.expensesPane.expense.getExpenseItemsList().getOriginalList().add((Object)this.expenses);
            this.expensesPane.expenseVbrep.getChildren().add((Object)new ExpenseContainer(this.expenses, this.expensesPane, this.santa));
            try {
                this.expensesPane.createExpense();
            }
            catch (Exception ex) {
                this.expensesPane.mainPage.showNotification(NotificationType.Error, ex.getMessage(), this);
            }
        } else {
            this.expensesPane.mainPage.showNotification(NotificationType.Error, this.errorMessage, this.expensesPane);
        }
    }

    private void cancel() {
        this.expensesPane.mainPage.hbCenter.setContent((Node)this.mainParent);
    }

    private void done() {
        if (this.validateControl() && this.needToSave && !this.expenses.isEdit) {
            this.expenses.isEdit = true;
            this.expensesPane.expense.getExpenseItemsList().getOriginalList().add((Object)this.expenses);
            this.expensesPane.expenseVbrep.getChildren().add((Object)new ExpenseContainer(this.expenses, this.expensesPane, this.santa));
        } else {
            this.expensesPane.mainPage.showNotification(NotificationType.Error, this.errorMessage, this);
        }
    }

    @Override
    boolean validateControl() {
        this.errorMessage = "";
        this.needToSave = false;
        if (this.desTxt.getText() != null && !this.desTxt.getText().trim().isEmpty() && Double.valueOf(this.amtTxt.getText()) > 0.0) {
            this.needToSave = true;
        }
        if (this.desTxt.getText() == null || this.desTxt.getText().trim().isEmpty()) {
            this.errorMessage = this.errorMessage + "Expense description must not be empty\n";
        }
        if (Double.valueOf(this.amtTxt.getText()) == 0.0 || Double.valueOf(this.amtTxt.getText()) < 0.0) {
            this.errorMessage = this.errorMessage + "Expense amount must not be zero";
        }
        return this.errorMessage.equals("");
    }

    @Override
    void completeControl() {
        this.done();
    }
}

