/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import javafx.scene.control.TextField;

public class DecimalNumberTextBox
extends TextField {
    private double max = Double.MAX_VALUE;
    private double min = 1.0;

    public DecimalNumberTextBox() {
        this.setPromptText("0");
    }

    public DecimalNumberTextBox(double value) {
        super(Double.toString(value));
    }

    public void replaceText(int i, int il, String str) {
        if (!str.matches("[A-Za-z]") && !str.matches("[\\\\!\"#$%&()*+,/:;<=>?@\\[\\]^_{|}~]+") && (str.isEmpty() || this.valid(Double.parseDouble(str)))) {
            super.replaceText(i, il, str);
        }
    }

    public void replaceSelection(String str) {
        if (!str.matches("[A-Za-z]") && !str.matches("[\\\\!\"#$%&()*+,/:;<=>?@\\[\\]^_{|}~]+")) {
            super.replaceSelection(str);
        }
    }

    private boolean valid(double text) {
        return text >= this.min && text <= this.max;
    }

    public void setMax(double max) {
        this.max = max;
    }

    public void setMin(double min) {
        this.min = min;
    }
}

