/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.xputertechnologies.santa.Customer;
import com.xputertechnologies.santa.Sale;
import com.xputertechnologies.santa.core.DataAccess;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.list.SaleList;
import com.xputertechnologies.santa.ui.CustomerPaymentPane;
import com.xputertechnologies.santa.ui.General;
import com.xputertechnologies.santa.ui.UIControlBase;
import java.sql.JDBCType;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.input.KeyEvent;

public class CustomerPayment
extends UIControlBase {
    private static DataAccess da;
    @FXML
    private Button custButton;
    private CustomerPaymentPane customerPayment;
    public SaleList saleList;
    public Customer customer;

    public CustomerPayment(Customer customer, CustomerPaymentPane customerPayment) throws Exception {
        da = customerPayment.santa.da;
        this.saleList = new SaleList(da);
        this.customer = customer;
        this.customerPayment = customerPayment;
        this.custButton.textProperty().bind((ObservableValue)customer.nameProperty());
        this.custButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                CustomerPayment.this.showDetails();
            }
        });
    }

    private void showDetails() {
        this.customerPayment.customer = this.customer;
        this.customerPayment.saleList = this.saleList;
        this.customerPayment.debtTable.setItems(null);
        float balance = 0.0f;
        ParameterValue[] param = new ParameterValue[]{new ParameterValue("customername", JDBCType.VARCHAR, this.customer.getName())};
        this.customerPayment.saleList = Sale.search("Select * from Sale where CustomerName = ? and balance > 0 and returnAll<>1", param, da);
        this.customerPayment.debtTable.setItems(this.customerPayment.saleList.getOriginalList());
        balance = 0.0f;
        for (Sale sale : this.customerPayment.saleList.getOriginalList()) {
            balance = (float)((double)balance + sale.getBalance());
        }
        this.customerPayment.amountTxtfield.addEventFilter(KeyEvent.KEY_TYPED, General.numeric_Validation(15));
        this.customerPayment.balancetxtfield.setText(String.valueOf(balance));
    }
}

