/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXDialog;
import com.jfoenix.controls.JFXProgressBar;
import com.xputertechnologies.santa.CrossDock;
import com.xputertechnologies.santa.CrossDockItem;
import com.xputertechnologies.santa.StockItemData;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.list.CrossDockDataList;
import com.xputertechnologies.santa.list.CrossDockItemDataList;
import com.xputertechnologies.santa.list.StockItemList;
import com.xputertechnologies.santa.report.CSVUtils;
import com.xputertechnologies.santa.ui.CrossDockItemDialog;
import com.xputertechnologies.santa.ui.NewRequestPane;
import com.xputertechnologies.santa.ui.NotificationType;
import com.xputertechnologies.santa.ui.Santa;
import com.xputertechnologies.santa.ui.UIParent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.sql.JDBCType;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import javafx.util.Callback;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.controlsfx.glyphfont.FontAwesome;
import org.json.JSONArray;
import org.json.JSONObject;

public class CrossDockPane
extends UIParent {
    @FXML
    private TableView<CrossDockItem> table;
    @FXML
    private JFXButton btnNew;
    @FXML
    private JFXButton btnPost;
    @FXML
    private JFXButton btnUpload;
    @FXML
    private JFXButton btnDownload;
    @FXML
    private JFXButton btnClear;
    @FXML
    private JFXButton SearchButton;
    @FXML
    private JFXButton btnCheckAvailability;
    @FXML
    private StackPane stackPane;
    @FXML
    private TableColumn colName;
    @FXML
    private TableColumn colItemCode;
    @FXML
    private TableColumn colQty;
    @FXML
    private TableColumn colSn;
    @FXML
    private TableColumn colEdit;
    @FXML
    private TableColumn colHasSynced;
    @FXML
    private TableColumn colAvailQty;
    JFXDialog dialog;
    CrossDockItem selectedStock = null;
    public CrossDock crossDock;

    public CrossDockPane(Santa app) {
        super("CrossDockPane.fxml", app);
        this.santa = app;
        this.title = "Cross Dock";
        this.loadSavedCrossDock();
        this.table.setItems(this.crossDock.getItems());
        this.colSn.setCellValueFactory((Callback)new PropertyValueFactory("sn"));
        this.colName.setCellValueFactory((Callback)new PropertyValueFactory("itemName"));
        this.colItemCode.setCellValueFactory((Callback)new PropertyValueFactory("itemCode"));
        this.colQty.setCellValueFactory((Callback)new PropertyValueFactory("quantity"));
        this.colAvailQty.setCellValueFactory((Callback)new PropertyValueFactory("qtyAvailable"));
        this.colEdit.setCellValueFactory((Callback)new PropertyValueFactory(""));
        this.colHasSynced.setCellValueFactory((Callback)new PropertyValueFactory(""));
        this.btnNew.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.PLUS).color(Color.WHITE).size(15.0));
        this.btnPost.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.EXTERNAL_LINK).color(Color.WHITE).size(15.0));
        this.btnClear.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.TRASH).color(Color.WHITE).size(15.0));
        this.btnUpload.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.UPLOAD).color(Color.WHITE).size(15.0));
        this.btnDownload.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.DOWNLOAD).color(Color.WHITE).size(15.0));
        this.btnCheckAvailability.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.SEARCH_PLUS).color(Color.WHITE).size(15.0));
        Callback<TableColumn<CrossDockItem, String>, TableCell<CrossDockItem, String>> cellFactoryViewEdit = new Callback<TableColumn<CrossDockItem, String>, TableCell<CrossDockItem, String>>(){

            public TableCell call(TableColumn<CrossDockItem, String> param) {
                TableCell<CrossDockItem, String> cell = new TableCell<CrossDockItem, String>(){
                    final JFXButton btn = new JFXButton();

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                            this.setText(null);
                        } else {
                            this.btn.setButtonType(JFXButton.ButtonType.FLAT);
                            this.btn.setGraphic((Node)CrossDockPane.this.fontAwesome.create((Enum)FontAwesome.Glyph.EDIT).color(Color.WHITE).size(20.0));
                            this.btn.setStyle("-fx-background-color: #4FC4F6;");
                            CrossDockItem req = (CrossDockItem)this.getTableView().getItems().get(this.getIndex());
                            this.btn.setOnAction(event -> {
                                CrossDockPane.this.selectedStock = req;
                                CrossDockPane.this.showDialog();
                            });
                            this.setGraphic((Node)this.btn);
                            this.setAlignment(Pos.CENTER);
                            this.setText(null);
                        }
                    }
                };
                return cell;
            }
        };
        this.colEdit.setCellFactory((Callback)cellFactoryViewEdit);
        Callback<TableColumn<CrossDockItem, String>, TableCell<CrossDockItem, String>> cellFactoryVieSync = new Callback<TableColumn<CrossDockItem, String>, TableCell<CrossDockItem, String>>(){

            public TableCell call(TableColumn<CrossDockItem, String> param) {
                TableCell<CrossDockItem, String> cell = new TableCell<CrossDockItem, String>(){
                    final Label lbl = new Label();

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                            this.setText(null);
                        } else {
                            CrossDockItem req = (CrossDockItem)this.getTableView().getItems().get(this.getIndex());
                            this.lbl.setPadding(new Insets(0.0, 5.0, 0.0, 5.0));
                            this.lbl.setPadding(new Insets(0.0, 5.0, 0.0, 5.0));
                            if (req.syncFlag) {
                                this.lbl.setText("Posted");
                                this.lbl.setStyle("-fx-background-color: #00A86B;-fx-text-fill: #FFFFFF;-fx-font-size: 12.0px;");
                            } else {
                                this.lbl.setText("Not Posted");
                                this.lbl.setStyle("-fx-background-color: #FF0000;-fx-text-fill: #FFFFFF;-fx-font-size: 12.0px;");
                            }
                            this.setGraphic((Node)this.lbl);
                            this.setGraphic((Node)this.lbl);
                            this.setAlignment(Pos.CENTER);
                            this.setText(null);
                        }
                    }
                };
                return cell;
            }
        };
        this.colHasSynced.setCellFactory((Callback)cellFactoryVieSync);
        this.btnNew.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                CrossDockPane.this.selectedStock = null;
                CrossDockPane.this.showDialog();
            }
        });
        this.btnPost.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (!CrossDockPane.this.crossDock.getSyncFlag().booleanValue()) {
                    if (CrossDockPane.this.crossDock.getItems().stream().filter(p -> p.getItemCode().isEmpty()).count() == 0L) {
                        final String url = CrossDockPane.this.santa.syncSetting.getBEURL() + "RCrossDock/CreateCrossDockItems";
                        JFXProgressBar progressIndicator = new JFXProgressBar();
                        progressIndicator.setProgress(-1.0);
                        final VBox box = new VBox(new Node[]{progressIndicator});
                        box.setAlignment(Pos.CENTER);
                        CrossDockPane.this.stackPane.getChildren().add((Object)box);
                        Service service = new Service(){

                            protected Task createTask() {
                                return new Task(){

                                    protected Object call() throws Exception {
                                        try {
                                            JSONArray jSONArray = new JSONArray();
                                            JSONObject crJSONObject = new JSONObject();
                                            crJSONObject.put("DateCreated", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                                            crJSONObject.put("UserEmail", (Object)CrossDockPane.this.currentUser.getUserName());
                                            crJSONObject.put("Code", (Object)CrossDockPane.this.crossDock.getCode());
                                            JSONArray crossDockItemJSONArray = new JSONArray();
                                            for (CrossDockItem crossDockItem : CrossDockPane.this.crossDock.getItems()) {
                                                JSONObject job = new JSONObject();
                                                job.put("ItemCode", (Object)crossDockItem.getItemCode());
                                                job.put("ItemName", (Object)crossDockItem.getItemName());
                                                job.put("Quantity", crossDockItem.getQuantity());
                                                job.put("ParentCode", (Object)crossDockItem.getParentCode());
                                                crossDockItemJSONArray.put((Object)job);
                                            }
                                            crJSONObject.put("CrossDockItems", (Object)crossDockItemJSONArray);
                                            jSONArray.put((Object)crJSONObject);
                                            HttpPost httpPost = new HttpPost(url);
                                            RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectTimeout(Santa.connectionTimeOut).setSocketTimeout(Santa.socketTimeOut).setConnectionRequestTimeout(Santa.socketTimeOut).build();
                                            CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(defaultRequestConfig).build();
                                            StringEntity stringEntity = new StringEntity(jSONArray.toString());
                                            httpPost.setEntity((HttpEntity)stringEntity);
                                            httpPost.setHeader("Content-type", "application/json");
                                            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
                                            if (response.getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 204) {
                                                String output;
                                                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                                StringBuilder stringBuilder = new StringBuilder();
                                                while ((output = br.readLine()) != null) {
                                                    stringBuilder.append(output + "\n");
                                                }
                                                br.close();
                                                httpClient.getConnectionManager().shutdown();
                                                String result = stringBuilder.toString();
                                                JSONArray ra = new JSONArray(result);
                                                Platform.runLater(() -> {
                                                    try {
                                                        for (int i = 0; i < ra.length(); ++i) {
                                                            JSONObject jSONObject = ra.getJSONObject(i);
                                                            String itemCode = jSONObject.getString("ItemCode");
                                                            CrossDockItem found = CrossDockPane.this.crossDock.getItems().stream().filter(s -> s.getItemCode().equals(itemCode)).findAny().orElse(null);
                                                            if (found == null) continue;
                                                            found.setSyncError(jSONObject.isNull("SyncError") ? "" : jSONObject.getString("SyncError"));
                                                            found.syncFlag = found.getSyncError().isEmpty();
                                                            System.out.println((String)(found.syncFlag ? "True " : "False " + found.getItemCode()));
                                                        }
                                                        if (CrossDockPane.this.crossDock.getItems().stream().filter(v -> !v.getSyncError().isEmpty()).findAny().orElse(null) == null) {
                                                            StockItemList.deleteAll("Delete  From CrossDock where syncFlag=?", new ParameterValue[]{new ParameterValue("syncFlag", JDBCType.CHAR, false)}, CrossDockPane.this.da);
                                                            CrossDockPane.this.crossDock.setSyncFlag(Boolean.TRUE);
                                                            CrossDockPane.this.mainPage.showNotification(NotificationType.Success, "Cross Dock posted successfully", CrossDockPane.this);
                                                        } else {
                                                            CrossDockPane.this.mainPage.showNotification(NotificationType.Information, "Some Cross DOck Item(s) cannot be posted,please check the error message from the tooltip", CrossDockPane.this);
                                                            List dataTosave = CrossDockPane.this.crossDock.getItems().stream().filter(v -> !v.getSyncError().isEmpty()).collect(Collectors.toList());
                                                            CrossDockDataList crossDockDataList = new CrossDockDataList(CrossDockPane.this.da);
                                                            CrossDockPane.this.crossDock.setSyncFlag(Boolean.FALSE);
                                                            crossDockDataList.getOriginalList().add((Object)CrossDockPane.this.crossDock);
                                                            crossDockDataList.update();
                                                            CrossDockItemDataList crossDockItemDataList = new CrossDockItemDataList(CrossDockPane.this.da);
                                                            crossDockItemDataList.getOriginalList().addAll(dataTosave);
                                                            crossDockItemDataList.update();
                                                        }
                                                        CrossDockPane.this.table.setItems(CrossDockPane.this.crossDock.getItems());
                                                        CrossDockPane.this.table.refresh();
                                                    }
                                                    catch (Exception ex) {
                                                        CrossDockPane.this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), CrossDockPane.this);
                                                    }
                                                    CrossDockPane.this.stackPane.getChildren().remove((Object)box);
                                                });
                                            } else {
                                                String output;
                                                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                                StringBuilder stringBuilder = new StringBuilder();
                                                while ((output = br.readLine()) != null) {
                                                    System.out.println(output);
                                                    stringBuilder.append(output + "\n");
                                                }
                                                br.close();
                                                String fullError = stringBuilder.toString();
                                                Platform.runLater(() -> {
                                                    CrossDockPane.this.stackPane.getChildren().remove((Object)box);
                                                    CrossDockPane.this.mainPage.showNotification(NotificationType.Error, fullError, CrossDockPane.this);
                                                });
                                            }
                                        }
                                        catch (Exception e) {
                                            Platform.runLater(() -> {
                                                CrossDockPane.this.stackPane.getChildren().remove((Object)box);
                                                CrossDockPane.this.mainPage.showNotification(NotificationType.Error, e.getMessage(), CrossDockPane.this);
                                            });
                                        }
                                        return null;
                                    }
                                };
                            }
                        };
                        progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
                        service.start();
                    } else {
                        CrossDockPane.this.mainPage.showNotification(NotificationType.Error, "One or more products do not have item code or quantity", CrossDockPane.this);
                    }
                } else {
                    CrossDockPane.this.mainPage.showNotification(NotificationType.Error, "Cross Dock Item(s) already posted", CrossDockPane.this);
                }
            }
        });
        this.btnDownload.setOnAction(v -> this.download());
        this.btnUpload.setOnAction(v -> this.upload());
        if (this.santa.Products.isEmpty()) {
            try {
                this.santa.Products.addAll(StockItemList.selectAllYuProducts(this.da));
            }
            catch (SQLException ex) {
                Logger.getLogger(CrossDockPane.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.btnClear.setOnAction(v -> {
            this.crossDock = new CrossDock(this.da);
            this.table.getItems().clear();
            this.table.refresh();
        });
        this.btnCheckAvailability.setOnAction(x -> {
            if (!this.table.getItems().isEmpty()) {
                this.checkAvailability();
            } else {
                this.mainPage.showNotification(NotificationType.Error, "No Item(s) available to check", this);
            }
        });
    }

    void checkAvailability() {
        try {
            JFXProgressBar progressIndicator = new JFXProgressBar();
            progressIndicator.setProgress(-1.0);
            final VBox box = new VBox(new Node[]{progressIndicator});
            box.setAlignment(Pos.CENTER);
            this.stackPane.getChildren().add((Object)box);
            Service service = new Service(){

                protected Task createTask() {
                    return new Task(){

                        protected Object call() throws Exception {
                            try {
                                Object url = CrossDockPane.this.santa.syncSetting.getBEURL();
                                url = (String)url + "RCrossDock/GetVirtualQuantityForItems";
                                JSONArray jSONArray = new JSONArray();
                                for (CrossDockItem requestItem : CrossDockPane.this.table.getItems()) {
                                    JSONObject joItem = new JSONObject();
                                    joItem.put("ItemCode", (Object)requestItem.getItemCode());
                                    jSONArray.put((Object)joItem);
                                }
                                HttpPost httpPost = new HttpPost((String)url);
                                RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectTimeout(Santa.connectionTimeOut).setSocketTimeout(Santa.socketTimeOut).setConnectionRequestTimeout(Santa.socketTimeOut).build();
                                CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(defaultRequestConfig).build();
                                StringEntity stringEntity = new StringEntity(jSONArray.toString());
                                httpPost.setEntity((HttpEntity)stringEntity);
                                httpPost.setHeader("Content-type", "application/json");
                                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
                                if (response.getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 204) {
                                    String output;
                                    BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                    StringBuilder stringBuilder = new StringBuilder();
                                    System.out.println("Output from Server .... \n");
                                    while ((output = br.readLine()) != null) {
                                        System.out.println(output);
                                        stringBuilder.append(output + "\n");
                                    }
                                    br.close();
                                    httpClient.getConnectionManager().shutdown();
                                    String result = stringBuilder.toString();
                                    JSONArray ra = new JSONArray(result);
                                    Platform.runLater(() -> {
                                        for (int i = 0; i < ra.length(); ++i) {
                                            try {
                                                JSONObject jsono = ra.getJSONObject(i);
                                                String itemCode = jsono.getString("ItemCode");
                                                int qty = jsono.getInt("Quantity");
                                                CrossDockItem requestItem = CrossDockPane.this.table.getItems().stream().filter(p -> p.getItemCode().equals(itemCode)).findAny().get();
                                                requestItem.qtyAvailableProperty().set(qty);
                                                continue;
                                            }
                                            catch (Exception ex) {
                                                Logger.getLogger(NewRequestPane.class.getName()).log(Level.SEVERE, null, ex);
                                            }
                                        }
                                        CrossDockPane.this.table.refresh();
                                        CrossDockPane.this.stackPane.getChildren().remove((Object)box);
                                        CrossDockPane.this.mainPage.showNotification(NotificationType.Success, "Quantity successfully loaded", CrossDockPane.this);
                                    });
                                } else {
                                    String output;
                                    BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                    StringBuilder stringBuilder = new StringBuilder();
                                    while ((output = br.readLine()) != null) {
                                        System.out.println(output);
                                        stringBuilder.append(output + "\n");
                                    }
                                    br.close();
                                    String fullError = stringBuilder.toString();
                                    Platform.runLater(() -> {
                                        CrossDockPane.this.stackPane.getChildren().remove((Object)box);
                                        CrossDockPane.this.mainPage.showNotification(NotificationType.Error, fullError, CrossDockPane.this);
                                    });
                                }
                            }
                            catch (Exception ex) {
                                Logger.getLogger(NewRequestPane.class.getName()).log(Level.SEVERE, null, ex);
                                Platform.runLater(() -> {
                                    CrossDockPane.this.stackPane.getChildren().remove((Object)box);
                                    CrossDockPane.this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), CrossDockPane.this);
                                });
                            }
                            return null;
                        }
                    };
                }
            };
            progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
            service.start();
        }
        catch (Exception ex) {
            this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), this);
            Logger.getLogger(NewRequestPane.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    void showDialog() {
        this.dialog = new JFXDialog(this.stackPane, (Region)new CrossDockItemDialog(this), JFXDialog.DialogTransition.CENTER);
        this.dialog.setOverlayClose(false);
        this.dialog.show();
    }

    void download() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Save Template");
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("CSV Document", Arrays.asList("*.csv", "*.CSV")));
        File file = fileChooser.showSaveDialog((Window)this.santa.stage);
        FileWriter fileWriter = null;
        try {
            if (file != null) {
                fileWriter = new FileWriter(file);
                CSVUtils.writeLine(fileWriter, Arrays.asList("Item Code", "Quantity"));
                fileWriter.flush();
                fileWriter.close();
                this.mainPage.showNotification(NotificationType.Information, "Template downloaded successfully", this);
            }
        }
        catch (Exception ex) {
            this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), this);
            Logger.getLogger(NewRequestPane.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    void upload() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Save Template");
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("CSV Document", Arrays.asList("*.csv", "*.CSV")));
        String FieldDelimiter = ",";
        File file = fileChooser.showOpenDialog((Window)this.santa.stage);
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(file));
            Object errors = "";
            ArrayList<CrossDockItem> crossDocksss = new ArrayList<CrossDockItem>();
            int count = 0;
            while ((line = br.readLine()) != null) {
                String[] fields = line.split(FieldDelimiter, -1);
                if (count > 0) {
                    if (count < 100) {
                        if (!fields[0].isEmpty()) {
                            StockItemData data = this.santa.Products.stream().filter(v -> v.getItemCode().equals(fields[0].toUpperCase().trim())).findAny().orElse(null);
                            if (((String)errors).isEmpty()) {
                                errors = "The following item(s) not found: ";
                            }
                            if (data == null) {
                                errors = (String)errors + fields[0].toUpperCase().trim() + ",";
                            } else {
                                CrossDockItem crossDockExist = this.crossDock.getItems().stream().filter(v -> v.getItemCode().equals(fields[0].toUpperCase().trim())).findAny().orElse(null);
                                if (crossDockExist == null) {
                                    CrossDockItem crossDockItem = new CrossDockItem(this.da);
                                    crossDockItem.setItemCode(fields[0].toUpperCase().trim());
                                    crossDockItem.setItemName(data.getDescription());
                                    crossDockItem.setQuantity(Integer.valueOf(fields[1]));
                                    crossDockItem.setParentCode(this.crossDock.getCode());
                                    crossDocksss.add(crossDockItem);
                                } else {
                                    crossDockExist.setQuantity(crossDockExist.getQuantity() + Integer.valueOf(fields[1]));
                                }
                            }
                        }
                    } else {
                        this.mainPage.showNotification(NotificationType.Information, "Only 100 products is allowed per post", this);
                        break;
                    }
                }
                ++count;
            }
            this.crossDock.getItems().addAll(crossDocksss);
            this.crossDock.resetNumbering();
            this.table.setItems(this.crossDock.getItems());
            this.table.refresh();
            this.mainPage.showNotification(NotificationType.Information, "Data uploaded successfully", this);
        }
        catch (Exception ex) {
            this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), this);
            Logger.getLogger(NewRequestPane.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void loadSavedCrossDock() {
        CrossDockDataList crossDockDataList = new CrossDockDataList(this.da);
        crossDockDataList.selectAll("Select * from CrossDock where syncFlag=?", new ParameterValue[]{new ParameterValue("", JDBCType.CHAR, false)});
        if (crossDockDataList.getOriginalList().size() > 0) {
            this.crossDock = (CrossDock)crossDockDataList.getOriginalList().get(0);
            CrossDockItemDataList crossDockItemDataList = new CrossDockItemDataList();
            crossDockItemDataList.selectAll("Select * from CrossDockItem where parentCode=?", new ParameterValue[]{new ParameterValue("parentCode", JDBCType.VARCHAR, this.crossDock.getCode())});
            this.crossDock.getItems().addAll(crossDockItemDataList.getOriginalList());
        } else {
            this.crossDock = new CrossDock(this.da);
        }
    }
}

