/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXCheckBox;
import com.jfoenix.controls.JFXTextField;
import com.xputertechnologies.santa.NameValueObject;
import com.xputertechnologies.santa.StageUser;
import com.xputertechnologies.santa.ui.ApprovalPane;
import com.xputertechnologies.santa.ui.ApprovalStageAuthorizerListDialog;
import com.xputertechnologies.santa.ui.UIParent;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javafx.beans.property.Property;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.TextField;
import javafx.util.StringConverter;
import javafx.util.converter.IntegerStringConverter;
import org.controlsfx.control.textfield.AutoCompletionBinding;
import org.controlsfx.control.textfield.TextFields;

public class ApprovalStageAuthorizerDialog
extends UIParent {
    @FXML
    private JFXTextField tbName;
    @FXML
    private JFXTextField tbEmail;
    @FXML
    private JFXCheckBox chkEnable;
    @FXML
    private JFXButton btnDone;
    @FXML
    private JFXButton btnNew;
    @FXML
    private JFXButton btnCancel;
    StageUser stageUser;
    ApprovalStageAuthorizerListDialog parent;
    protected StringConverter<? extends Number> intConverter = new IntegerStringConverter(){

        public String toString(Integer object) {
            if (object != null) {
                return Integer.toString(object);
            }
            return null;
        }

        public Integer fromString(String string) {
            Integer d = 0;
            if (!string.isEmpty()) {
                string = string.replace(",", "");
                d = Integer.parseInt(string);
            }
            return d;
        }
    };
    ObservableList<NameValueObject> users = FXCollections.observableArrayList();

    public ApprovalStageAuthorizerDialog(final ApprovalStageAuthorizerListDialog parent) {
        super("ApprovalStageAuthorizerDialog.fxml", parent.santa);
        this.santa = parent.santa;
        this.title = "Approval Stage Authorizer";
        this.parent = parent;
        if (parent.currStageUser == null) {
            this.stageUser = new StageUser(this.da);
        } else {
            this.stageUser = parent.currStageUser;
            this.tbEmail.setDisable(true);
        }
        this.stageUser.setApprovalDescription(parent.parent.approval.getDescription());
        this.stageUser.setStageCode(parent.approvalStage.getCode());
        this.stageUser.setStageName(parent.approvalStage.getName());
        this.tbName.textProperty().bindBidirectional((Property)this.stageUser.nameProperty());
        this.tbEmail.textProperty().bindBidirectional((Property)this.stageUser.emailProperty());
        this.chkEnable.selectedProperty().unbindBidirectional((Property)this.stageUser.isDisableProperty());
        this.btnCancel.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                parent.dialog.close();
            }
        });
        this.btnDone.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (parent.currStageUser == null || !parent.currStageUser.getEmail().equals(ApprovalStageAuthorizerDialog.this.stageUser.getEmail())) {
                    parent.parent.currentApprovalStage.getStageUsers().add((Object)ApprovalStageAuthorizerDialog.this.stageUser);
                }
                parent.dialog.close();
                parent.parent.showDialog(ApprovalPane.DialogTypeEnum.StageUser);
            }
        });
        this.btnNew.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                ApprovalStageAuthorizerDialog.this.rebind();
            }
        });
        AutoCompletionBinding autoCompletionBinding = TextFields.bindAutoCompletion((TextField)this.tbEmail, t -> {
            List<NameValueObject> result = this.searchResult(t.getUserText());
            return result.size() > 25 ? result.subList(0, 24) : result;
        });
        autoCompletionBinding.setOnAutoCompleted((EventHandler)new EventHandler<AutoCompletionBinding.AutoCompletionEvent<NameValueObject>>(){

            public void handle(AutoCompletionBinding.AutoCompletionEvent<NameValueObject> event) {
                ApprovalStageAuthorizerDialog.this.populateResult((NameValueObject)event.getCompletion());
            }
        });
        autoCompletionBinding.setPrefWidth(550.0);
    }

    public List<NameValueObject> searchResult(String searchString) {
        if (searchString == null || searchString.equals("")) {
            return new ArrayList<NameValueObject>();
        }
        List result = this.users.stream().filter(e -> e.getKey().toLowerCase().contains(searchString.toLowerCase())).collect(Collectors.toList());
        LinkedList searchResult = new LinkedList();
        searchResult.addAll(result.isEmpty() ? this.users : result);
        return searchResult.subList(0, searchResult.size());
    }

    public void populateResult(NameValueObject data) {
        this.tbEmail.setText(data.getKey());
        this.tbName.setText(data.getData());
    }

    public void rebind() {
        this.tbEmail.textProperty().unbindBidirectional((Property)this.stageUser.emailProperty());
        this.tbName.textProperty().unbindBidirectional((Property)this.stageUser.nameProperty());
        this.chkEnable.selectedProperty().unbindBidirectional((Property)this.stageUser.isDisableProperty());
        if (this.parent.currStageUser == null || !this.parent.currStageUser.getEmail().equals(this.stageUser.getEmail())) {
            this.parent.parent.currentApprovalStage.getStageUsers().add((Object)this.stageUser);
        }
        this.stageUser = new StageUser(this.parent.da);
        this.tbEmail.setDisable(false);
        this.tbEmail.textProperty().bindBidirectional((Property)this.stageUser.emailProperty());
        this.tbName.textProperty().bindBidirectional((Property)this.stageUser.nameProperty());
        this.chkEnable.selectedProperty().bindBidirectional((Property)this.stageUser.isDisableProperty());
    }
}

