/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXProgressBar;
import com.xputertechnologies.santa.Request;
import com.xputertechnologies.santa.RequestStatus;
import com.xputertechnologies.santa.RequestType;
import com.xputertechnologies.santa.RequestitemSerial;
import com.xputertechnologies.santa.Store;
import com.xputertechnologies.santa.list.RequestDataList;
import com.xputertechnologies.santa.list.StoreDataList;
import com.xputertechnologies.santa.ui.NotificationType;
import com.xputertechnologies.santa.ui.RequestItem;
import com.xputertechnologies.santa.ui.Santa;
import com.xputertechnologies.santa.ui.TransferPane;
import com.xputertechnologies.santa.ui.TransferSaleItemScanDialog;
import com.xputertechnologies.santa.ui.UIParent;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URI;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.util.Callback;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONArray;
import org.json.JSONObject;

public class AdminTransfer
extends UIParent {
    @FXML
    private TableView<Request> tbRequest;
    @FXML
    private TableColumn colreqFrom;
    @FXML
    private TableColumn colStoreName;
    @FXML
    private TableColumn colDate;
    @FXML
    private TableColumn colStatus;
    @FXML
    private TableColumn colUser;
    @FXML
    private TableColumn colApproveUser;
    @FXML
    private TableColumn colView;
    @FXML
    private TableColumn colSn;
    @FXML
    JFXButton btnReload;
    @FXML
    StackPane stackPane;
    VBox progressContainer;
    StoreDataList storeDataList;
    RequestDataList requestDataList;
    Request selectedRequestRow;
    boolean isDeclineClicked;
    boolean UserCanApprove;

    public AdminTransfer(Santa app) {
        super("AdminTransfer.fxml", app);
        this.requestDataList = new RequestDataList(this.da);
        this.isDeclineClicked = false;
        this.UserCanApprove = false;
        this.santa = app;
        this.title = "Transfer";
        this.colSn.setCellValueFactory((Callback)new PropertyValueFactory("code"));
        this.colreqFrom.setCellValueFactory((Callback)new PropertyValueFactory("storeNameFrom"));
        this.colStoreName.setCellValueFactory((Callback)new PropertyValueFactory("storeName"));
        this.colDate.setCellValueFactory((Callback)new PropertyValueFactory("requestDate"));
        this.colStatus.setCellValueFactory((Callback)new PropertyValueFactory("status"));
        this.colUser.setCellValueFactory((Callback)new PropertyValueFactory("originatedUser"));
        this.colApproveUser.setCellValueFactory((Callback)new PropertyValueFactory("approvingUser"));
        this.colView.setCellValueFactory((Callback)new PropertyValueFactory("DUMMY"));
        ObservableList options = FXCollections.observableArrayList();
        this.storeDataList = new StoreDataList(this.da);
        this.storeDataList.selectAll("Select *from store", this.da.getEmptyParameterValues());
        this.btnReload.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                AdminTransfer.this.loadRequests();
            }
        });
        Callback<TableColumn<Request, String>, TableCell<Request, String>> cellFactoryView = new Callback<TableColumn<Request, String>, TableCell<Request, String>>(){

            public TableCell call(TableColumn<Request, String> param) {
                TableCell<Request, String> cell = new TableCell<Request, String>(){
                    final Button btn = new Button("View");

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                            this.setText(null);
                        } else {
                            Request req = (Request)this.getTableView().getItems().get(this.getIndex());
                            if (!AdminTransfer.this.UserCanApprove || !req.getStatus().equals(RequestStatus.PENDING.name())) {
                                this.btn.setVisible(false);
                            } else {
                                this.btn.setStyle("-fx-background-color: #4FC4F6;");
                                this.btn.setOnAction(event -> {
                                    Dialog dialog = new Dialog();
                                    dialog.initStyle(StageStyle.UTILITY);
                                    dialog.initOwner((Window)AdminTransfer.this.santa.stage);
                                    dialog.setTitle("Transfer Item(s)");
                                    dialog.setResizable(true);
                                    dialog.getDialogPane().setContent((Node)new RequestItem(AdminTransfer.this.santa, req, AdminTransfer.this));
                                    dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.CANCEL});
                                    dialog.show();
                                });
                                this.setGraphic((Node)this.btn);
                                this.setAlignment(Pos.CENTER);
                                this.setText(null);
                            }
                        }
                    }
                };
                return cell;
            }
        };
        this.colView.setCellFactory((Callback)cellFactoryView);
        Callback<TableColumn<Request, String>, TableCell<Request, String>> cellFactoryApprove = new Callback<TableColumn<Request, String>, TableCell<Request, String>>(){

            public TableCell call(TableColumn<Request, String> param) {
                TableCell<Request, String> cell = new TableCell<Request, String>(){
                    final Button btn = new Button("Approve");
                    final Button btnDecline = new Button("Decline");
                    final Label lbl = new Label();

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                            this.setText(null);
                        } else {
                            final Request req = (Request)this.getTableView().getItems().get(this.getIndex());
                            HBox hb = new HBox();
                            if (!AdminTransfer.this.UserCanApprove || !req.getStatus().equals(RequestStatus.PENDING.name())) {
                                if (!req.getAcceptingUser().isEmpty()) {
                                    hb.getChildren().add((Object)this.lbl);
                                    this.lbl.setText(req.getApprovingUser());
                                    this.setGraphic((Node)hb);
                                }
                            } else {
                                this.btn.setStyle("-fx-background-color: #000;");
                                this.btnDecline.setStyle("-fx-background-color: #980000;");
                                hb.setSpacing(20.0);
                                hb.getChildren().addAll((Object[])new Node[]{this.btn, this.btnDecline});
                                this.btn.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                                    public void handle(ActionEvent event) {
                                        try {
                                            Dialog dialog = new Dialog();
                                            dialog.initStyle(StageStyle.DECORATED);
                                            dialog.initOwner((Window)AdminTransfer.this.santa.stage);
                                            dialog.setTitle("Transfer Approval");
                                            dialog.setResizable(true);
                                            dialog.getDialogPane().setContent((Node)new TransferSaleItemScanDialog(AdminTransfer.this.santa, req));
                                            ButtonType buttonType = new ButtonType("Approve", ButtonBar.ButtonData.OK_DONE);
                                            dialog.getDialogPane().getButtonTypes().add((Object)buttonType);
                                            Optional result = dialog.showAndWait();
                                            if (result.isPresent() && result.get() == buttonType) {
                                                if (req.getItems().stream().filter(v -> v.getApprovedQty().intValue() != v.getQuantity()).findAny().orElse(null) == null || req.getItems().stream().filter(v -> v.getApprovedQty().intValue() != v.getQuantity()).findAny().orElse(null) != null && !req.getApprovalComment().isEmpty()) {
                                                    AdminTransfer.this.selectedRequestRow = req;
                                                    AdminTransfer.this.isDeclineClicked = false;
                                                    AdminTransfer.this.mainPage.showNotification(NotificationType.Warning, "Are you sure you want to approve request " + req.getCode(), AdminTransfer.this);
                                                } else {
                                                    AdminTransfer.this.mainPage.showNotification(NotificationType.Error, "One or more items(s) has quantity not equals to requested quantity, Please specify comment and try again", AdminTransfer.this);
                                                }
                                            }
                                        }
                                        catch (Exception ex) {
                                            req.setStatus(RequestStatus.APPROVED.name());
                                            Logger.getLogger(TransferPane.class.getName()).log(Level.SEVERE, null, ex);
                                        }
                                    }
                                });
                                this.btnDecline.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                                    public void handle(ActionEvent event) {
                                        try {
                                            Dialog dialog = new Dialog();
                                            dialog.initStyle(StageStyle.DECORATED);
                                            dialog.initOwner((Window)AdminTransfer.this.santa.stage);
                                            dialog.setTitle("Transfer Decline");
                                            dialog.setResizable(true);
                                            dialog.getDialogPane().setContent((Node)new TransferSaleItemScanDialog(AdminTransfer.this.santa, req));
                                            ButtonType buttonType = new ButtonType("Decline", ButtonBar.ButtonData.OK_DONE);
                                            dialog.getDialogPane().getButtonTypes().add((Object)buttonType);
                                            Optional result = dialog.showAndWait();
                                            if (result.isPresent() && result.get() == buttonType && !req.getApprovalComment().isEmpty()) {
                                                req.setStatus(RequestStatus.DECLINED.name());
                                                AdminTransfer.this.selectedRequestRow = req;
                                                AdminTransfer.this.isDeclineClicked = true;
                                                AdminTransfer.this.mainPage.showNotification(NotificationType.Warning, "Are you sure you want to decline request " + req.getCode(), AdminTransfer.this);
                                            }
                                        }
                                        catch (Exception ex) {
                                            req.setStatus(RequestStatus.APPROVED.name());
                                            Logger.getLogger(TransferPane.class.getName()).log(Level.SEVERE, null, ex);
                                        }
                                    }
                                });
                                this.setGraphic((Node)hb);
                            }
                            this.setAlignment(Pos.CENTER);
                            this.setText(null);
                        }
                    }
                };
                return cell;
            }
        };
        this.colApproveUser.setCellFactory((Callback)cellFactoryApprove);
        this.loadRequests();
    }

    void Accept(final Request request) {
        request.setApprovingUser(this.currentUser.getUserName());
        JFXProgressBar progressIndicator = new JFXProgressBar();
        progressIndicator.setProgress(-1.0);
        final VBox box = new VBox(new Node[]{progressIndicator});
        box.setAlignment(Pos.CENTER);
        this.progressContainer = box;
        this.stackPane.getChildren().add((Object)box);
        Service service = new Service(){

            protected Task createTask() {
                return new Task(){

                    protected Object call() throws Exception {
                        try {
                            Object url = AdminTransfer.this.santa.syncSetting.getBEURL();
                            url = (String)url + "RRequest/ApproveRequests";
                            JSONArray jSONArray = new JSONArray();
                            JSONObject job = new JSONObject();
                            job.put("Code", (Object)request.getCode());
                            job.put("Reason", (Object)request.getReason());
                            job.put("Status", (Object)request.getStatus());
                            job.put("Reason", (Object)request.getReason());
                            job.put("StoreCode", (Object)request.getFromStoreCode());
                            job.put("DocEntry", request.getDocEntry());
                            job.put("ApprovalDate", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new java.util.Date()));
                            job.put("ReleaseComment", (Object)request.getReleaseComment());
                            job.put("ReleasingUser", (Object)request.getReleasingUser());
                            job.put("ApprovalComment", (Object)request.getApprovalComment());
                            job.put("AcceptComment", (Object)request.getAcceptedComment());
                            job.put("AcceptingUser", (Object)request.getAcceptingUser());
                            job.put("ApprovingUser", (Object)request.getApprovingUser());
                            job.put("RequestType", (Object)request.getRequestType());
                            job.put("OriginatingUser", (Object)request.getoriginatedUser());
                            job.put("DestinationStore", (Object)request.getToStoreCode());
                            job.put("LastUpdatedDate", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new java.util.Date()));
                            job.put("RequestDate", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new java.util.Date()));
                            JSONArray jab = new JSONArray();
                            for (com.xputertechnologies.santa.RequestItem requestItem : request.getItems()) {
                                JSONObject joItem = new JSONObject();
                                joItem.put("RequestCode", (Object)request.getCode());
                                joItem.put("Quantity", requestItem.getQuantity());
                                joItem.put("DestinationStore", (Object)request.getToStoreCode());
                                joItem.put("ReleasedQty", requestItem.getReleasedQuantity());
                                joItem.put("ApprovedQty", (Object)requestItem.getApprovedQty());
                                joItem.put("AcceptedQty", (Object)requestItem.getAcceptedQty());
                                joItem.put("ItemCode", (Object)requestItem.getItemCode());
                                joItem.put("ItemName", (Object)requestItem.getItemName());
                                joItem.put("Code", (Object)requestItem.getCode());
                                joItem.put("Serials", (Object)new JSONArray());
                                jab.put((Object)joItem);
                            }
                            job.put("RequestItems", (Object)jab);
                            jSONArray.put((Object)job);
                            HttpPost httpPost = new HttpPost((String)url);
                            RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectTimeout(Santa.connectionTimeOut).setSocketTimeout(Santa.socketTimeOut).setConnectionRequestTimeout(Santa.socketTimeOut).build();
                            CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(defaultRequestConfig).build();
                            StringEntity stringEntity = new StringEntity(jSONArray.toString());
                            httpPost.setEntity((HttpEntity)stringEntity);
                            httpPost.setHeader("Content-type", "application/json");
                            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
                            if (response.getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 204) {
                                Platform.runLater(() -> {
                                    AdminTransfer.this.tbRequest.refresh();
                                    AdminTransfer.this.stackPane.getChildren().remove((Object)box);
                                    String destntStoreName = request.getRequestType().equals((Object)RequestType.Inbound) ? request.getFromStoreName() : request.getFromStoreName();
                                    AdminTransfer.this.mainPage.showNotification(NotificationType.Success, "Operation successful", AdminTransfer.this);
                                });
                            } else {
                                String output;
                                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                StringBuilder stringBuilder = new StringBuilder();
                                while ((output = br.readLine()) != null) {
                                    System.out.println(output);
                                    stringBuilder.append(output + "\n");
                                }
                                br.close();
                                String fullError = stringBuilder.toString();
                                Platform.runLater(() -> {
                                    AdminTransfer.this.stackPane.getChildren().remove((Object)box);
                                    AdminTransfer.this.mainPage.showNotification(NotificationType.Error, fullError, AdminTransfer.this);
                                });
                            }
                        }
                        catch (Exception ex) {
                            Platform.runLater(() -> {
                                AdminTransfer.this.stackPane.getChildren().remove((Object)box);
                                AdminTransfer.this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), AdminTransfer.this);
                            });
                        }
                        return null;
                    }
                };
            }
        };
        progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
        service.start();
    }

    void loadRequests() {
        this.tbRequest.getItems().clear();
        final String url = this.santa.syncSetting.getBEURL() + "RRequest/GetRequestsToApprove";
        JFXProgressBar progressIndicator = new JFXProgressBar();
        progressIndicator.setProgress(-1.0);
        final VBox box = new VBox(new Node[]{progressIndicator});
        box.setAlignment(Pos.CENTER);
        this.progressContainer = box;
        this.stackPane.getChildren().add((Object)box);
        Service service = new Service(){

            protected Task createTask() {
                return new Task(){

                    protected Object call() throws Exception {
                        try {
                            HttpGet httpGet = new HttpGet(url);
                            RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectTimeout(Santa.connectionTimeOut).setSocketTimeout(Santa.socketTimeOut).setConnectionRequestTimeout(Santa.socketTimeOut).build();
                            ArrayList<BasicNameValuePair> listParam = new ArrayList<BasicNameValuePair>();
                            BasicNameValuePair param1 = new BasicNameValuePair("approvingUser", AdminTransfer.this.currentUser.getUserName());
                            listParam.add(param1);
                            URI uri = new URIBuilder(httpGet.getURI()).addParameters(listParam).build();
                            httpGet.setURI(uri);
                            httpGet.setHeader("Content-type", "application/json");
                            CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(defaultRequestConfig).build();
                            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
                            if (response.getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 204) {
                                String output;
                                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                StringBuilder stringBuilder = new StringBuilder();
                                System.out.println("Output from Server .... \n");
                                while ((output = br.readLine()) != null) {
                                    System.out.println(output);
                                    stringBuilder.append(output + "\n");
                                }
                                br.close();
                                httpClient.getConnectionManager().shutdown();
                                String result = stringBuilder.toString();
                                JSONObject resultObj = new JSONObject(result);
                                AdminTransfer.this.UserCanApprove = resultObj.isNull("UserCanApprove") ? false : resultObj.getBoolean("UserCanApprove");
                                JSONArray ra = resultObj.getJSONArray("Requests");
                                if (ra.length() > 0) {
                                    AdminTransfer.this.requestDataList.getOriginalList().clear();
                                    for (int i = 0; i < ra.length(); ++i) {
                                        JSONObject jSONObject = ra.getJSONObject(i);
                                        Request request = new Request(AdminTransfer.this.da);
                                        request.setCode(jSONObject.isNull("Code") ? "" : jSONObject.getString("Code"));
                                        request.setReason(jSONObject.isNull("Reason") ? "" : jSONObject.getString("Reason"));
                                        request.setStatus(jSONObject.isNull("Status") ? "" : jSONObject.getString("Status"));
                                        request.setFromStoreCode(jSONObject.isNull("StoreCode") ? "" : jSONObject.getString("StoreCode"));
                                        request.setRequestType(jSONObject.isNull("RequestType") ? "" : jSONObject.getString("RequestType"));
                                        request.setOriginatedUser(jSONObject.isNull("OriginatingUser") ? "" : jSONObject.getString("OriginatingUser"));
                                        request.setDocEntry(jSONObject.isNull("DocEntry") ? 0 : jSONObject.getInt("DocEntry"));
                                        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss");
                                        java.util.Date dt = df.parse(jSONObject.getString("DateAccepted"));
                                        request.setDateAccept(new Date(dt.getTime()));
                                        dt = df.parse(jSONObject.getString("LastUpdatedDate"));
                                        request.setLastUpdatedDate(new Date(dt.getTime()));
                                        dt = df.parse(jSONObject.getString("ApprovalDate"));
                                        request.approvalDateProperty().set((Object)new java.util.Date(dt.getTime()));
                                        dt = df.parse(jSONObject.getString("ReleaseDate"));
                                        request.releaseDateProperty().set((Object)new java.util.Date(dt.getTime()));
                                        dt = df.parse(jSONObject.getString("RequestDate"));
                                        request.requestDateProperty().set((Object)new Date(dt.getTime()));
                                        dt = df.parse(jSONObject.getString("ReturnDate"));
                                        request.returnDateProperty().set((Object)new java.util.Date(dt.getTime()));
                                        request.setApprovingUser(jSONObject.isNull("ApprovingUser") ? "" : jSONObject.getString("ApprovingUser"));
                                        request.setReleasingUser(jSONObject.isNull("ReleasingUser") ? "" : jSONObject.getString("ReleasingUser"));
                                        request.setAcceptingUser(jSONObject.isNull("AcceptingUser") ? "" : jSONObject.getString("AcceptingUser"));
                                        request.setApprovalComment(jSONObject.isNull("ApprovalComment") ? "" : jSONObject.getString("ApprovalComment"));
                                        request.setReleaseComment(jSONObject.isNull("ReleaseComment") ? "" : jSONObject.getString("ReleaseComment"));
                                        request.setAcceptedComment(jSONObject.isNull("AcceptComment") ? "" : jSONObject.getString("AcceptComment"));
                                        request.setToStoreCode(jSONObject.isNull("DestinationStore") ? "" : jSONObject.getString("DestinationStore"));
                                        request.setReturningUser(jSONObject.isNull("ReturningUser") ? "" : jSONObject.getString("ReturningUser"));
                                        request.setReturningComment(jSONObject.isNull("ReturningComment") ? "" : jSONObject.getString("ReturningComment"));
                                        Store StoreFrom = AdminTransfer.this.storeDataList.getOriginalList().stream().filter(v -> v.getCode().equals(request.getFromStoreCode())).findAny().orElse(null);
                                        request.setFromStoreName(StoreFrom == null ? "" : StoreFrom.getName());
                                        StoreFrom = AdminTransfer.this.storeDataList.getOriginalList().stream().filter(v -> v.getCode().equals(request.getToStoreCode())).findAny().orElse(null);
                                        request.fromStoreNameProperty().set((Object)(StoreFrom == null ? "" : StoreFrom.getName()));
                                        JSONArray requestArray = jSONObject.getJSONArray("RequestItems");
                                        for (int j = 0; j < requestArray.length(); ++j) {
                                            JSONObject jsono = requestArray.getJSONObject(j);
                                            com.xputertechnologies.santa.RequestItem requestItem = new com.xputertechnologies.santa.RequestItem(AdminTransfer.this.da);
                                            requestItem.setRequestCode(jsono.isNull("Code") ? "" : jSONObject.getString("Code"));
                                            requestItem.setQuantity(jsono.isNull("Quantity") ? 0 : jsono.getInt("Quantity"));
                                            requestItem.setReason(jsono.isNull("Reason") ? "" : jsono.getString("Reason"));
                                            requestItem.setReleasedQuantity(jsono.isNull("ReleasedQty") ? 0 : jsono.getInt("ReleasedQty"));
                                            requestItem.setItemCode(jsono.isNull("ItemCode") ? "" : jsono.getString("ItemCode"));
                                            requestItem.setItemName(jsono.isNull("ItemName") ? "" : jsono.getString("ItemName"));
                                            requestItem.setOriginatedStore(jsono.isNull("OriginatingStore") ? "" : jsono.getString("OriginatingStore"));
                                            requestItem.setToStoreInitQty(jsono.isNull("DestinationStoreQty") ? 0 : jsono.getInt("DestinationStoreQty"));
                                            requestItem.setApprovedQty(jsono.isNull("ApprovedQty") ? 0 : jsono.getInt("ApprovedQty"));
                                            requestItem.setAcceptedQty(jsono.isNull("AcceptedQty") ? 0 : jsono.getInt("AcceptedQty"));
                                            requestItem.setReturnedQty(jsono.isNull("ReturnedQty") ? 0 : jsono.getInt("ReturnedQty"));
                                            requestItem.setCode(jsono.isNull("Code") ? "" : jsono.getString("Code"));
                                            JSONArray jSONArray = jsono.getJSONArray("Serials");
                                            for (int k = 0; k < jSONArray.length(); ++k) {
                                                JSONObject jsono1 = jSONArray.getJSONObject(k);
                                                RequestitemSerial requestitemSerial = new RequestitemSerial(AdminTransfer.this.da);
                                                requestitemSerial.setRequestItemCode(jsono1.isNull("RequestItemCode") ? "" : jsono1.getString("RequestItemCode"));
                                                requestitemSerial.setSerial(jsono1.isNull("Serial") ? "" : jsono1.getString("Serial"));
                                                requestitemSerial.setItemCode(jsono1.isNull("ItemCode") ? "" : jsono1.getString("ItemCode"));
                                                requestitemSerial.setIsAccepted(jsono1.isNull("IsAccepted") ? false : jsono1.getBoolean("IsAccepted"));
                                                requestitemSerial.setSysSerial(jsono1.isNull("SysSerial") ? 0 : jsono1.getInt("SysSerial"));
                                                requestItem.getSerials().add((Object)requestitemSerial);
                                            }
                                            request.getItems().add((Object)requestItem);
                                        }
                                        AdminTransfer.this.requestDataList.getOriginalList().add((Object)request);
                                    }
                                    Platform.runLater(() -> {
                                        AdminTransfer.this.stackPane.getChildren().remove((Object)box);
                                        AdminTransfer.this.tbRequest.setItems(AdminTransfer.this.requestDataList.getOriginalList());
                                    });
                                } else {
                                    Platform.runLater(() -> {
                                        AdminTransfer.this.stackPane.getChildren().remove((Object)box);
                                        AdminTransfer.this.mainPage.showNotification(NotificationType.Information, "No Transfer Found", AdminTransfer.this);
                                    });
                                }
                            } else {
                                String output;
                                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                StringBuilder stringBuilder = new StringBuilder();
                                while ((output = br.readLine()) != null) {
                                    System.out.println(output);
                                    stringBuilder.append(output + "\n");
                                }
                                br.close();
                                String fullError = stringBuilder.toString();
                                Platform.runLater(() -> AdminTransfer.this.stackPane.getChildren().remove((Object)box));
                                AdminTransfer.this.mainPage.showNotification(NotificationType.Error, fullError, AdminTransfer.this);
                            }
                        }
                        catch (Exception e) {
                            Platform.runLater(() -> AdminTransfer.this.stackPane.getChildren().remove((Object)box));
                            AdminTransfer.this.mainPage.showNotification(NotificationType.Error, e.getMessage(), AdminTransfer.this);
                        }
                        return null;
                    }
                };
            }
        };
        progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
        service.start();
    }

    @Override
    public void yes() {
        if (this.selectedRequestRow != null && !this.isDeclineClicked) {
            this.selectedRequestRow.setStatus(RequestStatus.APPROVED.name());
            this.Accept(this.selectedRequestRow);
        } else if (this.selectedRequestRow != null && this.isDeclineClicked) {
            this.selectedRequestRow.setStatus(RequestStatus.DECLINED.name());
            this.Accept(this.selectedRequestRow);
        }
    }
}

