/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.jfoenix.controls.JFXButton;
import com.xputertechnologies.santa.Sale;
import com.xputertechnologies.santa.SaleStatus;
import com.xputertechnologies.santa.UserType;
import com.xputertechnologies.santa.core.ObjectState;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.list.SaleAccountDetailResolverDataList;
import com.xputertechnologies.santa.list.SaleItemList;
import com.xputertechnologies.santa.list.SaleList;
import com.xputertechnologies.santa.ui.AdminSalesView;
import com.xputertechnologies.santa.ui.General;
import com.xputertechnologies.santa.ui.UIControlBase;
import java.sql.JDBCType;
import java.text.SimpleDateFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import org.controlsfx.glyphfont.FontAwesome;

public class AdminSalesViewItem
extends UIControlBase {
    @FXML
    private VBox vbApprove;
    @FXML
    private Label custName;
    @FXML
    private Label custPhone;
    @FXML
    private Label total;
    @FXML
    private Label naira;
    @FXML
    private Label lblSaleRep;
    @FXML
    private TextField custNo;
    @FXML
    private TextField cashier;
    @FXML
    private TextField voucherCode;
    @FXML
    private TextField voucherAmt;
    @FXML
    private JFXButton btnReload;
    @FXML
    private JFXButton btnSave;
    @FXML
    private TextArea tbComment;
    @FXML
    private JFXButton btnPush;
    @FXML
    private Label img;
    @FXML
    private TextField date;
    @FXML
    private TextField store;
    @FXML
    private TextField invoice;
    @FXML
    private TextField saleId;
    @FXML
    private TextField creditType;
    @FXML
    private TextField creditToken;
    @FXML
    private TextField saleType;
    @FXML
    private Label lblApprove;
    @FXML
    private Label status;

    public AdminSalesViewItem(Sale sale, AdminSalesView adminSalesView) {
        if (sale.getSyncFlag().booleanValue()) {
            this.img.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.CHECK_CIRCLE).color(Color.GREEN).size(20.0));
        } else {
            this.img.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.TIMES_CIRCLE_ALT).color(Color.RED).size(20.0));
        }
        this.btnSave.setVisible(false);
        if (adminSalesView.currentUser.getRoleDescription().equals(UserType.Administrator.name())) {
            this.btnSave.setVisible(true);
            this.btnSave.setOnAction(eh -> {
                SaleList sl = new SaleList(adminSalesView.da);
                sl.selectAll("select * from Sale where invoiceNumber=?", new ParameterValue[]{new ParameterValue("invoiceNumber", JDBCType.INTEGER, sale.getInvoiceNumber())});
                if (sl.getOriginalList().isEmpty()) {
                    try {
                        sl.getOriginalList().add((Object)sale);
                        SaleItemList slitem = new SaleItemList(adminSalesView.da);
                        SaleAccountDetailResolverDataList saleAccountDetailResolverDataList = new SaleAccountDetailResolverDataList(adminSalesView.da);
                        sale.getSaleItemsList().forEach(si -> {
                            si.setDbAccess(adminSalesView.da);
                            si.setState(ObjectState.New);
                            slitem.getOriginalList().add(si);
                        });
                        saleAccountDetailResolverDataList.getOriginalList().addAll(sale.getSaleAccountDetailResolvers());
                        sl.update();
                        slitem.update();
                        saleAccountDetailResolverDataList.update();
                    }
                    catch (Exception ex) {
                        Logger.getLogger(AdminSalesViewItem.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            });
        }
        this.custName.setText(sale.getCustomerName());
        this.custNo.setText(sale.getd365CustomerNo());
        this.custPhone.setText(sale.getCustomerPhoneNumber());
        this.invoice.setText(sale.getHdInvoiceNo());
        this.store.setText("Store:" + sale.getStoreCode());
        this.saleId.setText(sale.getSaleId());
        this.creditType.setText(sale.getCreditDescription().isEmpty() ? "Cash Sale" : sale.getCreditDescription());
        this.creditToken.setText(sale.getCreditToken().isEmpty() ? "No Token" : sale.getCreditToken());
        this.lblApprove.setText(sale.getIsManual() != false ? "Manual Sale" : "Normal sale");
        this.voucherCode.setText(sale.getPromoVoucher().isEmpty() ? "No voucher" : sale.getPromoVoucher());
        this.voucherAmt.setText((String)(sale.getPromoVoucherAmt() > 0.0 ? General.toNaira() + General.formatDecimalToMoneyString(sale.getPromoVoucherAmt()) : "No Discount"));
        this.status.setText(sale.getSaleStatus());
        this.cashier.setText("Cashier:" + sale.getSaleStaffResponsible());
        this.lblSaleRep.setText(sale.getSalesRep().isEmpty() ? "Walk In Customer" : sale.getSalesRep());
        SimpleDateFormat format = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
        String saleDateString = format.format(sale.getTransactionDate());
        this.date.setText(saleDateString);
        this.total.setText(General.formatDecimalToMoneyString(sale.getAmountPaid()));
        this.naira.setText(General.toNaira());
        String saleTyp = sale.getSalesChannel();
        this.saleType.setText(sale.getIsManual() != false ? saleTyp + "-Manual Sale" : saleTyp + "-Normal sale");
        if (sale.getSyncError().isEmpty()) {
            if (sale.getSaleStatus().equals(SaleStatus.APPROVED.name()) || sale.getSaleStatus().equals(SaleStatus.PENDING.name())) {
                this.status.setStyle("-fx-background-color:blue;-fx-text-fill:white;");
                this.img.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.PAUSE).color(Color.BLUE).size(20.0));
            }
            if (sale.getSaleStatus().equals(SaleStatus.RETURNED.name()) || sale.getSaleStatus().equals(SaleStatus.COMPLETED.name())) {
                this.img.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.CHECK_CIRCLE).color(Color.GREEN).size(20.0));
                this.status.setStyle("-fx-background-color:green;-fx-text-fill:white;");
            }
            if (sale.getSaleStatus().equals(SaleStatus.CANCELLED.name()) || sale.getSaleStatus().equals(SaleStatus.DELETED.name())) {
                this.img.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.CHECK_CIRCLE).color(Color.PURPLE).size(20.0));
                this.status.setStyle("-fx-background-color:purple;-fx-text-fill:white;");
            }
            if (sale.getSaleStatus().equals(SaleStatus.RETURNAPPROVED.name()) || sale.getSaleStatus().equals(SaleStatus.PENDINGRETURN.name())) {
                this.img.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.CHECK_CIRCLE).color(Color.GREENYELLOW).size(20.0));
                this.status.setStyle("-fx-background-color:greenyellow;-fx-text-fill:white;");
            }
        } else {
            this.img.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.TIMES_CIRCLE).color(Color.RED).size(20.0));
            this.status.setStyle("-fx-background-color:red;-fx-text-fill:white;");
        }
        if (!sale.getIsManual().booleanValue()) {
            this.getChildren().remove((Object)this.tbComment);
        }
        this.btnReload.setOnAction(eh -> adminSalesView.reloadSale(String.valueOf(sale.getInvoiceNumber())));
        this.btnPush.setOnAction(eh -> adminSalesView.pushSales(sale, "salesorder/createSalesorder"));
        this.tbComment.setText(sale.getSaleComment());
        if (sale.getApprovals() != null && !sale.getApprovals().isEmpty() || sale.getSalesRejectedBy() != null && !sale.getSalesRejectedBy().isEmpty()) {
            if (sale.getApprovals() != null && !sale.getApprovals().isEmpty()) {
                String[] splits;
                String css = "-fx-text-fill:white;-fx-font-size:12px;-fx-background-color:#73C685; -fx-padding: 3 3 3 3";
                for (String split : splits = sale.getApprovals().split(",")) {
                    Label lbl = new Label(split);
                    lbl.setStyle(css);
                    this.vbApprove.getChildren().add((Object)lbl);
                }
                this.lblApprove.setText("Approvals");
            } else {
                String[] splits;
                String css = "-fx-text-fill:white;-fx-font-size:12px;-fx-background-color:Red; -fx-padding: 3 3 3 3";
                for (String split : splits = sale.getSalesRejectedBy().split(",")) {
                    Label lbl = new Label(split);
                    lbl.setStyle(css);
                    this.vbApprove.getChildren().add((Object)lbl);
                }
                this.lblApprove.setText("Decline");
            }
        }
    }
}

