/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.list;

import com.xputertechnologies.santa.SearchClass;
import com.xputertechnologies.santa.User;
import com.xputertechnologies.santa.core.DataAccess;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.core.SearchCondition;
import com.xputertechnologies.santa.list.DataList;
import com.xputertechnologies.santa.list.StockItemList;
import java.sql.JDBCType;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UserDataList
extends DataList<User> {
    public DataAccess dataAccess;

    public UserDataList(DataAccess da) {
        this.dataAccess = da;
        this.t = new User(da);
    }

    public UserDataList() {
    }

    @Override
    public void select() {
    }

    public void selectAll(String query, DataAccess da) {
        try {
            this.getOriginalList().clear();
            ResultSet rs = da.select(query, da.getEmptyParameterValues());
            if (rs != null) {
                while (rs.next()) {
                    User user = new User(rs.getDate("dateCreated"), rs.getString("firstName"), rs.getString("lastName"), rs.getString("password"), rs.getString("roleDescription"), rs.getString("status"), rs.getString("userName"), rs.getString("companyName"), this.getDataAccess());
                    user.vclone = user.clone();
                    this.getOriginalList().add((Object)user);
                }
                rs.close();
                da.closeConnection();
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UserDataList.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void selectAll(String query, ParameterValue[] param, DataAccess da) {
        try {
            this.getOriginalList().clear();
            ResultSet rs = da.select(query, param);
            if (rs != null) {
                while (rs.next()) {
                    User user = new User(rs.getDate("dateCreated"), rs.getString("firstName"), rs.getString("lastName"), rs.getString("password"), rs.getString("roleDescription"), rs.getString("status"), rs.getString("userName"), rs.getString("companyName"), this.getDataAccess());
                    user.vclone = user.clone();
                    this.getOriginalList().add((Object)user);
                }
                rs.close();
                da.closeConnection();
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UserDataList.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void selectAll(String query, ParameterValue[] param) {
        try {
            this.getOriginalList().clear();
            ResultSet rs = this.getDataAccess().select(query, param);
            if (rs != null) {
                while (rs.next()) {
                    User user = new User(rs.getDate("dateCreated"), rs.getString("firstName"), rs.getString("lastName"), rs.getString("password"), rs.getString("roleDescription"), rs.getString("status"), rs.getString("userName"), rs.getString("companyName"), this.getDataAccess());
                    user.vclone = user.clone();
                    this.getOriginalList().add((Object)user);
                }
                rs.close();
                this.getDataAccess().closeConnection();
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UserDataList.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void select(SearchCondition searchCondition, boolean forward, boolean reset) {
        DataAccess dt = this.getDataAccess();
        if (reset) {
            this.currentPage = 0;
        }
        Object query = "Select  * From \"User\" Where ";
        for (ParameterValue pv : searchCondition.getParametersvalues()) {
            query = (String)query + pv.getParameterName() + " like ? or ";
        }
        query = ((String)query).substring(0, ((String)query).length() - 3);
        Objects.requireNonNull(this);
        query = (String)query + "order by Username ASC Limit " + 50 + " Offset " + this.currentPage;
        ParameterValue[] parameterValue = searchCondition.ConvertoparameterValuesArray();
        ResultSet rs = dt.select((String)query, parameterValue);
        try {
            if (rs != null) {
                while (rs.next()) {
                    User user = new User(rs.getDate("dateCreated"), rs.getString("firstName"), rs.getString("lastName"), rs.getString("password"), rs.getString("roleDescription"), rs.getString("status"), rs.getString("userName"), rs.getString("companyName"), this.getDataAccess());
                    user.vclone = user.clone();
                    this.getOriginalList().add((Object)user);
                }
                this.currentPage = forward ? ++this.currentPage : (this.currentPage > 0 ? (this.currentPage = this.currentPage - 1) : 0);
                rs.close();
                this.getDataAccess().closeConnection();
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(StockItemList.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static ArrayList<SearchClass> selectAutoComplete(String searchString, DataAccess dt) throws SQLException {
        ParameterValue[] parameterValue;
        ArrayList<SearchClass> result = new ArrayList<SearchClass>();
        ArrayList<ParameterValue> tempParamValue = new ArrayList<ParameterValue>();
        tempParamValue.add(new ParameterValue("firstName", JDBCType.VARCHAR, "%" + searchString + "%"));
        tempParamValue.add(new ParameterValue("lastName", JDBCType.VARCHAR, "%" + searchString + "%"));
        tempParamValue.add(new ParameterValue("roleDescription", JDBCType.VARCHAR, "%" + searchString + "%"));
        tempParamValue.add(new ParameterValue("userName", JDBCType.VARCHAR, "%" + searchString + "%"));
        SearchCondition searchCondition = new SearchCondition();
        searchCondition.setParametersvalues(tempParamValue);
        Object query = "Select Distinct * From \"User\" Where ";
        for (ParameterValue pv : searchCondition.getParametersvalues()) {
            query = (String)query + pv.getParameterName() + " like ? or ";
        }
        query = ((String)query).substring(0, ((String)query).length() - 3);
        ResultSet rs = dt.select((String)(query = (String)query + "order by firstName ASC"), parameterValue = searchCondition.ConvertoparameterValuesArray());
        if (rs != null) {
            try {
                while (rs.next()) {
                    result.add(new SearchClass(rs.getString("userName"), rs.getString("firstName") + " " + rs.getString("lastName") + "[" + rs.getString("userName") + "]"));
                }
                rs.close();
                dt.closeConnection();
            }
            catch (Exception ex) {
                if (rs != null) {
                    rs.close();
                }
                Logger.getLogger(StockItemList.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return result;
    }
}

